/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ControlMode;
import gurux.dlms.objects.enums.ControlState;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSDisconnectControl
extends GXDLMSObject
implements IGXDLMSBase {
    private boolean outputState;
    private ControlState controlState = ControlState.DISCONNECTED;
    private ControlMode controlMode = ControlMode.NONE;

    public GXDLMSDisconnectControl() {
        this("0.0.96.3.10.255", 0);
    }

    public GXDLMSDisconnectControl(String ln) {
        this(ln, 0);
    }

    public GXDLMSDisconnectControl(String ln, int sn) {
        super(ObjectType.DISCONNECT_CONTROL, ln, sn);
        this.setVersion(1);
    }

    public final boolean getOutputState() {
        return this.outputState;
    }

    public final void setOutputState(boolean value) {
        this.outputState = value;
    }

    public final ControlState getControlState() {
        return this.controlState;
    }

    public final void setControlState(ControlState value) {
        this.controlState = value;
    }

    public final ControlMode getControlMode() {
        return this.controlMode;
    }

    public final void setControlMode(ControlMode value) {
        this.controlMode = value;
    }

    public final byte[][] remoteDisconnect(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    public final byte[][] remoteReconnect(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getOutputState(), this.getControlState(), this.getControlMode()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.BOOLEAN;
        }
        if (index == 3) {
            return DataType.ENUM;
        }
        if (index == 4) {
            return DataType.ENUM;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getOutputState();
        }
        if (e.getIndex() == 3) {
            return this.getControlState().ordinal();
        }
        if (e.getIndex() == 4) {
            return this.getControlMode().ordinal();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() == null) {
                this.setOutputState(false);
            } else {
                this.setOutputState((Boolean)e.getValue());
            }
        } else if (e.getIndex() == 3) {
            if (e.getValue() == null) {
                this.setControlState(ControlState.DISCONNECTED);
            } else {
                this.setControlState(ControlState.values()[((Number)e.getValue()).intValue()]);
            }
        } else if (e.getIndex() == 4) {
            if (e.getValue() == null) {
                this.setControlMode(ControlMode.NONE);
            } else {
                this.setControlMode(ControlMode.values()[((Number)e.getValue()).intValue()]);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.outputState = reader.readElementContentAsInt("OutputState") != 0;
        this.controlState = ControlState.values()[reader.readElementContentAsInt("ControlState")];
        this.controlMode = ControlMode.values()[reader.readElementContentAsInt("ControlMode")];
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("OutputState", this.outputState);
        if (this.controlState != null) {
            writer.writeElementString("ControlState", this.controlState.ordinal());
        }
        if (this.controlMode != null) {
            writer.writeElementString("ControlMode", this.controlMode.ordinal());
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Output State", "Control State", "Control Mode"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Remote disconnect", "Remote reconnect"};
    }
}

