/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXUInt32;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSG3PlcMacLayerCounters
extends GXDLMSObject
implements IGXDLMSBase {
    private long txDataPacketCount;
    private long rxDataPacketCount;
    private long txCmdPacketCount;
    private long rxCmdPacketCount;
    private long cSMAFailCount;
    private long cSMANoAckCount;
    private long badCrcCount;
    private long txDataBroadcastCount;
    private long rxDataBroadcastCount;

    public GXDLMSG3PlcMacLayerCounters() {
        this("0.0.29.0.0.255", 0);
    }

    public GXDLMSG3PlcMacLayerCounters(String ln) {
        this(ln, 0);
    }

    public GXDLMSG3PlcMacLayerCounters(String ln, int sn) {
        super(ObjectType.G3_PLC_MAC_LAYER_COUNTERS, ln, sn);
        this.setVersion(1);
    }

    public final long getTxDataPacketCount() {
        return this.txDataPacketCount;
    }

    public final void setTxDataPacketCount(long value) {
        this.txDataPacketCount = value;
    }

    public final long getRxDataPacketCount() {
        return this.rxDataPacketCount;
    }

    public final void setRxDataPacketCount(long value) {
        this.rxDataPacketCount = value;
    }

    public final long getTxCmdPacketCount() {
        return this.txCmdPacketCount;
    }

    public final void setTxCmdPacketCount(long value) {
        this.txCmdPacketCount = value;
    }

    public final long getRxCmdPacketCount() {
        return this.rxCmdPacketCount;
    }

    public final void setRxCmdPacketCount(long value) {
        this.rxCmdPacketCount = value;
    }

    public final long getCSMAFailCount() {
        return this.cSMAFailCount;
    }

    public final void setCSMAFailCount(long value) {
        this.cSMAFailCount = value;
    }

    public final long getCSMANoAckCount() {
        return this.cSMANoAckCount;
    }

    public final void setCSMANoAckCount(long value) {
        this.cSMANoAckCount = value;
    }

    public final long getBadCrcCount() {
        return this.badCrcCount;
    }

    public final void setBadCrcCount(long value) {
        this.badCrcCount = value;
    }

    public final long getTxDataBroadcastCount() {
        return this.txDataBroadcastCount;
    }

    public final void setTxDataBroadcastCount(long value) {
        this.txDataBroadcastCount = value;
    }

    public final long getRxDataBroadcastCount() {
        return this.rxDataBroadcastCount;
    }

    public final void setRxDataBroadcastCount(long value) {
        this.rxDataBroadcastCount = value;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getTxDataPacketCount(), this.getRxDataPacketCount(), this.getTxCmdPacketCount(), this.getRxCmdPacketCount(), this.getCSMAFailCount(), this.getCSMANoAckCount(), this.getBadCrcCount(), this.getTxDataBroadcastCount(), this.getRxDataBroadcastCount()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setRxDataBroadcastCount(0L);
            this.setTxDataBroadcastCount(this.getRxDataBroadcastCount());
            this.setBadCrcCount(this.getTxDataBroadcastCount());
            this.setCSMANoAckCount(this.getBadCrcCount());
            this.setCSMAFailCount(this.getCSMANoAckCount());
            this.setRxCmdPacketCount(this.getCSMAFailCount());
            this.setTxCmdPacketCount(this.getRxCmdPacketCount());
            this.setRxDataPacketCount(this.getTxCmdPacketCount());
            this.setTxDataPacketCount(this.getRxDataPacketCount());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "TxDataPacketCount", "RxDataPacketCount", "TxCmdPacketCount", "RxCmdPacketCount", " CSMAFailCount", "CSMANoAckCount", "BadCrcCount", "TxDataBroadcastCount", " RxDataBroadcastCount"};
    }

    @Override
    public final String[] getMethodNames() {
        return new String[]{"Reset"};
    }

    @Override
    public final int getAttributeCount() {
        return 10;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.UINT32;
        }
        if (index == 3) {
            return DataType.UINT32;
        }
        if (index == 4) {
            return DataType.UINT32;
        }
        if (index == 5) {
            return DataType.UINT32;
        }
        if (index == 6) {
            return DataType.UINT32;
        }
        if (index == 7) {
            return DataType.UINT32;
        }
        if (index == 8) {
            return DataType.UINT32;
        }
        if (index == 9) {
            return DataType.UINT32;
        }
        if (index == 10) {
            return DataType.UINT32;
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getTxDataPacketCount();
        }
        if (e.getIndex() == 3) {
            return this.getRxDataPacketCount();
        }
        if (e.getIndex() == 4) {
            return this.getTxCmdPacketCount();
        }
        if (e.getIndex() == 5) {
            return this.getRxCmdPacketCount();
        }
        if (e.getIndex() == 6) {
            return this.getCSMAFailCount();
        }
        if (e.getIndex() == 7) {
            return this.getCSMANoAckCount();
        }
        if (e.getIndex() == 8) {
            return this.getBadCrcCount();
        }
        if (e.getIndex() == 9) {
            return this.getTxDataBroadcastCount();
        }
        if (e.getIndex() == 10) {
            return this.getRxDataBroadcastCount();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.setTxDataPacketCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 3) {
            this.setRxDataPacketCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 4) {
            this.setTxCmdPacketCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 5) {
            this.setRxCmdPacketCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 6) {
            this.setCSMAFailCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 7) {
            this.setCSMANoAckCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 8) {
            this.setBadCrcCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 9) {
            this.setTxDataBroadcastCount(((GXUInt32)e.getValue()).longValue());
        } else if (e.getIndex() == 10) {
            this.setRxDataBroadcastCount(((GXUInt32)e.getValue()).longValue());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.setTxDataPacketCount(reader.readElementContentAsInt("TxDataPacketCount"));
        this.setRxDataPacketCount(reader.readElementContentAsInt("RxDataPacketCount"));
        this.setTxCmdPacketCount(reader.readElementContentAsInt("TxCmdPacketCount"));
        this.setRxCmdPacketCount(reader.readElementContentAsInt("RxCmdPacketCount"));
        this.setCSMAFailCount(reader.readElementContentAsInt("CSMAFailCount"));
        this.setCSMANoAckCount(reader.readElementContentAsInt("CSMANoAckCount"));
        this.setBadCrcCount(reader.readElementContentAsInt("BadCrcCount"));
        this.setTxDataBroadcastCount(reader.readElementContentAsInt("TxDataBroadcastCount"));
        this.setRxDataBroadcastCount(reader.readElementContentAsInt("RxDataBroadcastCount"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("TxDataPacketCount", this.getTxDataPacketCount());
        writer.writeElementString("RxDataPacketCount", this.getRxDataPacketCount());
        writer.writeElementString("TxCmdPacketCount", this.getTxCmdPacketCount());
        writer.writeElementString("RxCmdPacketCount", this.getRxCmdPacketCount());
        writer.writeElementString("CSMAFailCount", this.getCSMAFailCount());
        writer.writeElementString("CSMANoAckCount", this.getCSMANoAckCount());
        writer.writeElementString("BadCrcCount", this.getBadCrcCount());
        writer.writeElementString("TxDataBroadcastCount", this.getTxDataBroadcastCount());
        writer.writeElementString("RxDataBroadcastCount", this.getRxDataBroadcastCount());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

