/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSIp4SetupIpOption;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.Ip4SetupIpOptionType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIp4Setup
extends GXDLMSObject
implements IGXDLMSBase {
    private String dataLinkLayerReference;
    private InetAddress ipAddress;
    private InetAddress[] multicastIPAddress;
    private GXDLMSIp4SetupIpOption[] ipOptions;
    private String subnetMask;
    private InetAddress gatewayIPAddress;
    private boolean useDHCP;
    private InetAddress primaryDNSAddress;
    private InetAddress secondaryDNSAddress;

    public GXDLMSIp4Setup() {
        this("0.0.25.1.0.255");
    }

    public GXDLMSIp4Setup(String ln) {
        this(ln, 0);
    }

    public GXDLMSIp4Setup(String ln, int sn) {
        super(ObjectType.IP4_SETUP, ln, sn);
    }

    public final String getDataLinkLayerReference() {
        return this.dataLinkLayerReference;
    }

    public final void setDataLinkLayerReference(String value) {
        this.dataLinkLayerReference = value;
    }

    public final InetAddress getIPAddress() {
        return this.ipAddress;
    }

    public final void setIPAddress(InetAddress value) {
        this.ipAddress = value;
    }

    public final InetAddress[] getMulticastIPAddress() {
        return this.multicastIPAddress;
    }

    public final void setMulticastIPAddress(InetAddress[] value) {
        this.multicastIPAddress = value;
    }

    public final GXDLMSIp4SetupIpOption[] getIPOptions() {
        return this.ipOptions;
    }

    public final void setIPOptions(GXDLMSIp4SetupIpOption[] value) {
        this.ipOptions = value;
    }

    public final String getSubnetMask() {
        return this.subnetMask;
    }

    public final void setSubnetMask(String value) {
        this.subnetMask = value;
    }

    public final InetAddress getGatewayIPAddress() {
        return this.gatewayIPAddress;
    }

    public final void setGatewayIPAddress(InetAddress value) {
        this.gatewayIPAddress = value;
    }

    public final boolean getUseDHCP() {
        return this.useDHCP;
    }

    public final void setUseDHCP(boolean value) {
        this.useDHCP = value;
    }

    public final InetAddress getPrimaryDNSAddress() {
        return this.primaryDNSAddress;
    }

    public final void setPrimaryDNSAddress(InetAddress value) {
        this.primaryDNSAddress = value;
    }

    public final InetAddress getSecondaryDNSAddress() {
        return this.secondaryDNSAddress;
    }

    public final void setSecondaryDNSAddress(InetAddress value) {
        this.secondaryDNSAddress = value;
    }

    public byte[][] addMcIpAddress(GXDLMSClient client, InetAddress address) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.set(address.getAddress());
        return client.method(this, 1, bb.getUInt32(), DataType.UINT32);
    }

    public byte[][] deleteMcIpAaddress(GXDLMSClient client, InetAddress address) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.set(address.getAddress());
        return client.method(this, 2, bb.getUInt32(), DataType.UINT32);
    }

    public byte[][] getMcIpAddressCount(GXDLMSClient client, short index) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, index, DataType.UINT16);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getDataLinkLayerReference(), this.getIPAddress(), this.getMulticastIPAddress(), this.getIPOptions(), this.getSubnetMask(), this.getGatewayIPAddress(), this.getUseDHCP(), this.getPrimaryDNSAddress(), this.getSecondaryDNSAddress()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 10;
    }

    @Override
    public final int getMethodCount() {
        return 3;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.OCTET_STRING;
        }
        if (index == 3) {
            return DataType.UINT32;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        if (index == 5) {
            return DataType.ARRAY;
        }
        if (index == 6) {
            return DataType.UINT32;
        }
        if (index == 7) {
            return DataType.UINT32;
        }
        if (index == 8) {
            return DataType.BOOLEAN;
        }
        if (index == 9) {
            return DataType.UINT32;
        }
        if (index == 10) {
            return DataType.UINT32;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        GXByteBuffer bb = new GXByteBuffer();
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return GXCommon.logicalNameToBytes(this.getDataLinkLayerReference());
        }
        if (e.getIndex() == 3) {
            if (this.getIPAddress() == null) {
                return 0;
            }
            bb.set(this.getIPAddress().getAddress());
            return bb.getUInt32();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.multicastIPAddress == null) {
                GXCommon.setObjectCount(0, data);
            } else {
                GXCommon.setObjectCount(this.getMulticastIPAddress().length, data);
                for (InetAddress it : this.getMulticastIPAddress()) {
                    bb.setUInt8(DataType.UINT16.ordinal());
                    bb.set(it.getAddress());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 5) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.ipOptions == null) {
                data.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.ipOptions.length, data);
                for (GXDLMSIp4SetupIpOption it : this.ipOptions) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(settings, data, DataType.UINT8, (Object)it.getType());
                    GXCommon.setData(settings, data, DataType.UINT8, it.getLength());
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getData());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 6) {
            if (this.getSubnetMask() == null || this.getSubnetMask().isEmpty()) {
                return 0;
            }
            try {
                bb.set(InetAddress.getByName(this.getSubnetMask()).getAddress());
                return bb.getUInt32();
            }
            catch (UnknownHostException e1) {
                throw new IllegalArgumentException("Invalid subnet mask.");
            }
        }
        if (e.getIndex() == 7) {
            if (this.getGatewayIPAddress() == null) {
                return 0;
            }
            bb.set(this.getGatewayIPAddress().getAddress());
            return bb.getUInt32();
        }
        if (e.getIndex() == 8) {
            return this.getUseDHCP();
        }
        if (e.getIndex() == 9) {
            if (this.getPrimaryDNSAddress() == null) {
                return 0;
            }
            bb.set(this.getPrimaryDNSAddress().getAddress());
            return bb.getUInt32();
        }
        if (e.getIndex() == 10) {
            if (this.getSecondaryDNSAddress() == null) {
                return 0;
            }
            bb.set(this.getSecondaryDNSAddress().getAddress());
            return bb.getUInt32();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        GXByteBuffer bb = new GXByteBuffer();
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() instanceof String) {
                this.setDataLinkLayerReference(e.getValue().toString());
            } else {
                this.setDataLinkLayerReference(GXCommon.toLogicalName(e.getValue()));
            }
        } else {
            if (e.getIndex() == 3) {
                bb.setUInt32(((Number)e.getValue()).intValue());
                try {
                    this.setIPAddress(InetAddress.getByAddress(bb.array()));
                }
                catch (UnknownHostException e1) {
                    throw new IllegalArgumentException("Invalid primary DNS address.");
                }
            }
            if (e.getIndex() == 4) {
                ArrayList<InetAddress> data = new ArrayList<InetAddress>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        bb.setUInt32(((Number)it).intValue());
                        try {
                            data.add(InetAddress.getByAddress(bb.array()));
                        }
                        catch (UnknownHostException e1) {
                            throw new IllegalArgumentException("Invalid IP address.");
                        }
                        bb.clear();
                    }
                }
                this.setMulticastIPAddress(data.toArray(new InetAddress[0]));
            } else if (e.getIndex() == 5) {
                ArrayList<GXDLMSIp4SetupIpOption> data = new ArrayList<GXDLMSIp4SetupIpOption>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        GXDLMSIp4SetupIpOption item = new GXDLMSIp4SetupIpOption();
                        item.setType(Ip4SetupIpOptionType.forValue(((Number)((List)it).get(0)).intValue()));
                        item.setLength(((Number)((List)it).get(1)).shortValue());
                        item.setData((byte[])((List)it).get(2));
                        data.add(item);
                    }
                }
                this.setIPOptions(data.toArray(new GXDLMSIp4SetupIpOption[data.size()]));
            } else if (e.getIndex() == 6) {
                try {
                    bb.setUInt32(((Number)e.getValue()).intValue());
                    this.setSubnetMask(InetAddress.getByAddress(bb.array()).getHostName());
                }
                catch (UnknownHostException e1) {
                    throw new IllegalArgumentException("Invalid IP address.");
                }
            } else if (e.getIndex() == 7) {
                bb.setUInt32(((Number)e.getValue()).intValue());
                try {
                    this.setGatewayIPAddress(InetAddress.getByAddress(bb.array()));
                }
                catch (UnknownHostException e1) {
                    throw new IllegalArgumentException("Invalid Gateway IP address.");
                }
            } else if (e.getIndex() == 8) {
                this.setUseDHCP((Boolean)e.getValue());
            } else if (e.getIndex() == 9) {
                bb.setUInt32(((Number)e.getValue()).intValue());
                try {
                    this.setPrimaryDNSAddress(InetAddress.getByAddress(bb.array()));
                }
                catch (UnknownHostException e1) {
                    throw new IllegalArgumentException("Invalid primary DNS address.");
                }
            } else if (e.getIndex() == 10) {
                bb.setUInt32(((Number)e.getValue()).intValue());
                try {
                    this.setSecondaryDNSAddress(InetAddress.getByAddress(bb.array()));
                }
                catch (UnknownHostException e1) {
                    throw new IllegalArgumentException("Invalid IP address.");
                }
            } else {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        try {
            this.dataLinkLayerReference = reader.readElementContentAsString("DataLinkLayerReference");
            this.ipAddress = InetAddress.getByName(reader.readElementContentAsString("IPAddress"));
            ArrayList<InetAddress> list = new ArrayList<InetAddress>();
            if (reader.isStartElement("MulticastIPAddress", true)) {
                while (reader.isStartElement("Value", false)) {
                    list.add(InetAddress.getByName(reader.readElementContentAsString("Value")));
                }
                reader.readEndElement("MulticastIPAddress");
            }
            this.multicastIPAddress = list.toArray(new InetAddress[0]);
            ArrayList<GXDLMSIp4SetupIpOption> tmp = new ArrayList<GXDLMSIp4SetupIpOption>();
            if (reader.isStartElement("IPOptions", true)) {
                GXDLMSIp4SetupIpOption it;
                while (reader.isStartElement("IPOption", true)) {
                    it = new GXDLMSIp4SetupIpOption();
                    it.setType(Ip4SetupIpOptionType.forValue(reader.readElementContentAsInt("Type")));
                    it.setLength((short)reader.readElementContentAsInt("Length"));
                    it.setData(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Data")));
                    tmp.add(it);
                }
                while (reader.isStartElement("IPOptions", true)) {
                    it = new GXDLMSIp4SetupIpOption();
                    it.setType(Ip4SetupIpOptionType.forValue(reader.readElementContentAsInt("Type")));
                    it.setLength((short)reader.readElementContentAsInt("Length"));
                    it.setData(GXDLMSTranslator.hexToBytes(reader.readElementContentAsString("Data")));
                    tmp.add(it);
                }
                reader.readEndElement("IPOptions");
            }
            this.ipOptions = tmp.toArray(new GXDLMSIp4SetupIpOption[tmp.size()]);
            this.subnetMask = reader.readElementContentAsString("SubnetMask");
            this.gatewayIPAddress = InetAddress.getByName(reader.readElementContentAsString("GatewayIPAddress"));
            this.useDHCP = reader.readElementContentAsInt("UseDHCP") != 0;
            this.primaryDNSAddress = InetAddress.getByName(reader.readElementContentAsString("PrimaryDNSAddress"));
            this.secondaryDNSAddress = InetAddress.getByName(reader.readElementContentAsString("SecondaryDNSAddress"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("DataLinkLayerReference", this.dataLinkLayerReference);
        if (this.ipAddress != null) {
            writer.writeElementString("IPAddress", this.ipAddress.getHostAddress());
        }
        if (this.multicastIPAddress != null) {
            writer.writeStartElement("MulticastIPAddress");
            for (InetAddress inetAddress : this.multicastIPAddress) {
                writer.writeElementString("Value", inetAddress.getHostAddress());
            }
            writer.writeEndElement();
        }
        if (this.ipOptions != null) {
            writer.writeStartElement("IPOptions");
            for (GXDLMSIp4SetupIpOption gXDLMSIp4SetupIpOption : this.ipOptions) {
                writer.writeStartElement("IPOption");
                writer.writeElementString("Type", gXDLMSIp4SetupIpOption.getType().ordinal());
                writer.writeElementString("Length", gXDLMSIp4SetupIpOption.getLength());
                writer.writeElementString("Data", GXDLMSTranslator.toHex(gXDLMSIp4SetupIpOption.getData()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("SubnetMask", this.subnetMask);
        if (this.gatewayIPAddress != null) {
            writer.writeElementString("GatewayIPAddress", this.gatewayIPAddress.getHostAddress());
        }
        writer.writeElementString("UseDHCP", this.useDHCP);
        if (this.primaryDNSAddress != null) {
            writer.writeElementString("PrimaryDNSAddress", this.primaryDNSAddress.getHostAddress());
        }
        if (this.secondaryDNSAddress != null) {
            writer.writeElementString("SecondaryDNSAddress", this.secondaryDNSAddress.getHostAddress());
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Data LinkLayer Reference", "IP Address", "Multicast IP Address", "IP Options", "Subnet Mask", "Gateway IP Address", "Use DHCP", "Primary DNS Address", "Secondary DNS Address"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Add mc IP address", "Delete mc IP address", "Get nbof mc IP addresses"};
    }
}

