/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSLlcSscsSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private int serviceNodeAddress;
    private int baseNodeAddress;

    public GXDLMSLlcSscsSetup() {
        this("0.0.28.0.0.255", 0);
    }

    public GXDLMSLlcSscsSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSLlcSscsSetup(String ln, int sn) {
        super(ObjectType.LLC_SSCS_SETUP, ln, sn);
    }

    public final int getServiceNodeAddress() {
        return this.serviceNodeAddress;
    }

    public final void setServiceNodeAddress(int value) {
        this.serviceNodeAddress = value;
    }

    public final int getBaseNodeAddress() {
        return this.baseNodeAddress;
    }

    public final void setBaseNodeAddress(int value) {
        this.baseNodeAddress = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.serviceNodeAddress = 4094;
            this.baseNodeAddress = 0;
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.serviceNodeAddress, this.baseNodeAddress};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 3;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.serviceNodeAddress;
            }
            case 3: {
                return this.baseNodeAddress;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.serviceNodeAddress = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 3) {
            this.baseNodeAddress = ((Number)e.getValue()).intValue();
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.serviceNodeAddress = reader.readElementContentAsInt("ServiceNodeAddress");
        this.baseNodeAddress = reader.readElementContentAsInt("BaseNodeAddress");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("ServiceNodeAddress", this.serviceNodeAddress);
        writer.writeElementString("BaseNodeAddress", this.baseNodeAddress);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "ServiceNodeAddress", "BaseNodeAddress"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

