/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXMBusClientData;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.MBusEncryptionKeyStatus;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSMBusClient
extends GXDLMSObject
implements IGXDLMSBase {
    private long capturePeriod;
    private int primaryAddress;
    private String mBusPortReference;
    private List<Map.Entry<String, String>> captureDefinition = new ArrayList<Map.Entry<String, String>>();
    private long identificationNumber;
    private int manufacturerID;
    private int dataHeaderVersion;
    private int deviceType;
    private int accessNumber;
    private int status;
    private int alarm;
    private int configuration;
    private MBusEncryptionKeyStatus encryptionKeyStatus;

    public GXDLMSMBusClient() {
        this(null, 0);
    }

    public GXDLMSMBusClient(String ln) {
        this(ln, 0);
    }

    public GXDLMSMBusClient(String ln, int sn) {
        super(ObjectType.MBUS_CLIENT, ln, sn);
        this.setVersion(1);
    }

    public final String getMBusPortReference() {
        return this.mBusPortReference;
    }

    public final void setMBusPortReference(String value) {
        this.mBusPortReference = value;
    }

    public final List<Map.Entry<String, String>> getCaptureDefinition() {
        return this.captureDefinition;
    }

    public final long getCapturePeriod() {
        return this.capturePeriod;
    }

    public final void setCapturePeriod(long value) {
        this.capturePeriod = value;
    }

    public final int getPrimaryAddress() {
        return this.primaryAddress;
    }

    public final void setPrimaryAddress(int value) {
        this.primaryAddress = value;
    }

    public final long getIdentificationNumber() {
        return this.identificationNumber;
    }

    public final void setIdentificationNumber(long value) {
        this.identificationNumber = value;
    }

    public final int getManufacturerID() {
        return this.manufacturerID;
    }

    public final void setManufacturerID(int value) {
        this.manufacturerID = value;
    }

    public final int getDataHeaderVersion() {
        return this.dataHeaderVersion;
    }

    public final void setDataHeaderVersion(int value) {
        this.dataHeaderVersion = value;
    }

    public final int getDeviceType() {
        return this.deviceType;
    }

    public final void setDeviceType(int value) {
        this.deviceType = value;
    }

    public final int getAccessNumber() {
        return this.accessNumber;
    }

    public final void setAccessNumber(int value) {
        this.accessNumber = value;
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setStatus(int value) {
        this.status = value;
    }

    public final int getAlarm() {
        return this.alarm;
    }

    public final void setAlarm(int value) {
        this.alarm = value;
    }

    public int getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(int value) {
        this.configuration = value;
    }

    public MBusEncryptionKeyStatus getEncryptionKeyStatus() {
        return this.encryptionKeyStatus;
    }

    public void setEncryptionKeyStatus(MBusEncryptionKeyStatus value) {
        this.encryptionKeyStatus = value;
    }

    public final byte[][] slaveInstall(GXDLMSClient client, byte primaryAddress) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, primaryAddress, DataType.INT8);
    }

    public final byte[][] slaveDeInstall(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, 0, DataType.INT8);
    }

    public final byte[][] capture(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, 0, DataType.INT8);
    }

    public final byte[][] resetAlarm(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 4, 0, DataType.INT8);
    }

    public final byte[][] synchronizeClock(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 5, 0, DataType.INT8);
    }

    public final byte[][] sendData(GXDLMSClient client, GXMBusClientData[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.ARRAY);
        bb.setUInt8(DataType.STRUCTURE);
        GXCommon.setObjectCount(data.length, bb);
        for (GXMBusClientData it : data) {
            bb.setUInt8(DataType.STRUCTURE);
            bb.setUInt8(3);
            bb.setUInt8(DataType.OCTET_STRING);
            GXCommon.setObjectCount(it.getDataInformation().length, bb);
            bb.set(it.getDataInformation());
            bb.setUInt8(DataType.OCTET_STRING);
            GXCommon.setObjectCount(it.getValueInformation().length, bb);
            bb.set(it.getValueInformation());
            GXCommon.setData(null, bb, GXDLMSConverter.getDLMSDataType(it.getData()), it.getData());
        }
        return client.method(this, 6, bb.array(), DataType.ARRAY);
    }

    public final byte[][] setEncryptionKey(GXDLMSClient client, byte[] encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.OCTET_STRING);
        if (encryptionKey == null) {
            bb.setUInt8(0);
        } else {
            GXCommon.setObjectCount(encryptionKey.length, bb);
            bb.set(encryptionKey);
        }
        return client.method(this, 7, bb.array(), DataType.ARRAY);
    }

    public final byte[][] transferKey(GXDLMSClient client, byte[] encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.OCTET_STRING);
        if (encryptionKey == null) {
            bb.setUInt8(0);
        } else {
            GXCommon.setObjectCount(encryptionKey.length, bb);
            bb.set(encryptionKey);
        }
        return client.method(this, 8, bb.array(), DataType.ARRAY);
    }

    @Override
    public final Object[] getValues() {
        if (this.getVersion() == 0) {
            return new Object[]{this.getLogicalName(), this.mBusPortReference, this.captureDefinition, this.capturePeriod, this.primaryAddress, this.identificationNumber, this.manufacturerID, this.dataHeaderVersion, this.deviceType, this.accessNumber, this.status, this.alarm};
        }
        return new Object[]{this.getLogicalName(), this.mBusPortReference, this.captureDefinition, this.capturePeriod, this.primaryAddress, this.identificationNumber, this.manufacturerID, this.dataHeaderVersion, this.deviceType, this.accessNumber, this.status, this.alarm, this.configuration, this.encryptionKeyStatus};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        if (all || this.canRead(11)) {
            attributes.add(11);
        }
        if (all || this.canRead(12)) {
            attributes.add(12);
        }
        if (this.getVersion() > 0) {
            if (all || this.canRead(13)) {
                attributes.add(13);
            }
            if (all || this.canRead(14)) {
                attributes.add(14);
            }
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        if (this.getVersion() == 0) {
            return 12;
        }
        return 14;
    }

    @Override
    public final int getMethodCount() {
        return 8;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.OCTET_STRING;
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return DataType.UINT32;
        }
        if (index == 5) {
            return DataType.UINT8;
        }
        if (index == 6) {
            return DataType.UINT32;
        }
        if (index == 7) {
            return DataType.UINT16;
        }
        if (index == 8) {
            return DataType.UINT8;
        }
        if (index == 9) {
            return DataType.UINT8;
        }
        if (index == 10) {
            return DataType.UINT8;
        }
        if (index == 11) {
            return DataType.UINT8;
        }
        if (index == 12) {
            return DataType.UINT8;
        }
        if (this.getVersion() > 0) {
            if (index == 13) {
                return DataType.UINT16;
            }
            if (index == 14) {
                return DataType.ENUM;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return GXCommon.logicalNameToBytes(this.mBusPortReference);
        }
        if (e.getIndex() == 3) {
            GXByteBuffer buff = new GXByteBuffer();
            buff.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(this.captureDefinition.size(), buff);
            for (Map.Entry<String, String> it : this.captureDefinition) {
                buff.setUInt8(DataType.STRUCTURE.getValue());
                buff.setUInt8(2);
                GXCommon.setData(settings, buff, DataType.UINT8, it.getKey());
                if (it.getValue() == null) {
                    GXCommon.setData(settings, buff, DataType.OCTET_STRING, null);
                    continue;
                }
                GXCommon.setData(settings, buff, DataType.OCTET_STRING, it.getValue().getBytes());
            }
            return buff.array();
        }
        if (e.getIndex() == 4) {
            return this.capturePeriod;
        }
        if (e.getIndex() == 5) {
            return this.primaryAddress;
        }
        if (e.getIndex() == 6) {
            return this.identificationNumber;
        }
        if (e.getIndex() == 7) {
            return this.manufacturerID;
        }
        if (e.getIndex() == 8) {
            return this.dataHeaderVersion;
        }
        if (e.getIndex() == 9) {
            return this.deviceType;
        }
        if (e.getIndex() == 10) {
            return this.accessNumber;
        }
        if (e.getIndex() == 11) {
            return this.status;
        }
        if (e.getIndex() == 12) {
            return this.alarm;
        }
        if (this.getVersion() > 0) {
            if (e.getIndex() == 13) {
                return this.configuration;
            }
            if (e.getIndex() == 14) {
                return this.encryptionKeyStatus.ordinal();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.mBusPortReference = GXCommon.toLogicalName(e.getValue());
        } else if (e.getIndex() == 3) {
            this.captureDefinition.clear();
            if (e.getValue() != null) {
                for (Object it : (List)e.getValue()) {
                    this.captureDefinition.add(new GXSimpleEntry<String, String>(GXDLMSClient.changeType((byte[])((List)it).get(0), DataType.OCTET_STRING, e.getSettings()).toString(), GXDLMSClient.changeType((byte[])((List)it).get(1), DataType.OCTET_STRING, e.getSettings()).toString()));
                }
            }
        } else if (e.getIndex() == 4) {
            this.capturePeriod = ((Number)e.getValue()).longValue();
        } else if (e.getIndex() == 5) {
            this.primaryAddress = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 6) {
            this.identificationNumber = ((Number)e.getValue()).longValue();
        } else if (e.getIndex() == 7) {
            this.manufacturerID = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 8) {
            this.dataHeaderVersion = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 9) {
            this.deviceType = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 10) {
            this.accessNumber = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 11) {
            this.status = ((Number)e.getValue()).intValue();
        } else if (e.getIndex() == 12) {
            this.alarm = ((Number)e.getValue()).intValue();
        } else if (this.getVersion() > 0) {
            if (e.getIndex() == 13) {
                this.configuration = ((Number)e.getValue()).intValue();
            } else if (e.getIndex() == 14) {
                this.encryptionKeyStatus = MBusEncryptionKeyStatus.values()[((Number)e.getValue()).intValue()];
            } else {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.mBusPortReference = reader.readElementContentAsString("MBusPortReference");
        this.captureDefinition.clear();
        if (reader.isStartElement("CaptureDefinition", true)) {
            while (reader.isStartElement("Item", true)) {
                String d = reader.readElementContentAsString("Data");
                String v = reader.readElementContentAsString("Value");
                this.captureDefinition.add(new GXSimpleEntry<String, String>(d, v));
            }
            reader.readEndElement("CaptureDefinition");
        }
        this.capturePeriod = reader.readElementContentAsInt("CapturePeriod");
        this.primaryAddress = reader.readElementContentAsInt("PrimaryAddress");
        this.identificationNumber = reader.readElementContentAsInt("IdentificationNumber");
        this.manufacturerID = reader.readElementContentAsInt("ManufacturerID");
        this.dataHeaderVersion = reader.readElementContentAsInt("DataHeaderVersion");
        this.deviceType = reader.readElementContentAsInt("DeviceType");
        this.accessNumber = reader.readElementContentAsInt("AccessNumber");
        this.status = reader.readElementContentAsInt("Status");
        this.alarm = reader.readElementContentAsInt("Alarm");
        if (this.getVersion() > 0) {
            this.configuration = reader.readElementContentAsInt("Configuration");
            this.encryptionKeyStatus = MBusEncryptionKeyStatus.values()[reader.readElementContentAsInt("EncryptionKeyStatus")];
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("MBusPortReference", this.mBusPortReference);
        if (this.captureDefinition != null) {
            writer.writeStartElement("CaptureDefinition");
            for (Map.Entry<String, String> it : this.captureDefinition) {
                writer.writeStartElement("Item");
                writer.writeElementString("Data", it.getKey());
                writer.writeElementString("Value", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("CapturePeriod", this.capturePeriod);
        writer.writeElementString("PrimaryAddress", this.primaryAddress);
        writer.writeElementString("IdentificationNumber", this.identificationNumber);
        writer.writeElementString("ManufacturerID", this.manufacturerID);
        writer.writeElementString("DataHeaderVersion", this.dataHeaderVersion);
        writer.writeElementString("DeviceType", this.deviceType);
        writer.writeElementString("AccessNumber", this.accessNumber);
        writer.writeElementString("Status", this.status);
        writer.writeElementString("Alarm", this.alarm);
        if (this.getVersion() > 0) {
            writer.writeElementString("Configuration", this.configuration);
            writer.writeElementString("EncryptionKeyStatus", this.encryptionKeyStatus.ordinal());
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        if (this.version == 0) {
            return new String[]{"Logical Name", "MBus Port Reference", "Capture Definition", "Capture Period", "Primary Address", "Identification Number", "Manufacturer ID", "Version", "Device Type", "Access Number", "Status", "Alarm"};
        }
        return new String[]{"Logical Name", "MBus Port Reference", "Capture Definition", "Capture Period", "Primary Address", "Identification Number", "Manufacturer ID", "Version", "Device Type", "Access Number", "Status", "Alarm", "Configuration", "Encryption Key Status"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Slave install", "Slave deinstall", "Capture", "Reset alarm", "Synchronize clock", "Data send", "Set encryption key", "Transfer key"};
    }
}

