/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSPrimeNbOfdmPlcMacCounters
extends GXDLMSObject
implements IGXDLMSBase {
    private long txDataPktCount;
    private long rxDataPktCount;
    private long txCtrlPktCount;
    private long rxCtrlPktCount;
    private long csmaFailCount;
    private long csmaChBusyCount;

    public GXDLMSPrimeNbOfdmPlcMacCounters() {
        this("0.0.28.4.0.255", 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacCounters(String ln) {
        this(ln, 0);
    }

    public GXDLMSPrimeNbOfdmPlcMacCounters(String ln, int sn) {
        super(ObjectType.PRIME_NB_OFDM_PLC_MAC_COUNTERS, ln, sn);
    }

    public final long getTxDataPktCount() {
        return this.txDataPktCount;
    }

    public final void setTxDataPktCount(long value) {
        this.txDataPktCount = value;
    }

    public final long getRxDataPktCount() {
        return this.rxDataPktCount;
    }

    public final void setRxDataPktCount(long value) {
        this.rxDataPktCount = value;
    }

    public final long getTxCtrlPktCount() {
        return this.txCtrlPktCount;
    }

    public final void setTxCtrlPktCount(long value) {
        this.txCtrlPktCount = value;
    }

    public final long getRxCtrlPktCount() {
        return this.rxCtrlPktCount;
    }

    public final void setRxCtrlPktCount(long value) {
        this.rxCtrlPktCount = value;
    }

    public final long getCsmaFailCount() {
        return this.csmaFailCount;
    }

    public final void setCsmaFailCount(long value) {
        this.csmaFailCount = value;
    }

    public final long getCsmaChBusyCount() {
        return this.csmaChBusyCount;
    }

    public final void setCsmaChBusyCount(long value) {
        this.csmaChBusyCount = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.txDataPktCount, this.rxDataPktCount, this.txCtrlPktCount, this.rxCtrlPktCount, this.csmaFailCount, this.csmaChBusyCount};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.csmaChBusyCount = 0L;
            this.csmaFailCount = 0L;
            this.rxCtrlPktCount = 0L;
            this.txCtrlPktCount = 0L;
            this.rxDataPktCount = 0L;
            this.txDataPktCount = 0L;
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 7;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return DataType.UINT32;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.txDataPktCount;
            }
            case 3: {
                return this.rxDataPktCount;
            }
            case 4: {
                return this.txCtrlPktCount;
            }
            case 5: {
                return this.rxCtrlPktCount;
            }
            case 6: {
                return this.csmaFailCount;
            }
            case 7: {
                return this.csmaChBusyCount;
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.txDataPktCount = ((Number)e.getValue()).longValue();
                break;
            }
            case 3: {
                this.rxDataPktCount = ((Number)e.getValue()).longValue();
                break;
            }
            case 4: {
                this.txCtrlPktCount = ((Number)e.getValue()).longValue();
                break;
            }
            case 5: {
                this.rxCtrlPktCount = ((Number)e.getValue()).longValue();
                break;
            }
            case 6: {
                this.csmaFailCount = ((Number)e.getValue()).longValue();
                break;
            }
            case 7: {
                this.csmaChBusyCount = ((Number)e.getValue()).longValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.txDataPktCount = reader.readElementContentAsLong("TxDataPktCount");
        this.rxDataPktCount = reader.readElementContentAsLong("RxDataPktCount");
        this.txCtrlPktCount = reader.readElementContentAsLong("TxCtrlPktCount");
        this.rxCtrlPktCount = reader.readElementContentAsLong("RxCtrlPktCount");
        this.csmaFailCount = reader.readElementContentAsLong("CsmaFailCount");
        this.csmaChBusyCount = reader.readElementContentAsLong("CsmaChBusyCount");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("TxDataPktCount", this.txDataPktCount);
        writer.writeElementString("RxDataPktCount", this.rxDataPktCount);
        writer.writeElementString("TxCtrlPktCount", this.txCtrlPktCount);
        writer.writeElementString("RxCtrlPktCount", this.rxCtrlPktCount);
        writer.writeElementString("CsmaFailCount", this.csmaFailCount);
        writer.writeElementString("CsmaChBusyCount", this.csmaChBusyCount);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "TxDataPktCount", "RxDataPktCount", "TxCtrlPktCount", "RxCtrlPktCount", "CsmaFailCount", "CsmaChBusyCount"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

