/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSFSKReportingSystemList
extends GXDLMSObject
implements IGXDLMSBase {
    private ArrayList<byte[]> reportingSystemList = new ArrayList();

    public GXDLMSSFSKReportingSystemList() {
        this("0.0.26.6.0.255", 0);
    }

    public GXDLMSSFSKReportingSystemList(String ln) {
        this(ln, 0);
    }

    public GXDLMSSFSKReportingSystemList(String ln, int sn) {
        super(ObjectType.SFSK_REPORTING_SYSTEM_LIST, ln, sn);
    }

    public final ArrayList<byte[]> getReportingSystemList() {
        return this.reportingSystemList;
    }

    public final void setReportingSystemList(ArrayList<byte[]> value) {
        this.reportingSystemList = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.reportingSystemList};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                int cnt = this.reportingSystemList.size();
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                GXCommon.setObjectCount(cnt, data);
                for (byte[] it : this.reportingSystemList) {
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, it);
                }
                return data.array();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.reportingSystemList.clear();
                if (e.getValue() == null) break;
                for (Object tmp : (List)e.getValue()) {
                    this.reportingSystemList.add((byte[])tmp);
                }
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.reportingSystemList.clear();
        if (reader.isStartElement("ReportingSystems", true)) {
            while (reader.isStartElement("Item", false)) {
                this.reportingSystemList.add(GXCommon.hexToBytes(reader.readElementContentAsString("Item")));
            }
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("ReportingSystems");
        for (byte[] it : this.reportingSystemList) {
            writer.writeElementString("Item", GXCommon.toHex(it, false));
        }
        writer.writeEndElement();
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "ReportingSystemList"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

