/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSapAssignment
extends GXDLMSObject
implements IGXDLMSBase {
    private List<Map.Entry<Integer, String>> sapAssignmentList = new ArrayList<Map.Entry<Integer, String>>();

    public GXDLMSSapAssignment() {
        super(ObjectType.SAP_ASSIGNMENT, "0.0.41.0.0.255", 0);
    }

    public GXDLMSSapAssignment(String ln) {
        super(ObjectType.SAP_ASSIGNMENT, ln, 0);
    }

    public GXDLMSSapAssignment(String ln, int sn) {
        super(ObjectType.SAP_ASSIGNMENT, ln, sn);
    }

    public final List<Map.Entry<Integer, String>> getSapAssignmentList() {
        return this.sapAssignmentList;
    }

    public final void setSapAssignmentList(List<Map.Entry<Integer, String>> value) {
        this.sapAssignmentList = value;
    }

    public final byte[][] addSap(GXDLMSClient client, short id, String name) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        GXCommon.setData(null, data, DataType.UINT16, id);
        GXCommon.setData(null, data, DataType.OCTET_STRING, name.getBytes());
        return client.method(this, 1, data.array(), DataType.STRUCTURE);
    }

    public final byte[][] removeSap(GXDLMSClient client, String name) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        GXCommon.setData(null, data, DataType.UINT16, 0);
        GXCommon.setData(null, data, DataType.OCTET_STRING, name.getBytes());
        return client.method(this, 1, data.array(), DataType.STRUCTURE);
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getSapAssignmentList()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 2;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            List tmp = (List)e.getParameters();
            int id = ((Number)tmp.get(0)).intValue();
            String str = tmp.get(1) instanceof byte[] ? new String((byte[])tmp.get(1)) : tmp.get(1).toString();
            if (id == 0) {
                for (Map.Entry<Integer, String> it : this.sapAssignmentList) {
                    if (it.getValue().compareTo(str) != 0) continue;
                    this.sapAssignmentList.remove(it);
                    break;
                }
            } else {
                this.sapAssignmentList.add(new GXSimpleEntry<Integer, String>(id, str));
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            int cnt = 0;
            if (this.sapAssignmentList != null) {
                cnt = this.sapAssignmentList.size();
            }
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            GXCommon.setObjectCount(cnt, data);
            if (cnt != 0) {
                for (Map.Entry<Integer, String> it : this.sapAssignmentList) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(2);
                    GXCommon.setData(settings, data, DataType.UINT16, it.getKey());
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.getBytes(it.getValue()));
                }
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            this.sapAssignmentList.clear();
            if (e.getValue() != null) {
                for (Object item : (List)e.getValue()) {
                    Object tmp = ((List)item).get(1);
                    String str = tmp instanceof byte[] ? GXDLMSClient.changeType((byte[])tmp, DataType.STRING, e.getSettings()).toString() : tmp.toString();
                    this.sapAssignmentList.add(new GXSimpleEntry<Integer, String>(((Number)((List)item).get(0)).intValue(), str));
                }
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.sapAssignmentList.clear();
        if (reader.isStartElement("SapAssignmentList", true)) {
            while (reader.isStartElement("Item", true)) {
                int sap = reader.readElementContentAsInt("SAP");
                String ldn = reader.readElementContentAsString("LDN");
                this.sapAssignmentList.add(new GXSimpleEntry<Integer, String>(sap, ldn));
            }
            reader.readEndElement("SapAssignmentList");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.sapAssignmentList != null) {
            writer.writeStartElement("SapAssignmentList");
            for (Map.Entry<Integer, String> it : this.sapAssignmentList) {
                writer.writeStartElement("Item");
                writer.writeElementString("SAP", it.getKey());
                writer.writeElementString("LDN", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Sap Assignment List"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Connect logical device"};
    }
}

