/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSTcpUdpSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private int port = 4059;
    private String ipReference;
    private int maximumSimultaneousConnections;
    private int inactivityTimeout = 180;
    private int maximumSegmentSize = 576;

    public GXDLMSTcpUdpSetup() {
        this("0.0.25.0.0.255");
    }

    public GXDLMSTcpUdpSetup(String ln) {
        this(ln, 0);
    }

    public GXDLMSTcpUdpSetup(String ln, int sn) {
        super(ObjectType.TCP_UDP_SETUP, ln, sn);
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int value) {
        this.port = value;
    }

    public final String getIPReference() {
        return this.ipReference;
    }

    public final void setIPReference(String value) {
        if (value != null && value.length() != 0) {
            GXCommon.logicalNameToBytes(value);
        }
        this.ipReference = value;
    }

    public final int getMaximumSegmentSize() {
        return this.maximumSegmentSize;
    }

    public final void setMaximumSegmentSize(int value) {
        this.maximumSegmentSize = value;
    }

    public final int getMaximumSimultaneousConnections() {
        return this.maximumSimultaneousConnections;
    }

    public final void setMaximumSimultaneousConnections(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.maximumSimultaneousConnections = value;
    }

    public final int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public final void setInactivityTimeout(int value) {
        this.inactivityTimeout = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getPort(), this.getIPReference(), this.getMaximumSegmentSize(), this.getMaximumSimultaneousConnections(), this.getInactivityTimeout()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.UINT16;
        }
        if (index == 3) {
            return DataType.OCTET_STRING;
        }
        if (index == 4) {
            return DataType.UINT16;
        }
        if (index == 5) {
            return DataType.UINT8;
        }
        if (index == 6) {
            return DataType.UINT16;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getPort();
        }
        if (e.getIndex() == 3) {
            return GXCommon.logicalNameToBytes(this.getIPReference());
        }
        if (e.getIndex() == 4) {
            return this.getMaximumSegmentSize();
        }
        if (e.getIndex() == 5) {
            return this.getMaximumSimultaneousConnections();
        }
        if (e.getIndex() == 6) {
            return this.getInactivityTimeout();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() == null) {
                this.setPort(4059);
            } else {
                this.setPort(((Number)e.getValue()).intValue());
            }
        } else if (e.getIndex() == 3) {
            if (e.getValue() == null) {
                this.setIPReference(null);
            } else if (e.getValue() instanceof byte[]) {
                this.setIPReference(GXCommon.toLogicalName(e.getValue()));
            } else {
                this.setIPReference(String.valueOf(e.getValue()));
            }
        } else if (e.getIndex() == 4) {
            if (e.getValue() == null) {
                this.setMaximumSegmentSize(576);
            } else {
                this.setMaximumSegmentSize(((Number)e.getValue()).intValue());
            }
        } else if (e.getIndex() == 5) {
            if (e.getValue() == null) {
                this.setMaximumSimultaneousConnections(1);
            } else {
                this.setMaximumSimultaneousConnections(((Number)e.getValue()).intValue());
            }
        } else if (e.getIndex() == 6) {
            if (e.getValue() == null) {
                this.setInactivityTimeout(180);
            } else {
                this.setInactivityTimeout(((Number)e.getValue()).intValue());
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.port = reader.readElementContentAsInt("Port");
        this.ipReference = reader.readElementContentAsString("IPReference");
        this.maximumSegmentSize = reader.readElementContentAsInt("MaximumSegmentSize");
        this.maximumSimultaneousConnections = reader.readElementContentAsInt("MaximumSimultaneousConnections");
        this.inactivityTimeout = reader.readElementContentAsInt("InactivityTimeout");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Port", this.port);
        writer.writeElementString("IPReference", this.ipReference);
        writer.writeElementString("MaximumSegmentSize", this.maximumSegmentSize);
        writer.writeElementString("MaximumSimultaneousConnections", this.maximumSimultaneousConnections);
        writer.writeElementString("InactivityTimeout", this.inactivityTimeout);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Port", "IP Reference", "Maximum Segment Size", "Maximum Simultaneous Connections", "Inactivity Timeout"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

