/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.secure;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXICipher;
import gurux.dlms.asn.GXx509CertificateCollection;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.Signing;
import gurux.dlms.objects.enums.SecurityPolicy;
import gurux.dlms.objects.enums.SecuritySuite;
import gurux.dlms.secure.AesGcmParameter;
import gurux.dlms.secure.GXSecure;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class GXCiphering
implements GXICipher {
    private Security security = Security.NONE;
    Set<SecurityPolicy> securityPolicy;
    private byte[] authenticationKey;
    private byte[] dedicatedKey;
    private GXx509CertificateCollection certificates;
    private KeyPair ephemeralKeyPair;
    private byte[] systemTitle;
    private byte[] recipientSystemTitle;
    private byte[] blockCipherKey;
    private byte[] broadcastBlockCipherKey;
    private long invocationCounter = 0L;
    private SecuritySuite securitySuite = SecuritySuite.SUITE_0;
    private KeyPair signingKeyPair;
    private KeyPair keyAgreementKeyPair;
    private Signing signing;
    private byte[] transactionId;
    KeyPair tlsKeyPair;

    public GXCiphering(byte[] title) {
        this.securityPolicy = new HashSet<SecurityPolicy>();
        this.certificates = new GXx509CertificateCollection();
        this.setSecurity(Security.NONE);
        this.setSystemTitle(title);
        this.setBlockCipherKey(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
        this.setAuthenticationKey(new byte[]{-48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33});
        this.signing = Signing.NONE;
    }

    public static byte[] decrypt(GXICipher c, AesGcmParameter p, GXByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] tmp = GXSecure.decryptAesGcm(c, p, data);
        return tmp;
    }

    public static byte[] encrypt(AesGcmParameter p, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if (p.getSecurity() != Security.NONE) {
            return GXSecure.encryptAesGcm(true, p, data);
        }
        return data;
    }

    @Override
    public final void reset() {
        this.signing = Signing.NONE;
        this.setSecurity(Security.NONE);
        this.setInvocationCounter(0L);
    }

    @Override
    public final boolean isCiphered() {
        return this.security != Security.NONE;
    }

    @Override
    public final void setInvocationCounter(long value) {
        this.invocationCounter = value;
    }

    @Override
    public final long getInvocationCounter() {
        return this.invocationCounter;
    }

    @Override
    public final Security getSecurity() {
        return this.security;
    }

    @Override
    public final void setSecurity(Security value) {
        this.security = value;
    }

    @Override
    public void setSecurityPolicy(Set<SecurityPolicy> value) {
        this.securityPolicy.addAll(value);
    }

    @Override
    public Set<SecurityPolicy> getSecurityPolicy() {
        return this.securityPolicy;
    }

    @Override
    public final byte[] getSystemTitle() {
        return this.systemTitle;
    }

    @Override
    public final void setSystemTitle(byte[] value) {
        if (value != null && value.length != 8) {
            throw new IllegalArgumentException("Invalid system title.");
        }
        this.systemTitle = value;
    }

    @Override
    public final byte[] getRecipientSystemTitle() {
        return this.recipientSystemTitle;
    }

    public final void setRecipientSystemTitle(byte[] value) {
        if (value != null && value.length != 8) {
            throw new IllegalArgumentException("Invalid recipient system title.");
        }
        this.recipientSystemTitle = value;
    }

    @Override
    public final byte[] getBlockCipherKey() {
        return this.blockCipherKey;
    }

    @Override
    public final void setBlockCipherKey(byte[] value) {
        if (value != null && value.length != 0 && (this.getSecuritySuite() != SecuritySuite.SUITE_2 && value.length != 16 || this.getSecuritySuite() == SecuritySuite.SUITE_2 && value.length != 32)) {
            throw new IllegalArgumentException("Invalid Block Cipher Key.");
        }
        this.blockCipherKey = value;
    }

    @Override
    public final byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    @Override
    public final void setAuthenticationKey(byte[] value) {
        if (value != null && value.length != 0 && (this.getSecuritySuite() != SecuritySuite.SUITE_2 && value.length != 16 || this.getSecuritySuite() == SecuritySuite.SUITE_2 && value.length != 32)) {
            throw new IllegalArgumentException("Invalid Authentication Key.");
        }
        this.authenticationKey = value;
    }

    @Override
    public final void setBroadcastBlockCipherKey(byte[] value) {
        if (value != null && value.length != 0 && (this.getSecuritySuite() != SecuritySuite.SUITE_2 && value.length != 16 || this.getSecuritySuite() == SecuritySuite.SUITE_2 && value.length != 32)) {
            throw new IllegalArgumentException("Invalid Block Cipher Key.");
        }
        this.broadcastBlockCipherKey = value;
    }

    @Override
    public final byte[] getBroadcastBlockCipherKey() {
        return this.broadcastBlockCipherKey;
    }

    @Override
    public final GXx509CertificateCollection getCertificates() {
        return this.certificates;
    }

    @Override
    public KeyPair getEphemeralKeyPair() {
        return this.ephemeralKeyPair;
    }

    @Override
    public void setEphemeralKeyPair(KeyPair value) {
        this.ephemeralKeyPair = value;
    }

    @Override
    public final KeyPair getSigningKeyPair() {
        return this.signingKeyPair;
    }

    @Override
    public final void setSigningKeyPair(KeyPair value) {
        this.signingKeyPair = value;
    }

    @Override
    public final KeyPair getKeyAgreementKeyPair() {
        return this.keyAgreementKeyPair;
    }

    @Override
    public final void setKeyAgreementKeyPair(KeyPair value) {
        this.keyAgreementKeyPair = value;
    }

    @Override
    public SecuritySuite getSecuritySuite() {
        return this.securitySuite;
    }

    @Override
    public void setSecuritySuite(SecuritySuite value) {
        this.securitySuite = value;
    }

    public byte[] generateGmacPassword(byte[] challenge) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        AesGcmParameter p = new AesGcmParameter(null, 16, Security.AUTHENTICATION, SecuritySuite.SUITE_0, this.invocationCounter, this.systemTitle, this.blockCipherKey, this.authenticationKey);
        p.setType(1);
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(16);
        bb.setUInt32(this.invocationCounter);
        bb.set(GXSecure.encryptAesGcm(true, p, challenge));
        return bb.array();
    }

    @Override
    public byte[] getDedicatedKey() {
        return this.dedicatedKey;
    }

    @Override
    public void setDedicatedKey(byte[] value) {
        this.dedicatedKey = value;
    }

    @Override
    public Signing getSigning() {
        return this.signing;
    }

    @Override
    public void setSigning(Signing value) {
        this.signing = value;
    }

    @Override
    public byte[] getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void setTransactionId(byte[] value) {
        this.transactionId = value;
    }

    @Override
    public KeyPair getTlsKeyPair() {
        return this.tlsKeyPair;
    }

    @Override
    public void setTlsKeyPair(KeyPair value) {
        this.tlsKeyPair = value;
    }
}

