/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSConfirmedServiceError;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSExceptionResponse;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXICipher;
import gurux.dlms.ServiceError;
import gurux.dlms.TranslatorSimpleTags;
import gurux.dlms.TranslatorStandardTags;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.asn.enums.KeyUsage;
import gurux.dlms.enums.AcseServiceProvider;
import gurux.dlms.enums.AssociationResult;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.ConfirmedServiceError;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.Service;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.enums.ApplicationContextName;
import gurux.dlms.secure.AesGcmParameter;
import gurux.dlms.secure.GXCiphering;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

final class GXAPDU {
    private GXAPDU() {
    }

    private static void getAuthenticationString(GXDLMSSettings settings, GXByteBuffer data, boolean ignoreAcse) {
        if (settings.getAuthentication() != Authentication.NONE || !ignoreAcse && settings.getCipher() != null && settings.getCipher().getSecurity() != Security.NONE) {
            data.setUInt8(138);
            data.setUInt8(2);
            data.setUInt8(7);
            data.setUInt8(128);
            data.setUInt8(139);
            data.setUInt8(7);
            byte[] p = new byte[]{96, -123, 116, 5, 8, 2, (byte)settings.getAuthentication().getValue()};
            data.set(p);
        }
        if (settings.getAuthentication() != Authentication.NONE) {
            int len = 0;
            byte[] callingAuthenticationValue = null;
            if (settings.getAuthentication() == Authentication.LOW) {
                if (settings.getPassword() != null) {
                    callingAuthenticationValue = settings.getPassword();
                    len = callingAuthenticationValue.length;
                }
            } else {
                callingAuthenticationValue = settings.getCtoSChallenge();
                len = callingAuthenticationValue.length;
            }
            data.setUInt8(172);
            data.setUInt8(2 + len);
            data.setUInt8(128);
            data.setUInt8(len);
            if (len != 0) {
                data.set(callingAuthenticationValue);
            }
        }
    }

    private static void generateApplicationContextName(int name, GXDLMSSettings settings, GXByteBuffer data, GXICipher cipher) {
        if (settings.getProtocolVersion() != null) {
            data.setUInt8(128);
            data.setUInt8(2);
            data.setUInt8((byte)(8 - settings.getProtocolVersion().length()));
            GXCommon.setBitString(data, settings.getProtocolVersion(), false);
        }
        data.setUInt8(161);
        data.setUInt8(9);
        data.setUInt8(6);
        data.setUInt8(7);
        boolean ciphered = settings.isCiphered(true);
        data.setUInt8(96);
        data.setUInt8(133);
        data.setUInt8(116);
        data.setUInt8(5);
        data.setUInt8(8);
        data.setUInt8(1);
        if (name != 0) {
            data.setUInt8(name);
        } else if (settings.getUseLogicalNameReferencing()) {
            if (ciphered) {
                data.setUInt8(3);
            } else {
                data.setUInt8(1);
            }
        } else if (ciphered) {
            data.setUInt8(4);
        } else {
            data.setUInt8(2);
        }
        if (!settings.isServer() && (ciphered || settings.getAuthentication() == Authentication.HIGH_GMAC || settings.getAuthentication() == Authentication.HIGH_SHA256 || settings.getAuthentication() == Authentication.HIGH_ECDSA)) {
            if (cipher.getSystemTitle() == null || cipher.getSystemTitle().length == 0) {
                throw new IllegalArgumentException("SystemTitle");
            }
            data.setUInt8(166);
            data.setUInt8(2 + cipher.getSystemTitle().length);
            data.setUInt8(4);
            data.setUInt8(cipher.getSystemTitle().length);
            data.set(cipher.getSystemTitle());
            if (settings.getClientPublicKeyCertificate() != null) {
                byte[] raw = settings.getClientPublicKeyCertificate().getEncoded();
                data.setUInt8(167);
                GXCommon.setObjectCount(4 + raw.length, data);
                data.setUInt8(4);
                GXCommon.setObjectCount(raw.length, data);
                data.set(raw);
            }
        }
        if (!settings.isServer() && settings.getUserId() != -1) {
            data.setUInt8(169);
            data.setUInt8(3);
            data.setUInt8(2);
            data.setUInt8(1);
            data.setUInt8(settings.getUserId());
        }
    }

    static void getInitiateRequest(GXDLMSSettings settings, GXByteBuffer data, boolean xml) {
        data.setUInt8(1);
        if (!(settings.getCipher() != null && settings.getCipher().getDedicatedKey() != null && settings.getCipher().getSecurity() != Security.NONE || xml)) {
            data.setUInt8(0);
        } else {
            data.setUInt8(1);
            GXCommon.setObjectCount(settings.getCipher().getDedicatedKey().length, data);
            data.set(settings.getCipher().getDedicatedKey());
        }
        data.setUInt8(0);
        data.setUInt8(0);
        data.setUInt8(settings.getDLMSVersion());
        data.setUInt8(95);
        data.setUInt8(31);
        data.setUInt8(DataType.BITSTRING);
        data.setUInt8(0);
        GXBitString bs = new GXBitString(Conformance.toInteger(settings.getProposedConformance()), 24);
        data.set(bs.getValue());
        data.setUInt16(settings.getMaxPduSize());
    }

    static void generateUserInformation(GXDLMSSettings settings, GXICipher cipher, GXByteBuffer encryptedData, GXByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        data.setUInt8(190);
        if (!settings.isCiphered(true)) {
            data.setUInt8(16);
            data.setUInt8(4);
            data.setUInt8(0);
            int offset = data.size();
            GXAPDU.getInitiateRequest(settings, data, false);
            data.setUInt8(offset - 1, data.size() - offset);
        } else if (encryptedData != null && encryptedData.size() != 0) {
            data.setUInt8((byte)(4 + encryptedData.size()));
            data.setUInt8(4);
            data.setUInt8((byte)(2 + encryptedData.size()));
            data.setUInt8(33);
            data.setUInt8((byte)encryptedData.size());
            data.set(encryptedData);
        } else {
            GXByteBuffer tmp = new GXByteBuffer();
            GXAPDU.getInitiateRequest(settings, tmp, false);
            AesGcmParameter p = new AesGcmParameter(settings, 33, cipher.getSecurity(), cipher.getSecuritySuite(), cipher.getInvocationCounter(), cipher.getSystemTitle(), cipher.getBlockCipherKey(), cipher.getAuthenticationKey());
            byte[] crypted = GXCiphering.encrypt(p, tmp.array());
            cipher.setInvocationCounter(1L + cipher.getInvocationCounter());
            data.setUInt8(2 + crypted.length);
            data.setUInt8(4);
            data.setUInt8(crypted.length);
            data.set(crypted);
        }
    }

    public static void generateAarq(GXDLMSSettings settings, GXICipher cipher, GXByteBuffer encryptedData, GXByteBuffer data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer tmp = new GXByteBuffer();
        GXAPDU.generateApplicationContextName(0, settings, tmp, cipher);
        GXAPDU.getAuthenticationString(settings, tmp, encryptedData != null && encryptedData.size() != 0);
        GXAPDU.generateUserInformation(settings, cipher, encryptedData, tmp);
        data.setUInt8(96);
        GXCommon.setObjectCount(tmp.size(), data);
        data.set(tmp);
    }

    private static void getConformance(long value, GXDLMSTranslatorStructure xml) {
        if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
            for (Conformance it : Conformance.getEnumConstants()) {
                if (((long)it.getValue() & value) == 0L) continue;
                xml.appendLine(48648, "Name", (Object)TranslatorSimpleTags.conformancetoString(it));
            }
        } else {
            for (Conformance it : Conformance.getEnumConstants()) {
                if (((long)it.getValue() & value) == 0L) continue;
                xml.append(TranslatorStandardTags.conformancetoString(it) + " ");
            }
        }
    }

    static SourceDiagnostic parseUserInformation(GXDLMSSettings settings, GXICipher cipher, GXByteBuffer data, GXDLMSTranslatorStructure xml) throws Exception {
        short tag;
        short len = data.getUInt8();
        if (data.size() - data.position() < len) {
            if (xml == null) {
                throw new IllegalArgumentException("Not enough data.");
            }
            xml.appendComment("Error: Invalid data size.");
        }
        if ((tag = data.getUInt8()) != 4) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        len = data.getUInt8();
        if (data.size() - data.position() < len) {
            if (xml == null) {
                throw new IllegalArgumentException("Not enough data.");
            }
            xml.appendComment("Error: Invalid data size.");
        }
        if (xml != null && xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
            xml.appendLine(171, null, (Object)GXCommon.toHex(data.getData(), false, data.position(), len));
            data.position(data.position() + len);
            return SourceDiagnostic.NONE;
        }
        return GXAPDU.parseInitiate(false, settings, cipher, data, xml);
    }

    static SourceDiagnostic parse(boolean initiateRequest, GXDLMSSettings settings, GXICipher cipher, GXByteBuffer data, GXDLMSTranslatorStructure xml, int tag2) {
        int tag;
        boolean response;
        GXByteBuffer tmp2 = new GXByteBuffer();
        tmp2.setUInt8(0);
        boolean bl = response = tag2 == 8;
        if (response) {
            if (xml != null) {
                xml.appendStartTag(8);
            }
            if ((tag = data.getUInt8()) != 0) {
                settings.setQualityOfService((byte)data.getUInt8());
                if (xml != null && xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(48640, "Value", (Object)String.format("%02d", settings.getQualityOfService()));
                }
            }
        } else if (tag2 == 1) {
            short len;
            if (xml != null) {
                xml.appendStartTag(1);
            }
            if ((tag = data.getUInt8()) != 0) {
                if (xml == null && (cipher == null || cipher.getSecurity() != Security.AUTHENTICATION_ENCRYPTION)) {
                    return SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED;
                }
                len = data.getUInt8();
                byte[] tmp = new byte[len];
                data.get(tmp);
                if (settings.getCipher() != null) {
                    settings.getCipher().setDedicatedKey(tmp);
                }
                if (settings.getAssignedAssociation() != null) {
                    settings.getAssignedAssociation().getXDLMSContextInfo().setCypheringInfo(tmp);
                }
                if (xml != null) {
                    xml.appendLine(168, null, (Object)GXCommon.toHex(tmp, false));
                }
            } else if (settings.getCipher() != null) {
                settings.getCipher().setDedicatedKey(null);
            }
            tag = data.getUInt8();
            if (tag != 0) {
                len = data.getUInt8();
                if (xml != null && (initiateRequest || xml.getOutputType() == TranslatorOutputType.SIMPLE_XML)) {
                    xml.appendLine(48649, null, (Object)String.valueOf(len));
                }
            } else if (xml != null && xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                xml.appendLine(65410, null, (Object)"true");
            }
            if ((tag = data.getUInt8()) != 0) {
                settings.setQualityOfService((byte)data.getUInt8());
            }
        } else {
            if (tag2 == 14) {
                if (xml != null) {
                    xml.appendStartTag(14);
                    if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                        data.getUInt8();
                        xml.appendStartTag(65346);
                        ServiceError type = ServiceError.forValue(data.getUInt8());
                        String str = TranslatorStandardTags.serviceErrorToString(type);
                        String value = TranslatorStandardTags.getServiceErrorValue(type, (byte)data.getUInt8());
                        xml.appendLine("x:" + str, null, (Object)value);
                        xml.appendEndTag(65346);
                    } else {
                        xml.appendLine(65344, "Value", (Object)xml.integerToHex(data.getUInt8(), 2));
                        ServiceError type = ServiceError.forValue(data.getUInt8());
                        xml.appendStartTag(65345);
                        xml.appendLine(TranslatorSimpleTags.serviceErrorToString(type), "Value", (Object)TranslatorSimpleTags.getServiceErrorValue(type, (byte)data.getUInt8()));
                        xml.appendEndTag(65345);
                    }
                    xml.appendEndTag(14);
                    return SourceDiagnostic.NONE;
                }
                throw new GXDLMSConfirmedServiceError(ConfirmedServiceError.forValue(data.getUInt8()), ServiceError.forValue(data.getUInt8()), data.getUInt8());
            }
            if (xml != null) {
                xml.appendComment("Error: Failed to decrypt data.");
                data.position(data.size());
                return SourceDiagnostic.NONE;
            }
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (!response) {
            short ver = data.getUInt8();
            settings.setDLMSVersion(ver);
            if (ver != 6 && !settings.isServer()) {
                throw new IllegalArgumentException("Invalid DLMS version number.");
            }
            if (xml != null && (initiateRequest || xml.getOutputType() == TranslatorOutputType.SIMPLE_XML)) {
                xml.appendLine(48641, "Value", (Object)xml.integerToHex(settings.getDLMSVersion(), 2));
            }
        } else {
            if (data.getUInt8() != 6) {
                throw new IllegalArgumentException("Invalid DLMS version number.");
            }
            if (xml != null && (initiateRequest || xml.getOutputType() == TranslatorOutputType.SIMPLE_XML)) {
                xml.appendLine(48646, "Value", (Object)xml.integerToHex(settings.getDLMSVersion(), 2));
            }
        }
        tag = data.getUInt8();
        if (tag != 95) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (data.getUInt8(data.position()) == 31) {
            data.getUInt8();
        }
        data.getUInt8();
        byte[] conformance = new byte[4];
        data.get(conformance);
        GXBitString bs = new GXBitString(conformance);
        int v = bs.toInteger();
        if (settings.isServer()) {
            settings.setNegotiatedConformance(Conformance.forValue(v & Conformance.toInteger(settings.getProposedConformance())));
            if (xml != null) {
                xml.appendStartTag(48643);
                GXAPDU.getConformance(v, xml);
            }
        } else {
            if (xml != null) {
                xml.appendStartTag(48645);
                GXAPDU.getConformance(v, xml);
            }
            Set<Conformance> c = Conformance.forValue(v);
            settings.setNegotiatedConformance(c);
        }
        if (!response) {
            int pdu = data.getUInt16();
            settings.setMaxPduSize(pdu);
            if (xml != null) {
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendEndTag(48643);
                } else if (initiateRequest) {
                    xml.append(48643, false);
                }
                xml.appendLine(48642, "Value", (Object)xml.integerToHex(pdu, 4));
            }
            if (pdu > settings.getMaxServerPDUSize()) {
                settings.setMaxPduSize(settings.getMaxServerPDUSize());
            }
        } else {
            int pduSize = data.getUInt16();
            if (xml == null && pduSize < 64) {
                throw new GXDLMSConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.PDU_SIZE.getValue());
            }
            if (xml != null) {
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendEndTag(48645);
                } else if (initiateRequest) {
                    xml.append(48645, false);
                }
                xml.appendLine(48647, "Value", (Object)xml.integerToHex(pduSize, 4));
            }
            if (pduSize > settings.getMaxServerPDUSize()) {
                pduSize = settings.getMaxServerPDUSize();
            }
            settings.setMaxPduSize(pduSize);
        }
        if (response) {
            tag = data.getUInt16();
            if (xml != null && (initiateRequest || xml.getOutputType() == TranslatorOutputType.SIMPLE_XML)) {
                xml.appendLine(48644, "Value", (Object)xml.integerToHex(tag, 4));
            }
            if (tag == 7) {
                if (initiateRequest) {
                    settings.setUseLogicalNameReferencing(true);
                } else if (!settings.getUseLogicalNameReferencing() && xml == null) {
                    throw new IllegalArgumentException("Invalid VAA.");
                }
            } else if (tag == 64000) {
                if (initiateRequest) {
                    settings.setUseLogicalNameReferencing(false);
                } else if (settings.getUseLogicalNameReferencing()) {
                    throw new IllegalArgumentException("Invalid VAA.");
                }
            } else {
                throw new IllegalArgumentException("Invalid VAA.");
            }
            if (xml != null) {
                xml.appendEndTag(8);
            }
        } else if (xml != null) {
            xml.appendEndTag(1);
        }
        return SourceDiagnostic.NONE;
    }

    static SourceDiagnostic parseInitiate(boolean initiateRequest, GXDLMSSettings settings, GXICipher cipher, GXByteBuffer data, GXDLMSTranslatorStructure xml) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        short tag = data.getUInt8();
        if (tag == 40 || tag == 33 || tag == 72 || tag == 65 || tag == 219 || tag == 220) {
            if (xml != null) {
                byte[] st;
                int cnt;
                int originalPos = data.position();
                if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                    xml.appendStartTag(tag);
                }
                if (tag == 219 || tag == 220) {
                    cnt = GXCommon.getObjectCount(data);
                    st = new byte[cnt];
                    data.get(st);
                    xml.appendLine(65348, null, (Object)GXCommon.toHex(st, false));
                } else {
                    st = settings.getSourceSystemTitle();
                }
                cnt = GXCommon.getObjectCount(data);
                byte[] encrypted = new byte[cnt];
                data.get(encrypted);
                if (cipher != null && xml.isComments()) {
                    int pos = xml.getXmlLength();
                    int pos2 = data.position();
                    try {
                        data.position(originalPos - 1);
                        AesGcmParameter p = new AesGcmParameter(settings, st, settings.getCipher().getBlockCipherKey(), settings.getCipher().getAuthenticationKey());
                        p.setXml(xml);
                        byte[] tmp = GXCiphering.decrypt(settings.getCipher(), p, data);
                        data.clear();
                        data.set(tmp);
                        cipher.setSecurity(p.getSecurity());
                        short tag1 = data.getUInt8();
                        xml.startComment("Decrypted data:");
                        xml.appendLine("Security: " + (Object)((Object)p.getSecurity()));
                        xml.appendLine("Invocation Counter: " + p.getInvocationCounter());
                        GXAPDU.parse(initiateRequest, settings, cipher, data, xml, tag1);
                        xml.endComment();
                    }
                    catch (Exception ex) {
                        xml.setXmlLength(pos);
                        data.position(pos2);
                    }
                }
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(tag, "Value", (Object)GXCommon.toHex(encrypted, false));
                } else {
                    xml.appendLine(65347, null, (Object)GXCommon.toHex(encrypted, false));
                    xml.appendEndTag(tag);
                }
                return SourceDiagnostic.NONE;
            }
            data.position(data.position() - 1);
            AesGcmParameter p = new AesGcmParameter(settings, settings.getSourceSystemTitle(), settings.getCipher().getBlockCipherKey(), settings.getCipher().getAuthenticationKey());
            byte[] tmp = GXCiphering.decrypt(settings.getCipher(), p, data);
            data.size(0);
            data.set(tmp);
            if (settings.isServer()) {
                cipher.setSecurity(p.getSecurity());
            }
            tag = data.getUInt8();
        }
        return GXAPDU.parse(initiateRequest, settings, cipher, data, xml, tag);
    }

    private static ApplicationContextName parseApplicationContextName(GXDLMSSettings settings, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        short len = buff.getUInt8();
        if (buff.size() - buff.position() < len) {
            throw new IllegalArgumentException("Encoding failed. Not enough data.");
        }
        if (buff.getUInt8() != 6) {
            throw new IllegalArgumentException("Encoding failed. Not an Object ID.");
        }
        if (settings.isServer() && settings.getCipher() != null) {
            settings.getCipher().setSecurity(Security.NONE);
        }
        len = buff.getUInt8();
        byte[] tmp = new byte[len];
        buff.get(tmp);
        if (tmp[0] != 96 || tmp[1] != -123 || tmp[2] != 116 || tmp[3] != 5 || tmp[4] != 8 || tmp[5] != 1) {
            if (xml != null) {
                xml.appendLine(161, "Value", (Object)"UNKNOWN");
                return null;
            }
            throw new IllegalArgumentException("Encoding failed. Invalid Application context name.");
        }
        byte name = tmp[6];
        if (xml != null) {
            if (name == 1) {
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(161, "Value", (Object)"LN");
                } else {
                    xml.appendLine(161, null, (Object)"1");
                }
                settings.setUseLogicalNameReferencing(true);
            } else if (name == 3) {
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(161, "Value", (Object)"LN_WITH_CIPHERING");
                } else {
                    xml.appendLine(161, null, (Object)"3");
                }
                settings.setUseLogicalNameReferencing(true);
            } else if (name == 2) {
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(161, "Value", (Object)"SN");
                } else {
                    xml.appendLine(161, null, (Object)"2");
                }
                settings.setUseLogicalNameReferencing(false);
            } else if (name == 4) {
                if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                    xml.appendLine(161, "Value", (Object)"SN_WITH_CIPHERING");
                } else {
                    xml.appendLine(161, null, (Object)"4");
                }
                settings.setUseLogicalNameReferencing(false);
            }
            return null;
        }
        if (settings.assignedAssociation != null) {
            if (settings.assignedAssociation.getApplicationContextName().getContextId().getValue() == name) {
                return null;
            }
            return settings.assignedAssociation.getApplicationContextName().getContextId();
        }
        if (settings.getUseLogicalNameReferencing()) {
            if (name == 1 && (settings.isServer() || settings.getCipher() == null || settings.getCipher().getSecurity() == Security.NONE)) {
                return null;
            }
            if (name == 3 && (settings.isServer() || settings.getCipher() != null && settings.getCipher().getSecurity() != Security.NONE)) {
                return null;
            }
        } else {
            if (name == 2 && (settings.isServer() || settings.getCipher() == null || settings.getCipher().getSecurity() == Security.NONE)) {
                return null;
            }
            if (name == 4 && (settings.isServer() || settings.getCipher() != null && settings.getCipher().getSecurity() != Security.NONE)) {
                return null;
            }
        }
        return ApplicationContextName.values()[name];
    }

    private static void validateAare(GXDLMSSettings settings, GXByteBuffer buff) {
        short tag = buff.getUInt8();
        if (settings.isServer() ? tag != 96 : tag != 97) {
            throw new IllegalArgumentException("Invalid tag.");
        }
    }

    public static Object parsePDU(GXDLMSSettings settings, GXICipher cipher, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        GXAPDU.validateAare(settings, buff);
        int len = GXCommon.getObjectCount(buff);
        int size = buff.size() - buff.position();
        if (len > size) {
            if (xml == null) {
                throw new IllegalArgumentException("Not enough data.");
            }
            xml.appendComment("Error: Invalid data size.");
        }
        if (xml != null) {
            if (settings.isServer()) {
                xml.appendStartTag(96);
            } else {
                xml.appendStartTag(97);
            }
        }
        Object ret = GXAPDU.parsePDU2(settings, cipher, buff, xml);
        if (xml != null) {
            if (settings.isServer()) {
                xml.appendEndTag(96);
            } else {
                xml.appendEndTag(97);
            }
        }
        return ret;
    }

    private static AcseServiceProvider parseProtocolVersion(GXDLMSSettings settings, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        buff.getUInt8();
        byte unusedBits = (byte)buff.getUInt8();
        if (unusedBits > 8) {
            throw new IllegalArgumentException("unusedBits");
        }
        byte value = (byte)buff.getUInt8();
        StringBuilder sb = new StringBuilder();
        GXCommon.toBitString(sb, value, 8 - unusedBits);
        settings.setProtocolVersion(sb.toString());
        if (xml != null) {
            xml.appendLine(65404, "Value", (Object)settings.getProtocolVersion());
        } else if (!settings.getProtocolVersion().equals("100001")) {
            return AcseServiceProvider.NO_COMMON_ACSE_VERSION;
        }
        if (xml != null) {
            xml.appendLine(65404, "Value", (Object)settings.getProtocolVersion());
        }
        return AcseServiceProvider.NONE;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Object parsePDU2(GXDLMSSettings settings, GXICipher cipher, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        resultComponent = AssociationResult.ACCEPTED;
        msg = null;
        ret /* !! */  = 0;
        name = null;
        block33: while (buff.position() < buff.size()) {
            tag = buff.getUInt8();
            switch (tag) {
                case 161: {
                    name = GXAPDU.parseApplicationContextName(settings, buff, xml);
                    if (name == null) continue block33;
                    if (!settings.isServer()) {
                        switch (1.$SwitchMap$gurux$dlms$objects$enums$ApplicationContextName[name.ordinal()]) {
                            case 1: {
                                msg = " Meter expects Logical Name referencing.";
                                break;
                            }
                            case 2: {
                                msg = " Meter expects Short Name referencing.";
                                break;
                            }
                            case 3: {
                                msg = " Meter expects Logical Name referencing with secured connection.";
                                break;
                            }
                            case 4: {
                                msg = " Meter expects Short Name referencing with secured connection.";
                                break;
                            }
                        }
                        throw new GXDLMSException(AssociationResult.PERMANENT_REJECTED, SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED, msg);
                    }
                    ret /* !! */  = name;
                    continue block33;
                }
                case 162: {
                    if (buff.getUInt8() != 3) {
                        throw new IllegalArgumentException("Invalid tag.");
                    }
                    if (settings.isServer()) {
                        if (buff.getUInt8() != 4) {
                            throw new IllegalArgumentException("Invalid tag.");
                        }
                        len = buff.getUInt8();
                        tmp = new byte[len];
                        buff.get(tmp);
                        if (xml == null) continue block33;
                        xml.appendLine(65405, "Value", (Object)GXCommon.toHex(tmp, false));
                        continue block33;
                    }
                    if (buff.getUInt8() != 2) {
                        throw new IllegalArgumentException("Invalid tag.");
                    }
                    if (buff.getUInt8() != 1) {
                        throw new IllegalArgumentException("Invalid tag.");
                    }
                    resultComponent = AssociationResult.forValue(buff.getUInt8());
                    if (xml == null) continue block33;
                    if (resultComponent != AssociationResult.ACCEPTED) {
                        xml.appendComment(resultComponent.toString());
                    }
                    xml.appendLine(162, "Value", (Object)xml.integerToHex(resultComponent.getValue(), 2));
                    xml.appendStartTag(163);
                    continue block33;
                }
                case 163: {
                    ret /* !! */  = GXAPDU.parseSourceDiagnostic(settings, buff, xml);
                    continue block33;
                }
                case 164: {
                    GXAPDU.parseResult(settings, buff, xml);
                    continue block33;
                }
                case 166: {
                    buff.getUInt8();
                    buff.getUInt8();
                    len = buff.getUInt8();
                    tmp = new byte[len];
                    buff.get(tmp);
                    try {
                        if (tmp.length == 8) {
                            settings.setSourceSystemTitle(tmp);
                        } else {
                            settings.setSourceSystemTitle(null);
                        }
                    }
                    catch (Exception ex) {
                        if (xml != null) ** GOTO lbl74
                        throw ex;
                    }
lbl74:
                    // 3 sources

                    GXAPDU.appendClientSystemTitleToXml(settings, xml);
                    continue block33;
                }
                case 170: {
                    buff.getUInt8();
                    tag = buff.getUInt8();
                    len = buff.getUInt8();
                    tmp = new byte[len];
                    buff.get(tmp);
                    settings.setStoCChallenge(tmp);
                    GXAPDU.appendServerSystemTitleToXml(settings, xml, tag);
                    continue block33;
                }
                case 169: {
                    buff.getUInt8();
                    buff.getUInt8();
                    buff.getUInt8();
                    settings.setUserId(buff.getUInt8());
                    if (xml == null) continue block33;
                    xml.appendLine(169, "Value", (Object)xml.integerToHex(settings.getUserId(), 2));
                    continue block33;
                }
                case 165: {
                    len = GXCommon.getObjectCount(buff);
                    tag = buff.getUInt8();
                    len = GXCommon.getObjectCount(buff);
                    if (tag == 4) {
                        tmp2 /* !! */  = (AcseServiceProvider)new byte[len];
                        buff.get((byte[])tmp2 /* !! */ );
                        if (xml != null) {
                            xml.appendLine(167, "Value", (Object)GXCommon.toHex((byte[])tmp2 /* !! */ , false));
                        }
                        try {
                            cert = new GXx509Certificate((byte[])tmp2 /* !! */ );
                            settings.setServerPublicKeyCertificate(cert);
                            pk = null;
                            if (cert.getKeyUsage().contains((Object)KeyUsage.KEY_CERT_SIGN)) {
                                if (settings.getCipher().getKeyAgreementKeyPair() != null) {
                                    pk = settings.getCipher().getKeyAgreementKeyPair().getPrivate();
                                }
                                settings.getCipher().setKeyAgreementKeyPair(new KeyPair(cert.getPublicKey(), pk));
                            }
                            if (cert.getKeyUsage().contains((Object)KeyUsage.DIGITAL_SIGNATURE)) {
                                if (settings.getCipher().getSigningKeyPair() != null) {
                                    pk = settings.getCipher().getSigningKeyPair().getPrivate();
                                }
                                settings.getCipher().setSigningKeyPair(new KeyPair(cert.getPublicKey(), pk));
                            }
                            if (xml == null || !xml.isComments()) continue block33;
                            xml.appendComment(cert.toString());
                        }
                        catch (Exception ex) {
                            if (xml == null) {
                                throw ex;
                            }
                            xml.appendLine("Invalid certificate.");
                        }
                        continue block33;
                    }
                    settings.setUserId(buff.getUInt8());
                    if (xml == null) continue block33;
                    xml.appendLine(165, "Value", (Object)xml.integerToHex(settings.getUserId(), 2));
                    continue block33;
                }
                case 167: {
                    GXCommon.getObjectCount(buff);
                    tag = buff.getUInt8();
                    len = GXCommon.getObjectCount(buff);
                    if (tag == 4) {
                        tmp2 /* !! */  = (AcseServiceProvider)new byte[len];
                        buff.get((byte[])tmp2 /* !! */ );
                        if (xml != null) {
                            xml.appendLine(167, "Value", (Object)GXCommon.toHex((byte[])tmp2 /* !! */ , false));
                        }
                        try {
                            cert = new GXx509Certificate((byte[])tmp2 /* !! */ );
                            settings.setClientPublicKeyCertificate(cert);
                            pk = null;
                            if (cert.getKeyUsage().contains((Object)KeyUsage.KEY_CERT_SIGN)) {
                                if (settings.getCipher().getKeyAgreementKeyPair() != null) {
                                    pk = settings.getCipher().getKeyAgreementKeyPair().getPrivate();
                                }
                                settings.getCipher().setKeyAgreementKeyPair(new KeyPair(cert.getPublicKey(), pk));
                            }
                            if (cert.getKeyUsage().contains((Object)KeyUsage.DIGITAL_SIGNATURE)) {
                                if (settings.getCipher().getSigningKeyPair() != null) {
                                    pk = settings.getCipher().getSigningKeyPair().getPrivate();
                                }
                                settings.getCipher().setSigningKeyPair(new KeyPair(cert.getPublicKey(), pk));
                            }
                            if (xml == null || !xml.isComments()) continue block33;
                            xml.appendComment(cert.toString());
                        }
                        catch (Exception ex) {
                            if (xml == null) {
                                throw ex;
                            }
                            xml.appendLine("Invalid certificate.");
                        }
                        continue block33;
                    }
                    settings.setUserId(buff.getUInt8());
                    if (xml == null) continue block33;
                    if (settings.isServer()) {
                        xml.appendLine(167, "Value", (Object)xml.integerToHex(settings.getUserId(), 2));
                        continue block33;
                    }
                    xml.appendLine(173, "Value", (Object)xml.integerToHex(settings.getUserId(), 2));
                    continue block33;
                }
                case 168: {
                    if (buff.getUInt8() != 3) {
                        throw new IllegalArgumentException("Invalid tag.");
                    }
                    if (buff.getUInt8() != 2) {
                        throw new IllegalArgumentException("Invalid length.");
                    }
                    if (buff.getUInt8() != 1) {
                        throw new IllegalArgumentException("Invalid tag length.");
                    }
                    len = buff.getUInt8();
                    if (xml == null) continue block33;
                    xml.appendLine(65408, "Value", (Object)xml.integerToHex(len, 2));
                    continue block33;
                }
                case 136: 
                case 138: {
                    if (buff.getUInt8() != 2) {
                        throw new IllegalArgumentException("Invalid tag.");
                    }
                    if (buff.getUInt8() != 7) {
                        throw new IllegalArgumentException("Invalid tag.");
                    }
                    buff.getUInt8();
                    if (xml == null) continue block33;
                    xml.appendLine(tag, "Value", (Object)"1");
                    continue block33;
                }
                case 137: 
                case 139: {
                    GXAPDU.updateAuthentication(settings, buff);
                    if (xml == null) continue block33;
                    if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                        xml.appendLine(tag, "Value", (Object)settings.getAuthentication().toString());
                        continue block33;
                    }
                    xml.appendLine(tag, "Value", (Object)String.valueOf(settings.getAuthentication().ordinal()));
                    continue block33;
                }
                case 172: {
                    GXAPDU.updatePassword(settings, buff, xml);
                    continue block33;
                }
                case 190: {
                    try {
                        ret2 = GXAPDU.parseUserInformation(settings, cipher, buff, xml);
                        if (ret2 == SourceDiagnostic.NONE) continue block33;
                        return ret2.getValue();
                    }
                    catch (GXDLMSExceptionResponse e) {
                        return e.getExceptionServiceError();
                    }
                    catch (AEADBadTagException e) {
                        return ExceptionServiceError.DECIPHERING_ERROR;
                    }
                    catch (Exception e) {
                        if (xml != null) continue block33;
                        if (resultComponent != AssociationResult.ACCEPTED && ret /* !! */  instanceof SourceDiagnostic && (SourceDiagnostic)ret /* !! */  != SourceDiagnostic.NONE) {
                            throw new GXDLMSException(resultComponent, (SourceDiagnostic)ret /* !! */ );
                        }
                        if (resultComponent != AssociationResult.ACCEPTED && ret /* !! */  instanceof AcseServiceProvider && (AcseServiceProvider)ret /* !! */  != AcseServiceProvider.NONE) {
                            throw new GXDLMSException(resultComponent, (AcseServiceProvider)ret /* !! */ );
                        }
                        throw new GXDLMSException(AssociationResult.PERMANENT_REJECTED, SourceDiagnostic.NO_REASON_GIVEN);
                    }
                }
                case 128: {
                    tmp2 /* !! */  = GXAPDU.parseProtocolVersion(settings, buff, xml);
                    if (tmp2 /* !! */  != AcseServiceProvider.NONE) {
                        resultComponent = AssociationResult.PERMANENT_REJECTED;
                    }
                    ret /* !! */  = tmp2 /* !! */ ;
                    continue block33;
                }
            }
            Logger.getLogger(GXAPDU.class.getName()).log(Level.WARNING, "Unknown tag: " + tag + ".");
            if (buff.position() >= buff.size()) continue;
            len = buff.getUInt8();
            buff.position(buff.position() + len);
        }
        if (!settings.isServer() && xml == null && resultComponent != AssociationResult.ACCEPTED && !(ret /* !! */  instanceof Integer)) {
            if (ret /* !! */  instanceof SourceDiagnostic) {
                throw new GXDLMSException(resultComponent, (SourceDiagnostic)ret /* !! */ );
            }
            throw new GXDLMSException(resultComponent, (AcseServiceProvider)ret /* !! */ );
        }
        if (name != null) {
            return name;
        }
        return ret /* !! */ ;
    }

    private static void parseResult(GXDLMSSettings settings, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        if (settings.isServer()) {
            if (buff.getUInt8() != 3) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            if (buff.getUInt8() != 2) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            if (buff.getUInt8() != 1) {
                throw new IllegalArgumentException("Invalid tag length.");
            }
            short len = buff.getUInt8();
            if (xml != null) {
                xml.appendLine(65406, "Value", (Object)xml.integerToHex(len, 2));
            }
        } else {
            if (buff.getUInt8() != 10) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            if (buff.getUInt8() != 4) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            short len = buff.getUInt8();
            byte[] tmp = new byte[len];
            buff.get(tmp);
            settings.setSourceSystemTitle(tmp);
            GXAPDU.appendResultToXml(settings, xml);
        }
    }

    private static Object parseSourceDiagnostic(GXDLMSSettings settings, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        Object ret = 0;
        buff.getUInt8();
        short tag = buff.getUInt8();
        short len = buff.getUInt8();
        short tag2 = buff.getUInt8();
        if (tag2 == 4) {
            byte[] calledAEQualifier = new byte[len];
            buff.get(calledAEQualifier);
            if (xml != null) {
                xml.appendLine(65409, "Value", (Object)GXCommon.toHex(calledAEQualifier, false));
            }
        } else {
            if (tag2 != 2) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            if (buff.getUInt8() != 1) {
                throw new IllegalArgumentException("Invalid tag.");
            }
            if (tag == 161) {
                ret = SourceDiagnostic.forValue(buff.getUInt8());
                if (xml != null) {
                    if ((SourceDiagnostic)((Object)ret) != SourceDiagnostic.NONE) {
                        xml.appendComment(ret.toString());
                    }
                    xml.appendLine(41729, "Value", (Object)xml.integerToHex(((SourceDiagnostic)((Object)ret)).getValue(), 2));
                }
            } else {
                ret = AcseServiceProvider.forValue(buff.getUInt8());
                if (xml != null) {
                    if ((AcseServiceProvider)((Object)ret) != AcseServiceProvider.NONE) {
                        xml.appendComment(ret.toString());
                    }
                    xml.appendLine(41730, "Value", (Object)xml.integerToHex(((AcseServiceProvider)((Object)ret)).getValue(), 2));
                }
            }
            if (xml != null) {
                xml.appendEndTag(163);
            }
        }
        return ret;
    }

    private static void appendServerSystemTitleToXml(GXDLMSSettings settings, GXDLMSTranslatorStructure xml, int tag) {
        if (xml != null) {
            if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                xml.appendLine(tag, null, (Object)GXCommon.toHex(settings.getStoCChallenge(), false));
            } else {
                xml.append(tag, true);
                xml.append(170, true);
                xml.append(GXCommon.toHex(settings.getStoCChallenge(), false));
                xml.append(170, false);
                xml.append(tag, false);
                xml.append("\r\n");
            }
        }
    }

    private static void appendClientSystemTitleToXml(GXDLMSSettings settings, GXDLMSTranslatorStructure xml) {
        if (xml != null) {
            xml.appendLine(166, "Value", (Object)GXCommon.toHex(settings.getSourceSystemTitle(), false));
        }
    }

    private static void appendResultToXml(GXDLMSSettings settings, GXDLMSTranslatorStructure xml) {
        if (xml != null) {
            xml.appendLine(164, "Value", (Object)GXCommon.toHex(settings.getSourceSystemTitle(), false));
        }
    }

    private static void updatePassword(GXDLMSSettings settings, GXByteBuffer buff, GXDLMSTranslatorStructure xml) {
        buff.getUInt8();
        if (buff.getUInt8() != 128) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        short len = buff.getUInt8();
        byte[] tmp = new byte[len];
        buff.get(tmp);
        if (settings.getAuthentication() == Authentication.LOW) {
            settings.setPassword(tmp);
        } else {
            settings.setCtoSChallenge(tmp);
        }
        if (xml != null) {
            if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                if (settings.getAuthentication() == Authentication.LOW) {
                    if (GXByteBuffer.isAsciiString(settings.getPassword())) {
                        xml.appendComment(new String(settings.getPassword()));
                    }
                    xml.appendLine(172, "Value", (Object)GXCommon.toHex(settings.getPassword(), false));
                } else {
                    xml.appendLine(172, "Value", (Object)GXCommon.toHex(settings.getCtoSChallenge(), false));
                }
            } else {
                xml.appendStartTag(172);
                xml.appendStartTag(170);
                if (settings.getAuthentication() == Authentication.LOW) {
                    xml.append(GXCommon.toHex(settings.getPassword(), false));
                } else {
                    xml.append(GXCommon.toHex(settings.getCtoSChallenge(), false));
                }
                xml.appendEndTag(170);
                xml.appendEndTag(172);
            }
        }
    }

    private static void updateAuthentication(GXDLMSSettings settings, GXByteBuffer buff) {
        buff.getUInt8();
        if (buff.getUInt8() != 96) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (buff.getUInt8() != 133) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (buff.getUInt8() != 116) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (buff.getUInt8() != 5) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (buff.getUInt8() != 8) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        if (buff.getUInt8() != 2) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        short ch = buff.getUInt8();
        if (ch < 0 || ch > 7) {
            throw new IllegalArgumentException("Invalid tag.");
        }
        settings.setAuthentication(Authentication.forValue(ch));
    }

    static byte[] getUserInformation(GXDLMSSettings settings, GXICipher cipher) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(8);
        if (settings.getQualityOfService() == 0) {
            data.setUInt8(0);
        } else {
            data.setUInt8(1);
            data.setUInt8(settings.getQualityOfService());
        }
        data.setUInt8(6);
        data.setUInt8(95);
        data.setUInt8(31);
        data.setUInt8(DataType.BITSTRING);
        data.setUInt8(0);
        GXBitString bs = new GXBitString(Conformance.toInteger(settings.getNegotiatedConformance()), 24);
        data.set(bs.getValue());
        data.setUInt16(settings.getMaxPduSize());
        if (settings.getUseLogicalNameReferencing()) {
            data.setUInt16(7);
        } else {
            data.setUInt16(64000);
        }
        if (settings.isCiphered(false)) {
            AesGcmParameter p = new AesGcmParameter(settings, 40, cipher.getSecurity(), cipher.getSecuritySuite(), cipher.getInvocationCounter(), cipher.getSystemTitle(), cipher.getBlockCipherKey(), cipher.getAuthenticationKey());
            byte[] tmp = GXCiphering.encrypt(p, data.array());
            cipher.setInvocationCounter(1L + cipher.getInvocationCounter());
            return tmp;
        }
        return data.array();
    }

    public static void generateAARE(int name, GXDLMSSettings settings, GXByteBuffer data, AssociationResult result, Object diagnostic, GXICipher cipher, GXByteBuffer errorData, GXByteBuffer encryptedData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        int offset = data.size();
        data.setUInt8(97);
        GXAPDU.generateApplicationContextName(name, settings, data, cipher);
        data.setUInt8(162);
        data.setUInt8(3);
        data.setUInt8(2);
        data.setUInt8(1);
        data.setUInt8(result.getValue());
        data.setUInt8(163);
        data.setUInt8(5);
        if (diagnostic instanceof SourceDiagnostic) {
            data.setUInt8(161);
        } else {
            data.setUInt8(162);
        }
        data.setUInt8(3);
        data.setUInt8(2);
        data.setUInt8(1);
        if (diagnostic instanceof SourceDiagnostic) {
            data.setUInt8(((SourceDiagnostic)((Object)diagnostic)).getValue());
        } else if (diagnostic instanceof AcseServiceProvider) {
            data.setUInt8(((AcseServiceProvider)((Object)diagnostic)).getValue());
        } else {
            data.setUInt8((Integer)diagnostic);
        }
        if (settings.isCiphered(false) || settings.getAuthentication() == Authentication.HIGH_GMAC || settings.getAuthentication() == Authentication.HIGH_SHA256 || settings.getAuthentication() == Authentication.HIGH_ECDSA) {
            data.setUInt8(164);
            data.setUInt8(2 + cipher.getSystemTitle().length);
            data.setUInt8(4);
            data.setUInt8(cipher.getSystemTitle().length);
            data.set(cipher.getSystemTitle());
        }
        if (settings.getAuthentication() == Authentication.HIGH_ECDSA && settings.getServerPublicKeyCertificate() != null) {
            byte[] raw = settings.getServerPublicKeyCertificate().getEncoded();
            data.setUInt8(167);
            GXCommon.setObjectCount(4 + raw.length, data);
            data.setUInt8(4);
            GXCommon.setObjectCount(raw.length, data);
            data.set(raw);
        } else if (settings.getUserId() != -1) {
            data.setUInt8(165);
            data.setUInt8(3);
            data.setUInt8(2);
            data.setUInt8(1);
            data.setUInt8(settings.getUserId());
        }
        if (settings.getAuthentication().getValue() > Authentication.LOW.getValue()) {
            data.setUInt8(136);
            data.setUInt8(2);
            data.setUInt16(1920);
            data.setUInt8(137);
            data.setUInt8(7);
            data.setUInt8(96);
            data.setUInt8(133);
            data.setUInt8(116);
            data.setUInt8(5);
            data.setUInt8(8);
            data.setUInt8(2);
            data.setUInt8(settings.getAuthentication().getValue());
            data.setUInt8(170);
            data.setUInt8(2 + settings.getStoCChallenge().length);
            data.setUInt8(128);
            data.setUInt8(settings.getStoCChallenge().length);
            data.set(settings.getStoCChallenge());
        }
        if (result == AssociationResult.ACCEPTED || cipher == null || cipher.getSecurity() == Security.NONE) {
            byte[] tmp;
            data.setUInt8(190);
            if (encryptedData != null && encryptedData.size() != 0) {
                GXByteBuffer tmp2 = new GXByteBuffer(2 + encryptedData.size());
                tmp2.setUInt8(40);
                GXCommon.setObjectCount(encryptedData.size(), tmp2);
                tmp2.set(encryptedData);
                tmp = tmp2.array();
            } else {
                tmp = errorData != null && errorData.size() != 0 ? errorData.array() : GXAPDU.getUserInformation(settings, cipher);
            }
            data.setUInt8(2 + tmp.length);
            data.setUInt8(4);
            data.setUInt8(tmp.length);
            data.set(tmp);
        }
        GXCommon.insertObjectCount(data.size() - offset - 1, data, offset + 1);
    }
}

