/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXUInt16;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt8;
import gurux.dlms.enums.DataType;
import gurux.dlms.internal.GXCommon;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class GXByteBuffer {
    private static final int ARRAY_CAPACITY = 10;
    private byte[] data;
    private int size;
    private int position;

    public GXByteBuffer() {
    }

    public GXByteBuffer(int capacity) {
        this.capacity(capacity);
    }

    public GXByteBuffer(byte[] value) {
        this.capacity(value.length);
        this.set(value);
    }

    public GXByteBuffer(GXByteBuffer value) {
        this.capacity(value.size - value.position);
        this.set(value);
    }

    public final void clear() {
        this.size(0);
    }

    public final void capacity(int capacity) {
        if (capacity == 0) {
            this.setData(null);
            this.size = 0;
            this.position = 0;
        } else if (this.getData() == null) {
            this.setData(new byte[capacity]);
        } else {
            byte[] tmp = this.getData();
            this.setData(new byte[capacity]);
            if (this.size < capacity) {
                System.arraycopy(tmp, 0, this.getData(), 0, this.size);
            } else {
                System.arraycopy(tmp, 0, this.getData(), 0, capacity);
                this.size(capacity);
            }
        }
    }

    public final int capacity() {
        if (this.getData() == null) {
            return 0;
        }
        return this.getData().length;
    }

    public final void position(int value) {
        if (value < 0 || value > this.size()) {
            throw new IllegalArgumentException("position");
        }
        this.position = value;
    }

    public final int position() {
        return this.position;
    }

    public final int size() {
        return this.size;
    }

    public final void size(int value) {
        if (value < 0 || value > this.capacity()) {
            throw new IllegalArgumentException("size");
        }
        this.size = value;
        if (this.position > this.size) {
            this.position = this.size;
        }
    }

    public int available() {
        return this.size - this.position;
    }

    public final byte[] array() {
        return this.subArray(0, this.size);
    }

    public final byte[] subArray(int index, int count) {
        byte[] tmp = new byte[count];
        if (count != 0) {
            System.arraycopy(this.data, index, tmp, 0, count);
        }
        return tmp;
    }

    public final void move(int srcPos, int destPos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (count != 0) {
            System.arraycopy(this.data, srcPos, this.data, destPos, count);
            this.size(destPos + count);
            if (this.position > this.size) {
                this.position(this.size);
            }
        }
    }

    public final void trim() {
        if (this.size == this.position) {
            this.size(0);
        } else {
            this.move(this.position, 0, this.size - this.position);
        }
        this.position(0);
    }

    public final void setUInt8(int item) {
        this.setUInt8(this.size, item);
        ++this.size;
    }

    public final void setUInt8(DataType item) {
        this.setUInt8(item.getValue());
    }

    public final void setUInt8(int index, int item) {
        if (index >= this.capacity()) {
            this.capacity(index + 10);
        }
        this.data[index] = (byte)item;
    }

    public final void setUInt16(int item) {
        this.setUInt16(this.size, item);
        this.size += 2;
    }

    public final void setUInt16(int index, int item) {
        if (index + 2 >= this.capacity()) {
            this.capacity(index + 10);
        }
        this.data[index] = (byte)(item >> 8 & 0xFF);
        this.data[index + 1] = (byte)(item & 0xFF);
    }

    public final void setUInt32(long item) {
        this.setUInt32(this.size, item);
        this.size += 4;
    }

    public final void setUInt32(int index, long item) {
        if (index + 4 >= this.capacity()) {
            this.capacity(index + 10);
        }
        this.data[index] = (byte)(item >> 24 & 0xFFL);
        this.data[index + 1] = (byte)(item >> 16 & 0xFFL);
        this.data[index + 2] = (byte)(item >> 8 & 0xFFL);
        this.data[index + 3] = (byte)(item & 0xFFL);
    }

    public final void setUInt64(long item) {
        this.setUInt64(this.size, item);
        this.size += 8;
    }

    public final void setUInt64(int index, long item) {
        if (index + 8 >= this.capacity()) {
            this.capacity(index + 10);
        }
        this.data[this.size] = (byte)(item >> 56 & 0xFFL);
        this.data[this.size + 1] = (byte)(item >> 48 & 0xFFL);
        this.data[this.size + 2] = (byte)(item >> 40 & 0xFFL);
        this.data[this.size + 3] = (byte)(item >> 32 & 0xFFL);
        this.data[this.size + 4] = (byte)(item >> 24 & 0xFFL);
        this.data[this.size + 5] = (byte)(item >> 16 & 0xFFL);
        this.data[this.size + 6] = (byte)(item >> 8 & 0xFFL);
        this.data[this.size + 7] = (byte)(item & 0xFFL);
    }

    public final void setFloat(float value) {
        this.setFloat(this.size, value);
        this.size += 4;
    }

    public final void setFloat(int index, float value) {
        int tmp = Float.floatToIntBits(value);
        this.setUInt32(index, tmp);
    }

    public final void setDouble(double value) {
        this.setDouble(this.size, value);
        this.size += 8;
    }

    public final void setDouble(int index, double value) {
        long tmp = Double.doubleToLongBits(value);
        this.setUInt64(index, tmp);
    }

    public final short getUInt8() {
        short value = this.getUInt8(this.position());
        ++this.position;
        return value;
    }

    public final byte getInt8() {
        return (byte)this.getUInt8();
    }

    public final short getUInt8(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("getUInt8");
        }
        return (short)(this.data[index] & 0xFF);
    }

    public final int getUInt16() {
        int value = this.getUInt16(this.position());
        this.position += 2;
        return value;
    }

    public final short getInt16() {
        return (short)this.getUInt16();
    }

    public final int getUInt16(int index) {
        if (index + 2 > this.size) {
            throw new IllegalArgumentException("getUInt16");
        }
        return (this.data[index] & 0xFF) << 8 | this.data[index + 1] & 0xFF;
    }

    public final long getUInt32() {
        long value = this.getUInt32(this.position());
        this.position += 4;
        return value;
    }

    public final int getUInt24() {
        int value = this.getUInt24(this.position());
        this.position += 3;
        return value;
    }

    public final int getInt32() {
        int value = this.getInt32(this.position());
        this.position += 4;
        return value;
    }

    public final int getInt32(int index) {
        if (index + 4 > this.size) {
            throw new IllegalArgumentException("getUInt32");
        }
        return (this.data[index] & 0xFF) << 24 | (this.data[index + 1] & 0xFF) << 16 | (this.data[index + 2] & 0xFF) << 8 | this.data[index + 3] & 0xFF;
    }

    public final int getUInt24(int index) {
        if (index + 3 > this.size) {
            throw new IllegalArgumentException("getUInt24");
        }
        return (this.data[index] & 0xFF) << 16 | (this.data[index + 1] & 0xFF) << 8 | this.data[index + 2] & 0xFF;
    }

    public final long getUInt32(int index) {
        if (index + 4 > this.size) {
            throw new IllegalArgumentException("getUInt32");
        }
        long value = this.data[index] & 0xFF;
        value <<= 24;
        value |= (long)((this.data[index + 1] & 0xFF) << 16);
        value |= (long)((this.data[index + 2] & 0xFF) << 8);
        return value |= (long)(this.data[index + 3] & 0xFF);
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt32());
    }

    public final double getDouble() {
        return Double.longBitsToDouble(this.getInt64());
    }

    public final long getInt64() {
        long value = this.getInt64(this.position);
        this.position += 8;
        return value;
    }

    public final long getInt64(int index) {
        long value = (long)(this.data[index] & 0xFF) << 56;
        value |= (long)(this.data[index + 1] & 0xFF) << 48;
        value |= (long)(this.data[index + 2] & 0xFF) << 40;
        value |= (long)(this.data[index + 3] & 0xFF) << 32;
        value |= (long)(this.data[index + 4] & 0xFF) << 24;
        value |= (long)((this.data[index + 5] & 0xFF) << 16);
        value |= (long)((this.data[index + 6] & 0xFF) << 8);
        return value |= (long)(this.data[index + 7] & 0xFF);
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] value) {
        this.data = value;
    }

    public final BigInteger getUInt64() {
        BigInteger value = this.getUInt64(this.position);
        this.position += 8;
        return value;
    }

    public final BigInteger getUInt64(int index) {
        long value = this.getInt64(index);
        BigInteger b = BigInteger.valueOf(value);
        if (b.compareTo(BigInteger.ZERO) < 0) {
            b = b.add(BigInteger.ONE.shiftLeft(64));
        }
        return b;
    }

    public static boolean isAsciiString(String value) {
        if (value != null) {
            return StandardCharsets.US_ASCII.newEncoder().canEncode(value);
        }
        return true;
    }

    public static boolean isAsciiString(byte[] value) {
        if (value != null) {
            for (byte it : value) {
                if (it >= 32 && it <= 127 || it == 13 || it == 10 || it == 0) continue;
                return false;
            }
        }
        return true;
    }

    public final String getString(int count) {
        String str = this.getString(this.position, count, "ASCII");
        this.position += count;
        return str;
    }

    public final String getString(int index, int count) {
        return this.getString(index, count, "ASCII");
    }

    public final String getString(int index, int count, String charsetName) {
        if (index + count > this.size) {
            throw new IllegalArgumentException("getString");
        }
        try {
            byte[] tmp = this.subArray(index, count);
            if (charsetName.equalsIgnoreCase("ASCII")) {
                if (GXByteBuffer.isAsciiString(tmp)) {
                    return new String(this.getData(), index, count, charsetName).replaceAll("[\\x00]", "");
                }
                return GXCommon.toHex(tmp, true);
            }
            return new String(this.getData(), index, count, charsetName).replaceAll("[\\x00]", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final void set(byte[] value) {
        if (value != null) {
            this.set(value, 0, value.length);
        }
    }

    public final void set(int index, byte[] value) {
        if (value != null) {
            this.move(index, value.length, this.size - index);
            this.set(value, index, value.length);
        }
    }

    public final void set(byte[] value, int index, int count) {
        if (value != null && count != 0) {
            if (this.size + count > this.capacity()) {
                this.capacity(this.size + count + 10);
            }
            System.arraycopy(value, index, this.data, this.size, count);
            this.size += count;
        }
    }

    public final void set(GXByteBuffer value) {
        if (value != null) {
            this.set(value, value.size() - value.position());
        }
    }

    public final void set(GXByteBuffer value, int count) {
        if (this.size + count > this.capacity()) {
            this.capacity(this.size + count + 10);
        }
        if (count != 0) {
            System.arraycopy(value.data, value.position, this.data, this.size, count);
            this.size += count;
            value.position += count;
        }
    }

    public final void add(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                this.set((byte[])value);
            } else if (value instanceof Byte) {
                this.setUInt8(((Byte)value).intValue());
            } else if (value instanceof Short) {
                this.setUInt16(((Short)value).shortValue());
            } else if (value instanceof Integer) {
                this.setUInt32(((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.setUInt64((Long)value);
            } else if (value instanceof String) {
                try {
                    this.set(((String)value).getBytes("ASCII"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else if (value instanceof BigInteger) {
                this.set(((BigInteger)value).toByteArray());
            } else if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.setUInt8(1);
                } else {
                    this.setUInt8(0);
                }
            } else if (value instanceof GXUInt8) {
                this.setUInt16(((GXUInt8)value).shortValue());
            } else if (value instanceof GXUInt16) {
                this.setUInt16(((GXUInt16)value).shortValue());
            } else if (value instanceof GXUInt32) {
                this.setUInt32(((GXUInt32)value).longValue());
            } else {
                throw new RuntimeException("Invalid object type.");
            }
        }
    }

    public final void get(byte[] target) {
        if (this.size - this.position < target.length) {
            throw new IllegalArgumentException("get");
        }
        System.arraycopy(this.getData(), this.position, target, 0, target.length);
        this.position += target.length;
    }

    public final boolean compare(byte[] arr) {
        if (this.size - this.position < arr.length) {
            return false;
        }
        byte[] bytes = new byte[arr.length];
        this.get(bytes);
        boolean ret = Arrays.equals(bytes, arr);
        if (!ret) {
            this.position -= arr.length;
        }
        return ret;
    }

    public final void reverse() {
        if (this.size() == 0) {
            return;
        }
        int first = this.position;
        for (int last = this.size - 1; last > first; --last, ++first) {
            byte tmp = this.data[last];
            this.data[last] = this.data[first];
            this.data[first] = tmp;
        }
    }

    public final void setHexString(String value) {
        this.set(GXCommon.hexToBytes(value));
    }

    public final void setHexString(int index, String value) {
        this.set(index, GXCommon.hexToBytes(value));
    }

    public final void setHexString(String value, int index, int count) {
        this.set(GXCommon.hexToBytes(value), index, count);
    }

    public final String toString() {
        return GXCommon.toHex(this.data, true, 0, this.size);
    }

    public byte[] remaining() {
        return this.subArray(this.position, this.size - this.position);
    }

    public String remainingHexString(boolean addSpace) {
        return GXCommon.toHex(this.data, addSpace, this.position, this.size - this.position);
    }

    public final String toHex(boolean addSpace, int index) {
        return GXCommon.toHex(this.data, addSpace, index, this.size - index);
    }

    public final String toHex(boolean addSpace, int index, int count) {
        return GXCommon.toHex(this.data, addSpace, index, count);
    }
}

