/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.ExceptionStateError;

public class GXDLMSExceptionResponse
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ExceptionStateError exceptionStateError;
    private final ExceptionServiceError exceptionServiceError;
    private final Object exceptionResponseValue;

    public GXDLMSExceptionResponse(ExceptionStateError error, ExceptionServiceError type, Object value) {
        super(GXDLMSExceptionResponse.getStateError(error) + ". " + GXDLMSExceptionResponse.getServiceError(type));
        this.exceptionStateError = error;
        this.exceptionServiceError = type;
        this.exceptionResponseValue = value;
    }

    public final ExceptionStateError getStateError() {
        return this.exceptionStateError;
    }

    public final ExceptionServiceError getExceptionServiceError() {
        return this.exceptionServiceError;
    }

    public final Object getValue() {
        return this.exceptionResponseValue;
    }

    private static String getStateError(ExceptionStateError stateError) {
        switch (stateError) {
            case SERVICE_NOT_ALLOWED: {
                return "Service not allowed";
            }
            case SERVICE_UNKNOWN: {
                return "Service unknown";
            }
        }
        return "";
    }

    private static String getServiceError(ExceptionServiceError serviceError) {
        switch (serviceError) {
            case OPERATION_NOT_POSSIBLE: {
                return "Operation not possible";
            }
            case SERVICE_NOT_SUPPORTED: {
                return "Service not supported";
            }
            case OTHER_REASON: {
                return "Other reason";
            }
            case PDU_TOO_LONG: {
                return "PDU is too long";
            }
            case DECIPHERING_ERROR: {
                return "Ciphering failed";
            }
            case INVOCATION_COUNTER_ERROR: {
                return "Invocation counter is invalid.";
            }
        }
        return "";
    }
}

