/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSLongTransaction;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXReplyData;
import gurux.dlms.GXSNInfo;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ServiceError;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.ConfirmedServiceError;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Service;
import gurux.dlms.enums.TranslatorOutputType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSAssociationShortName;
import gurux.dlms.objects.GXDLMSObject;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

final class GXDLMSSNCommandHandler {
    private static final Logger LOGGER = Logger.getLogger(GXDLMSServerBase.class.getName());

    private GXDLMSSNCommandHandler() {
    }

    private static void handleRead(GXDLMSSettings settings, GXDLMSServerBase server, byte type, GXByteBuffer data, List<ValueEventArgs> list, List<ValueEventArgs> reads, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        int sn = data.getInt16();
        if (xml != null) {
            if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                xml.appendStartTag(65316);
            } else {
                sn &= 0xFFFF;
            }
            if (type == 4) {
                xml.appendStartTag(5, (byte)4);
                xml.appendLine(1282, "Value", (Object)xml.integerToHex(sn, 4));
                xml.appendLine(65295, "Value", (Object)xml.integerToHex(data.getUInt8(), 2));
                GXDataInfo di = new GXDataInfo();
                di.setXml(xml);
                xml.appendStartTag(65296);
                GXCommon.getData(settings, data, di);
                xml.appendEndTag(65296);
                xml.appendEndTag(5, (byte)4);
            } else {
                xml.appendLine(1282, "Value", (Object)xml.integerToHex(sn, 4));
            }
            if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                xml.appendEndTag(65316);
            }
            return;
        }
        GXSNInfo i = GXDLMSSNCommandHandler.findSNObject(server, server.getSettings(), sn &= 0xFFFF);
        ValueEventArgs e = new ValueEventArgs(server, i.getItem(), i.getIndex(), 0, null);
        e.setAction(i.isAction());
        if (type == 4) {
            e.setSelector(data.getUInt8());
            GXDataInfo di = new GXDataInfo();
            e.setParameters(GXCommon.getData(settings, data, di));
        }
        if (!((settings.getConnected() & 2) != 0 || cipheredCommand != 0 || e.isAction() && e.getTarget().getShortName() == 64000 && e.getIndex() == 8)) {
            replyData.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            return;
        }
        list.add(e);
        if (!e.isAction() && server.notifyGetAttributeAccess(e) == 0) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else if (e.isAction() && server.notifyGetMethodAccess(e) == 0) {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        } else {
            reads.add(e);
        }
    }

    private static void handleReadBlockNumberAccess(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml) throws Exception {
        int blockNumber = data.getUInt16();
        if (xml != null) {
            xml.appendStartTag(5, (byte)5);
            xml.appendLine(65298, "Value", (Object)xml.integerToHex(blockNumber, 4));
            xml.appendEndTag(5, (byte)5);
            return;
        }
        GXByteBuffer bb = new GXByteBuffer();
        if (blockNumber != settings.getBlockIndex()) {
            LOGGER.log(Level.INFO, "handleReadBlockNumberAccess failed. Invalid block number. " + settings.getBlockIndex() + "/" + blockNumber);
            bb.setUInt8(ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue());
            GXDLMS.getSNPdu(new GXDLMSSNParameters(settings, 12, 1, 1, bb, null), replyData);
            settings.resetBlockIndex();
            return;
        }
        if (settings.getIndex() != settings.getCount() && server.getTransaction().getData().size() < settings.getMaxPduSize()) {
            ArrayList<ValueEventArgs> reads = new ArrayList<ValueEventArgs>();
            ArrayList<ValueEventArgs> actions = new ArrayList<ValueEventArgs>();
            for (ValueEventArgs it : server.getTransaction().getTargets()) {
                if (it.isAction()) {
                    actions.add(it);
                    continue;
                }
                reads.add(it);
            }
            if (reads.size() != 0) {
                server.notifyRead(reads.toArray(new ValueEventArgs[reads.size()]));
            }
            if (actions.size() != 0) {
                server.notifyAction(actions.toArray(new ValueEventArgs[actions.size()]));
            }
            GXDLMSSNCommandHandler.getReadData(settings, server.getTransaction().getTargets(), server.getTransaction().getData());
            if (reads.size() != 0) {
                server.notifyPostRead(reads.toArray(new ValueEventArgs[reads.size()]));
            }
            if (actions.size() != 0) {
                server.notifyPostAction(actions.toArray(new ValueEventArgs[actions.size()]));
            }
        }
        settings.increaseBlockIndex();
        GXDLMSSNParameters p = new GXDLMSSNParameters(settings, 12, 1, 2, bb, server.getTransaction().getData());
        p.setMultipleBlocks(true);
        GXDLMS.getSNPdu(p, replyData);
        if (server.getTransaction().getData().size() == server.getTransaction().getData().position()) {
            server.setTransaction(null);
            settings.resetBlockIndex();
        } else {
            server.getTransaction().getData().trim();
        }
    }

    private static byte getReadData(GXDLMSSettings settings, ValueEventArgs[] list, GXByteBuffer data) throws InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        boolean first = true;
        byte type = 0;
        for (ValueEventArgs e : list) {
            Object value = e.getHandled() ? e.getValue() : (e.isAction() ? (Object)e.getTarget().invoke(settings, e) : e.getTarget().getValue(settings, e));
            if (e.getError() == ErrorCode.OK) {
                if (!first && list.length != 1) {
                    data.setUInt8(0);
                }
                if (e.isAction()) {
                    GXCommon.setData(settings, data, GXDLMSConverter.getDLMSDataType(value), value);
                } else {
                    GXDLMS.appendData(e.getTarget(), e.getIndex(), data, value);
                }
            } else {
                if (!first && list.length != 1) {
                    data.setUInt8(1);
                }
                data.setUInt8(e.getError().getValue());
                type = 1;
            }
            first = false;
        }
        return type;
    }

    private static void handleReadDataBlockAccess(GXDLMSSettings settings, GXDLMSServerBase server, int command, GXByteBuffer data, int cnt, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        GXByteBuffer bb = new GXByteBuffer();
        short lastBlock = data.getUInt8();
        int blockNumber = data.getUInt16();
        if (xml != null) {
            if (command == 13) {
                xml.appendStartTag(65311);
            } else {
                xml.appendStartTag(65310);
            }
            if (xml.getOutputType() == TranslatorOutputType.SIMPLE_XML) {
                xml.appendLine(65297, null, (Object)xml.integerToHex(lastBlock, 2));
            } else {
                xml.appendLine(65297, null, (Object)(lastBlock != 0 ? "true" : "false"));
            }
            xml.appendLine(65298, null, (Object)xml.integerToHex(blockNumber, 4));
            if (command == 13) {
                xml.appendEndTag(65311);
            } else {
                xml.appendEndTag(65310);
            }
            return;
        }
        if (blockNumber != settings.getBlockIndex()) {
            LOGGER.log(Level.INFO, "handleReadDataBlockAccess failed. Invalid block number. " + settings.getBlockIndex() + "/" + blockNumber);
            bb.setUInt8(ErrorCode.DATA_BLOCK_NUMBER_INVALID.getValue());
            GXDLMS.getSNPdu(new GXDLMSSNParameters(settings, command, 1, 1, bb, null), replyData);
            settings.resetBlockIndex();
            return;
        }
        short count = 1;
        int type = DataType.OCTET_STRING.getValue();
        if (command == 13) {
            count = data.getUInt8();
            type = data.getUInt8();
        }
        int size = GXCommon.getObjectCount(data);
        int realSize = data.size() - data.position();
        if (count != 1 || type != DataType.OCTET_STRING.getValue() || size != realSize) {
            LOGGER.log(Level.INFO, "handleGetRequest failed. Invalid block size.");
            bb.setUInt8(ErrorCode.DATA_BLOCK_UNAVAILABLE.getValue());
            GXDLMS.getSNPdu(new GXDLMSSNParameters(settings, command, cnt, 1, bb, null), replyData);
            settings.resetBlockIndex();
            return;
        }
        if (server.getTransaction() == null) {
            server.setTransaction(new GXDLMSLongTransaction(null, command, data));
        } else {
            server.getTransaction().getData().set(data);
        }
        if (lastBlock == 0) {
            bb.setUInt16(blockNumber);
            settings.increaseBlockIndex();
            type = command == 12 ? 3 : 2;
            GXDLMS.getSNPdu(new GXDLMSSNParameters(settings, command, cnt, type, null, bb), replyData);
            return;
        }
        if (server.getTransaction() != null) {
            data.size(0);
            data.set(server.getTransaction().getData());
            server.setTransaction(null);
        }
        if (command == 12) {
            GXDLMSSNCommandHandler.handleReadRequest(settings, server, data, replyData, xml, cipheredCommand);
        } else {
            GXDLMSSNCommandHandler.handleWriteRequest(settings, server, data, replyData, xml, cipheredCommand);
        }
        settings.resetBlockIndex();
    }

    static void handleReadRequest(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        GXByteBuffer bb = new GXByteBuffer();
        int cnt = 255;
        ArrayList<ValueEventArgs> list = new ArrayList<ValueEventArgs>();
        if (xml == null && data.size() == 0) {
            if (replyData.available() != 0) {
                return;
            }
            for (ValueEventArgs it : server.getTransaction().getTargets()) {
                list.add(it);
            }
        } else {
            cnt = GXCommon.getObjectCount(data);
            ArrayList<ValueEventArgs> reads = new ArrayList<ValueEventArgs>();
            if (xml != null) {
                xml.appendStartTag(5, "Qty", xml.integerToHex(cnt, 2));
            }
            block6: for (int pos = 0; pos != cnt; ++pos) {
                byte type = (byte)data.getUInt8();
                switch (type) {
                    case 2: 
                    case 4: {
                        GXDLMSSNCommandHandler.handleRead(settings, server, type, data, list, reads, replyData, xml, cipheredCommand);
                        continue block6;
                    }
                    case 5: {
                        GXDLMSSNCommandHandler.handleReadBlockNumberAccess(settings, server, data, replyData, xml);
                        if (xml != null) {
                            xml.appendEndTag(5);
                        }
                        return;
                    }
                    case 6: {
                        GXDLMSSNCommandHandler.handleReadDataBlockAccess(settings, server, 12, data, cnt, replyData, xml, cipheredCommand);
                        if (xml != null) {
                            xml.appendEndTag(5);
                        }
                        return;
                    }
                    default: {
                        GXDLMSSNCommandHandler.returnSNError(settings, 12, ErrorCode.READ_WRITE_DENIED, replyData);
                        return;
                    }
                }
            }
            if (reads.size() != 0) {
                server.notifyRead(reads.toArray(new ValueEventArgs[reads.size()]));
            }
        }
        if (xml != null) {
            xml.appendEndTag(5);
            return;
        }
        byte requestType = GXDLMSSNCommandHandler.getReadData(settings, list.toArray(new ValueEventArgs[list.size()]), bb);
        GXDLMSSNParameters p = new GXDLMSSNParameters(settings, 12, cnt, requestType, null, bb);
        GXDLMS.getSNPdu(p, replyData);
        if (server.getTransaction() == null && (bb.size() != bb.position() || settings.getCount() != settings.getIndex())) {
            ArrayList<ValueEventArgs> reads = new ArrayList<ValueEventArgs>();
            for (ValueEventArgs it : list) {
                reads.add(it);
            }
            if (!reads.isEmpty()) {
                server.notifyPostRead(reads.toArray(new ValueEventArgs[reads.size()]));
            }
            server.setTransaction(new GXDLMSLongTransaction(reads.toArray(new ValueEventArgs[reads.size()]), 5, bb));
        } else if (server.getTransaction() != null) {
            replyData.set(bb);
        }
    }

    private static void returnSNError(GXDLMSSettings settings, int cmd, ErrorCode error, GXByteBuffer replyData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(error.getValue());
        GXDLMS.getSNPdu(new GXDLMSSNParameters(settings, cmd, 1, 1, bb, null), replyData);
        settings.resetBlockIndex();
    }

    private static GXSNInfo findSNObject(GXDLMSServerBase server, GXDLMSSettings settings, int sn) throws Exception {
        GXSNInfo i = new GXSNInfo();
        int[] offset = new int[1];
        int[] count = new int[1];
        for (GXDLMSObject it : settings.getObjects()) {
            if (sn < it.getShortName()) continue;
            if (sn < it.getShortName() + it.getAttributeCount() * 8) {
                i.setAction(false);
                i.setItem(it);
                i.setIndex((sn - it.getShortName()) / 8 + 1);
                break;
            }
            GXDLMS.getActionInfo(it.getObjectType(), offset, count);
            if (sn >= it.getShortName() + offset[0] + 8 * count[0]) continue;
            i.setItem(it);
            i.setAction(true);
            i.setIndex((sn - it.getShortName() - offset[0]) / 8 + 1);
            break;
        }
        if (i.getItem() == null && server != null) {
            i.setItem(server.notifyFindObject(ObjectType.NONE, sn, null));
        }
        return i;
    }

    static void handleWriteRequest(GXDLMSSettings settings, GXDLMSServerBase server, GXByteBuffer data, GXByteBuffer replyData, GXDLMSTranslatorStructure xml, int cipheredCommand) throws Exception {
        ArrayList<GXSNInfo> targets = new ArrayList<GXSNInfo>();
        int cnt = GXCommon.getObjectCount(data);
        if (xml != null) {
            xml.appendStartTag(6);
            xml.appendStartTag(65286, "Qty", xml.integerToHex(cnt, 2));
            if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                xml.appendStartTag(65316);
            }
        }
        GXByteBuffer results = new GXByteBuffer(cnt);
        block4: for (int pos = 0; pos != cnt; ++pos) {
            short type = data.getUInt8();
            switch (type) {
                case 2: {
                    int sn = data.getUInt16();
                    if (xml != null) {
                        xml.appendLine(0x600 | type, "Value", (Object)xml.integerToHex(sn, 4));
                        continue block4;
                    }
                    GXSNInfo i = GXDLMSSNCommandHandler.findSNObject(server, server.getSettings(), sn);
                    targets.add(i);
                    if (i == null) {
                        results.setUInt8(ErrorCode.UNDEFINED_OBJECT.getValue());
                        continue block4;
                    }
                    results.setUInt8(ErrorCode.OK.getValue());
                    continue block4;
                }
                case 7: {
                    GXDLMSSNCommandHandler.handleReadDataBlockAccess(settings, server, 13, data, cnt, replyData, xml, cipheredCommand);
                    if (xml == null) {
                        return;
                    }
                }
                default: {
                    results.setUInt8(ErrorCode.HARDWARE_FAULT.getValue());
                }
            }
        }
        if (xml != null) {
            if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                xml.appendEndTag(65316);
            }
            xml.appendEndTag(65286);
        }
        cnt = GXCommon.getObjectCount(data);
        GXDataInfo di = new GXDataInfo();
        if (xml != null) {
            di.setXml(xml);
            xml.appendStartTag(65287, "Qty", xml.integerToHex(cnt, 2));
        }
        for (int pos = 0; pos != cnt; ++pos) {
            int am;
            Object value;
            di.clear();
            if (xml != null) {
                if (xml.getOutputType() == TranslatorOutputType.STANDARD_XML) {
                    xml.appendStartTag(1536);
                }
                value = GXCommon.getData(settings, data, di);
                if (!di.isComplete()) {
                    value = GXCommon.toHex(data.getData(), false, data.position(), data.size() - data.position());
                    xml.appendLine(0xFF0000 + di.getType().getValue(), "Value", (Object)value.toString());
                }
                if (xml.getOutputType() != TranslatorOutputType.STANDARD_XML) continue;
                xml.appendEndTag(1536);
                continue;
            }
            if (results.getUInt8(pos) != 0) continue;
            boolean access = true;
            GXSNInfo target = (GXSNInfo)targets.get(pos);
            value = GXCommon.getData(settings, data, di);
            ValueEventArgs e = new ValueEventArgs(server, target.getItem(), target.getIndex(), 0, null);
            if (target.isAction()) {
                am = server.notifyGetMethodAccess(e);
                if (am == 0) {
                    access = false;
                }
            } else {
                DataType dt;
                if (value instanceof byte[] && (dt = target.getItem().getDataType(target.getIndex())) != DataType.NONE && dt != DataType.OCTET_STRING) {
                    value = GXDLMSClient.changeType((byte[])value, dt, settings);
                }
                if (((am = server.notifyGetAttributeAccess(e)) & AccessMode.WRITE.getValue()) == 0) {
                    access = false;
                }
            }
            if (access) {
                if (target.isAction()) {
                    e.setParameters(value);
                    ValueEventArgs[] actions = new ValueEventArgs[]{e};
                    server.notifyAction(actions);
                    if (e.getHandled()) continue;
                    byte[] reply = target.getItem().invoke(settings, e);
                    server.notifyPostAction(actions);
                    if (!(target.getItem() instanceof GXDLMSAssociationShortName) || target.getIndex() != 8 || reply == null) continue;
                    GXByteBuffer bb = new GXByteBuffer();
                    bb.setUInt8(DataType.OCTET_STRING.getValue());
                    bb.setUInt8(reply.length);
                    bb.set(reply);
                    GXDLMSSNParameters p = new GXDLMSSNParameters(settings, 12, 1, 0, null, bb);
                    GXDLMS.getSNPdu(p, replyData);
                    continue;
                }
                e.setValue(value);
                server.notifyWrite(new ValueEventArgs[]{e});
                if (e.getError() != ErrorCode.OK) {
                    results.setUInt8(pos, e.getError().getValue());
                } else if (!e.getHandled()) {
                    target.getItem().setValue(settings, e);
                }
                server.notifyPostWrite(new ValueEventArgs[]{e});
                continue;
            }
            results.setUInt8(pos, ErrorCode.READ_WRITE_DENIED.getValue());
        }
        if (xml != null) {
            xml.appendEndTag(65287);
            xml.appendEndTag(6);
            return;
        }
        GXByteBuffer bb = new GXByteBuffer(2 * cnt);
        for (int pos = 0; pos != cnt; ++pos) {
            short ret = results.getUInt8(pos);
            if (ret != 0) {
                bb.setUInt8(1);
            }
            bb.setUInt8(ret);
        }
        GXDLMSSNParameters p = new GXDLMSSNParameters(settings, 13, cnt, 255, null, bb);
        GXDLMS.getSNPdu(p, replyData);
    }

    static void handleInformationReport(GXDLMSSettings settings, GXReplyData reply, List<Map.Entry<GXDLMSObject, Integer>> list) throws Exception {
        reply.setTime(null);
        short len = reply.getData().getUInt8();
        byte[] tmp = null;
        if (len != 0) {
            tmp = new byte[len];
            reply.getData().get(tmp);
            reply.setTime((GXDateTime)GXDLMSClient.changeType(tmp, DataType.DATETIME, settings));
        }
        TranslatorOutputType ot = TranslatorOutputType.SIMPLE_XML;
        if (reply.getXml() != null) {
            ot = reply.getXml().getOutputType();
        }
        int count = GXCommon.getObjectCount(reply.getData());
        if (reply.getXml() != null) {
            reply.getXml().appendStartTag(24);
            if (reply.getTime() != null) {
                reply.getXml().appendComment(String.valueOf(reply.getTime()));
                if (ot == TranslatorOutputType.SIMPLE_XML) {
                    reply.getXml().appendLine(65366, null, (Object)GXCommon.toHex(tmp, false));
                } else {
                    reply.getXml().appendLine(65366, null, (Object)GXCommon.generalizedTime(reply.getTime()));
                }
            }
            reply.getXml().appendStartTag(65286, "Qty", reply.getXml().integerToHex(count, 2));
        }
        for (int pos = 0; pos != count; ++pos) {
            short type = reply.getData().getUInt8();
            if (type != 2) continue;
            int sn = reply.getData().getUInt16();
            if (reply.getXml() != null) {
                if (ot == TranslatorOutputType.STANDARD_XML) {
                    reply.getXml().appendStartTag(65316);
                }
                reply.getXml().appendLine(1538, "Value", (Object)reply.getXml().integerToHex(sn, 4));
                if (ot != TranslatorOutputType.STANDARD_XML) continue;
                reply.getXml().appendEndTag(65316);
                continue;
            }
            GXSNInfo info = GXDLMSSNCommandHandler.findSNObject(null, settings, sn);
            if (info.getItem() != null) {
                list.add(new GXSimpleEntry<GXDLMSObject, Integer>(info.getItem(), info.getIndex()));
                continue;
            }
            Logger.getLogger(GXDLMS.class.getName()).log(Level.INFO, "InformationReport message. Unknown object : " + String.valueOf(sn));
        }
        if (reply.getXml() != null) {
            reply.getXml().appendEndTag(65286);
            reply.getXml().appendStartTag(65287, "Qty", reply.getXml().integerToHex(count, 2));
        }
        count = GXCommon.getObjectCount(reply.getData());
        GXDataInfo di = new GXDataInfo();
        di.setXml(reply.getXml());
        for (int pos = 0; pos != count; ++pos) {
            di.clear();
            if (reply.getXml() != null) {
                if (ot == TranslatorOutputType.STANDARD_XML) {
                    reply.getXml().appendStartTag(1536);
                }
                GXCommon.getData(settings, reply.getData(), di);
                if (ot != TranslatorOutputType.STANDARD_XML) continue;
                reply.getXml().appendEndTag(1536);
                continue;
            }
            ValueEventArgs v = new ValueEventArgs(list.get(pos).getKey(), list.get(pos).getValue(), 0, null);
            v.setValue(GXCommon.getData(settings, reply.getData(), di));
            list.get(pos).getKey().setValue(settings, v);
        }
        if (reply.getXml() != null) {
            reply.getXml().appendEndTag(65287);
            reply.getXml().appendEndTag(24);
        }
    }
}

