/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXAPDU;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSConfirmedServiceError;
import gurux.dlms.GXDLMSConnectionEventArgs;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSExceptionResponse;
import gurux.dlms.GXDLMSLNCommandHandler;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSLimits;
import gurux.dlms.GXDLMSLongTransaction;
import gurux.dlms.GXDLMSSNCommandHandler;
import gurux.dlms.GXDLMSSNParameters;
import gurux.dlms.GXDLMSServer;
import gurux.dlms.GXDLMSServer2;
import gurux.dlms.GXDLMSServer3;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXReplyData;
import gurux.dlms.GXServerReply;
import gurux.dlms.IGXCryptoNotifier;
import gurux.dlms.IGXCustomObjectNotifier;
import gurux.dlms.ServiceError;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.AccessMode;
import gurux.dlms.enums.AccessMode3;
import gurux.dlms.enums.AcseServiceProvider;
import gurux.dlms.enums.AssociationResult;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.ConfirmedServiceError;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ExceptionServiceError;
import gurux.dlms.enums.ExceptionStateError;
import gurux.dlms.enums.Initiate;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.MethodAccessMode;
import gurux.dlms.enums.MethodAccessMode3;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.RequestTypes;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.Service;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.SourceDiagnostic;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.manufacturersettings.GXAttributeCollection;
import gurux.dlms.manufacturersettings.GXDLMSAttributeSettings;
import gurux.dlms.objects.GXDLMSAssociationLogicalName;
import gurux.dlms.objects.GXDLMSAssociationShortName;
import gurux.dlms.objects.GXDLMSHdlcSetup;
import gurux.dlms.objects.GXDLMSIECLocalPortSetup;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ApplicationContextName;
import gurux.dlms.objects.enums.AssociationStatus;
import gurux.dlms.objects.enums.BaudRate;
import gurux.dlms.secure.GXSecure;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Calendar;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class GXDLMSServerBase {
    private static final Logger LOGGER = Logger.getLogger(GXDLMSServer.class.getName());
    private final Object owner;
    private GXReplyData info = new GXReplyData();
    private GXByteBuffer receivedData = new GXByteBuffer();
    private GXByteBuffer replyData = new GXByteBuffer();
    private String flaID;
    private GXDLMSIECLocalPortSetup localPortSetup;
    private GXDLMSLongTransaction transaction;
    private final GXDLMSSettings settings;
    private boolean initialized = false;
    private long dataReceived = 0L;

    public byte[] getClientSystemTitle() {
        return this.settings.getPreEstablishedSystemTitle();
    }

    public void setClientSystemTitle(byte[] value) {
        this.settings.setPreEstablishedSystemTitle(value);
    }

    public int getPushClientAddress() {
        return this.settings.getPushClientAddress();
    }

    public void setPushClientAddress(int value) {
        this.settings.setPushClientAddress(value);
    }

    public String getFlaID() {
        return this.flaID;
    }

    public void setFlaID(String value) {
        if (value == null || value.length() != 3) {
            throw new IllegalArgumentException("Invalid FLAG ID.");
        }
        this.flaID = value;
    }

    public GXDLMSIECLocalPortSetup getLocalPortSetup() {
        return this.localPortSetup;
    }

    public void setLocalPortSetup(GXDLMSIECLocalPortSetup value) {
        this.localPortSetup = value;
    }

    public byte getConnectionState() {
        return this.settings.getConnected();
    }

    protected final void setCipher(GXICipher value) {
        this.settings.setCipher(value);
    }

    final void setTransaction(GXDLMSLongTransaction value) {
        this.transaction = value;
    }

    final GXDLMSLongTransaction getTransaction() {
        return this.transaction;
    }

    public final byte[] getCtoSChallenge() {
        return this.settings.getCtoSChallenge();
    }

    public final byte[] getStoCChallenge() {
        return this.settings.getStoCChallenge();
    }

    public final InterfaceType getInterfaceType() {
        return this.settings.getInterfaceType();
    }

    public final void setStoCChallenge(byte[] value) {
        this.settings.setUseCustomChallenge(value != null);
        this.settings.setStoCChallenge(value);
    }

    public final void setStartingPacketIndex(int value) {
        this.settings.setBlockIndex(value);
    }

    public final int getInvokeID() {
        return this.settings.getInvokeID();
    }

    public final void setInvokeID(int value) {
        this.settings.setInvokeID(value);
    }

    public final ServiceClass getServiceClass() {
        return this.settings.getServiceClass();
    }

    public final void setServiceClass(ServiceClass value) {
        this.settings.setServiceClass(value);
    }

    public final Priority getPriority() {
        return this.settings.getPriority();
    }

    public final void setPriority(Priority value) {
        this.settings.setPriority(value);
    }

    public final void setAssignedAssociation(GXDLMSAssociationLogicalName value) {
        this.settings.setAssignedAssociation(value);
    }

    public final GXDLMSAssociationLogicalName getAssignedAssociation() {
        return this.settings.getAssignedAssociation();
    }

    public GXDLMSServerBase(Object forOwner, boolean logicalNameReferencing, InterfaceType type) {
        IGXCryptoNotifier notifier1 = this instanceof IGXCryptoNotifier ? (IGXCryptoNotifier)((Object)this) : null;
        IGXCustomObjectNotifier notifier2 = this instanceof IGXCustomObjectNotifier ? (IGXCustomObjectNotifier)((Object)this) : null;
        this.settings = new GXDLMSSettings(true, notifier1, notifier2);
        this.owner = forOwner;
        this.settings.setUseLogicalNameReferencing(logicalNameReferencing);
        this.settings.setInterfaceType(type);
        this.reset();
    }

    public final GXDLMSObjectCollection getItems() {
        return this.settings.getObjects();
    }

    public final GXDLMSLimits getLimits() {
        return (GXDLMSLimits)this.settings.getHdlcSettings();
    }

    public final GXHdlcSettings getHdlcSettings() {
        return this.settings.getHdlcSettings();
    }

    public boolean getUseUtc2NormalTime() {
        return this.settings.getUseUtc2NormalTime();
    }

    public void setUseUtc2NormalTime(boolean value) {
        this.settings.setUseUtc2NormalTime(value);
    }

    public Set<DateTimeSkips> getDateTimeSkips() {
        return this.settings.getDateTimeSkips();
    }

    public void setDateTimeSkips(Set<DateTimeSkips> value) {
        this.settings.setDateTimeSkips(value);
    }

    public final int getMaxReceivePDUSize() {
        return this.settings.getMaxServerPDUSize();
    }

    public final void setMaxReceivePDUSize(int value) {
        this.settings.setMaxServerPDUSize(value);
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.settings.getUseLogicalNameReferencing();
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        this.settings.setUseLogicalNameReferencing(value);
    }

    public final GXDLMSSettings getSettings() {
        return this.settings;
    }

    public void close() throws Exception {
        for (GXDLMSObject it : this.settings.getObjects()) {
            it.stop(this);
        }
    }

    public final void initialize() {
        GXDLMSObject associationObject = null;
        this.initialized = true;
        for (int pos = 0; pos != this.settings.getObjects().size(); ++pos) {
            GXDLMSObject it = (GXDLMSObject)this.settings.getObjects().get(pos);
            if (it.getLogicalName() == null) {
                throw new IllegalArgumentException("Invalid Logical Name.");
            }
            it.start(this);
            if (it instanceof GXDLMSAssociationShortName && !this.getUseLogicalNameReferencing()) {
                if (((GXDLMSAssociationShortName)it).getObjectList().isEmpty()) {
                    ((GXDLMSAssociationShortName)it).getObjectList().addAll(this.getItems());
                }
                associationObject = it;
                continue;
            }
            if (it instanceof GXDLMSAssociationLogicalName && this.getUseLogicalNameReferencing()) {
                GXDLMSAssociationLogicalName ln = (GXDLMSAssociationLogicalName)it;
                if (ln.getObjectList().isEmpty()) {
                    ln.getObjectList().addAll(this.getItems());
                }
                associationObject = it;
                if (this.settings.getProposedConformance().isEmpty()) continue;
                ln.getXDLMSContextInfo().setConformance(this.settings.getProposedConformance());
                continue;
            }
            if (it instanceof IGXDLMSBase) continue;
            LOGGER.log(Level.INFO, it.getLogicalName() + " not supported.");
            this.settings.getObjects().remove(pos);
            --pos;
        }
        if (associationObject == null) {
            if (this.getUseLogicalNameReferencing()) {
                GXDLMSAssociationLogicalName it = new GXDLMSAssociationLogicalName();
                it.getXDLMSContextInfo().setMaxReceivePduSize(this.settings.getMaxServerPDUSize());
                it.getXDLMSContextInfo().setMaxSendPduSize(this.settings.getMaxServerPDUSize());
                this.getItems().add(it);
                it.getObjectList().addAll(this.getItems());
            } else {
                GXDLMSAssociationShortName it = new GXDLMSAssociationShortName();
                this.getItems().add(it);
                it.getObjectList().addAll(this.getItems());
            }
        }
        if (!this.getUseLogicalNameReferencing()) {
            this.updateShortNames(false);
        }
    }

    final void updateShortNames(boolean force) {
        int sn = 160;
        int[] offset = new int[1];
        int[] count = new int[1];
        for (GXDLMSObject it : this.settings.getObjects()) {
            if (it instanceof GXDLMSAssociationShortName || it instanceof GXDLMSAssociationLogicalName) continue;
            if (force || it.getShortName() == 0) {
                it.setShortName(sn);
                GXDLMS.getActionInfo(it.getObjectType(), offset, count);
                if (count[0] != 0) {
                    sn += offset[0] + 8 * count[0];
                    continue;
                }
                sn += 8 * it.getAttributeCount();
                continue;
            }
            sn = it.getShortName();
        }
    }

    private void handleAarqRequest(GXByteBuffer data, GXDLMSConnectionEventArgs connectionInfo) throws Exception {
        Object ret;
        AssociationResult result = AssociationResult.ACCEPTED;
        GXByteBuffer error = null;
        this.settings.setCtoSChallenge(null);
        if (this.settings.getCipher() != null) {
            this.settings.getCipher().setDedicatedKey(null);
        }
        if (this.settings.getInterfaceType() == InterfaceType.WRAPPER || this.settings.getInterfaceType() == InterfaceType.PDU) {
            this.reset(true);
        }
        int name = 0;
        try {
            ret = GXAPDU.parsePDU(this.settings, this.settings.getCipher(), data, null);
            if (ret instanceof ExceptionServiceError) {
                ExceptionServiceError e = (ExceptionServiceError)((Object)ret);
                if (GXDLMS.useHdlc(this.settings.getInterfaceType())) {
                    this.replyData.set(GXCommon.LLC_REPLY_BYTES);
                }
                this.replyData.setUInt8(216);
                this.replyData.setUInt8(ExceptionStateError.SERVICE_UNKNOWN.getValue());
                this.replyData.setUInt8(e.getValue());
                if (e == ExceptionServiceError.INVOCATION_COUNTER_ERROR) {
                    this.replyData.setUInt32(((Number)this.settings.getInvocationCounter().getValue()).longValue());
                }
                return;
            }
            if (!(ret instanceof AcseServiceProvider)) {
                if (ret instanceof ApplicationContextName) {
                    name = ((ApplicationContextName)((Object)ret)).ordinal();
                    result = AssociationResult.PERMANENT_REJECTED;
                    ret = SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED;
                } else if (this.settings.getNegotiatedConformance().isEmpty()) {
                    result = AssociationResult.PERMANENT_REJECTED;
                    ret = SourceDiagnostic.NO_REASON_GIVEN;
                    error = new GXByteBuffer();
                    error.setUInt8(14);
                    error.setUInt8(ConfirmedServiceError.INITIATE_ERROR.getValue());
                    error.setUInt8(ServiceError.INITIATE.getValue());
                    error.setUInt8(Initiate.INCOMPATIBLE_CONFORMANCE.getValue());
                } else if (this.settings.getMaxPduSize() < 64) {
                    result = AssociationResult.PERMANENT_REJECTED;
                    ret = SourceDiagnostic.NO_REASON_GIVEN;
                    error = new GXByteBuffer();
                    error.setUInt8(14);
                    error.setUInt8(ConfirmedServiceError.INITIATE_ERROR.getValue());
                    error.setUInt8(ServiceError.INITIATE.getValue());
                    error.setUInt8(Initiate.PDU_SIZE_TOO_SHORT.getValue());
                } else if (this.settings.getDLMSVersion() != 6) {
                    this.settings.setDLMSVersion(6);
                    result = AssociationResult.PERMANENT_REJECTED;
                    ret = SourceDiagnostic.NO_REASON_GIVEN;
                    error = new GXByteBuffer();
                    error.setUInt8(14);
                    error.setUInt8(ConfirmedServiceError.INITIATE_ERROR.getValue());
                    error.setUInt8(ServiceError.INITIATE.getValue());
                    error.setUInt8(Initiate.DLMS_VERSION_TOO_LOW.getValue());
                } else if (SourceDiagnostic.forValue((Integer)ret) != SourceDiagnostic.NONE) {
                    result = AssociationResult.PERMANENT_REJECTED;
                    ret = SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED;
                    this.notifyInvalidConnection(connectionInfo);
                } else {
                    GXDLMSAssociationLogicalName ln;
                    Object b;
                    if (this.owner instanceof GXDLMSServer) {
                        if (this.getAssignedAssociation() != null && this.getAssignedAssociation().getAuthenticationMechanismName().getMechanismId() != this.settings.getAuthentication()) {
                            ret = SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED;
                        } else {
                            b = (GXDLMSServer)this.owner;
                            ret = ((GXDLMSServer)b).validateAuthentication(this.settings.getAuthentication(), this.settings.getPassword());
                        }
                    } else if (this.getAssignedAssociation() != null && this.getAssignedAssociation().getAuthenticationMechanismName().getMechanismId() != this.settings.getAuthentication()) {
                        ret = SourceDiagnostic.APPLICATION_CONTEXT_NAME_NOT_SUPPORTED;
                    } else {
                        b = (GXDLMSServer2)this.owner;
                        ret = ((GXDLMSServer2)b).onValidateAuthentication(this.settings.getAuthentication(), this.settings.getPassword());
                    }
                    if (ret != SourceDiagnostic.NONE) {
                        result = AssociationResult.PERMANENT_REJECTED;
                    } else if (this.settings.getAuthentication().getValue() > Authentication.LOW.getValue()) {
                        result = AssociationResult.ACCEPTED;
                        ret = SourceDiagnostic.AUTHENTICATION_REQUIRED;
                        if (this.getUseLogicalNameReferencing()) {
                            ln = this.getAssignedAssociation();
                            if (ln == null && (ln = (GXDLMSAssociationLogicalName)this.getItems().findByLN(ObjectType.ASSOCIATION_LOGICAL_NAME, "0.0.40.0.0.255")) == null) {
                                ln = (GXDLMSAssociationLogicalName)this.notifyFindObject(ObjectType.ASSOCIATION_LOGICAL_NAME, 0, "0.0.40.0.0.255");
                            }
                            if (ln != null) {
                                ln.setAssociationStatus(AssociationStatus.ASSOCIATION_PENDING);
                            }
                        }
                    } else {
                        if (this.getUseLogicalNameReferencing()) {
                            ln = this.getAssignedAssociation();
                            if (ln == null && (ln = (GXDLMSAssociationLogicalName)this.getItems().findByLN(ObjectType.ASSOCIATION_LOGICAL_NAME, "0.0.40.0.0.255")) == null) {
                                ln = (GXDLMSAssociationLogicalName)this.notifyFindObject(ObjectType.ASSOCIATION_LOGICAL_NAME, 0, "0.0.40.0.0.255");
                            }
                            if (ln != null) {
                                ln.setAssociationStatus(AssociationStatus.ASSOCIATED);
                            }
                        }
                        this.settings.setConnected(this.settings.getConnected() | 2);
                    }
                }
            } else if (result == AssociationResult.ACCEPTED && ((AcseServiceProvider)((Object)ret)).getValue() != 0) {
                result = AssociationResult.PERMANENT_REJECTED;
            }
        }
        catch (GXDLMSConfirmedServiceError e) {
            result = AssociationResult.PERMANENT_REJECTED;
            ret = SourceDiagnostic.NO_REASON_GIVEN;
            error = new GXByteBuffer();
            error.setUInt8(14);
            error.setUInt8(e.getConfirmedServiceError().getValue());
            error.setUInt8(e.getServiceError().getValue());
            error.setUInt8(e.getServiceErrorValue());
        }
        catch (IllegalArgumentException e) {
            result = AssociationResult.PERMANENT_REJECTED;
            ret = SourceDiagnostic.NO_REASON_GIVEN;
        }
        catch (GXDLMSException e) {
            result = e.getResult();
            ret = e.getDiagnostic();
        }
        if (GXDLMS.useHdlc(this.settings.getInterfaceType())) {
            this.replyData.set(GXCommon.LLC_REPLY_BYTES);
        }
        if (this.settings.getAuthentication().getValue() > Authentication.LOW.getValue()) {
            this.settings.setStoCChallenge(GXSecure.generateChallenge(this.settings.getAuthentication(), this.settings.getChallengeSize()));
        }
        GXAPDU.generateAARE(name, this.settings, this.replyData, result, ret, this.settings.getCipher(), error, null);
    }

    private void handleReleaseRequest(GXByteBuffer data, GXDLMSConnectionEventArgs connectionInfo) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        if ((this.settings.getConnected() & 2) == 0) {
            this.replyData.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            return;
        }
        if (GXDLMS.useHdlc(this.settings.getInterfaceType())) {
            this.replyData.set(0, GXCommon.LLC_REPLY_BYTES);
        }
        byte[] tmp = GXAPDU.getUserInformation(this.settings, this.settings.getCipher());
        this.replyData.setUInt8(99);
        this.replyData.setUInt8((byte)(tmp.length + 3));
        this.replyData.setUInt8(128);
        this.replyData.setUInt8(1);
        this.replyData.setUInt8(0);
        this.replyData.setUInt8(190);
        this.replyData.setUInt8((byte)(tmp.length + 1));
        this.replyData.setUInt8(4);
        this.replyData.setUInt8((byte)tmp.length);
        this.replyData.set(tmp);
    }

    private void handleSnrmRequest(GXByteBuffer data) {
        GXDLMS.parseSnrmUaResponse(data, this.settings);
        this.reset(true);
        this.replyData.setUInt8(129);
        this.replyData.setUInt8(128);
        this.replyData.setUInt8(0);
        if (this.getHdlc() != null) {
            if (this.settings.getHdlcSettings().getMaxInfoTX() > this.getHdlc().getMaximumInfoLengthReceive()) {
                this.settings.getHdlcSettings().setMaxInfoTX(this.getHdlc().getMaximumInfoLengthReceive());
            }
            if (this.settings.getHdlcSettings().getMaxInfoRX() > this.getHdlc().getMaximumInfoLengthTransmit()) {
                this.settings.getHdlcSettings().setMaxInfoRX(this.getHdlc().getMaximumInfoLengthTransmit());
            }
            if (this.settings.getHdlcSettings().getMaxInfoRX() > this.getHdlc().getMaximumInfoLengthTransmit()) {
                this.settings.getHdlcSettings().setWindowSizeTX(this.getHdlc().getWindowSizeReceive());
            }
            if (this.settings.getHdlcSettings().getMaxInfoRX() > this.getHdlc().getMaximumInfoLengthTransmit()) {
                this.settings.getHdlcSettings().setWindowSizeRX(this.getHdlc().getWindowSizeTransmit());
            }
        }
        this.replyData.setUInt8(5);
        GXDLMS.appendHdlcParameter(this.replyData, this.getHdlcSettings().getMaxInfoTX());
        this.replyData.setUInt8(6);
        GXDLMS.appendHdlcParameter(this.replyData, this.getHdlcSettings().getMaxInfoRX());
        this.replyData.setUInt8(7);
        this.replyData.setUInt8(4);
        this.replyData.setUInt32(this.getHdlcSettings().getWindowSizeTX());
        this.replyData.setUInt8(8);
        this.replyData.setUInt8(4);
        this.replyData.setUInt32(this.getHdlcSettings().getWindowSizeRX());
        int len = this.replyData.size() - 3;
        this.replyData.setUInt8(2, len);
        this.settings.setConnected(1);
    }

    private void generateDisconnectRequest() {
        this.replyData.setUInt8(129);
        this.replyData.setUInt8(128);
        this.replyData.setUInt8(0);
        this.replyData.setUInt8(5);
        this.replyData.setUInt8(1);
        this.replyData.setUInt8(this.getHdlcSettings().getMaxInfoTX());
        this.replyData.setUInt8(6);
        this.replyData.setUInt8(1);
        this.replyData.setUInt8(this.getHdlcSettings().getMaxInfoRX());
        this.replyData.setUInt8(7);
        this.replyData.setUInt8(4);
        this.replyData.setUInt32(this.getHdlcSettings().getWindowSizeTX());
        this.replyData.setUInt8(8);
        this.replyData.setUInt8(4);
        this.replyData.setUInt32(this.getHdlcSettings().getWindowSizeRX());
        int len = this.replyData.size() - 3;
        this.replyData.setUInt8(2, len);
    }

    final void reset(boolean connect) {
        if (!connect) {
            this.info.clear();
            this.settings.setServerAddress(0);
            this.settings.setClientAddress(0);
        }
        this.settings.setProtocolVersion(null);
        this.settings.setEphemeralBlockCipherKey(null);
        this.settings.setEphemeralBroadcastBlockCipherKey(null);
        this.settings.setEphemeralAuthenticationKey(null);
        this.settings.setCtoSChallenge(null);
        this.settings.setStoCChallenge(null);
        this.receivedData.clear();
        this.transaction = null;
        this.settings.setBlockIndex(1);
        this.settings.setCount(0L);
        this.settings.setIndex(0L);
        this.settings.setConnected(0);
        this.replyData.clear();
        this.receivedData.clear();
        this.settings.setPassword(null);
        if (!connect) {
            this.info.clear();
            this.settings.setServerAddress(0);
            this.settings.setClientAddress(0);
            this.setAssignedAssociation(null);
        }
        this.settings.setAuthentication(Authentication.NONE);
        if (this.settings.getCipher() != null) {
            if (!connect) {
                this.settings.getCipher().reset();
            } else {
                this.settings.getCipher().setSecurity(Security.NONE);
            }
        }
        this.dataReceived = 0L;
        this.settings.setGbtCount(0);
    }

    public final void reset() {
        this.reset(false);
    }

    private boolean GetIecPacket() {
        if (this.receivedData.size() < 5) {
            return false;
        }
        int eop = -1;
        int bop = -1;
        for (int pos = this.receivedData.size() - 2; pos != 2; --pos) {
            if (this.receivedData.getUInt8(pos) != 13 || this.receivedData.getUInt8(pos + 1) != 10) continue;
            eop = pos;
            break;
        }
        if (eop == -1) {
            return false;
        }
        for (int pos = eop - 1; pos != -1; --pos) {
            short ch = this.receivedData.getUInt8(pos);
            if (ch != 6 && (pos + 2 >= this.receivedData.size() || ch != 47 || this.receivedData.getUInt8(pos + 1) != 63 || this.receivedData.getUInt8(pos + 2) != 33)) continue;
            bop = pos;
            break;
        }
        if (bop == -1) {
            return false;
        }
        this.receivedData.position(bop);
        return true;
    }

    public final void handleRequest(GXServerReply sr) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        block45: {
            sr.setReply(null);
            if (!(sr.isStreaming() || sr.getData() != null && sr.getData().length != 0)) {
                return;
            }
            if (!this.initialized) {
                throw new RuntimeException("Server not Initialized.");
            }
            try {
                if (!sr.isStreaming()) {
                    int elapsed;
                    boolean first;
                    this.receivedData.set(sr.getData());
                    boolean bl = first = this.settings.getServerAddress() == 0 && this.settings.getClientAddress() == 0;
                    if (this.settings.getInterfaceType() == InterfaceType.HDLC_WITH_MODE_E && this.settings.getConnected() == 0) {
                        if (!this.GetIecPacket()) {
                            return;
                        }
                        if (this.receivedData.getUInt8(this.receivedData.position()) == 6) {
                            BaudRate baudrate;
                            if (this.receivedData.getUInt8(this.receivedData.position() + 1) != 50 || this.receivedData.getUInt8(this.receivedData.position() + 3) != 50) {
                                // empty if block
                            }
                            if ((baudrate = BaudRate.values()[this.receivedData.getUInt8(this.receivedData.position() + 2) - 48]).ordinal() > this.localPortSetup.getProposedBaudrate().ordinal()) {
                                baudrate = this.localPortSetup.getProposedBaudrate();
                            }
                            this.receivedData.clear();
                            this.settings.setConnected(4);
                            sr.setReply(new byte[]{6, 50, (byte)(48 + baudrate.ordinal()), 50, 13, 10});
                            sr.setNewBaudRate(300 << baudrate.ordinal());
                            this.settings.setConnected(4);
                        } else if (this.receivedData.getUInt8(this.receivedData.position()) == 47) {
                            String meterAddress = new String(this.receivedData.subArray(this.receivedData.position() + 3, this.receivedData.available() - 5));
                            if (meterAddress.length() != 0 && meterAddress != this.localPortSetup.getDeviceAddress()) {
                                this.receivedData.clear();
                                return;
                            }
                            this.receivedData.clear();
                            this.receivedData.setUInt8(47);
                            this.receivedData.set(this.flaID.getBytes());
                            this.receivedData.setUInt8(48 + this.localPortSetup.getProposedBaudrate().ordinal());
                            this.receivedData.add(this.localPortSetup.getDeviceAddress());
                            this.receivedData.add("\r\n");
                            sr.setReply(this.receivedData.array());
                            this.receivedData.clear();
                        }
                        return;
                    }
                    try {
                        GXDLMS.getData(this.settings, this.receivedData, this.info, null);
                    }
                    catch (GXDLMSExceptionResponse ex) {
                        this.transaction = null;
                        this.settings.setCount(0L);
                        this.settings.setIndex(0L);
                        this.receivedData.clear();
                        this.dataReceived = Calendar.getInstance().getTimeInMillis();
                        sr.setReply(this.reportError(this.info.getCommand(), ErrorCode.INCONSISTENT_CLASS));
                        return;
                    }
                    catch (Exception ex) {
                        this.transaction = null;
                        this.settings.setCount(0L);
                        this.settings.setIndex(0L);
                        this.receivedData.clear();
                        this.dataReceived = Calendar.getInstance().getTimeInMillis();
                        if ((this.getSettings().getConnected() & 2) != 0) {
                            sr.setReply(this.reportError(this.info.getCommand(), ErrorCode.INCONSISTENT_CLASS));
                        }
                        return;
                    }
                    if (!this.info.isComplete()) {
                        return;
                    }
                    this.receivedData.clear();
                    if (this.info.getCommand() == 83 && this.settings.getConnected() == 0) {
                        if (this.owner instanceof GXDLMSServer) {
                            GXDLMSServer b = (GXDLMSServer)this.owner;
                            if (!b.isTarget(this.settings.getServerAddress(), this.settings.getClientAddress())) {
                                this.info.clear();
                                return;
                            }
                        } else {
                            GXDLMSServer2 b = (GXDLMSServer2)this.owner;
                            if (!b.isTarget(this.settings.getServerAddress(), this.settings.getClientAddress())) {
                                this.info.clear();
                                return;
                            }
                        }
                        sr.setReply(GXDLMS.getHdlcFrame(this.settings, 31, this.replyData));
                        this.info.clear();
                        return;
                    }
                    if (first || this.info.getCommand() == 147 || this.settings.getInterfaceType() == InterfaceType.WRAPPER && this.info.getCommand() == 96) {
                        Object b;
                        if (this.owner instanceof GXDLMSServer) {
                            b = (GXDLMSServer)this.owner;
                            if (!((GXDLMSServer)b).isTarget(this.settings.getServerAddress(), this.settings.getClientAddress())) {
                                this.info.clear();
                                this.settings.setClientAddress(0);
                                this.settings.setServerAddress(0);
                                return;
                            }
                        } else {
                            b = (GXDLMSServer2)this.owner;
                            if (!((GXDLMSServer2)b).isTarget(this.settings.getServerAddress(), this.settings.getClientAddress())) {
                                this.info.clear();
                                this.settings.setClientAddress(0);
                                this.settings.setServerAddress(0);
                                return;
                            }
                        }
                    }
                    if (this.info.getMoreData().contains((Object)RequestTypes.FRAME)) {
                        this.dataReceived = Calendar.getInstance().getTimeInMillis();
                        sr.setReply(GXDLMS.getHdlcFrame(this.settings, this.settings.getReceiverReady(), this.replyData));
                        return;
                    }
                    if (this.info.getCommand() == 0) {
                        if (this.transaction != null) {
                            this.info.setCommand(this.transaction.getCommand());
                        } else if (this.replyData.size() == 0) {
                            sr.setReply(GXDLMS.getHdlcFrame(this.settings, this.settings.getReceiverReady(), this.replyData));
                            return;
                        }
                    }
                    if (this.settings.getHdlc() != null && this.settings.getHdlc().getInactivityTimeout() != 0) {
                        int elapsed2;
                        if (this.info.getCommand() != 147 && (elapsed2 = (int)(Calendar.getInstance().getTimeInMillis() - this.dataReceived) / 1000) >= this.settings.getHdlc().getInactivityTimeout()) {
                            this.reset();
                            this.UpdateDefaultBaudRate(sr);
                            this.dataReceived = 0L;
                            return;
                        }
                    } else if (this.settings.getWrapper() != null && this.settings.getWrapper().getInactivityTimeout() != 0 && this.info.getCommand() != 96 && (elapsed = (int)(Calendar.getInstance().getTimeInMillis() - this.dataReceived) / 1000) >= this.settings.getWrapper().getInactivityTimeout()) {
                        this.reset();
                        this.dataReceived = 0L;
                        return;
                    }
                } else {
                    this.info.setCommand(224);
                }
                try {
                    sr.setReply(this.handleCommand(this.info.getCommand(), this.info.getData(), sr, this.info.getCipheredCommand()));
                }
                catch (Exception ex) {
                    this.settings.resetBlockIndex();
                    this.receivedData.size(0);
                    sr.setReply(this.reportError(this.info.getCommand(), ErrorCode.INCONSISTENT_CLASS));
                    return;
                }
                this.dataReceived = Calendar.getInstance().getTimeInMillis();
                this.info.clear();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.toString());
                if (e instanceof GXDLMSConfirmedServiceError) {
                    sr.setReply(this.reportConfirmedServiceError((GXDLMSConfirmedServiceError)e));
                    this.transaction = null;
                    this.settings.setCount(0L);
                    this.settings.setIndex(0L);
                    this.info.clear();
                    this.receivedData.clear();
                    return;
                }
                if (this.info.getCommand() != 0) {
                    sr.setReply(this.reportError(this.info.getCommand(), ErrorCode.INCONSISTENT_CLASS));
                    this.transaction = null;
                    this.settings.setCount(0L);
                    this.settings.setIndex(0L);
                    this.info.clear();
                    this.receivedData.clear();
                }
                this.reset();
                if ((this.settings.getConnected() & 2) == 0) break block45;
                this.settings.setConnected(this.settings.getConnected() & 0xFFFFFFFD);
                if (this.owner instanceof GXDLMSServer) {
                    GXDLMSServer b = (GXDLMSServer)this.owner;
                    b.disconnected(sr.getConnectionInfo());
                }
                GXDLMSServer2 b = (GXDLMSServer2)this.owner;
                try {
                    b.onDisconnected(sr.getConnectionInfo());
                    this.UpdateDefaultBaudRate(sr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void UpdateDefaultBaudRate(GXServerReply sr) {
        if (this.settings.getInterfaceType() == InterfaceType.HDLC_WITH_MODE_E) {
            sr.setNewBaudRate(300 << this.localPortSetup.getDefaultBaudrate().ordinal());
        }
    }

    private byte[] reportConfirmedServiceError(GXDLMSConfirmedServiceError e) {
        this.replyData.clear();
        if (this.getSettings().getInterfaceType() == InterfaceType.HDLC) {
            GXDLMS.addLLCBytes(this.getSettings(), this.replyData);
        }
        this.replyData.setUInt8(14);
        this.replyData.setUInt8(e.getConfirmedServiceError().getValue());
        this.replyData.setUInt8(e.getServiceError().getValue());
        this.replyData.setUInt8(e.getServiceErrorValue());
        if (this.settings.getInterfaceType() == InterfaceType.WRAPPER) {
            return GXDLMS.getWrapperFrame(this.settings, 14, this.replyData);
        }
        return GXDLMS.getHdlcFrame(this.settings, 0, this.replyData);
    }

    private byte[] reportError(int command, ErrorCode error) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        int cmd;
        switch (command) {
            case 5: {
                cmd = 12;
                break;
            }
            case 6: {
                cmd = 13;
                break;
            }
            case 192: {
                cmd = 196;
                break;
            }
            case 193: {
                cmd = 197;
                break;
            }
            case 195: {
                cmd = 199;
                break;
            }
            case 221: {
                cmd = 221;
                break;
            }
            default: {
                cmd = 0;
            }
        }
        if (this.settings.getUseLogicalNameReferencing()) {
            GXDLMSLNParameters p = new GXDLMSLNParameters(this.settings, 0L, cmd, 1, null, null, error.getValue(), this.info.getCipheredCommand());
            GXDLMS.getLNPdu(p, this.replyData);
        } else {
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(error.getValue());
            GXDLMSSNParameters p = new GXDLMSSNParameters(this.settings, cmd, 1, 1, null, bb);
            GXDLMS.getSNPdu(p, this.replyData);
        }
        if (this.settings.getInterfaceType() == InterfaceType.WRAPPER) {
            return GXDLMS.getWrapperFrame(this.settings, cmd, this.replyData);
        }
        return GXDLMS.getHdlcFrame(this.settings, 0, this.replyData);
    }

    private byte[] handleCommand(int cmd, GXByteBuffer data, GXServerReply sr, int cipheredCommand) throws Exception {
        int frame = 0;
        if (GXDLMS.useHdlc(this.settings.getInterfaceType()) && this.replyData.size() != 0) {
            frame = this.settings.getNextSend(false);
        }
        Boolean invalidCommand = false;
        if (cmd != 96 && cmd != 147 && cmd != 6 && cmd != 195 && cmd != 83 && (this.settings.getConnected() & 2) == 0 && cipheredCommand == 0) {
            this.replyData.clear();
            this.replyData.setUInt8(216);
            this.replyData.setUInt8(ExceptionStateError.SERVICE_UNKNOWN.getValue());
            this.replyData.setUInt8(ExceptionServiceError.SERVICE_NOT_SUPPORTED.getValue());
        } else {
            switch (cmd) {
                case 217: {
                    if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.ACCESS)) {
                        invalidCommand = true;
                        break;
                    }
                    GXDLMSLNCommandHandler.handleAccessRequest(this.settings, this, data, this.replyData, null, cipheredCommand);
                    break;
                }
                case 193: {
                    if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.SET)) {
                        invalidCommand = true;
                        break;
                    }
                    GXDLMSLNCommandHandler.handleSetRequest(this.settings, this, data, this.replyData, null, cipheredCommand);
                    break;
                }
                case 6: {
                    if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.WRITE)) {
                        invalidCommand = true;
                        break;
                    }
                    GXDLMSSNCommandHandler.handleWriteRequest(this.settings, this, data, this.replyData, null, cipheredCommand);
                    break;
                }
                case 192: {
                    if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.GET)) {
                        invalidCommand = true;
                        break;
                    }
                    if (data.size() == 0) break;
                    GXDLMSLNCommandHandler.handleGetRequest(this.settings, this, data, this.replyData, null, cipheredCommand);
                    break;
                }
                case 5: {
                    if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.READ)) {
                        invalidCommand = true;
                        break;
                    }
                    GXDLMSSNCommandHandler.handleReadRequest(this.settings, this, data, this.replyData, null, cipheredCommand);
                    break;
                }
                case 195: {
                    if (!this.settings.getNegotiatedConformance().contains((Object)Conformance.ACTION)) {
                        invalidCommand = true;
                        break;
                    }
                    GXDLMSLNCommandHandler.handleMethodRequest(this.settings, this, data, sr.getConnectionInfo(), this.replyData, null, cipheredCommand);
                    break;
                }
                case 147: {
                    this.handleSnrmRequest(data);
                    frame = 115;
                    break;
                }
                case 96: {
                    this.handleAarqRequest(data, sr.getConnectionInfo());
                    this.settings.updateSecuritySettings(this.settings.getSourceSystemTitle());
                    if ((this.settings.getConnected() & 2) == 0) break;
                    this.notifyConnected(sr.getConnectionInfo());
                    break;
                }
                case 98: {
                    this.handleReleaseRequest(data, sr.getConnectionInfo());
                    if ((this.settings.getConnected() & 2) == 0) break;
                    this.settings.setConnected(this.settings.getConnected() & 0xFFFFFFFD);
                    if (this.owner instanceof GXDLMSServer) {
                        ((GXDLMSServer)this.owner).disconnected(sr.getConnectionInfo());
                        break;
                    }
                    ((GXDLMSServer2)this.owner).onDisconnected(sr.getConnectionInfo());
                    break;
                }
                case 83: {
                    this.replyData.clear();
                    this.generateDisconnectRequest();
                    if (this.settings.getConnected() != 0) {
                        if ((this.settings.getConnected() & 2) != 0) {
                            if (this.owner instanceof GXDLMSServer) {
                                ((GXDLMSServer)this.owner).disconnected(sr.getConnectionInfo());
                            } else {
                                ((GXDLMSServer2)this.owner).onDisconnected(sr.getConnectionInfo());
                            }
                        }
                        this.settings.setConnected(0);
                        this.setAssignedAssociation(null);
                        this.UpdateDefaultBaudRate(sr);
                    }
                    frame = 115;
                    break;
                }
                case 224: {
                    if (this.handleGeneralBlockTransfer(data, sr, this.info.getCipheredCommand())) break;
                    return null;
                }
                case 29: {
                    this.settings.getPlc().parseDiscoverRequest(data);
                    boolean newMeter = this.settings.getPlc().getMacSourceAddress() == 4094 && this.settings.getPlc().getMacDestinationAddress() == 4095;
                    return this.settings.getPlc().discoverReport(this.settings.getPlc().getSystemTitle(), newMeter);
                }
                case 28: {
                    this.settings.getPlc().parseRegisterRequest(data);
                    return this.settings.getPlc().discoverReport(this.settings.getPlc().getSystemTitle(), false);
                }
                case 25: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid command: " + String.valueOf(cmd));
                }
            }
            if (invalidCommand.booleanValue()) {
                this.replyData.clear();
                this.replyData.setUInt8(216);
                this.replyData.setUInt8(ExceptionStateError.SERVICE_UNKNOWN.getValue());
                this.replyData.setUInt8(ExceptionServiceError.SERVICE_NOT_SUPPORTED.getValue());
            }
        }
        byte[] reply = this.settings.getInterfaceType() == InterfaceType.WRAPPER ? GXDLMS.getWrapperFrame(this.settings, cmd, this.replyData) : GXDLMS.getHdlcFrame(this.settings, frame, this.replyData);
        if (cmd == 83 || this.settings.getInterfaceType() == InterfaceType.WRAPPER && cmd == 98) {
            this.reset();
        }
        return reply;
    }

    private boolean handleGeneralBlockTransfer(GXByteBuffer data, GXServerReply sr, int cipheredCommand) throws Exception {
        short bc = 0;
        int blockNumber = 0;
        int blockNumberAck = 0;
        if (!sr.isStreaming()) {
            bc = data.getUInt8();
            blockNumber = data.getUInt16();
            blockNumberAck = data.getUInt16();
            int len = GXCommon.getObjectCount(data);
            if (len > data.size() - data.position()) {
                this.replyData.set(GXDLMSServerBase.generateConfirmedServiceError(ConfirmedServiceError.INITIATE_ERROR, ServiceError.SERVICE, Service.UNSUPPORTED.getValue()));
            }
            if (this.transaction != null) {
                if (this.transaction.getCommand() == 192 || this.transaction.getCommand() == 199) {
                    if (sr.getCount() == 0) {
                        this.settings.setBlockNumberAck(this.settings.getBlockNumberAck() + 1);
                        sr.setCount(bc & 0x3F);
                    }
                    if (this.transaction.getCommand() == 192) {
                        GXDLMSLNCommandHandler.getRequestNextDataBlock(this.settings, 0, this, data, this.replyData, null, true, cipheredCommand);
                    } else {
                        GXDLMSLNCommandHandler.methodRequestNextDataBlock(this.settings, 0, this, data, this.replyData, null, true, cipheredCommand);
                    }
                    if (sr.getCount() != 0) {
                        sr.setCount(sr.getCount() - 1);
                    }
                    if (this.transaction == null) {
                        sr.setCount(0);
                    }
                    if (this.settings.isServer()) {
                        this.settings.setCount(sr.getCount());
                    }
                }
            } else {
                this.transaction.getData().set(data);
                boolean igonoreAck = (bc & 0x40) != 0 && blockNumberAck * this.settings.getGbtWindowSize() + 1 > blockNumber;
                byte windowSize = this.settings.getGbtWindowSize();
                int bn = this.settings.getBlockIndex();
                if ((bc & 0x80) != 0) {
                    this.handleCommand(this.transaction.getCommand(), this.transaction.getData(), sr, cipheredCommand);
                    this.transaction = null;
                    igonoreAck = false;
                    windowSize = 1;
                }
                if (igonoreAck) {
                    return false;
                }
                this.replyData.setUInt8(224);
                this.replyData.setUInt8((byte)(0x80 | windowSize));
                this.settings.setBlockIndex(this.settings.getBlockIndex() + 1);
                this.replyData.setUInt16(bn);
                this.replyData.setUInt16(blockNumber);
                this.replyData.setUInt8(0);
            }
        } else {
            this.transaction = new GXDLMSLongTransaction(null, data.getUInt8(), data);
            this.replyData.setUInt8(224);
            this.replyData.setUInt8(0x80 | this.settings.getGbtWindowSize());
            this.replyData.setUInt16(blockNumber);
            this.replyData.setUInt16(++blockNumberAck);
            this.replyData.setUInt8(0);
        }
        return true;
    }

    static byte[] generateConfirmedServiceError(ConfirmedServiceError service, ServiceError type, int code) {
        return new byte[]{14, (byte)service.getValue(), (byte)type.getValue(), (byte)code};
    }

    final GXDLMSObject notifyFindObject(ObjectType objectType, int sn, String ln) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            return ((GXDLMSServer)this.owner).onFindObject(objectType, sn, ln);
        }
        return ((GXDLMSServer2)this.owner).onFindObject(objectType, sn, ln);
    }

    final void notifyRead(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            ((GXDLMSServer)this.owner).read(args);
        } else {
            ((GXDLMSServer2)this.owner).onPreRead(args);
        }
    }

    final void notifyWrite(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            ((GXDLMSServer)this.owner).write(args);
        } else {
            ((GXDLMSServer2)this.owner).onPreWrite(args);
        }
    }

    public final void notifyAction(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            ((GXDLMSServer)this.owner).action(args);
        } else {
            ((GXDLMSServer2)this.owner).onPreAction(args);
        }
    }

    final void notifyInvalidConnection(GXDLMSConnectionEventArgs connectionInfo) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            ((GXDLMSServer)this.owner).invalidConnection(connectionInfo);
        } else {
            ((GXDLMSServer2)this.owner).onInvalidConnection(connectionInfo);
        }
    }

    final void notifyConnected(GXDLMSConnectionEventArgs connectionInfo) throws Exception {
        if ((this.settings.getConnected() & 2) != 0) {
            if (this.owner instanceof GXDLMSServer) {
                ((GXDLMSServer)this.owner).connected(connectionInfo);
            } else {
                ((GXDLMSServer2)this.owner).onConnected(connectionInfo);
            }
        }
    }

    public final int notifyGetAttributeAccess(ValueEventArgs arg) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            GXAttributeCollection attributes = arg.getTarget().getAttributes();
            GXDLMSAttributeSettings att = attributes.find(arg.getIndex());
            if (att == null) {
                return AccessMode.READ.getValue();
            }
            return att.getAccess().getValue();
        }
        if (this.owner instanceof GXDLMSServer3) {
            if (this.getSettings().getAssignedAssociation().getVersion() < 3) {
                return ((GXDLMSServer3)this.owner).onGetAttributeAccess(arg).getValue();
            }
            return AccessMode3.toInteger(((GXDLMSServer3)this.owner).onGetAttributeAccess3(arg));
        }
        if (arg.getIndex() == 1) {
            return AccessMode.READ.getValue();
        }
        return ((GXDLMSServer2)this.owner).onGetAttributeAccess(arg).getValue();
    }

    public final int notifyGetMethodAccess(ValueEventArgs arg) throws Exception {
        if (this.owner instanceof GXDLMSServer) {
            GXAttributeCollection attributes = arg.getTarget().getMethodAttributes();
            GXDLMSAttributeSettings att = attributes.find(arg.getIndex());
            if (att == null) {
                return MethodAccessMode.NO_ACCESS.getValue();
            }
            return att.getMethodAccess().getValue();
        }
        if (this.owner instanceof GXDLMSServer3) {
            if (this.getSettings().getAssignedAssociation().getVersion() < 3) {
                return ((GXDLMSServer3)this.owner).onGetMethodAccess(arg).getValue();
            }
            return MethodAccessMode3.toInteger(((GXDLMSServer3)this.owner).onGetMethodAccess3(arg));
        }
        return ((GXDLMSServer2)this.owner).onGetMethodAccess(arg).getValue();
    }

    final void notifyPostRead(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer2) {
            ((GXDLMSServer2)this.owner).onPostRead(args);
        }
    }

    final void notifyPostWrite(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer2) {
            ((GXDLMSServer2)this.owner).onPostWrite(args);
        }
    }

    public final void notifyPostAction(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer2) {
            ((GXDLMSServer2)this.owner).onPostAction(args);
        }
    }

    public final void notifyPreGet(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer2) {
            ((GXDLMSServer2)this.owner).onPreGet(args);
        } else if (this.owner instanceof GXDLMSServer) {
            ((GXDLMSServer)this.owner).read(args);
        }
    }

    public final void notifyPostGet(ValueEventArgs[] args) throws Exception {
        if (this.owner instanceof GXDLMSServer2) {
            ((GXDLMSServer2)this.owner).onPostGet(args);
        }
    }

    public GXDLMSHdlcSetup getHdlc() {
        return this.settings.getHdlc();
    }

    public void setHdlc(GXDLMSHdlcSetup value) {
        this.settings.setHdlc(value);
    }
}

