/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSGateway;
import gurux.dlms.GXDLMSTranslatorStructure;
import gurux.dlms.GXDateTime;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.RequestTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GXReplyData {
    private boolean echo = false;
    private Set<RequestTypes> moreData;
    private int command;
    private int cipheredCommand;
    private int commandType;
    private GXByteBuffer data = new GXByteBuffer();
    private boolean complete;
    private short frameId;
    private int error;
    private Object dataValue = null;
    private int totalCount = 0;
    private int readPosition;
    private int packetLength = 0;
    private boolean peek;
    private DataType dataType = DataType.NONE;
    private int cipherIndex = 0;
    private GXDateTime time = null;
    private GXDLMSTranslatorStructure xml;
    private long invokeId;
    private int blockNumber;
    private int blockNumberAck;
    private boolean streaming;
    private byte windowSize;
    private int targetAddress;
    private int sourceAddress;
    private GXDLMSGateway gateway;

    GXReplyData(RequestTypes more, short cmd, GXByteBuffer buff, boolean forComplete, byte err) {
        this.clear();
        this.moreData = new HashSet<RequestTypes>();
        this.moreData.add(more);
        this.command = cmd;
        this.data = buff;
        this.complete = forComplete;
        this.error = err;
    }

    public GXReplyData() {
        this.moreData = new HashSet<RequestTypes>();
        this.clear();
    }

    public final DataType getValueType() {
        return this.dataType;
    }

    public final void setValueType(DataType value) {
        this.dataType = value;
    }

    public final Object getValue() {
        return this.dataValue;
    }

    public final void setValue(Object value) {
        this.dataValue = value;
    }

    public final int getReadPosition() {
        return this.readPosition;
    }

    public final void setReadPosition(int value) {
        this.readPosition = value;
    }

    public final int getPacketLength() {
        return this.packetLength;
    }

    public final void setPacketLength(int value) {
        this.packetLength = value;
    }

    public final void setCommand(int value) {
        this.command = value;
    }

    public final void setData(GXByteBuffer value) {
        this.data = value;
    }

    public final void setComplete(boolean value) {
        this.complete = value;
    }

    public final void setError(int value) {
        this.error = value;
    }

    public final void setTotalCount(int value) {
        this.totalCount = value;
    }

    final void setEcho(boolean value) {
        this.echo = value;
    }

    public final boolean isEcho() {
        return this.echo;
    }

    public final void clear() {
        this.moreData.clear();
        this.command = 0;
        this.cipheredCommand = 0;
        this.commandType = 0;
        this.data.capacity(0);
        this.complete = false;
        this.error = 0;
        this.totalCount = 0;
        this.dataValue = null;
        this.readPosition = 0;
        this.packetLength = 0;
        this.dataType = DataType.NONE;
        this.cipherIndex = 0;
        this.time = null;
        if (this.xml != null) {
            this.xml.setXmlLength(0);
        }
        this.invokeId = 0L;
    }

    public final boolean isMoreData() {
        return !this.moreData.isEmpty() && this.error == 0;
    }

    public boolean isNotify() {
        return this.command == 194 || this.command == 15 || this.command == 24;
    }

    public final Set<RequestTypes> getMoreData() {
        return this.moreData;
    }

    public final int getCommand() {
        return this.command;
    }

    public final GXByteBuffer getData() {
        return this.data;
    }

    public final boolean isComplete() {
        return this.complete;
    }

    public final int getError() {
        return this.error;
    }

    public final String getErrorMessage() {
        return GXDLMS.getDescription(this.error);
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    public final int getCount() {
        if (this.dataValue instanceof List) {
            return ((List)this.dataValue).size();
        }
        return 0;
    }

    public final boolean getPeek() {
        return this.peek;
    }

    public final void setPeek(boolean forValue) {
        this.peek = forValue;
    }

    public final int getCipherIndex() {
        return this.cipherIndex;
    }

    public final void setCipherIndex(int value) {
        this.cipherIndex = value;
    }

    public final GXDateTime getTime() {
        return this.time;
    }

    public final void setTime(GXDateTime value) {
        this.time = value;
    }

    public final int getCommandType() {
        return this.commandType;
    }

    public final void setCommandType(int value) {
        this.commandType = value;
    }

    final GXDLMSTranslatorStructure getXml() {
        return this.xml;
    }

    public void setXml(GXDLMSTranslatorStructure value) {
        this.xml = value;
    }

    public final short getFrameId() {
        return this.frameId;
    }

    public final void setFrameId(short value) {
        this.frameId = value;
    }

    public final long getInvokeId() {
        return this.invokeId;
    }

    public final void setInvokeId(long value) {
        this.invokeId = value;
    }

    public final int getBlockNumber() {
        return this.blockNumber;
    }

    final void setBlockNumber(int value) {
        this.blockNumber = value;
    }

    public final int getBlockNumberAck() {
        return this.blockNumberAck;
    }

    final void setBlockNumberAck(int value) {
        this.blockNumberAck = value;
    }

    public final boolean getStreaming() {
        return this.streaming;
    }

    final void setStreaming(boolean value) {
        this.streaming = value;
    }

    public final byte getWindowSize() {
        return this.windowSize;
    }

    public final void setWindowSize(byte value) {
        this.windowSize = value;
    }

    @Deprecated
    public final boolean IsStreaming() {
        return this.isStreaming();
    }

    public final boolean isStreaming() {
        return this.getStreaming() && this.getBlockNumberAck() * this.getWindowSize() + 1 > this.getBlockNumber();
    }

    public final int getClientAddress() {
        return this.targetAddress;
    }

    public final void setClientAddress(int value) {
        this.targetAddress = value;
    }

    public final int getTargetAddress() {
        return this.targetAddress;
    }

    public final void setTargetAddress(int value) {
        this.targetAddress = value;
    }

    public final int getSourceAddress() {
        return this.sourceAddress;
    }

    public final void setSourceAddress(int value) {
        this.sourceAddress = value;
    }

    public final int getServerAddress() {
        return this.sourceAddress;
    }

    public final void setServerAddress(int value) {
        this.sourceAddress = value;
    }

    public final GXDLMSGateway getGateway() {
        return this.gateway;
    }

    public final void setGateway(GXDLMSGateway value) {
        this.gateway = value;
    }

    public String toString() {
        if (this.xml != null) {
            return this.xml.toString();
        }
        if (this.data == null) {
            return "";
        }
        return this.data.toString();
    }

    public int getCipheredCommand() {
        return this.cipheredCommand;
    }

    public void setCipheredCommand(int value) {
        this.cipheredCommand = value;
    }
}

