/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.GXByteBuffer;
import java.math.BigInteger;

public class GXAsn1Integer
extends Number {
    private static final long serialVersionUID = 1L;
    private byte[] value;

    public GXAsn1Integer() {
    }

    public GXAsn1Integer(long data) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt32(data);
        this.value = bb.array();
    }

    public GXAsn1Integer(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.value = data;
    }

    public GXAsn1Integer(byte[] data, int index, int count) {
        if (data == null || data.length < index + count) {
            throw new IllegalArgumentException("data");
        }
        this.value = new byte[count];
        System.arraycopy(data, index, this.value, 0, count);
    }

    public GXAsn1Integer(String data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.value = new BigInteger(data).toByteArray();
    }

    public final byte[] getByteArray() {
        return this.value;
    }

    public final byte toByte() {
        GXByteBuffer bb = new GXByteBuffer(this.value);
        return bb.getInt8();
    }

    public final short toShort() {
        GXByteBuffer bb = new GXByteBuffer(this.value);
        return bb.getInt16();
    }

    public final String toString() {
        String str;
        switch (this.value.length) {
            case 1: {
                str = String.valueOf(this.toByte());
                break;
            }
            case 2: {
                str = String.valueOf(this.toShort());
                break;
            }
            case 4: {
                str = String.valueOf(this.intValue());
                break;
            }
            case 8: {
                str = String.valueOf(this.longValue());
                break;
            }
            default: {
                str = new BigInteger(this.value).toString();
            }
        }
        return str;
    }

    @Override
    public int intValue() {
        GXByteBuffer bb = new GXByteBuffer(this.value);
        return bb.getInt32();
    }

    @Override
    public long longValue() {
        GXByteBuffer bb = new GXByteBuffer(this.value);
        return bb.getInt64();
    }

    @Override
    public float floatValue() {
        GXByteBuffer bb = new GXByteBuffer(this.value);
        return bb.getInt64();
    }

    @Override
    public double doubleValue() {
        GXByteBuffer bb = new GXByteBuffer(this.value);
        return bb.getInt64();
    }
}

