/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSCertificateException;
import gurux.dlms.asn.CertificateVersion;
import gurux.dlms.asn.GXAsn1Context;
import gurux.dlms.asn.GXAsn1Converter;
import gurux.dlms.asn.GXAsn1Integer;
import gurux.dlms.asn.GXAsn1ObjectIdentifier;
import gurux.dlms.asn.GXAsn1Sequence;
import gurux.dlms.asn.enums.ExtendedKeyUsage;
import gurux.dlms.asn.enums.HashAlgorithm;
import gurux.dlms.asn.enums.KeyUsage;
import gurux.dlms.asn.enums.PkcsType;
import gurux.dlms.asn.enums.X509Certificate;
import gurux.dlms.asn.enums.X509Name;
import gurux.dlms.internal.GXCommon;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GXx509Certificate {
    private byte[] rawData;
    private byte[] subjectKeyIdentifier;
    private byte[] authorityKeyIdentifier;
    private byte[] authorityCertificationSerialNumber;
    private boolean basicConstraints;
    private HashAlgorithm signatureAlgorithm;
    private Object signatureParameters;
    private PublicKey publicKey;
    private HashAlgorithm publicKeySignature;
    private Object parameters;
    private byte[] signature;
    private String subject;
    private String issuer;
    private byte[] issuerRaw;
    private String authorityCertIssuer;
    private BigInteger serialNumber;
    private CertificateVersion version;
    private Date validFrom;
    private Date validTo;
    private Set<KeyUsage> keyUsage = new HashSet<KeyUsage>();
    private Set<ExtendedKeyUsage> extendedKeyUsage = new HashSet<ExtendedKeyUsage>();

    public GXx509Certificate() {
        this.version = CertificateVersion.V3;
    }

    public static Path getFilePath(GXx509Certificate cert) {
        String path;
        if (cert.getKeyUsage().contains((Object)KeyUsage.DIGITAL_SIGNATURE) && cert.getKeyUsage().contains((Object)KeyUsage.KEY_AGREEMENT)) {
            path = "T";
        } else if (cert.getKeyUsage().contains((Object)KeyUsage.DIGITAL_SIGNATURE)) {
            path = "D";
        } else if (cert.getKeyUsage().contains((Object)KeyUsage.KEY_AGREEMENT)) {
            path = "A";
        } else {
            throw new IllegalArgumentException("Unknown certificate type.");
        }
        path = path + GXAsn1Converter.hexSystemTitleFromSubject(cert.getSubject()).trim() + ".pem";
        path = cert.getPublicKey().getEncoded().length < 100 ? Paths.get("Certificates", path).toString() : Paths.get("Certificates384", path).toString();
        return Paths.get(path, new String[0]);
    }

    public GXx509Certificate(String data) {
        String START = "BEGIN CERTIFICATE-----\n";
        String END = "-----END";
        String tmp = data.replace("\r\n", "\n");
        int start = tmp.indexOf("BEGIN CERTIFICATE-----\n");
        if (start == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        int end = tmp.indexOf("-----END");
        if (end == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        this.init(GXCommon.fromBase64(tmp.substring(start + "BEGIN CERTIFICATE-----\n".length(), end)));
    }

    public static GXx509Certificate fromHexString(String data) {
        GXx509Certificate cert = new GXx509Certificate();
        cert.init(GXCommon.hexToBytes(data));
        return cert;
    }

    public static GXx509Certificate fromPem(String data) {
        String START = "BEGIN CERTIFICATE-----\n";
        String END = "-----END";
        String tmp = data.replace("\r\n", "\n");
        int start = tmp.indexOf("BEGIN CERTIFICATE-----\n");
        if (start == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        int end = tmp.indexOf("-----END");
        if (end == -1) {
            throw new IllegalArgumentException("Invalid PEM file.");
        }
        return GXx509Certificate.fromDer(tmp.substring(start + "BEGIN CERTIFICATE-----\n".length(), end));
    }

    public static GXx509Certificate fromDer(String data) {
        GXx509Certificate cert = new GXx509Certificate();
        cert.init(GXCommon.fromBase64(data));
        return cert;
    }

    static String getAlgorithm(String algorithm) {
        if (algorithm.endsWith("RSA")) {
            return "RSA";
        }
        if (algorithm.endsWith("ECDSA")) {
            return "EC";
        }
        throw new IllegalStateException("Unknown algorithm:" + algorithm);
    }

    private void init(byte[] data) {
        KeyFactory eckf;
        this.rawData = data;
        GXAsn1Sequence seq = (GXAsn1Sequence)GXAsn1Converter.fromByteArray(data);
        if (seq.size() != 3) {
            throw new IllegalArgumentException("Wrong number of elements in sequence.");
        }
        if (!(seq.get(0) instanceof GXAsn1Sequence)) {
            PkcsType type = GXAsn1Converter.getCertificateType(data, seq);
            switch (type) {
                case PKCS_8: {
                    throw new GXDLMSCertificateException("Invalid Certificate. This is PKCS 8 private key, not x509 certificate.");
                }
                case PKCS_10: {
                    throw new GXDLMSCertificateException("Invalid Certificate. This is PKCS 10 certification requests, not x509 certificate.");
                }
            }
            throw new GXDLMSCertificateException("Invalid Certificate Version.");
        }
        GXAsn1Sequence reqInfo = (GXAsn1Sequence)seq.get(0);
        if (!(reqInfo.get(0) instanceof GXAsn1Context)) {
            throw new GXDLMSCertificateException("Invalid Certificate Version.");
        }
        this.version = CertificateVersion.forValue(((Number)((GXAsn1Context)reqInfo.get(0)).get(0)).byteValue());
        this.serialNumber = reqInfo.get(1) instanceof GXAsn1Integer ? new BigInteger(((GXAsn1Integer)reqInfo.get(1)).getByteArray()).abs() : BigInteger.valueOf(((Number)reqInfo.get(1)).longValue());
        String tmp = ((GXAsn1Sequence)reqInfo.get(2)).get(0).toString();
        this.signatureAlgorithm = HashAlgorithm.forValue(tmp);
        if (this.signatureAlgorithm != HashAlgorithm.SHA256withECDSA && this.signatureAlgorithm != HashAlgorithm.SHA384withECDSA) {
            throw new IllegalArgumentException("DLMS certificate must be signed with ecdsa-with-SHA256 or ecdsa-with-SHA384.");
        }
        if (((GXAsn1Sequence)reqInfo.get(2)).size() > 1) {
            this.parameters = ((GXAsn1Sequence)reqInfo.get(2)).get(1);
        }
        this.issuerRaw = GXAsn1Converter.toByteArray(reqInfo.get(3));
        this.issuer = GXAsn1Converter.getSubject((GXAsn1Sequence)reqInfo.get(3));
        boolean basicConstraintsExists = false;
        this.validFrom = (Date)((GXAsn1Sequence)reqInfo.get(4)).get(0);
        this.validTo = (Date)((GXAsn1Sequence)reqInfo.get(4)).get(1);
        this.subject = GXAsn1Converter.getSubject((GXAsn1Sequence)reqInfo.get(5));
        GXAsn1Sequence subjectPKInfo = (GXAsn1Sequence)reqInfo.get(6);
        if (reqInfo.size() > 7) {
            block20: for (Iterator it : (GXAsn1Sequence)((GXAsn1Context)reqInfo.get(7)).get(0)) {
                GXAsn1Sequence s = (GXAsn1Sequence)((Object)it);
                GXAsn1ObjectIdentifier id = (GXAsn1ObjectIdentifier)s.get(0);
                Object value = s.get(1);
                X509Certificate t = X509Certificate.forValue(id.toString());
                switch (t) {
                    case SUBJECT_KEY_IDENTIFIER: {
                        this.subjectKeyIdentifier = (byte[])value;
                        break;
                    }
                    case AUTHORITY_KEY_IDENTIFIER: {
                        block21: for (Object i : (GXAsn1Sequence)value) {
                            GXAsn1Context a = (GXAsn1Context)i;
                            switch (a.getIndex()) {
                                case 0: {
                                    this.authorityKeyIdentifier = (byte[])a.get(0);
                                    continue block21;
                                }
                                case 1: {
                                    StringBuilder sb = new StringBuilder();
                                    for (Object kp : (GXAsn1Sequence)((GXAsn1Context)a.get(0)).get(0)) {
                                        Map.Entry it2 = (Map.Entry)kp;
                                        if (sb.length() != 0) {
                                            sb.append(", ");
                                        }
                                        sb.append((Object)X509Name.forValue(String.valueOf(it2.getKey())));
                                        sb.append("=");
                                        sb.append(String.valueOf(it2.getValue()));
                                    }
                                    this.authorityCertIssuer = sb.toString();
                                    continue block21;
                                }
                                case 2: {
                                    this.authorityCertificationSerialNumber = (byte[])a.get(0);
                                    continue block21;
                                }
                            }
                            throw new IllegalArgumentException("Invalid context." + a.getIndex());
                        }
                        continue block20;
                    }
                    case KEY_USAGE: {
                        if (value instanceof GXBitString) {
                            this.keyUsage = KeyUsage.forValue(((GXBitString)value).toInteger());
                            break;
                        }
                        if (value instanceof Boolean) {
                            value = s.get(2);
                            this.keyUsage = KeyUsage.forValue(((GXBitString)value).toInteger());
                            break;
                        }
                        throw new IllegalStateException("Invalid key usage.");
                    }
                    case EXTENDED_KEY_USAGE: {
                        if (value instanceof GXAsn1Sequence) {
                            for (Object tmp2 : (GXAsn1Sequence)value) {
                                GXAsn1ObjectIdentifier eku = (GXAsn1ObjectIdentifier)tmp2;
                                if ("1.3.6.1.5.5.7.3.1".compareTo(eku.getObjectIdentifier()) == 0) {
                                    this.extendedKeyUsage.add(ExtendedKeyUsage.SERVER_AUTH);
                                    continue;
                                }
                                if ("1.3.6.1.5.5.7.3.2".compareTo(eku.getObjectIdentifier()) == 0) {
                                    this.extendedKeyUsage.add(ExtendedKeyUsage.CLIENT_AUTH);
                                    continue;
                                }
                                throw new IllegalStateException("Invalid extended key usage.");
                            }
                            continue block20;
                        }
                        throw new IllegalStateException("Invalid extended key usage.");
                    }
                    case BASIC_CONSTRAINTS: {
                        basicConstraintsExists = true;
                        if (value instanceof GXAsn1Sequence) {
                            if (((GXAsn1Sequence)value).size() == 0) continue block20;
                            this.basicConstraints = (Boolean)((GXAsn1Sequence)value).get(0);
                            break;
                        }
                        if (value instanceof Boolean) {
                            this.basicConstraints = (Boolean)value;
                            break;
                        }
                        throw new IllegalStateException("Invalid key usage.");
                    }
                    default: {
                        Logger.getLogger(GXx509Certificate.class.getName()).log(Level.SEVERE, "Unknown extensions: " + id.toString());
                    }
                }
            }
        }
        if (!basicConstraintsExists) {
            boolean commonNameFound = false;
            for (Object tmp2 : (GXAsn1Sequence)reqInfo.get(5)) {
                Map.Entry it = (Map.Entry)tmp2;
                if (!X509Name.CN.getValue().equals(String.valueOf(it.getKey()))) continue;
                if (it.getValue().toString().length() != 16) {
                    throw new GXDLMSCertificateException("System title is not included in Common Name.");
                }
                commonNameFound = true;
                break;
            }
            if (!commonNameFound) {
                throw new GXDLMSCertificateException("common name doesn't exist.");
            }
        }
        if (this.keyUsage == null || this.keyUsage.isEmpty()) {
            throw new IllegalArgumentException("Key usage not present. It's mandotory.");
        }
        if ((this.keyUsage.contains((Object)KeyUsage.KEY_CERT_SIGN) || this.keyUsage.contains((Object)KeyUsage.CRL_SIGN)) && !basicConstraintsExists) {
            throw new IllegalArgumentException("Basic Constraints value not present. It's mandotory.");
        }
        if (this.keyUsage.contains((Object)KeyUsage.DIGITAL_SIGNATURE) && this.keyUsage.contains((Object)KeyUsage.KEY_AGREEMENT) && this.extendedKeyUsage.isEmpty()) {
            throw new IllegalArgumentException("Extended key usage not present. It's mandotory for TLS.");
        }
        if (this.extendedKeyUsage.isEmpty() && this.keyUsage.contains((Object)KeyUsage.DIGITAL_SIGNATURE) && this.keyUsage.contains((Object)KeyUsage.KEY_AGREEMENT)) {
            throw new IllegalArgumentException("Extended key usage present. It's used only for TLS.");
        }
        try {
            eckf = KeyFactory.getInstance(GXx509Certificate.getAlgorithm(this.signatureAlgorithm.toString()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(this.signatureAlgorithm.name().substring(0, 2) + "key factory not present in runtime");
        }
        try {
            byte[] encodedKey = GXAsn1Converter.toByteArray(subjectPKInfo);
            X509EncodedKeySpec ecpks = new X509EncodedKeySpec(encodedKey);
            this.publicKey = eckf.generatePublic(ecpks);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.publicKeySignature = HashAlgorithm.forValue(((GXAsn1Sequence)seq.get(1)).get(0).toString());
        if (((GXAsn1Sequence)seq.get(1)).size() > 1) {
            this.signatureParameters = ((GXAsn1Sequence)seq.get(1)).get(1);
        }
        this.signature = ((GXBitString)seq.get(2)).getValue();
    }

    public GXx509Certificate(byte[] data) {
        this.init(data);
    }

    public final String getSubject() {
        return this.subject;
    }

    public final void setSubject(String value) {
        this.subject = value;
    }

    public final String getIssuer() {
        return this.issuer;
    }

    public final void setIssuer(String value) {
        this.issuer = value;
    }

    public final BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public final void setSerialNumber(BigInteger value) {
        this.serialNumber = value;
    }

    public final CertificateVersion getVersion() {
        return this.version;
    }

    public final void setVersion(CertificateVersion value) {
        this.version = value;
    }

    public final Date getValidFrom() {
        return this.validFrom;
    }

    public final void setValidFrom(Date value) {
        this.validFrom = value;
    }

    public final Date getValidTo() {
        return this.validTo;
    }

    public final void setValidTo(Date value) {
        this.validTo = value;
    }

    public final HashAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final void setSignatureAlgorithm(HashAlgorithm value) {
        this.signatureAlgorithm = value;
    }

    public final Object getParameters() {
        return this.parameters;
    }

    public final void setParameters(Object value) {
        this.parameters = value;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final void setPublicKey(PublicKey value) {
        this.publicKey = value;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public final void setSignature(byte[] value) {
        this.signature = value;
    }

    private Object[] getdata() {
        GXAsn1Sequence s1;
        GXAsn1ObjectIdentifier a = new GXAsn1ObjectIdentifier(this.signatureAlgorithm.getValue());
        GXAsn1Context p = new GXAsn1Context();
        p.add(this.version.getValue());
        GXAsn1Sequence s = new GXAsn1Sequence();
        if (this.subjectKeyIdentifier != null) {
            s1 = new GXAsn1Sequence();
            s1.add(new GXAsn1ObjectIdentifier(X509Certificate.SUBJECT_KEY_IDENTIFIER.getValue()));
            GXByteBuffer bb = new GXByteBuffer();
            bb.setUInt8(4);
            GXCommon.setObjectCount(this.subjectKeyIdentifier.length, bb);
            bb.set(this.subjectKeyIdentifier);
            s1.add(bb.array());
            s.add(s1);
        }
        if (this.authorityKeyIdentifier != null || this.authorityCertIssuer != null || this.authorityCertificationSerialNumber != null) {
            GXAsn1Context c4;
            s1 = new GXAsn1Sequence();
            s1.add(new GXAsn1ObjectIdentifier(X509Certificate.AUTHORITY_KEY_IDENTIFIER.getValue()));
            s.add(s1);
            GXAsn1Context s2 = new GXAsn1Context();
            s2.setIndex(3);
            GXAsn1Sequence c1 = new GXAsn1Sequence();
            if (this.authorityKeyIdentifier != null) {
                c4 = new GXAsn1Context();
                c4.setConstructed(false);
                c4.setIndex(0);
                c4.add(this.authorityKeyIdentifier);
                c1.add(c4);
                s1.add(GXAsn1Converter.toByteArray(c1));
            }
            if (this.authorityCertIssuer != null) {
                GXAsn1Context c2 = new GXAsn1Context();
                c2.setIndex(1);
                c1.add(c2);
                GXAsn1Context c3 = new GXAsn1Context();
                c3.setIndex(4);
                c2.add(c3);
                c3.add(GXAsn1Converter.encodeSubject(this.authorityCertIssuer));
                s2.add(c1);
            }
            if (this.authorityCertificationSerialNumber != null) {
                c4 = new GXAsn1Context();
                c4.setConstructed(false);
                c4.setIndex(2);
                c4.add(this.authorityCertificationSerialNumber);
                c1.add(c4);
                s1.add(GXAsn1Converter.toByteArray(c1));
            }
        }
        s1 = new GXAsn1Sequence();
        s1.add(new GXAsn1ObjectIdentifier(X509Certificate.BASIC_CONSTRAINTS.getValue()));
        GXAsn1Sequence seq = new GXAsn1Sequence();
        if (this.basicConstraints) {
            s1.add(this.basicConstraints);
        }
        s1.add(GXAsn1Converter.toByteArray(seq));
        s.add(s1);
        if (this.keyUsage == null || this.keyUsage.isEmpty()) {
            throw new IllegalArgumentException("Key usage not present.");
        }
        s1 = new GXAsn1Sequence();
        s1.add(new GXAsn1ObjectIdentifier(X509Certificate.KEY_USAGE.getValue()));
        int value = 0;
        short min = 255;
        for (KeyUsage it : this.keyUsage) {
            short val = GXCommon.swapBits((byte)it.getValue());
            value |= val;
            if (val >= min) continue;
            min = val;
        }
        int ignore = 0;
        while ((min >>= 1) != 0) {
            ++ignore;
        }
        byte[] tmp = GXAsn1Converter.toByteArray(new GXBitString(new byte[]{(byte)(ignore % 8), (byte)value}));
        s1.add(tmp);
        s.add(s1);
        GXAsn1Sequence valid = new GXAsn1Sequence();
        valid.add(this.validFrom);
        valid.add(this.validTo);
        Object[] tmp3 = new Object[]{new GXAsn1ObjectIdentifier("1.2.840.10045.2.1"), new GXAsn1ObjectIdentifier("1.2.840.10045.3.1.7")};
        GXAsn1Context tmp4 = new GXAsn1Context();
        tmp4.setIndex(3);
        tmp4.add(s);
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(4);
        bb.set(GXAsn1Converter.rawValue(this.publicKey));
        Object[] tmp2 = new Object[]{tmp3, new GXBitString(bb.array(), 0)};
        Object[] p2 = this.signatureParameters == null ? new Object[]{a} : new Object[]{a, this.signatureParameters};
        Object[] list = new Object[]{p, new GXAsn1Integer(this.serialNumber.toByteArray()), p2, GXAsn1Converter.encodeSubject(this.issuer), valid, GXAsn1Converter.encodeSubject(this.subject), tmp2, tmp4};
        return list;
    }

    public final byte[] getEncoded() {
        if (this.rawData != null) {
            return this.rawData;
        }
        Object[] tmp = new Object[]{new GXAsn1ObjectIdentifier(this.signatureAlgorithm.getValue())};
        Object[] list = new Object[]{this.getdata(), tmp, new GXBitString(this.signature, 0)};
        return GXAsn1Converter.toByteArray(list);
    }

    public void sign(KeyPair kp, HashAlgorithm hashAlgorithm) {
        byte[] data = GXAsn1Converter.toByteArray(this.getdata());
        try {
            Signature instance = Signature.getInstance(hashAlgorithm.toString());
            instance.initSign(kp.getPrivate());
            instance.update(data);
            this.signatureAlgorithm = hashAlgorithm;
            this.signature = instance.sign();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final String toString() {
        StringBuilder bb = new StringBuilder();
        bb.append("Version: ");
        bb.append(this.version.toString());
        bb.append("\n");
        bb.append("Serial Number: ");
        bb.append(this.serialNumber.toString());
        bb.append("\n");
        bb.append("Signature Algorithm: ");
        if (this.signatureAlgorithm != null) {
            bb.append(this.signatureAlgorithm.toString());
            bb.append(", OID = ");
            bb.append(this.signatureAlgorithm.getValue());
        }
        bb.append("\n");
        bb.append("Issuer: ");
        bb.append(this.issuer);
        bb.append("\n");
        bb.append("Validity: [From: ");
        bb.append(this.validFrom.toString());
        bb.append(", \n");
        bb.append("To: ");
        bb.append(this.validTo.toString());
        bb.append("]\n");
        bb.append("Subject Public Key Info:\n");
        bb.append("Public Key Algorythm: ");
        bb.append(this.publicKey.getAlgorithm());
        bb.append("\n");
        bb.append(this.publicKey.toString());
        bb.append("\n");
        if (this.subjectKeyIdentifier != null) {
            bb.append("X509v3 Subject Key Identifier:\n");
            bb.append(GXCommon.toHex(this.subjectKeyIdentifier));
            bb.append("\n");
        }
        if (this.authorityKeyIdentifier != null) {
            bb.append("X509v3 Authority Key Identifier:\n");
            bb.append(GXCommon.toHex(this.authorityKeyIdentifier));
            bb.append("\n");
        }
        bb.append("Signature Algorithm: ");
        if (this.signatureAlgorithm != null) {
            bb.append(this.signatureAlgorithm.toString());
        }
        bb.append("\n");
        bb.append(GXCommon.toHex(this.signature));
        bb.append("\n");
        return bb.toString();
    }

    public Set<KeyUsage> getKeyUsage() {
        return this.keyUsage;
    }

    public void setKeyUsage(Set<KeyUsage> value) {
        this.keyUsage = value;
    }

    public Set<ExtendedKeyUsage> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public void setExtendedKeyUsage(Set<ExtendedKeyUsage> value) {
        this.extendedKeyUsage = value;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public void setSubjectKeyIdentifier(byte[] value) {
        this.subjectKeyIdentifier = value;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public void setAuthorityKeyIdentifier(byte[] value) {
        this.authorityKeyIdentifier = value;
    }

    public boolean isBasicConstraints() {
        return this.basicConstraints;
    }

    public void setBasicConstraints(boolean value) {
        this.basicConstraints = value;
    }

    public static GXx509Certificate load(Path path) throws IOException {
        return GXx509Certificate.fromPem(Files.readString(path));
    }

    public void save(Path path) throws IOException {
        Files.write(path, this.toPem().getBytes(), StandardOpenOption.CREATE);
    }

    public String toPem() {
        StringBuilder sb = new StringBuilder();
        if (this.publicKey == null) {
            throw new IllegalArgumentException("Public or private key is not set.");
        }
        sb.append("-----BEGIN CERTIFICATE-----" + System.lineSeparator());
        sb.append(this.toDer());
        sb.append(System.lineSeparator() + "-----END CERTIFICATE-----" + System.lineSeparator());
        return sb.toString();
    }

    public String toDer() {
        return GXCommon.toBase64(this.getEncoded());
    }

    public byte[] getIssuerRaw() {
        return this.issuerRaw;
    }
}

