/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.asn.enums;

import gurux.dlms.asn.enums.GXOid;
import java.util.HashMap;

public enum HashAlgorithm implements GXOid
{
    SHA1_RSA("1.2.840.113549.1.1.5"),
    MD5_RSA("1.2.840.113549.1.1.4"),
    SHA1_DSA("1.2.840.10040.4.3"),
    SHA1_RSA_1("1.3.14.3.2.29"),
    SHA_RSA("1.3.14.3.2.15"),
    MD5_RSA_1("1.3.14.3.2.3"),
    MD2_RSA_1("1.2.840.113549.1.1.2"),
    MD4_RSA("1.2.840.113549.1.1.3"),
    MD4_RSA_1("1.3.14.3.2.2"),
    MD4_RSA_2("1.3.14.3.2.4"),
    MD2_RSA("1.3.14.7.2.3.1"),
    SHA1_DSA_1("1.3.14.3.2.13"),
    DSA_SHA1("1.3.14.3.2.27"),
    MOSAIC_UPDATED_SIG("2.16.840.1.101.2.1.1.19"),
    SHA1_NO_SIGN("1.3.14.3.2.26"),
    MD5_NO_SIGN("1.2.840.113549.2.5"),
    SHA_256_NO_SIGN("2.16.840.1.101.3.4.2.1"),
    SHA_384_NO_SIGN("2.16.840.1.101.3.4.2.2"),
    SHA_512_NO_SIGN("2.16.840.1.101.3.4.2.3"),
    SHA_256_RSA("1.2.840.113549.1.1.11"),
    SHA_384_RSA("1.2.840.113549.1.1.12"),
    SHA_512_RSA("1.2.840.113549.1.1.13"),
    RSA_SSA_PSS("1.2.840.113549.1.1.10"),
    SHA1withECDSA("1.2.840.10045.4.1"),
    SHA256withECDSA("1.2.840.10045.4.3.2"),
    SHA384withECDSA("1.2.840.10045.4.3.3"),
    SHA512withECDSA("1.2.840.10045.4.3.4"),
    SPECIFIED_ECDSA("1.2.840.10045.4.3");

    private String value;
    private static HashMap<String, HashAlgorithm> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, HashAlgorithm> getMappings() {
        Class<HashAlgorithm> clazz = HashAlgorithm.class;
        synchronized (HashAlgorithm.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private HashAlgorithm(String mode) {
        this.value = mode;
        HashAlgorithm.getMappings().put(new String(mode), this);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static HashAlgorithm forValue(String value) {
        return HashAlgorithm.getMappings().get(value);
    }
}

