/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.enums;

import java.util.HashMap;

public enum DataType {
    ARRAY(1),
    BCD(13),
    BITSTRING(4),
    BOOLEAN(3),
    COMPACT_ARRAY(19),
    DATE(26),
    DATETIME(25),
    ENUM(22),
    FLOAT32(23),
    FLOAT64(24),
    INT16(16),
    INT32(5),
    INT64(20),
    INT8(15),
    NONE(0),
    OCTET_STRING(9),
    STRING(10),
    STRING_UTF8(12),
    STRUCTURE(2),
    TIME(27),
    DELTA_INT8(28),
    DELTA_INT16(29),
    DELTA_INT32(30),
    DELTA_UINT8(31),
    DELTA_UINT16(32),
    DELTA_UINT32(33),
    UINT16(18),
    UINT32(6),
    UINT64(21),
    UINT8(17);

    private int intValue;
    private static HashMap<Integer, DataType> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, DataType> getMappings() {
        Class<DataType> clazz = DataType.class;
        synchronized (DataType.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private DataType(int value) {
        this.intValue = value;
        DataType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static DataType forValue(int value) {
        DataType type = DataType.getMappings().get(value);
        if (type == null) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(value));
        }
        return type;
    }

    public String toString() {
        String str;
        DataType dt = DataType.forValue(this.intValue);
        switch (dt.ordinal()) {
            case 0: {
                str = "Array";
                break;
            }
            case 1: {
                str = "Bcd";
                break;
            }
            case 2: {
                str = "BitString";
                break;
            }
            case 3: {
                str = "Boolean";
                break;
            }
            case 4: {
                str = "CompactArray";
                break;
            }
            case 5: {
                str = "Date";
                break;
            }
            case 6: {
                str = "DateTime";
                break;
            }
            case 7: {
                str = "Enum";
                break;
            }
            case 8: {
                str = "Float32";
                break;
            }
            case 9: {
                str = "Float64";
                break;
            }
            case 10: {
                str = "Int16";
                break;
            }
            case 11: {
                str = "Int32";
                break;
            }
            case 12: {
                str = "Int64";
                break;
            }
            case 13: {
                str = "Int8";
                break;
            }
            case 14: {
                str = "None";
                break;
            }
            case 15: {
                str = "OctetString";
                break;
            }
            case 16: {
                str = "String";
                break;
            }
            case 17: {
                str = "StringUTF8";
                break;
            }
            case 18: {
                str = "Structure";
                break;
            }
            case 19: {
                str = "Time";
                break;
            }
            case 26: {
                str = "UInt16";
                break;
            }
            case 27: {
                str = "UInt32";
                break;
            }
            case 28: {
                str = "UInt64";
                break;
            }
            case 29: {
                str = "UInt8";
                break;
            }
            default: {
                throw new IllegalArgumentException("DataType");
            }
        }
        return str;
    }
}

