/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.internal;

import java.util.HashMap;

public enum CoAPClientError {
    BAD_REQUEST(0),
    UNAUTHORIZED(1),
    BAD_OPTION(2),
    FORBIDDEN(3),
    NOT_FOUND(4),
    METHOD_NOT_ALLOWED(5),
    NOT_ACCEPTABLE(6),
    REQUEST_ENTITY_INCOMPLETE(8),
    CONFLICT(9),
    PRECONDITION_FAILED(12),
    REQUEST_ENTITY_TOO_LARGE(13),
    UNSUPPORTED_CONTENT_FORMAT(15);

    private int intValue;
    private static HashMap<Integer, CoAPClientError> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, CoAPClientError> getMappings() {
        if (mappings != null) return mappings;
        Class<CoAPClientError> clazz = CoAPClientError.class;
        synchronized (CoAPClientError.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private CoAPClientError(int value) {
        this.intValue = value;
        CoAPClientError.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static CoAPClientError forValue(int value) {
        CoAPClientError ret = CoAPClientError.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid CoAP client error enum value.");
        }
        return ret;
    }
}

