/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSActionItem;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSArbitrator
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSActionItem[] actions;
    private String[] permissionsTable;
    private int[][] weightingsTable;
    private String[] mostRecentRequestsTable;
    private byte lastOutcome;

    public GXDLMSArbitrator() {
        this("0.0.96.3.20.255", 0);
    }

    public GXDLMSArbitrator(String ln) {
        this(ln, 0);
    }

    public GXDLMSArbitrator(String ln, int sn) {
        super(ObjectType.ARBITRATOR, ln, sn);
    }

    public final GXDLMSActionItem[] getActions() {
        return this.actions;
    }

    public final void setActions(GXDLMSActionItem[] value) {
        this.actions = value;
    }

    public final String[] getPermissionsTable() {
        return this.permissionsTable;
    }

    public final void setPermissionsTable(String[] value) {
        this.permissionsTable = value;
    }

    public final int[][] getWeightingsTable() {
        return this.weightingsTable;
    }

    public final void setWeightingsTable(int[][] value) {
        this.weightingsTable = value;
    }

    public final String[] getMostRecentRequestsTable() {
        return this.mostRecentRequestsTable;
    }

    public final void setMostRecentRequestsTable(String[] value) {
        this.mostRecentRequestsTable = value;
    }

    public final byte getLastOutcome() {
        return this.lastOutcome;
    }

    public final void setLastOutcome(byte value) {
        this.lastOutcome = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.actions, this.permissionsTable, this.weightingsTable, this.mostRecentRequestsTable, this.lastOutcome};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    public byte[][] requestAction(GXDLMSClient client, byte actor, String actions) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE);
        bb.setUInt8(2);
        bb.setUInt8(DataType.UINT8);
        bb.setUInt8(actor);
        GXCommon.setData(null, bb, DataType.BITSTRING, actions);
        return client.method(this, 1, bb.array(), DataType.STRUCTURE);
    }

    public byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 2, 0, DataType.INT8);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return DataType.ARRAY;
            }
            case 6: {
                return DataType.UINT8;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.actions == null) {
                    GXCommon.setObjectCount(0, data);
                } else {
                    GXCommon.setObjectCount(this.actions.length, data);
                    for (GXDLMSActionItem it : this.actions) {
                        data.setUInt8(DataType.STRUCTURE);
                        data.setUInt8(2);
                        GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getLogicalName()));
                        GXCommon.setData(settings, data, DataType.UINT16, it.getScriptSelector());
                    }
                }
                ret = data.array();
                break;
            }
            case 3: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.permissionsTable == null) {
                    GXCommon.setObjectCount(0, data);
                } else {
                    GXCommon.setObjectCount(this.permissionsTable.length, data);
                    for (String it : this.permissionsTable) {
                        GXCommon.setData(settings, data, DataType.BITSTRING, it);
                    }
                }
                ret = data.array();
                break;
            }
            case 4: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.weightingsTable == null) {
                    GXCommon.setObjectCount(0, data);
                } else {
                    GXCommon.setObjectCount(this.weightingsTable.length, data);
                    for (int[] it : this.weightingsTable) {
                        data.setUInt8(DataType.ARRAY);
                        GXCommon.setObjectCount(it.length, data);
                        for (int it2 : it) {
                            GXCommon.setData(settings, data, DataType.UINT16, it2);
                        }
                    }
                }
                ret = data.array();
                break;
            }
            case 5: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.mostRecentRequestsTable == null) {
                    GXCommon.setObjectCount(0, data);
                } else {
                    GXCommon.setObjectCount(this.mostRecentRequestsTable.length, data);
                    for (String it : this.mostRecentRequestsTable) {
                        GXCommon.setData(settings, data, DataType.BITSTRING, it);
                    }
                }
                ret = data.array();
                break;
            }
            case 6: {
                ret = this.lastOutcome;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    private static GXDLMSActionItem createAction(GXDLMSSettings settings, List<?> it) {
        GXDLMSActionItem item = new GXDLMSActionItem();
        item.setLogicalName(GXCommon.toLogicalName(it.get(0)));
        item.setScriptSelector(((Number)it.get(1)).intValue());
        return item;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                ArrayList<GXDLMSActionItem> list = new ArrayList<GXDLMSActionItem>();
                if (e.getValue() != null) {
                    List arr = (List)e.getValue();
                    for (Object it : arr) {
                        list.add(GXDLMSArbitrator.createAction(settings, (List)it));
                    }
                }
                this.actions = list.toArray(new GXDLMSActionItem[0]);
                break;
            }
            case 3: {
                ArrayList<String> list = new ArrayList<String>();
                if (e.getValue() != null) {
                    List arr = (List)e.getValue();
                    for (Object it : arr) {
                        list.add(it.toString());
                    }
                }
                this.permissionsTable = list.toArray(new String[0]);
                break;
            }
            case 4: {
                ArrayList<int[]> list = new ArrayList<int[]>();
                if (e.getValue() != null) {
                    List arr = (List)e.getValue();
                    for (Object it : arr) {
                        ArrayList<Integer> list2 = new ArrayList<Integer>();
                        for (Object it2 : (List)it) {
                            list2.add(((Number)it2).intValue());
                        }
                        list.add(GXCommon.toIntArray(list2));
                    }
                }
                this.weightingsTable = (int[][])list.toArray((T[])new int[0][0]);
                break;
            }
            case 5: {
                ArrayList<String> list = new ArrayList<String>();
                if (e.getValue() != null) {
                    List arr = (List)e.getValue();
                    for (Object it : arr) {
                        list.add((String)it);
                    }
                }
                this.mostRecentRequestsTable = list.toArray(new String[0]);
                break;
            }
            case 6: {
                this.lastOutcome = ((Number)e.getValue()).byteValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        ArrayList<GXDLMSActionItem> actionsList = new ArrayList<GXDLMSActionItem>();
        if (reader.isStartElement("Actions", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSActionItem it = new GXDLMSActionItem();
                it.setLogicalName(reader.readElementContentAsString("LN"));
                it.setScriptSelector(reader.readElementContentAsInt("ScriptSelector"));
                actionsList.add(it);
            }
            reader.readEndElement("Actions");
        }
        this.actions = actionsList.toArray(new GXDLMSActionItem[0]);
        ArrayList<String> permissions = new ArrayList<String>();
        if (reader.isStartElement("PermissionTable", true)) {
            while (reader.isStartElement("Item", false)) {
                permissions.add(reader.readElementContentAsString("Item"));
            }
            reader.readEndElement("PermissionTable");
        }
        this.permissionsTable = permissions.toArray(new String[0]);
        ArrayList<int[]> weightings = new ArrayList<int[]>();
        if (reader.isStartElement("WeightingTable", true)) {
            while (reader.isStartElement("Weightings", true)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                while (reader.isStartElement("Item", false)) {
                    list.add(reader.readElementContentAsInt("Item"));
                }
                weightings.add(GXCommon.toIntArray(list));
            }
            reader.readEndElement("WeightingTable");
        }
        this.weightingsTable = (int[][])weightings.toArray((T[])new int[0][0]);
        ArrayList mostRecentRequests = new ArrayList();
        if (reader.isStartElement("MostRecentRequestsTable", true)) {
            while (reader.isStartElement("Item", false)) {
                permissions.add(reader.readElementContentAsString("Item"));
            }
            reader.readEndElement("MostRecentRequestsTable");
        }
        this.mostRecentRequestsTable = mostRecentRequests.toArray(new String[0]);
        this.lastOutcome = (byte)reader.readElementContentAsInt("LastOutcome");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.actions != null) {
            writer.writeStartElement("Actions");
            for (GXDLMSActionItem gXDLMSActionItem : this.actions) {
                writer.writeStartElement("Item");
                writer.writeElementString("LN", gXDLMSActionItem.getLogicalName());
                writer.writeElementString("ScriptSelector", gXDLMSActionItem.getScriptSelector());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.permissionsTable != null) {
            writer.writeStartElement("PermissionTable");
            for (String string : this.permissionsTable) {
                writer.writeElementString("Item", String.valueOf(string));
            }
            writer.writeEndElement();
        }
        if (this.weightingsTable != null) {
            writer.writeStartElement("WeightingTable");
            for (int[] nArray : this.weightingsTable) {
                writer.writeStartElement("Weightings");
                for (int it2 : nArray) {
                    writer.writeElementString("Item", it2);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (this.mostRecentRequestsTable != null) {
            writer.writeStartElement("MostRecentRequestsTable");
            for (String string : this.mostRecentRequestsTable) {
                writer.writeElementString("Item", string);
            }
            writer.writeEndElement();
        }
        writer.writeElementString("LastOutcome", this.lastOutcome);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Actions", "Permissions table", "Weightings table", "Most recent requests table", "Last outcome"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Request Action", "Reset"};
    }
}

