/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXStructure;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXCoapBtCounter;
import gurux.dlms.objects.GXCoapCaptureTime;
import gurux.dlms.objects.GXCoapMessagesCounter;
import gurux.dlms.objects.GXCoapRequestResponseCounter;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSCoAPDiagnostic
extends GXDLMSObject
implements IGXDLMSBase {
    private GXCoapMessagesCounter messagesCounter = new GXCoapMessagesCounter();
    private GXCoapRequestResponseCounter requestResponseCounter = new GXCoapRequestResponseCounter();
    private GXCoapBtCounter btCounter = new GXCoapBtCounter();
    private GXCoapCaptureTime captureTime = new GXCoapCaptureTime();

    public GXDLMSCoAPDiagnostic() {
        this("0.0.25.17.0.255", 0);
    }

    public GXDLMSCoAPDiagnostic(String ln) {
        this(ln, 0);
    }

    public GXDLMSCoAPDiagnostic(String ln, int sn) {
        super(ObjectType.COAP_DIAGNOSTIC, ln, sn);
    }

    public final GXCoapMessagesCounter getMessagesCounter() {
        return this.messagesCounter;
    }

    public final GXCoapRequestResponseCounter getRequestResponseCounter() {
        return this.requestResponseCounter;
    }

    public final GXCoapBtCounter getBtCounter() {
        return this.btCounter;
    }

    public final GXCoapCaptureTime getCaptureTime() {
        return this.captureTime;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getMessagesCounter(), this.getRequestResponseCounter(), this.getBtCounter(), this.getCaptureTime()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final String[] getNames() {
        return new String[]{"Logical Name", "Messages counter", "Request response counter", "BT counter", "Capture time"};
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 1, 0, DataType.INT8);
    }

    @Override
    public final String[] getMethodNames() {
        return new String[]{"Reset"};
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return DataType.STRUCTURE;
            }
        }
        throw new IllegalArgumentException("GetDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        GXByteBuffer buff = new GXByteBuffer();
        byte[] ret = null;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(10, buff);
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getTx());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getRx());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getTxResend());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getTxReset());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getRxReset());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getTxAck());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getRxAck());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getRxDrop());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getTxNonPiggybacked());
                GXCommon.setData(settings, buff, DataType.UINT32, this.messagesCounter.getMaxRtxExceeded());
                ret = buff.array();
                break;
            }
            case 3: {
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(8, buff);
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getRxRequests());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getTxRequests());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getRxResponse());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getTxResponse());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getTxClientError());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getRxClientError());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getTxServerError());
                GXCommon.setData(settings, buff, DataType.UINT32, this.requestResponseCounter.getRxServerError());
                ret = buff.array();
                break;
            }
            case 4: {
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(3, buff);
                GXCommon.setData(settings, buff, DataType.UINT32, this.btCounter.getBlockWiseTransferStarted());
                GXCommon.setData(settings, buff, DataType.UINT32, this.btCounter.getBlockWiseTransferCompleted());
                GXCommon.setData(settings, buff, DataType.UINT32, this.btCounter.getBlockWiseTransferTimeout());
                ret = buff.array();
                break;
            }
            case 5: {
                buff.setUInt8(DataType.STRUCTURE);
                GXCommon.setObjectCount(2, buff);
                GXCommon.setData(settings, buff, DataType.UINT8, this.captureTime.getAttributeId());
                GXCommon.setData(settings, buff, DataType.DATETIME, this.captureTime.getTimeStamp());
                ret = buff.array();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                GXStructure s = (GXStructure)(e.getValue() instanceof GXStructure ? e.getValue() : null);
                this.messagesCounter.setTx(((Number)s.get(0)).longValue());
                this.messagesCounter.setRx(((Number)s.get(1)).longValue());
                this.messagesCounter.setTxResend(((Number)s.get(2)).longValue());
                this.messagesCounter.setTxReset(((Number)s.get(3)).longValue());
                this.messagesCounter.setRxReset(((Number)s.get(4)).longValue());
                this.messagesCounter.setTxAck(((Number)s.get(5)).longValue());
                this.messagesCounter.setRxAck(((Number)s.get(6)).longValue());
                this.messagesCounter.setRxDrop(((Number)s.get(7)).longValue());
                this.messagesCounter.setTxNonPiggybacked(((Number)s.get(8)).longValue());
                this.messagesCounter.setMaxRtxExceeded(((Number)s.get(9)).longValue());
                break;
            }
            case 3: {
                GXStructure s = (GXStructure)(e.getValue() instanceof GXStructure ? e.getValue() : null);
                this.requestResponseCounter.setRxRequests(((Number)s.get(0)).longValue());
                this.requestResponseCounter.setTxRequests(((Number)s.get(1)).longValue());
                this.requestResponseCounter.setRxResponse(((Number)s.get(2)).longValue());
                this.requestResponseCounter.setTxResponse(((Number)s.get(3)).longValue());
                this.requestResponseCounter.setTxClientError(((Number)s.get(4)).longValue());
                this.requestResponseCounter.setRxClientError(((Number)s.get(5)).longValue());
                this.requestResponseCounter.setTxServerError(((Number)s.get(6)).longValue());
                this.requestResponseCounter.setRxServerError(((Number)s.get(7)).longValue());
                break;
            }
            case 4: {
                GXStructure s = (GXStructure)(e.getValue() instanceof GXStructure ? e.getValue() : null);
                this.btCounter.setBlockWiseTransferStarted(((Number)s.get(0)).longValue());
                this.btCounter.setBlockWiseTransferCompleted(((Number)s.get(1)).longValue());
                this.btCounter.setBlockWiseTransferTimeout(((Number)s.get(2)).longValue());
                break;
            }
            case 5: {
                GXStructure s = (GXStructure)(e.getValue() instanceof GXStructure ? e.getValue() : null);
                this.captureTime.setAttributeId(((Number)s.get(0)).byteValue());
                this.captureTime.setTimeStamp((GXDateTime)s.get(1));
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.messagesCounter.setTx(reader.readElementContentAsLong("Tx"));
        this.messagesCounter.setRx(reader.readElementContentAsLong("Rx"));
        this.messagesCounter.setTxResend(reader.readElementContentAsLong("TxResend"));
        this.messagesCounter.setTxReset(reader.readElementContentAsLong("TxReset"));
        this.messagesCounter.setRxReset(reader.readElementContentAsLong("RxReset"));
        this.messagesCounter.setTxAck(reader.readElementContentAsLong("TxAck"));
        this.messagesCounter.setRxAck(reader.readElementContentAsLong("RxAck"));
        this.messagesCounter.setRxDrop(reader.readElementContentAsLong("RxDrop"));
        this.messagesCounter.setTxNonPiggybacked(reader.readElementContentAsLong("TxNonPiggybacked"));
        this.messagesCounter.setMaxRtxExceeded(reader.readElementContentAsLong("MaxRtxExceeded"));
        this.requestResponseCounter.setRxRequests(reader.readElementContentAsLong("RxRequests"));
        this.requestResponseCounter.setTxRequests(reader.readElementContentAsLong("TxRequests"));
        this.requestResponseCounter.setRxResponse(reader.readElementContentAsLong("RxResponse"));
        this.requestResponseCounter.setTxResponse(reader.readElementContentAsLong("TxResponse"));
        this.requestResponseCounter.setTxClientError(reader.readElementContentAsLong("TxClientError"));
        this.requestResponseCounter.setRxClientError(reader.readElementContentAsLong("RxClientError"));
        this.requestResponseCounter.setTxServerError(reader.readElementContentAsLong("TxServerError"));
        this.requestResponseCounter.setRxServerError(reader.readElementContentAsLong("RxServerError"));
        this.btCounter.setBlockWiseTransferStarted(reader.readElementContentAsLong("TransferStarted"));
        this.btCounter.setBlockWiseTransferCompleted(reader.readElementContentAsLong("TransferCompleted"));
        this.btCounter.setBlockWiseTransferTimeout(reader.readElementContentAsLong("TransferTimeout"));
        this.captureTime.setAttributeId((byte)reader.readElementContentAsInt("AttributeId"));
        this.captureTime.setTimeStamp(reader.readElementContentAsDateTime("TimeStamp"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Tx", this.messagesCounter.getTx());
        writer.writeElementString("Rx", this.messagesCounter.getRx());
        writer.writeElementString("TxResend", this.messagesCounter.getTxResend());
        writer.writeElementString("TxReset", this.messagesCounter.getTxReset());
        writer.writeElementString("RxReset", this.messagesCounter.getRxReset());
        writer.writeElementString("TxAck", this.messagesCounter.getTxAck());
        writer.writeElementString("RxAck", this.messagesCounter.getRxAck());
        writer.writeElementString("RxDrop", this.messagesCounter.getRxDrop());
        writer.writeElementString("TxNonPiggybacked", this.messagesCounter.getTxNonPiggybacked());
        writer.writeElementString("MaxRtxExceeded", this.messagesCounter.getMaxRtxExceeded());
        writer.writeElementString("RxRequests", this.requestResponseCounter.getRxRequests());
        writer.writeElementString("TxRequests", this.requestResponseCounter.getTxRequests());
        writer.writeElementString("RxResponse", this.requestResponseCounter.getRxResponse());
        writer.writeElementString("TxResponse", this.requestResponseCounter.getTxResponse());
        writer.writeElementString("TxClientError", this.requestResponseCounter.getTxClientError());
        writer.writeElementString("RxClientError", this.requestResponseCounter.getRxClientError());
        writer.writeElementString("TxServerError", this.requestResponseCounter.getTxServerError());
        writer.writeElementString("RxServerError", this.requestResponseCounter.getRxServerError());
        writer.writeElementString("TransferStarted", this.btCounter.getBlockWiseTransferStarted());
        writer.writeElementString("TransferCompleted", this.btCounter.getBlockWiseTransferCompleted());
        writer.writeElementString("TransferTimeout", this.btCounter.getBlockWiseTransferTimeout());
        writer.writeElementString("AttributeId", this.captureTime.getAttributeId());
        writer.writeElementString("TimeStamp", this.captureTime.getTimeStamp());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }
}

