/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSException;
import gurux.dlms.GXDLMSServerBase;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.internal.GXDataInfo;
import gurux.dlms.objects.GXDLMSCaptureObject;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.CaptureMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class GXDLMSCompactData
extends GXDLMSObject
implements IGXDLMSBase {
    private byte[] buffer;
    private List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> captureObjects;
    private short templateId;
    private byte[] templateDescription;
    private CaptureMethod captureMethod = CaptureMethod.INVOKE;

    public GXDLMSCompactData() {
        this("0.0.66.0.1.255", 0);
    }

    public GXDLMSCompactData(String ln) {
        this(ln, 0);
    }

    public GXDLMSCompactData(String ln, int sn) {
        super(ObjectType.COMPACT_DATA, ln, sn);
        this.captureObjects = new ArrayList<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>>();
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(byte[] value) {
        this.buffer = value;
    }

    public final List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> getCaptureObjects() {
        return this.captureObjects;
    }

    public final short getTemplateId() {
        return this.templateId;
    }

    public final void setTemplateId(short value) {
        this.templateId = value;
    }

    public final byte[] getTemplateDescription() {
        return this.templateDescription;
    }

    public final void setTemplateDescription(byte[] value) {
        this.templateDescription = value;
    }

    public final CaptureMethod getCaptureMethod() {
        return this.captureMethod;
    }

    public final void setCaptureMethod(CaptureMethod value) {
        this.captureMethod = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        GXDLMSCompactData gXDLMSCompactData = this;
        synchronized (gXDLMSCompactData) {
            this.buffer = null;
        }
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.buffer, this.captureObjects, this.templateId, this.templateDescription, this.captureMethod};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    public static List<Object> getDataTypes(byte[] value) {
        if (value == null || value.length == 0) {
            return new ArrayList<Object>();
        }
        GXDataInfo info = new GXDataInfo();
        Object ret = GXCommon.getCompactArray(null, new GXByteBuffer(value), info, true);
        return (List)ret;
    }

    public static List<Object> getData(byte[] columns, byte[] value) {
        return GXDLMSCompactData.getData(columns, value, false);
    }

    public static List<Object> getData(byte[] columns, byte[] value, boolean AppendAA) {
        if (columns == null || columns.length == 0 || value == null || value.length == 0) {
            return new GXArray();
        }
        GXDataInfo info = new GXDataInfo();
        info.setAppendAA(AppendAA);
        GXByteBuffer bb = new GXByteBuffer();
        bb.set(columns);
        GXCommon.setObjectCount(value.length, bb);
        bb.set(value);
        return (List)GXCommon.getCompactArray(null, bb, info, false);
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.OCTET_STRING;
            }
            case 3: {
                return DataType.ARRAY;
            }
            case 4: {
                return DataType.UINT8;
            }
            case 5: {
                return DataType.OCTET_STRING;
            }
            case 6: {
                return DataType.ENUM;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.reset();
        } else if (e.getIndex() == 2) {
            try {
                this.capture(e.getServer());
            }
            catch (Exception e1) {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    private byte[] getCaptureObjects(GXDLMSSettings settings) {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.ARRAY.getValue());
        GXCommon.setObjectCount(this.captureObjects.size(), data);
        for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.captureObjects) {
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(4);
            GXCommon.setData(settings, data, DataType.UINT16, it.getKey().getObjectType().getValue());
            GXCommon.setData(settings, data, DataType.OCTET_STRING, GXCommon.logicalNameToBytes(it.getKey().getLogicalName()));
            GXCommon.setData(settings, data, DataType.INT8, it.getValue().getAttributeIndex());
            GXCommon.setData(settings, data, DataType.UINT16, it.getValue().getDataIndex());
        }
        return data.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                return this.buffer;
            }
            case 3: {
                return this.getCaptureObjects(settings);
            }
            case 4: {
                return this.templateId;
            }
            case 5: {
                return this.templateDescription;
            }
            case 6: {
                return this.captureMethod.ordinal();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    private static void setCaptureObjects(GXDLMSSettings settings, List<Map.Entry<GXDLMSObject, GXDLMSCaptureObject>> list, List<?> array) {
        GXDLMSConverter c = null;
        list.clear();
        try {
            if (array != null) {
                for (Object it : array) {
                    List tmp = (List)it;
                    if (tmp.size() != 4) {
                        throw new GXDLMSException("Invalid structure format.");
                    }
                    int v = ((Number)tmp.get(0)).intValue();
                    ObjectType type = ObjectType.forValue(v);
                    String ln = GXCommon.toLogicalName((byte[])tmp.get(1));
                    int attributeIndex = ((Number)tmp.get(2)).intValue();
                    int dataIndex = ((Number)tmp.get(3)).intValue();
                    GXDLMSObject obj = null;
                    if (settings != null && settings.getObjects() != null) {
                        obj = settings.getObjects().findByLN(type, ln);
                    }
                    if (obj == null) {
                        obj = GXDLMSClient.createObject(type);
                        if (c == null) {
                            c = new GXDLMSConverter();
                        }
                        c.updateOBISCodeInformation(obj);
                    }
                    list.add(new GXSimpleEntry<GXDLMSObject, GXDLMSCaptureObject>(obj, new GXDLMSCaptureObject(attributeIndex, dataIndex)));
                }
            }
        }
        catch (RuntimeException e) {
            list.clear();
        }
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                if (e.getValue() instanceof byte[]) {
                    this.buffer = (byte[])e.getValue();
                    break;
                }
                if (!(e.getValue() instanceof String)) break;
                this.buffer = GXCommon.hexToBytes((String)e.getValue());
                break;
            }
            case 3: {
                GXDLMSCompactData.setCaptureObjects(settings, this.captureObjects, (List)e.getValue());
                if (!settings.isServer()) break;
                this.updateTemplateDescription();
                break;
            }
            case 4: {
                this.templateId = ((Number)e.getValue()).shortValue();
                break;
            }
            case 5: {
                this.templateDescription = (byte[])e.getValue();
                break;
            }
            case 6: {
                this.captureMethod = CaptureMethod.values()[((Number)e.getValue()).shortValue()];
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    private static void captureArray(GXDLMSServerBase server, GXByteBuffer tmp, GXByteBuffer bb, int index) {
        tmp.getUInt8();
        int cnt = GXCommon.getObjectCount(tmp);
        for (int pos = 0; pos != cnt; ++pos) {
            if (index != -1 && index != pos) continue;
            DataType dt = DataType.forValue(tmp.getUInt8(tmp.position()));
            if (dt == DataType.STRUCTURE || dt == DataType.ARRAY) {
                GXDLMSCompactData.captureArray(server, tmp, bb, -1);
            } else {
                GXDLMSCompactData.captureValue(server, tmp, bb);
            }
            if (index == pos) break;
        }
    }

    private static void captureValue(GXDLMSServerBase server, GXByteBuffer tmp, GXByteBuffer bb) {
        GXByteBuffer tmp2 = new GXByteBuffer();
        GXDataInfo info = new GXDataInfo();
        Object value = GXCommon.getData(server.getSettings(), tmp, info);
        GXCommon.setData(server.getSettings(), tmp2, info.getType(), value);
        if (tmp2.size() == 1) {
            bb.setUInt8(0);
        } else {
            tmp2.position(1);
            bb.set(tmp2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void capture(Object server) throws Exception {
        GXDLMSCompactData gXDLMSCompactData = this;
        synchronized (gXDLMSCompactData) {
            GXDLMSServerBase srv = (GXDLMSServerBase)server;
            GXByteBuffer bb = new GXByteBuffer();
            ValueEventArgs[] args = new ValueEventArgs[]{new ValueEventArgs(srv, (GXDLMSObject)this, 2, 0, null)};
            this.buffer = null;
            srv.notifyPreGet(args);
            if (!args[0].getHandled()) {
                for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.captureObjects) {
                    GXByteBuffer tmp;
                    ValueEventArgs e = new ValueEventArgs(srv, it.getKey(), it.getValue().getAttributeIndex(), 0, null);
                    Object value = it.getKey().getValue(srv.getSettings(), e);
                    DataType dt = it.getKey().getDataType(it.getValue().getAttributeIndex());
                    if ((value instanceof byte[] || value instanceof GXByteBuffer[]) && (dt == DataType.STRUCTURE || dt == DataType.ARRAY)) {
                        tmp = value instanceof byte[] ? new GXByteBuffer((byte[])value) : (GXByteBuffer)value;
                        GXDLMSCompactData.captureArray(srv, tmp, bb, it.getValue().getDataIndex() - 1);
                        continue;
                    }
                    tmp = new GXByteBuffer();
                    GXCommon.setData(null, tmp, dt, value);
                    if (tmp.size() == 1) {
                        bb.setUInt8(0);
                        continue;
                    }
                    tmp.position(1);
                    bb.set(tmp);
                }
                this.buffer = bb.array();
            }
            srv.notifyPostGet(args);
            srv.notifyAction(args);
            srv.notifyPostAction(args);
        }
    }

    private static void updateTemplateDescription(GXByteBuffer columns, GXByteBuffer data, int index) {
        DataType ch = DataType.forValue(data.getUInt8());
        int count = GXCommon.getObjectCount(data);
        if (index == -1) {
            columns.setUInt8(ch.getValue());
            if (ch == DataType.ARRAY) {
                columns.setUInt16(count);
            } else {
                columns.setUInt8(count);
            }
        }
        GXDataInfo info = new GXDataInfo();
        for (int pos = 0; pos < count; ++pos) {
            if (index != -1 && pos != index) continue;
            DataType dt = DataType.forValue(data.getUInt8(data.position()));
            if (dt == DataType.ARRAY || dt == DataType.STRUCTURE) {
                GXDLMSCompactData.updateTemplateDescription(columns, data, -1);
                if (ch == DataType.ARRAY) {
                    break;
                }
            } else {
                info.clear();
                columns.setUInt8(dt.getValue());
                GXCommon.getData(null, data, info);
            }
            if (index == pos) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTemplateDescription() {
        GXDLMSCompactData gXDLMSCompactData = this;
        synchronized (gXDLMSCompactData) {
            GXByteBuffer bb = new GXByteBuffer();
            this.buffer = null;
            bb.setUInt8(DataType.STRUCTURE.getValue());
            GXCommon.setObjectCount(this.captureObjects.size(), bb);
            for (Map.Entry<GXDLMSObject, GXDLMSCaptureObject> it : this.captureObjects) {
                DataType dt = it.getKey().getDataType(it.getValue().getAttributeIndex());
                if (dt == DataType.ARRAY || dt == DataType.STRUCTURE) {
                    ValueEventArgs e = new ValueEventArgs(null, it.getValue().getAttributeIndex(), 0, null);
                    GXByteBuffer data = new GXByteBuffer();
                    Object v = it.getKey().getValue(null, e);
                    if (v instanceof byte[]) {
                        data.set((byte[])v);
                    } else {
                        data = (GXByteBuffer)v;
                    }
                    GXDLMSCompactData.updateTemplateDescription(bb, data, it.getValue().getDataIndex() - 1);
                    continue;
                }
                bb.setUInt8(dt.getValue());
            }
            this.templateDescription = bb.array();
        }
    }

    public List<Object> getValues(byte[] templateDescription, byte[] buffer) {
        if (templateDescription == null || buffer == null || templateDescription.length == 0 || buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        GXDataInfo info = new GXDataInfo();
        GXByteBuffer data = new GXByteBuffer();
        data.set(templateDescription);
        GXCommon.setObjectCount(buffer.length, data);
        data.set(buffer);
        info.setType(DataType.COMPACT_ARRAY);
        return (List)GXCommon.getData(null, data, info);
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Buffer", "CaptureObjects", "TemplateId", "TemplateDescription", "CaptureMethod"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset", "Capture"};
    }
}

