/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Unit;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSDemandRegister
extends GXDLMSObject
implements IGXDLMSBase {
    private int scaler;
    private int unit;
    private Object currentAverageValue;
    private Object lastAverageValue;
    private Object status;
    private GXDateTime captureTime = new GXDateTime();
    private GXDateTime startTimeCurrent = new GXDateTime();
    private long numberOfPeriods;
    private long period;

    public GXDLMSDemandRegister() {
        this((String)null);
    }

    public GXDLMSDemandRegister(String ln) {
        this(ln, 0);
    }

    public GXDLMSDemandRegister(String ln, int sn) {
        super(ObjectType.DEMAND_REGISTER, ln, sn);
        this.setScaler(1.0);
    }

    public final Object getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public final void setCurrentAverageValue(Object value) {
        this.currentAverageValue = value;
    }

    public final Object getLastAverageValue() {
        return this.lastAverageValue;
    }

    public final void setLastAverageValue(Object value) {
        this.lastAverageValue = value;
    }

    public final double getScaler() {
        return Math.pow(10.0, this.scaler);
    }

    public final void setScaler(double value) {
        this.scaler = (int)Math.log10(value);
    }

    public final Unit getUnit() {
        return Unit.forValue(this.unit);
    }

    public final void setUnit(Unit value) {
        this.unit = value.getValue();
    }

    public final Object getStatus() {
        return this.status;
    }

    public final void setStatus(Object value) {
        this.status = value;
    }

    public final GXDateTime getCaptureTime() {
        return this.captureTime;
    }

    public final void setCaptureTime(GXDateTime value) {
        this.captureTime = value;
    }

    public final GXDateTime getStartTimeCurrent() {
        return this.startTimeCurrent;
    }

    public final void setStartTimeCurrent(GXDateTime value) {
        this.startTimeCurrent = value;
    }

    public final long getPeriod() {
        return this.period;
    }

    public final void setPeriod(long value) {
        this.period = value;
    }

    public final long getNumberOfPeriods() {
        return this.numberOfPeriods;
    }

    public final void setNumberOfPeriods(long value) {
        this.numberOfPeriods = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    public final byte[][] nextPeriod(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 2, 0, DataType.INT8);
    }

    @Override
    public final Object[] getValues() {
        String str = "Scaler: " + String.valueOf(this.getScaler()) + " Unit: " + this.getUnit().toString();
        return new Object[]{this.getLogicalName(), this.getCurrentAverageValue(), this.getLastAverageValue(), str, this.getStatus(), this.getCaptureTime(), this.getStartTimeCurrent(), this.getPeriod(), this.getNumberOfPeriods()};
    }

    @Override
    public final boolean isRead(int index) {
        if (index == 4) {
            return this.unit != 0;
        }
        return super.isRead(index);
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.lastAverageValue = null;
            this.currentAverageValue = null;
            this.captureTime = new GXDateTime(Calendar.getInstance());
            this.startTimeCurrent = new GXDateTime(Calendar.getInstance());
        } else if (e.getIndex() == 2) {
            this.lastAverageValue = this.currentAverageValue;
            this.currentAverageValue = null;
            this.captureTime = new GXDateTime(Calendar.getInstance());
            this.startTimeCurrent = new GXDateTime(Calendar.getInstance());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 9;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return super.getDataType(index);
        }
        if (index == 3) {
            return super.getDataType(index);
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        if (index == 5) {
            return super.getDataType(index);
        }
        if (index == 6) {
            return DataType.OCTET_STRING;
        }
        if (index == 7) {
            return DataType.OCTET_STRING;
        }
        if (index == 8) {
            return DataType.UINT32;
        }
        if (index == 9) {
            return DataType.UINT16;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            if (settings != null && !settings.isServer() && this.getScaler() != 1.0 && this.currentAverageValue != null) {
                DataType type = GXDLMSConverter.getDLMSDataType(this.currentAverageValue);
                Object tmp = ((Number)this.currentAverageValue).doubleValue() / this.getScaler();
                if (type != DataType.NONE) {
                    tmp = GXDLMSConverter.changeType(tmp, type);
                }
                return tmp;
            }
            return this.currentAverageValue;
        }
        if (e.getIndex() == 3) {
            if (settings != null && !settings.isServer() && this.getScaler() != 1.0 && this.lastAverageValue != null) {
                DataType type = GXDLMSConverter.getDLMSDataType(this.lastAverageValue);
                Object tmp = ((Number)this.lastAverageValue).doubleValue() / this.getScaler();
                if (type != DataType.NONE) {
                    tmp = GXDLMSConverter.changeType(tmp, type);
                }
                return tmp;
            }
            return this.lastAverageValue;
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(settings, data, DataType.INT8, this.scaler);
            GXCommon.setData(settings, data, DataType.ENUM, this.unit);
            return data.array();
        }
        if (e.getIndex() == 5) {
            return this.getStatus();
        }
        if (e.getIndex() == 6) {
            return this.getCaptureTime();
        }
        if (e.getIndex() == 7) {
            return this.getStartTimeCurrent();
        }
        if (e.getIndex() == 8) {
            return this.getPeriod();
        }
        if (e.getIndex() == 9) {
            return this.getNumberOfPeriods();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (settings != null && !settings.isServer() && this.getScaler() != 1.0 && e.getValue() != null) {
                try {
                    this.setCurrentAverageValue(((Number)e.getValue()).doubleValue() * this.getScaler());
                }
                catch (Exception e1) {
                    this.setCurrentAverageValue(e.getValue());
                }
            } else {
                this.setCurrentAverageValue(e.getValue());
            }
        } else if (e.getIndex() == 3) {
            if (settings != null && !settings.isServer() && this.getScaler() != 1.0 && e.getValue() != null) {
                try {
                    this.setLastAverageValue(((Number)e.getValue()).doubleValue() * this.getScaler());
                }
                catch (Exception e1) {
                    this.setLastAverageValue(e.getValue());
                }
            } else {
                this.setLastAverageValue(e.getValue());
            }
        } else if (e.getIndex() == 4) {
            if (e.getValue() == null) {
                this.scaler = 0;
                this.unit = 0;
            } else {
                List arr = (List)e.getValue();
                if (arr.size() != 2) {
                    throw new IllegalArgumentException("setValue failed. Invalid scaler unit value.");
                }
                this.scaler = ((Number)arr.get(0)).intValue();
                this.unit = ((Number)arr.get(1)).intValue() & 0xFF;
            }
        } else if (e.getIndex() == 5) {
            if (e.getValue() == null) {
                this.setStatus(null);
            } else {
                this.setStatus(e.getValue());
            }
        } else if (e.getIndex() == 6) {
            if (e.getValue() == null) {
                this.setCaptureTime(new GXDateTime());
            } else {
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.setCaptureTime(tmp);
            }
        } else if (e.getIndex() == 7) {
            if (e.getValue() == null) {
                this.setStartTimeCurrent(new GXDateTime());
            } else {
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.setStartTimeCurrent(tmp);
            }
        } else if (e.getIndex() == 8) {
            if (e.getValue() == null) {
                this.setPeriod(0L);
            } else {
                this.setPeriod(((Number)e.getValue()).longValue());
            }
        } else if (e.getIndex() == 9) {
            if (e.getValue() == null) {
                this.setNumberOfPeriods(0L);
            } else {
                this.setNumberOfPeriods(((Number)e.getValue()).longValue());
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.currentAverageValue = reader.readElementContentAsObject("CurrentAverageValue", null, this, 2);
        this.lastAverageValue = reader.readElementContentAsObject("LastAverageValue", null, this, 3);
        this.setScaler(reader.readElementContentAsDouble("Scaler", 1.0));
        this.unit = reader.readElementContentAsInt("Unit");
        this.status = reader.readElementContentAsObject("Status", null, this, 5);
        this.captureTime = reader.readElementContentAsDateTime("CaptureTime");
        this.startTimeCurrent = reader.readElementContentAsDateTime("StartTimeCurrent");
        this.period = reader.readElementContentAsInt("Period");
        this.numberOfPeriods = reader.readElementContentAsInt("NumberOfPeriods");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementObject("CurrentAverageValue", this.currentAverageValue);
        writer.writeElementObject("LastAverageValue", this.lastAverageValue);
        writer.writeElementString("Scaler", this.getScaler(), 1.0);
        writer.writeElementString("Unit", this.unit);
        writer.writeElementObject("Status", this.status);
        writer.writeElementString("CaptureTime", this.captureTime);
        writer.writeElementString("StartTimeCurrent", this.startTimeCurrent);
        writer.writeElementString("Period", this.period);
        writer.writeElementString("NumberOfPeriods", this.numberOfPeriods);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Current Average Value", "Last Average Value", "Scaler and Unit", "Status", "Capture Time", "Start Time Current", "Period", "Number Of Periods"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset", "Next period"};
    }
}

