/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXDateTime;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Unit;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSRegister;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.stream.XMLStreamException;

public class GXDLMSExtendedRegister
extends GXDLMSRegister {
    private GXDateTime captureTime = new GXDateTime();
    private Object status;

    public GXDLMSExtendedRegister() {
        super(ObjectType.EXTENDED_REGISTER, null, 0);
    }

    public GXDLMSExtendedRegister(String ln) {
        super(ObjectType.EXTENDED_REGISTER, ln, 0);
    }

    public GXDLMSExtendedRegister(String ln, int sn) {
        super(ObjectType.EXTENDED_REGISTER, ln, sn);
    }

    public final Object getStatus() {
        return this.status;
    }

    public final void setStatus(Object value) {
        this.status = value;
    }

    public final GXDateTime getCaptureTime() {
        return this.captureTime;
    }

    public final void setCaptureTime(GXDateTime value) {
        this.captureTime = value;
    }

    @Override
    public final DataType getUIDataType(int index) {
        if (index == 5) {
            return DataType.DATETIME;
        }
        return super.getUIDataType(index);
    }

    @Override
    public final Object[] getValues() {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String str = "Scaler: " + formatter.format(this.getScaler());
        str = str + " Unit: ";
        str = str + this.getUnit().toString();
        return new Object[]{this.getLogicalName(), this.getValue(), str, this.getStatus(), this.getCaptureTime()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setValue(null);
            this.captureTime = new GXDateTime(Calendar.getInstance());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 5;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return super.getDataType(index);
        }
        if (index == 3) {
            return DataType.ARRAY;
        }
        if (index == 4) {
            return super.getDataType(index);
        }
        if (index == 5) {
            return DataType.OCTET_STRING;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 4) {
            return this.getStatus();
        }
        if (e.getIndex() == 5) {
            return this.getCaptureTime();
        }
        return super.getValue(settings, e);
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 4) {
            this.setStatus(e.getValue());
        } else if (e.getIndex() == 5) {
            if (e.getValue() == null) {
                this.setCaptureTime(new GXDateTime());
            } else {
                GXDateTime tmp = e.getValue() instanceof byte[] ? (GXDateTime)GXDLMSClient.changeType((byte[])e.getValue(), DataType.DATETIME, e.getSettings()) : (GXDateTime)e.getValue();
                this.setCaptureTime(tmp);
            }
        } else {
            super.setValue(settings, e);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.setUnit(Unit.forValue(reader.readElementContentAsInt("Unit", 0)));
        this.setScaler(reader.readElementContentAsDouble("Scaler", 1.0));
        this.setValue(reader.readElementContentAsObject("Value", null, this, 2));
        this.status = reader.readElementContentAsObject("Status", null, this, 4);
        this.captureTime = reader.readElementContentAsDateTime("CaptureTime");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Unit", this.getUnit().getValue());
        writer.writeElementString("Scaler", this.getScaler(), 1.0);
        writer.writeElementObject("Value", this.getValue(), this.getDataType(2), this.getUIDataType(2));
        writer.writeElementObject("Status", this.status, this.getDataType(4), this.getUIDataType(4));
        writer.writeElementString("CaptureTime", this.captureTime);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Value", "Scaler and Unit", "Status", "Capture Time"};
    }
}

