/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXDLMSQualityOfService;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GXDLMSGprsSetup
extends GXDLMSObject
implements IGXDLMSBase {
    private String apn;
    private long pinCode;
    private GXDLMSQualityOfService defaultQualityOfService = new GXDLMSQualityOfService();
    private GXDLMSQualityOfService requestedQualityOfService = new GXDLMSQualityOfService();

    public GXDLMSGprsSetup() {
        super(ObjectType.GPRS_SETUP);
    }

    public GXDLMSGprsSetup(String ln) {
        super(ObjectType.GPRS_SETUP, ln, 0);
    }

    public GXDLMSGprsSetup(String ln, int sn) {
        super(ObjectType.GPRS_SETUP, ln, sn);
    }

    public final String getAPN() {
        return this.apn;
    }

    public final void setAPN(String value) {
        this.apn = value;
    }

    public final long getPINCode() {
        return this.pinCode;
    }

    public final void setPINCode(long value) {
        this.pinCode = value;
    }

    public final GXDLMSQualityOfService getDefaultQualityOfService() {
        return this.defaultQualityOfService;
    }

    public final GXDLMSQualityOfService getRequestedQualityOfService() {
        return this.requestedQualityOfService;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getAPN(), this.getPINCode(), this.getDefaultQualityOfService(), this.getRequestedQualityOfService()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 4;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.OCTET_STRING;
        }
        if (index == 3) {
            return DataType.UINT16;
        }
        if (index == 4) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            if (this.apn == null) {
                return null;
            }
            return this.apn.getBytes();
        }
        if (e.getIndex() == 3) {
            return this.getPINCode();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(5);
            GXCommon.setData(settings, data, DataType.UINT8, this.defaultQualityOfService.getPrecedence());
            GXCommon.setData(settings, data, DataType.UINT8, this.defaultQualityOfService.getDelay());
            GXCommon.setData(settings, data, DataType.UINT8, this.defaultQualityOfService.getReliability());
            GXCommon.setData(settings, data, DataType.UINT8, this.defaultQualityOfService.getPeakThroughput());
            GXCommon.setData(settings, data, DataType.UINT8, this.defaultQualityOfService.getMeanThroughput());
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(5);
            GXCommon.setData(settings, data, DataType.UINT8, this.requestedQualityOfService.getPrecedence());
            GXCommon.setData(settings, data, DataType.UINT8, this.requestedQualityOfService.getDelay());
            GXCommon.setData(settings, data, DataType.UINT8, this.requestedQualityOfService.getReliability());
            GXCommon.setData(settings, data, DataType.UINT8, this.requestedQualityOfService.getPeakThroughput());
            GXCommon.setData(settings, data, DataType.UINT8, this.requestedQualityOfService.getMeanThroughput());
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() instanceof String) {
                this.setAPN(e.getValue().toString());
            } else {
                this.setAPN(GXDLMSClient.changeType((byte[])e.getValue(), DataType.STRING, false).toString());
            }
        } else if (e.getIndex() == 3) {
            this.setPINCode(((Number)e.getValue()).intValue());
        } else if (e.getIndex() == 4) {
            List arr = (List)((List)e.getValue()).get(0);
            this.defaultQualityOfService.setPrecedence(((Number)arr.get(0)).intValue());
            this.defaultQualityOfService.setDelay(((Number)arr.get(1)).intValue());
            this.defaultQualityOfService.setReliability(((Number)arr.get(2)).intValue());
            this.defaultQualityOfService.setPeakThroughput(((Number)arr.get(3)).intValue());
            this.defaultQualityOfService.setMeanThroughput(((Number)arr.get(4)).intValue());
            arr = (List)((List)e.getValue()).get(1);
            this.requestedQualityOfService.setPrecedence(((Number)arr.get(0)).intValue());
            this.requestedQualityOfService.setDelay(((Number)arr.get(1)).intValue());
            this.requestedQualityOfService.setReliability(((Number)arr.get(2)).intValue());
            this.requestedQualityOfService.setPeakThroughput(((Number)arr.get(3)).intValue());
            this.requestedQualityOfService.setMeanThroughput(((Number)arr.get(4)).intValue());
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.apn = reader.readElementContentAsString("APN");
        this.pinCode = reader.readElementContentAsInt("PINCode");
        if (reader.isStartElement("DefaultQualityOfService", true)) {
            this.defaultQualityOfService.setPrecedence(reader.readElementContentAsInt("Precedence"));
            this.defaultQualityOfService.setDelay(reader.readElementContentAsInt("Delay"));
            this.defaultQualityOfService.setReliability(reader.readElementContentAsInt("Reliability"));
            this.defaultQualityOfService.setPeakThroughput(reader.readElementContentAsInt("PeakThroughput"));
            this.defaultQualityOfService.setMeanThroughput(reader.readElementContentAsInt("MeanThroughput"));
            reader.readEndElement("DefaultQualityOfService");
        }
        if (reader.isStartElement("RequestedQualityOfService", true)) {
            this.requestedQualityOfService.setPrecedence(reader.readElementContentAsInt("Precedence"));
            this.requestedQualityOfService.setDelay(reader.readElementContentAsInt("Delay"));
            this.requestedQualityOfService.setReliability(reader.readElementContentAsInt("Reliability"));
            this.requestedQualityOfService.setPeakThroughput(reader.readElementContentAsInt("PeakThroughput"));
            this.requestedQualityOfService.setMeanThroughput(reader.readElementContentAsInt("MeanThroughput"));
            reader.readEndElement("DefaultQualityOfService");
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("APN", this.apn);
        writer.writeElementString("PINCode", this.pinCode);
        if (this.defaultQualityOfService != null) {
            writer.writeStartElement("DefaultQualityOfService");
            writer.writeElementString("Precedence", this.defaultQualityOfService.getPrecedence());
            writer.writeElementString("Delay", this.defaultQualityOfService.getDelay());
            writer.writeElementString("Reliability", this.defaultQualityOfService.getReliability());
            writer.writeElementString("PeakThroughput", this.defaultQualityOfService.getPeakThroughput());
            writer.writeElementString("MeanThroughput", this.defaultQualityOfService.getMeanThroughput());
            writer.writeEndElement();
        }
        if (this.requestedQualityOfService != null) {
            writer.writeStartElement("RequestedQualityOfService");
            writer.writeElementString("Precedence", this.requestedQualityOfService.getPrecedence());
            writer.writeElementString("Delay", this.requestedQualityOfService.getDelay());
            writer.writeElementString("Reliability", this.requestedQualityOfService.getReliability());
            writer.writeElementString("PeakThroughput", this.requestedQualityOfService.getPeakThroughput());
            writer.writeElementString("MeanThroughput", this.requestedQualityOfService.getMeanThroughput());
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "APN", "PIN Code", "Default Quality Of Service and Requested Quality Of Service"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

