/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXStructure;
import gurux.dlms.GXUInt32;
import gurux.dlms.GXUInt64;
import gurux.dlms.GXUInt8;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSMeterPrimaryAccountNumber;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIec6205541Attributes
extends GXDLMSObject
implements IGXDLMSBase {
    private GXDLMSMeterPrimaryAccountNumber meterPan = new GXDLMSMeterPrimaryAccountNumber();
    private String commodity;
    private byte[] tokenCarrierTypes;
    private short encryptionAlgorithm;
    private long supplyGroupCode;
    private short tariffIndex;
    private short keyRevisionNumber;
    private short keyType;
    private short keyExpiryNumber;
    private short kctSupported;
    private String stsCertificate;

    public final short getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public final void setEncryptionAlgorithm(short value) {
        this.encryptionAlgorithm = value;
    }

    public final long getSupplyGroupCode() {
        return this.supplyGroupCode;
    }

    public final void setSupplyGroupCode(long value) {
        this.supplyGroupCode = value;
    }

    public final GXDLMSMeterPrimaryAccountNumber getMeterPan() {
        return this.meterPan;
    }

    public final void setMeterPan(GXDLMSMeterPrimaryAccountNumber value) {
        this.meterPan = value;
    }

    public final String getCommodity() {
        return this.commodity;
    }

    public final void setCommodity(String value) {
        this.commodity = value;
    }

    public final byte[] getTokenCarrierTypes() {
        return this.tokenCarrierTypes;
    }

    public final void setTokenCarrierTypes(byte[] value) {
        this.tokenCarrierTypes = value;
    }

    public final short getTariffIndex() {
        return this.tariffIndex;
    }

    public final void setTariffIndex(short value) {
        this.tariffIndex = value;
    }

    public final short getKeyRevisionNumber() {
        return this.keyRevisionNumber;
    }

    public final void setKeyRevisionNumber(short value) {
        this.keyRevisionNumber = value;
    }

    public final short getKeyType() {
        return this.keyType;
    }

    public final void setKeyType(short value) {
        this.keyType = value;
    }

    public final short getKeyExpiryNumber() {
        return this.keyExpiryNumber;
    }

    public final void setKeyExpiryNumber(short value) {
        this.keyExpiryNumber = value;
    }

    public final short getKctSupported() {
        return this.kctSupported;
    }

    public final void setKctSupported(short value) {
        this.kctSupported = value;
    }

    public final String getStsCertificate() {
        return this.stsCertificate;
    }

    public final void setStsCertificate(String value) {
        this.stsCertificate = value;
    }

    public GXDLMSIec6205541Attributes() {
        this("0.0.19.60.0.255", 0);
    }

    public GXDLMSIec6205541Attributes(String ln) {
        this(ln, 0);
    }

    public GXDLMSIec6205541Attributes(String ln, int sn) {
        super(ObjectType.IEC_6205541_ATTRIBUTES, ln, sn);
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getMeterPan(), this.getCommodity(), this.getTokenCarrierTypes(), this.getEncryptionAlgorithm(), this.getSupplyGroupCode(), this.getTariffIndex(), this.getKeyRevisionNumber(), this.getKeyType(), this.getKeyExpiryNumber(), this.getKctSupported(), this.getStsCertificate()};
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.canRead(6)) {
            attributes.add(6);
        }
        if (all || !this.canRead(7)) {
            attributes.add(7);
        }
        if (all || !this.canRead(8)) {
            attributes.add(8);
        }
        if (all || !this.canRead(9)) {
            attributes.add(9);
        }
        if (all || !this.canRead(10)) {
            attributes.add(10);
        }
        if (all || !super.isRead(11)) {
            attributes.add(11);
        }
        if (all || !super.isRead(12)) {
            attributes.add(12);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 12;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: {
                return DataType.STRUCTURE;
            }
            case 3: 
            case 12: {
                return DataType.STRING;
            }
            case 4: {
                return DataType.ARRAY;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return DataType.UINT8;
            }
            case 6: {
                return DataType.UINT32;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                return GXCommon.logicalNameToBytes(this.getLogicalName());
            }
            case 2: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.STRUCTURE);
                data.setUInt8(3);
                GXCommon.setData(settings, data, DataType.UINT32, this.meterPan.getIssuerId());
                GXCommon.setData(settings, data, DataType.UINT64, this.meterPan.getDecoderReferenceNumber());
                GXCommon.setData(settings, data, DataType.UINT8, this.meterPan.getPanCheckDigit());
                return data.array();
            }
            case 3: {
                return this.getCommodity();
            }
            case 4: {
                GXByteBuffer data = new GXByteBuffer();
                data.setUInt8(DataType.ARRAY);
                if (this.getTokenCarrierTypes() == null) {
                    data.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.getTokenCarrierTypes().length, data);
                    for (byte it : this.getTokenCarrierTypes()) {
                        GXCommon.setData(settings, data, DataType.UINT8, it);
                    }
                }
                return data.array();
            }
            case 5: {
                return this.getEncryptionAlgorithm();
            }
            case 6: {
                return this.getSupplyGroupCode();
            }
            case 7: {
                return this.getTariffIndex();
            }
            case 8: {
                return this.getKeyRevisionNumber();
            }
            case 9: {
                return this.getKeyType();
            }
            case 10: {
                return this.getKeyExpiryNumber();
            }
            case 11: {
                return this.getKctSupported();
            }
            case 12: {
                return this.getStsCertificate();
            }
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                if (!(e.getValue() instanceof GXStructure)) break;
                GXStructure s = (GXStructure)e.getValue();
                this.meterPan.setIssuerId(BigInteger.valueOf(((GXUInt32)s.get(0)).longValue()));
                this.meterPan.setDecoderReferenceNumber(((GXUInt64)s.get(1)).bigIntegerValue());
                this.meterPan.setPanCheckDigit(((Number)s.get(2)).shortValue());
                break;
            }
            case 3: {
                this.setCommodity(String.valueOf(e.getValue()));
                break;
            }
            case 4: {
                GXByteBuffer data = new GXByteBuffer();
                if (e.getValue() instanceof GXArray) {
                    for (Object it : (GXArray)e.getValue()) {
                        data.setUInt8(((GXUInt8)it).shortValue());
                    }
                }
                this.setTokenCarrierTypes(data.getData());
                break;
            }
            case 5: {
                this.setEncryptionAlgorithm(((Number)e.getValue()).shortValue());
                break;
            }
            case 6: {
                this.setSupplyGroupCode(((Number)e.getValue()).longValue());
                break;
            }
            case 7: {
                this.setTariffIndex(((Number)e.getValue()).shortValue());
                break;
            }
            case 8: {
                this.setKeyRevisionNumber(((Number)e.getValue()).shortValue());
                break;
            }
            case 9: {
                this.setKeyType(((Number)e.getValue()).shortValue());
                break;
            }
            case 10: {
                this.setKeyExpiryNumber(((Number)e.getValue()).shortValue());
                break;
            }
            case 11: {
                this.setKctSupported(((Number)e.getValue()).shortValue());
                break;
            }
            case 12: {
                this.setStsCertificate((String)e.getValue());
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        String str = reader.readElementContentAsString("IssuerId");
        if (str != null && str != "") {
            this.meterPan.setIssuerId(new BigInteger(str));
        }
        if ((str = reader.readElementContentAsString("DecoderReferenceNumber")) != null && str != "") {
            this.meterPan.setDecoderReferenceNumber(new BigInteger(str));
        }
        this.meterPan.setPanCheckDigit((short)reader.readElementContentAsInt("PanCheckDigit"));
        this.commodity = reader.readElementContentAsString("Commodity");
        GXByteBuffer list = new GXByteBuffer();
        if (reader.isStartElement("TokenCarrierTypes", true)) {
            while (reader.isStartElement("Value", false)) {
                list.setUInt8(reader.readElementContentAsInt("Value"));
            }
            reader.readEndElement("TokenCarrierTypes");
        }
        this.tokenCarrierTypes = list.array();
        this.setEncryptionAlgorithm((short)reader.readElementContentAsInt("EncryptionAlgorithm"));
        this.setSupplyGroupCode(reader.readElementContentAsULong("SupplyGroupCode"));
        this.setTariffIndex((byte)reader.readElementContentAsULong("TariffIndex"));
        this.setKeyRevisionNumber((short)reader.readElementContentAsULong("KeyRevisionNumber"));
        this.setKeyType((short)reader.readElementContentAsULong("KeyType"));
        this.setKeyExpiryNumber((byte)reader.readElementContentAsULong("KeyExpiryNumber"));
        this.setKctSupported((short)reader.readElementContentAsULong("KctSupported"));
        this.setStsCertificate(reader.readElementContentAsString("StsCertificate"));
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("IssuerId", String.valueOf(this.meterPan.getIssuerId()));
        writer.writeElementString("DecoderReferenceNumber", String.valueOf(this.meterPan.getDecoderReferenceNumber()));
        writer.writeElementString("PanCheckDigit", this.meterPan.getPanCheckDigit());
        writer.writeElementString("Commodity", this.commodity);
        writer.writeStartElement("TokenCarrierTypes");
        if (this.tokenCarrierTypes != null) {
            for (byte it : this.tokenCarrierTypes) {
                writer.writeElementString("Value", String.valueOf(it));
            }
        }
        writer.writeEndElement();
        writer.writeElementString("EncryptionAlgorithm", this.getEncryptionAlgorithm());
        writer.writeElementString("SupplyGroupCode", this.getSupplyGroupCode());
        writer.writeElementString("TariffIndex", this.getTariffIndex());
        writer.writeElementString("KeyRevisionNumber", this.getKeyRevisionNumber());
        writer.writeElementString("KeyType", this.getKeyType());
        writer.writeElementString("KeyExpiryNumber", this.getKeyExpiryNumber());
        writer.writeElementString("KctSupported", this.getKctSupported());
        writer.writeElementString("StsCertificate", this.getStsCertificate());
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "MeterPan", "Commodity", "TokenCarrierTypes", "EncryptionAlgorithm", "SupplyGroupCode", "TariffIndex", "KeyRevisionNumber", "KeyType", "KeyExpiryNumber", "KctSupported", "StsCertificate"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

