/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIec8802LlcType2Setup
extends GXDLMSObject
implements IGXDLMSBase {
    private byte transmitWindowSizeK = 1;
    private byte transmitWindowSizeRW = 1;
    private int maximumOctetsPdu = 128;
    private byte maximumNumberTransmissions;
    private int acknowledgementTimer;
    private int bitTimer;
    private int rejectTimer;
    private int busyStateTimer;

    public GXDLMSIec8802LlcType2Setup() {
        this("0.0.27.1.0.255", 0);
    }

    public GXDLMSIec8802LlcType2Setup(String ln) {
        this(ln, 0);
    }

    public GXDLMSIec8802LlcType2Setup(String ln, int sn) {
        super(ObjectType.IEC_8802_LLC_TYPE2_SETUP, ln, sn);
    }

    public final byte getTransmitWindowSizeK() {
        return this.transmitWindowSizeK;
    }

    public final void setTransmitWindowSizeK(byte value) {
        this.transmitWindowSizeK = value;
    }

    public final byte getTransmitWindowSizeRW() {
        return this.transmitWindowSizeRW;
    }

    public final void setTransmitWindowSizeRW(byte value) {
        this.transmitWindowSizeRW = value;
    }

    public final int getMaximumOctetsPdu() {
        return this.maximumOctetsPdu;
    }

    public final void setMaximumOctetsPdu(int value) {
        this.maximumOctetsPdu = value;
    }

    public final byte getMaximumNumberTransmissions() {
        return this.maximumNumberTransmissions;
    }

    public final void setMaximumNumberTransmissions(byte value) {
        this.maximumNumberTransmissions = value;
    }

    public final int getAcknowledgementTimer() {
        return this.acknowledgementTimer;
    }

    public final void setAcknowledgementTimer(int value) {
        this.acknowledgementTimer = value;
    }

    public final int getBitTimer() {
        return this.bitTimer;
    }

    public final void setBitTimer(int value) {
        this.bitTimer = value;
    }

    public final int getRejectTimer() {
        return this.rejectTimer;
    }

    public final void setRejectTimer(int value) {
        this.rejectTimer = value;
    }

    public final int getBusyStateTimer() {
        return this.busyStateTimer;
    }

    public final void setBusyStateTimer(int value) {
        this.busyStateTimer = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.transmitWindowSizeK, this.transmitWindowSizeRW, this.maximumOctetsPdu, this.maximumNumberTransmissions, this.acknowledgementTimer, this.bitTimer, this.rejectTimer, this.busyStateTimer};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 9;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 5: {
                return DataType.UINT8;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.transmitWindowSizeK;
                break;
            }
            case 3: {
                ret = this.transmitWindowSizeRW;
                break;
            }
            case 4: {
                ret = this.maximumOctetsPdu;
                break;
            }
            case 5: {
                ret = this.maximumNumberTransmissions;
                break;
            }
            case 6: {
                ret = this.acknowledgementTimer;
                break;
            }
            case 7: {
                ret = this.bitTimer;
                break;
            }
            case 8: {
                ret = this.rejectTimer;
                break;
            }
            case 9: {
                ret = this.busyStateTimer;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.transmitWindowSizeK = ((Number)e.getValue()).byteValue();
                break;
            }
            case 3: {
                this.transmitWindowSizeRW = ((Number)e.getValue()).byteValue();
                break;
            }
            case 4: {
                this.maximumOctetsPdu = ((Number)e.getValue()).intValue();
                break;
            }
            case 5: {
                this.maximumNumberTransmissions = ((Number)e.getValue()).byteValue();
                break;
            }
            case 6: {
                this.acknowledgementTimer = ((Number)e.getValue()).intValue();
                break;
            }
            case 7: {
                this.bitTimer = ((Number)e.getValue()).intValue();
                break;
            }
            case 8: {
                this.rejectTimer = ((Number)e.getValue()).intValue();
                break;
            }
            case 9: {
                this.busyStateTimer = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.transmitWindowSizeK = (byte)reader.readElementContentAsInt("TransmitWindowSizeK");
        this.transmitWindowSizeRW = (byte)reader.readElementContentAsInt("TransmitWindowSizeRW");
        this.maximumOctetsPdu = reader.readElementContentAsInt("MaximumOctetsPdu");
        this.maximumNumberTransmissions = (byte)reader.readElementContentAsInt("MaximumNumberTransmissions");
        this.acknowledgementTimer = reader.readElementContentAsInt("AcknowledgementTimer");
        this.bitTimer = reader.readElementContentAsInt("BitTimer");
        this.rejectTimer = reader.readElementContentAsInt("RejectTimer");
        this.busyStateTimer = reader.readElementContentAsInt("BusyStateTimer");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("TransmitWindowSizeK", this.transmitWindowSizeK);
        writer.writeElementString("TransmitWindowSizeRW", this.transmitWindowSizeRW);
        writer.writeElementString("MaximumOctetsPdu", this.maximumOctetsPdu);
        writer.writeElementString("MaximumNumberTransmissions", this.maximumNumberTransmissions);
        writer.writeElementString("AcknowledgementTimer", this.acknowledgementTimer);
        writer.writeElementString("BitTimer", this.bitTimer);
        writer.writeElementString("RejectTimer", this.rejectTimer);
        writer.writeElementString("BusyStateTimer", this.busyStateTimer);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "TransmitWindowSizeK", "TransmitWindowSizeRW", "MaximumOctetsPdu", "MaximumNumberTransmissions", "AcknowledgementTimer", "BitTimer", "RejectTimer", "BusyStateTimer"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

