/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIec8802LlcType3Setup
extends GXDLMSObject
implements IGXDLMSBase {
    private int maximumOctetsACnPdu;
    private byte maximumTransmissions;
    private int acknowledgementTime;
    private int receiveLifetime;
    private int transmitLifetime;

    public GXDLMSIec8802LlcType3Setup() {
        this("0.0.27.2.0.255", 0);
    }

    public GXDLMSIec8802LlcType3Setup(String ln) {
        this(ln, 0);
    }

    public GXDLMSIec8802LlcType3Setup(String ln, int sn) {
        super(ObjectType.IEC_8802_LLC_TYPE3_SETUP, ln, sn);
    }

    public final int getMaximumOctetsACnPdu() {
        return this.maximumOctetsACnPdu;
    }

    public final void setMaximumOctetsACnPdu(int value) {
        this.maximumOctetsACnPdu = value;
    }

    public final byte getMaximumTransmissions() {
        return this.maximumTransmissions;
    }

    public final void setMaximumTransmissions(byte value) {
        this.maximumTransmissions = value;
    }

    public final int getAcknowledgementTime() {
        return this.acknowledgementTime;
    }

    public final void setAcknowledgementTime(int value) {
        this.acknowledgementTime = value;
    }

    public final int getReceiveLifetime() {
        return this.receiveLifetime;
    }

    public final void setReceiveLifetime(int value) {
        this.receiveLifetime = value;
    }

    public final int getTransmitLifetime() {
        return this.transmitLifetime;
    }

    public final void setTransmitLifetime(int value) {
        this.transmitLifetime = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.maximumOctetsACnPdu, this.maximumTransmissions, this.acknowledgementTime, this.receiveLifetime, this.transmitLifetime};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 6;
    }

    @Override
    public final int getMethodCount() {
        return 0;
    }

    @Override
    public final DataType getDataType(int index) {
        switch (index) {
            case 1: {
                return DataType.OCTET_STRING;
            }
            case 2: 
            case 3: 
            case 5: {
                return DataType.UINT8;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return DataType.UINT16;
            }
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                ret = this.maximumOctetsACnPdu;
                break;
            }
            case 3: {
                ret = this.maximumTransmissions;
                break;
            }
            case 4: {
                ret = this.acknowledgementTime;
                break;
            }
            case 5: {
                ret = this.receiveLifetime;
                break;
            }
            case 6: {
                ret = this.transmitLifetime;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.maximumOctetsACnPdu = ((Number)e.getValue()).intValue();
                break;
            }
            case 3: {
                this.maximumTransmissions = ((Number)e.getValue()).byteValue();
                break;
            }
            case 4: {
                this.acknowledgementTime = ((Number)e.getValue()).intValue();
                break;
            }
            case 5: {
                this.receiveLifetime = ((Number)e.getValue()).intValue();
                break;
            }
            case 6: {
                this.transmitLifetime = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.maximumOctetsACnPdu = reader.readElementContentAsInt("MaximumOctetsACnPdu");
        this.maximumTransmissions = (byte)reader.readElementContentAsInt("MaximumTransmissions");
        this.acknowledgementTime = reader.readElementContentAsInt("AcknowledgementTime");
        this.receiveLifetime = reader.readElementContentAsInt("ReceiveLifetime");
        this.transmitLifetime = reader.readElementContentAsInt("TransmitLifetime");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("MaximumOctetsACnPdu", this.maximumOctetsACnPdu);
        writer.writeElementString("MaximumTransmissions", this.maximumTransmissions);
        writer.writeElementString("AcknowledgementTime", this.acknowledgementTime);
        writer.writeElementString("ReceiveLifetime", this.receiveLifetime);
        writer.writeElementString("TransmitLifetime", this.transmitLifetime);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "MaximumOctetsACnPdu", "MaximumTransmissions", "AcknowledgementTime", "ReceiveLifetime", "TransmitLifetime"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }
}

