/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXBitString;
import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSImageActivateInfo;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.ImageTransferStatus;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSImageTransfer
extends GXDLMSObject
implements IGXDLMSBase {
    private long imageSize;
    private Hashtable<Long, Object> imageData = new Hashtable();
    private long imageBlockSize = 200L;
    private String imageTransferredBlocksStatus;
    private long imageFirstNotTransferredBlockNumber = 0L;
    private boolean imageTransferEnabled = true;
    private ImageTransferStatus imageTransferStatus;
    private GXDLMSImageActivateInfo[] imageActivateInfo = new GXDLMSImageActivateInfo[0];

    public GXDLMSImageTransfer() {
        this("0.0.44.0.0.255", 0);
    }

    public GXDLMSImageTransfer(String ln) {
        this(ln, 0);
    }

    public GXDLMSImageTransfer(String ln, int sn) {
        super(ObjectType.IMAGE_TRANSFER, ln, sn);
        this.imageTransferStatus = ImageTransferStatus.IMAGE_TRANSFER_NOT_INITIATED;
    }

    public final long getImageBlockSize() {
        return this.imageBlockSize;
    }

    public final void setImageBlockSize(long value) {
        this.imageBlockSize = value;
    }

    public final String getImageTransferredBlocksStatus() {
        return this.imageTransferredBlocksStatus;
    }

    public final void setImageTransferredBlocksStatus(String value) {
        this.imageTransferredBlocksStatus = value;
    }

    public final long getImageFirstNotTransferredBlockNumber() {
        return this.imageFirstNotTransferredBlockNumber;
    }

    public final void setImageFirstNotTransferredBlockNumber(long value) {
        this.imageFirstNotTransferredBlockNumber = value;
    }

    public final boolean getImageTransferEnabled() {
        return this.imageTransferEnabled;
    }

    public final void setImageTransferEnabled(boolean value) {
        this.imageTransferEnabled = value;
    }

    public final ImageTransferStatus getImageTransferStatus() {
        return this.imageTransferStatus;
    }

    public final void setImageTransferStatus(ImageTransferStatus value) {
        this.imageTransferStatus = value;
    }

    public final GXDLMSImageActivateInfo[] getImageActivateInfo() {
        return this.imageActivateInfo;
    }

    public final void setImageActivateInfo(GXDLMSImageActivateInfo[] value) {
        this.imageActivateInfo = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.getImageBlockSize(), this.getImageTransferredBlocksStatus(), this.getImageFirstNotTransferredBlockNumber(), this.getImageTransferEnabled(), this.getImageTransferStatus(), this.getImageActivateInfo()};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || !this.isRead(4)) {
            attributes.add(4);
        }
        if (all || !this.isRead(5)) {
            attributes.add(5);
        }
        if (all || !this.isRead(6)) {
            attributes.add(6);
        }
        if (all || !this.isRead(7)) {
            attributes.add(7);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 7;
    }

    @Override
    public final int getMethodCount() {
        return 4;
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.imageFirstNotTransferredBlockNumber = 0L;
            this.imageTransferredBlocksStatus = "";
            List value = (List)e.getParameters();
            byte[] imageIdentifier = (byte[])value.get(0);
            this.imageSize = ((Number)value.get(1)).longValue();
            this.imageTransferStatus = ImageTransferStatus.IMAGE_TRANSFER_INITIATED;
            ArrayList<GXDLMSImageActivateInfo> list = new ArrayList<GXDLMSImageActivateInfo>();
            list.addAll(Arrays.asList(this.imageActivateInfo));
            GXDLMSImageActivateInfo item = null;
            for (GXDLMSImageActivateInfo it : this.imageActivateInfo) {
                if (!it.getIdentification().equals(imageIdentifier)) continue;
                item = it;
                break;
            }
            if (item == null) {
                item = new GXDLMSImageActivateInfo();
                list.add(item);
            }
            item.setSize(this.imageSize);
            item.setIdentification(imageIdentifier);
            this.imageActivateInfo = list.toArray(new GXDLMSImageActivateInfo[list.size()]);
            int cnt = (int)(this.imageSize / this.imageBlockSize);
            if (this.imageSize % this.imageBlockSize != 0L) {
                ++cnt;
            }
            StringBuilder sb = new StringBuilder(cnt);
            for (long pos = 0L; pos < (long)cnt; ++pos) {
                sb.append('0');
            }
            this.imageTransferredBlocksStatus = sb.toString();
            return null;
        }
        if (e.getIndex() == 2) {
            List value = (List)e.getParameters();
            long imageIndex = ((Number)value.get(0)).longValue();
            byte[] tmp = this.imageTransferredBlocksStatus.getBytes();
            tmp[(int)imageIndex] = 49;
            this.imageTransferredBlocksStatus = new String(tmp);
            this.imageFirstNotTransferredBlockNumber = imageIndex + 1L;
            this.imageData.put(imageIndex, (byte[])value.get(1));
            this.imageTransferStatus = ImageTransferStatus.IMAGE_TRANSFER_INITIATED;
            return null;
        }
        if (e.getIndex() == 3) {
            return null;
        }
        if (e.getIndex() == 4) {
            return null;
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return DataType.UINT32;
        }
        if (index == 3) {
            return DataType.BITSTRING;
        }
        if (index == 4) {
            return DataType.UINT32;
        }
        if (index == 5) {
            return DataType.BOOLEAN;
        }
        if (index == 6) {
            return DataType.ENUM;
        }
        if (index == 7) {
            return DataType.ARRAY;
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    private Object getImageActivateInfo(GXDLMSSettings settings) {
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8((byte)DataType.ARRAY.getValue());
        if (this.imageTransferStatus != ImageTransferStatus.IMAGE_VERIFICATION_SUCCESSFUL || this.imageActivateInfo == null) {
            data.setUInt8(0);
        } else {
            data.setUInt8((byte)this.imageActivateInfo.length);
            for (GXDLMSImageActivateInfo it : this.imageActivateInfo) {
                data.setUInt8((byte)DataType.STRUCTURE.getValue());
                data.setUInt8(3);
                GXCommon.setData(settings, data, DataType.UINT32, it.getSize());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getIdentification());
                GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getSignature());
            }
        }
        return data.array();
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return this.getImageBlockSize();
        }
        if (e.getIndex() == 3) {
            return this.imageTransferredBlocksStatus;
        }
        if (e.getIndex() == 4) {
            return this.getImageFirstNotTransferredBlockNumber();
        }
        if (e.getIndex() == 5) {
            return this.getImageTransferEnabled();
        }
        if (e.getIndex() == 6) {
            return this.getImageTransferStatus().ordinal();
        }
        if (e.getIndex() == 7) {
            return this.getImageActivateInfo(settings);
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (e.getValue() == null) {
                this.setImageBlockSize(0L);
            } else {
                this.setImageBlockSize(((Number)e.getValue()).intValue());
            }
        } else if (e.getIndex() == 3) {
            this.imageTransferredBlocksStatus = e.getValue() instanceof GXBitString ? ((GXBitString)e.getValue()).toString() : String.valueOf(e.getValue());
        } else if (e.getIndex() == 4) {
            if (e.getValue() == null) {
                this.setImageFirstNotTransferredBlockNumber(0L);
            } else {
                this.setImageFirstNotTransferredBlockNumber(((Number)e.getValue()).intValue());
            }
        } else if (e.getIndex() == 5) {
            if (e.getValue() == null) {
                this.setImageTransferEnabled(false);
            } else {
                this.setImageTransferEnabled((Boolean)e.getValue());
            }
        } else if (e.getIndex() == 6) {
            if (e.getValue() == null) {
                this.setImageTransferStatus(ImageTransferStatus.IMAGE_TRANSFER_NOT_INITIATED);
            } else {
                this.setImageTransferStatus(ImageTransferStatus.values()[((Number)e.getValue()).intValue()]);
            }
        } else if (e.getIndex() == 7) {
            this.imageActivateInfo = new GXDLMSImageActivateInfo[0];
            if (e.getValue() != null) {
                ArrayList<GXDLMSImageActivateInfo> list = new ArrayList<GXDLMSImageActivateInfo>();
                for (Object it : (List)e.getValue()) {
                    GXDLMSImageActivateInfo item = new GXDLMSImageActivateInfo();
                    item.setSize(((Number)((List)it).get(0)).longValue());
                    item.setIdentification((byte[])((List)it).get(1));
                    item.setSignature((byte[])((List)it).get(2));
                    list.add(item);
                }
                this.imageActivateInfo = list.toArray(new GXDLMSImageActivateInfo[list.size()]);
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    public final byte[][] imageTransferInitiate(GXDLMSClient client, String imageIdentifier, long forImageSize) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.imageTransferInitiate(client, GXCommon.getBytes(imageIdentifier), forImageSize);
    }

    public final byte[][] imageTransferInitiate(GXDLMSClient client, byte[] imageIdentifier, long forImageSize) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (this.imageBlockSize == 0L) {
            throw new IllegalArgumentException("Invalid image block size.");
        }
        if (this.imageBlockSize > (long)client.getMaxReceivePDUSize()) {
            throw new IllegalArgumentException("Image block size is bigger than max PDU size.");
        }
        GXByteBuffer data = new GXByteBuffer();
        data.setUInt8(DataType.STRUCTURE.getValue());
        data.setUInt8(2);
        GXCommon.setData(null, data, DataType.OCTET_STRING, imageIdentifier);
        GXCommon.setData(null, data, DataType.UINT32, forImageSize);
        return client.method(this, 1, data.array(), DataType.ARRAY);
    }

    public List<byte[]> getImageBlocks(byte[] image) {
        int cnt = (int)((long)image.length / this.imageBlockSize);
        if ((long)image.length % this.imageBlockSize != 0L) {
            ++cnt;
        }
        ArrayList<byte[]> packets = new ArrayList<byte[]>();
        for (int pos = 0; pos != cnt; ++pos) {
            byte[] tmp;
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(null, data, DataType.UINT32, pos);
            int bytes = (int)((long)image.length - (long)(pos + 1) * this.imageBlockSize);
            if (bytes < 0) {
                bytes = (int)((long)image.length - (long)pos * this.imageBlockSize);
                tmp = new byte[bytes];
                System.arraycopy(image, (int)((long)pos * this.imageBlockSize), tmp, 0, bytes);
            } else {
                tmp = new byte[(int)this.imageBlockSize];
                System.arraycopy(image, (int)((long)pos * this.imageBlockSize), tmp, 0, (int)this.imageBlockSize);
            }
            GXCommon.setData(null, data, DataType.OCTET_STRING, tmp);
            packets.add(data.array());
        }
        return packets;
    }

    public final byte[][] imageBlockTransfer(GXDLMSClient client, byte[] image, int[] imageBlockCount) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return this.imageBlockTransfer(client, image, 0, imageBlockCount);
    }

    public final byte[][] imageBlockTransfer(GXDLMSClient client, byte[] image, int index, int[] imageBlockCount) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        if (index < 0) {
            throw new IllegalArgumentException("Index is zero based value.");
        }
        List<byte[]> blocks = this.getImageBlocks(image);
        if (imageBlockCount != null) {
            imageBlockCount[0] = blocks.size();
        }
        if (index >= blocks.size()) {
            throw new IllegalArgumentException("Image start index is higher than image block count");
        }
        ArrayList packets = new ArrayList();
        int i = index;
        for (byte[] it : blocks) {
            if (i == 0) {
                packets.addAll(Arrays.asList(client.method(this, 2, it, DataType.ARRAY)));
                continue;
            }
            --i;
        }
        return (byte[][])packets.toArray((T[])new byte[packets.size()][]);
    }

    public byte[][] imageBlockTransfer(GXDLMSClient client, byte[] image, String blocksStatus, int[] imageBlockCount) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        ArrayList packets = new ArrayList();
        List<byte[]> blocks = this.getImageBlocks(image);
        if (imageBlockCount != null) {
            imageBlockCount[0] = blocks.size();
        }
        if (blocksStatus == null || blocksStatus.length() < blocks.size()) {
            throw new IllegalArgumentException("Image start index is higher than image block count");
        }
        int index = 0;
        byte[] status = blocksStatus.getBytes();
        for (byte[] it : blocks) {
            if (blocksStatus == null || blocksStatus.length() < index || status[index] != 49) {
                packets.addAll(Arrays.asList(client.method(this, 2, it, DataType.ARRAY)));
                continue;
            }
            ++index;
        }
        return (byte[][])packets.toArray((T[])new byte[packets.size()][]);
    }

    public final byte[][] imageVerify(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 3, 0, DataType.INT8);
    }

    public final byte[][] imageActivate(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this, 4, 0, DataType.INT8);
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        this.imageBlockSize = reader.readElementContentAsInt("ImageBlockSize");
        this.imageTransferredBlocksStatus = reader.readElementContentAsString("ImageTransferredBlocksStatus");
        this.imageFirstNotTransferredBlockNumber = reader.readElementContentAsLong("ImageFirstNotTransferredBlockNumber");
        this.imageTransferEnabled = reader.readElementContentAsInt("ImageTransferEnabled") != 0;
        this.imageTransferStatus = ImageTransferStatus.values()[reader.readElementContentAsInt("ImageTransferStatus")];
        ArrayList<GXDLMSImageActivateInfo> list = new ArrayList<GXDLMSImageActivateInfo>();
        if (reader.isStartElement("ImageActivateInfo", true)) {
            while (reader.isStartElement("Item", true)) {
                GXDLMSImageActivateInfo it = new GXDLMSImageActivateInfo();
                it.setSize(reader.readElementContentAsULong("Size"));
                it.setIdentification(GXCommon.hexToBytes(reader.readElementContentAsString("Identification")));
                it.setSignature(GXCommon.hexToBytes(reader.readElementContentAsString("Signature")));
                list.add(it);
            }
            reader.readEndElement("ImageActivateInfo");
        }
        this.imageActivateInfo = list.toArray(new GXDLMSImageActivateInfo[list.size()]);
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("ImageBlockSize", this.imageBlockSize);
        writer.writeElementString("ImageTransferredBlocksStatus", this.imageTransferredBlocksStatus);
        writer.writeElementString("ImageFirstNotTransferredBlockNumber", this.imageFirstNotTransferredBlockNumber);
        writer.writeElementString("ImageTransferEnabled", this.imageTransferEnabled);
        writer.writeElementString("ImageTransferStatus", this.imageTransferStatus.ordinal());
        if (this.imageActivateInfo != null) {
            writer.writeStartElement("ImageActivateInfo");
            for (GXDLMSImageActivateInfo it : this.imageActivateInfo) {
                writer.writeStartElement("Item");
                writer.writeElementString("Size", it.getSize());
                writer.writeElementString("Identification", GXCommon.toHex(it.getIdentification(), false));
                writer.writeElementString("Signature", GXCommon.toHex(it.getSignature(), false));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Image Block Size", "Image Transferred Blocks Status", "Image FirstNot Transferred Block Number", "Image Transfer Enabled", "Image Transfer Status", "Image Activate Info"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Image transfer initiate", "Image block transfer", "Image verify", "Image activate"};
    }
}

