/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXStructure;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXNeighborDiscoverySetup;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import gurux.dlms.objects.enums.AddressConfigMode;
import gurux.dlms.objects.enums.IPv6AddressType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSIp6Setup
extends GXDLMSObject
implements IGXDLMSBase {
    private String dataLinkLayerReference;
    private AddressConfigMode addressConfigMode = AddressConfigMode.AUTO;
    private InetAddress[] unicastIPAddress;
    private InetAddress[] multicastIPAddress;
    private InetAddress[] gatewayIPAddress;
    private InetAddress primaryDNSAddress;
    private InetAddress secondaryDNSAddress;
    private byte trafficClass;
    private GXNeighborDiscoverySetup[] neighborDiscoverySetup;

    public GXDLMSIp6Setup() {
        this("0.0.25.7.0.255");
    }

    public GXDLMSIp6Setup(String ln) {
        this(ln, 0);
    }

    public GXDLMSIp6Setup(String ln, int sn) {
        super(ObjectType.IP6_SETUP, ln, sn);
    }

    public final String getDataLinkLayerReference() {
        return this.dataLinkLayerReference;
    }

    public final void setDataLinkLayerReference(String value) {
        this.dataLinkLayerReference = value;
    }

    public final AddressConfigMode getAddressConfigMode() {
        return this.addressConfigMode;
    }

    public final void setAddressConfigMode(AddressConfigMode value) {
        this.addressConfigMode = value;
    }

    public final InetAddress[] getUnicastIPAddress() {
        return this.unicastIPAddress;
    }

    public final void setUnicastIPAddress(InetAddress[] value) {
        this.unicastIPAddress = value;
    }

    public final InetAddress[] getMulticastIPAddress() {
        return this.multicastIPAddress;
    }

    public final void setMulticastIPAddress(InetAddress[] value) {
        this.multicastIPAddress = value;
    }

    public final InetAddress[] getGatewayIPAddress() {
        return this.gatewayIPAddress;
    }

    public final void setGatewayIPAddress(InetAddress[] value) {
        this.gatewayIPAddress = value;
    }

    public final InetAddress getPrimaryDNSAddress() {
        return this.primaryDNSAddress;
    }

    public final void setPrimaryDNSAddress(InetAddress value) {
        this.primaryDNSAddress = value;
    }

    public final InetAddress getSecondaryDNSAddress() {
        return this.secondaryDNSAddress;
    }

    public final void setSecondaryDNSAddress(InetAddress value) {
        this.secondaryDNSAddress = value;
    }

    public final byte getTrafficClass() {
        return this.trafficClass;
    }

    public final void setTrafficClass(byte value) {
        this.trafficClass = value;
    }

    public final GXNeighborDiscoverySetup[] getNeighborDiscoverySetup() {
        return this.neighborDiscoverySetup;
    }

    public final void setNeighborDiscoverySetup(GXNeighborDiscoverySetup[] value) {
        this.neighborDiscoverySetup = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.dataLinkLayerReference, this.addressConfigMode, this.unicastIPAddress, this.multicastIPAddress, this.gatewayIPAddress, this.primaryDNSAddress, this.secondaryDNSAddress, this.trafficClass, this.neighborDiscoverySetup};
    }

    public byte[][] addAddress(GXDLMSClient client, IPv6AddressType type, InetAddress address) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.ordinal());
        bb.setUInt8(2);
        GXCommon.setData(null, bb, DataType.ENUM, type.ordinal());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, address.getAddress());
        return client.method(this, 1, bb.array(), DataType.STRUCTURE);
    }

    public byte[][] removeAddress(GXDLMSClient client, IPv6AddressType type, InetAddress address) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(DataType.STRUCTURE.ordinal());
        bb.setUInt8(2);
        GXCommon.setData(null, bb, DataType.ENUM, type.ordinal());
        GXCommon.setData(null, bb, DataType.OCTET_STRING, address.getAddress());
        return client.method(this, 2, bb.array(), DataType.STRUCTURE);
    }

    private void remove(List<InetAddress> list, InetAddress address) {
        for (InetAddress it : list) {
            if (it.toString().compareTo(address.toString()) != 0) continue;
            list.remove(it);
            return;
        }
        throw new IllegalArgumentException("IP address not found.");
    }

    @Override
    public final byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        InetAddress address;
        GXStructure val = (GXStructure)e.getParameters();
        IPv6AddressType type = IPv6AddressType.values()[((Number)val.get(0)).shortValue()];
        try {
            address = InetAddress.getByAddress((byte[])val.get(1));
        }
        catch (UnknownHostException e1) {
            throw new IllegalArgumentException(e1);
        }
        if (e.getIndex() == 1) {
            switch (type) {
                case UNICAST: {
                    ArrayList<InetAddress> list = new ArrayList<InetAddress>();
                    if (this.unicastIPAddress != null) {
                        list.addAll(Arrays.asList(this.unicastIPAddress));
                    }
                    list.add(address);
                    this.unicastIPAddress = list.toArray(new InetAddress[0]);
                    break;
                }
                case MULTICAST: {
                    ArrayList<InetAddress> list = new ArrayList<InetAddress>();
                    if (this.multicastIPAddress != null) {
                        list.addAll(Arrays.asList(this.multicastIPAddress));
                    }
                    list.add(address);
                    this.multicastIPAddress = list.toArray(new InetAddress[0]);
                    break;
                }
                case GATEWAY: {
                    ArrayList<InetAddress> list = new ArrayList<InetAddress>();
                    if (this.gatewayIPAddress != null) {
                        list.addAll(Arrays.asList(this.gatewayIPAddress));
                    }
                    list.add(address);
                    this.gatewayIPAddress = list.toArray(new InetAddress[0]);
                    break;
                }
                default: {
                    e.setError(ErrorCode.READ_WRITE_DENIED);
                    break;
                }
            }
        } else if (e.getIndex() == 2) {
            switch (type) {
                case UNICAST: {
                    ArrayList<InetAddress> list = new ArrayList<InetAddress>(Arrays.asList(this.multicastIPAddress));
                    this.remove(list, address);
                    this.unicastIPAddress = list.toArray(new InetAddress[0]);
                    break;
                }
                case MULTICAST: {
                    ArrayList<InetAddress> list = new ArrayList<InetAddress>(Arrays.asList(this.multicastIPAddress));
                    this.remove(list, address);
                    this.multicastIPAddress = list.toArray(new InetAddress[0]);
                    break;
                }
                case GATEWAY: {
                    ArrayList<InetAddress> list = new ArrayList<InetAddress>(Arrays.asList(this.gatewayIPAddress));
                    this.remove(list, address);
                    this.gatewayIPAddress = list.toArray(new InetAddress[0]);
                    break;
                }
                default: {
                    e.setError(ErrorCode.READ_WRITE_DENIED);
                    break;
                }
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || !this.isRead(8)) {
            attributes.add(8);
        }
        if (all || this.canRead(9)) {
            attributes.add(9);
        }
        if (all || this.canRead(10)) {
            attributes.add(10);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 10;
    }

    @Override
    public final int getMethodCount() {
        return 2;
    }

    @Override
    public final DataType getDataType(int index) {
        DataType ret;
        switch (index) {
            case 1: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 2: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 3: {
                ret = DataType.ENUM;
                break;
            }
            case 4: {
                ret = DataType.ARRAY;
                break;
            }
            case 5: {
                ret = DataType.ARRAY;
                break;
            }
            case 6: {
                ret = DataType.ARRAY;
                break;
            }
            case 7: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 8: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 9: {
                ret = DataType.UINT8;
                break;
            }
            case 10: {
                ret = DataType.ARRAY;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return ret;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            return GXCommon.logicalNameToBytes(this.dataLinkLayerReference);
        }
        if (e.getIndex() == 3) {
            return this.addressConfigMode.ordinal();
        }
        if (e.getIndex() == 4) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.unicastIPAddress == null) {
                GXCommon.setObjectCount(0, data);
            } else {
                GXCommon.setObjectCount(this.unicastIPAddress.length, data);
                for (InetAddress it : this.unicastIPAddress) {
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getAddress());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 5) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.multicastIPAddress == null) {
                GXCommon.setObjectCount(0, data);
            } else {
                GXCommon.setObjectCount(this.multicastIPAddress.length, data);
                for (InetAddress it : this.multicastIPAddress) {
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getAddress());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 6) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.gatewayIPAddress == null) {
                GXCommon.setObjectCount(0, data);
            } else {
                GXCommon.setObjectCount(this.gatewayIPAddress.length, data);
                for (InetAddress it : this.gatewayIPAddress) {
                    GXCommon.setData(settings, data, DataType.OCTET_STRING, it.getAddress());
                }
            }
            return data.array();
        }
        if (e.getIndex() == 7) {
            if (this.primaryDNSAddress == null) {
                return null;
            }
            return this.primaryDNSAddress.getAddress();
        }
        if (e.getIndex() == 8) {
            if (this.secondaryDNSAddress == null) {
                return null;
            }
            return this.secondaryDNSAddress.getAddress();
        }
        if (e.getIndex() == 9) {
            return this.trafficClass;
        }
        if (e.getIndex() == 10) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.ARRAY.getValue());
            if (this.neighborDiscoverySetup == null) {
                data.setUInt8(0);
            } else {
                GXCommon.setObjectCount(this.neighborDiscoverySetup.length, data);
                for (GXNeighborDiscoverySetup it : this.neighborDiscoverySetup) {
                    data.setUInt8(DataType.STRUCTURE.getValue());
                    data.setUInt8(3);
                    GXCommon.setData(settings, data, DataType.UINT8, it.getMaxRetry());
                    GXCommon.setData(settings, data, DataType.UINT16, it.getRetryWaitTime());
                    GXCommon.setData(settings, data, DataType.UINT32, it.getSendPeriod());
                }
            }
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        try {
            if (e.getIndex() == 1) {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
            } else if (e.getIndex() == 2) {
                this.dataLinkLayerReference = e.getValue() instanceof String ? e.getValue().toString() : GXCommon.toLogicalName(e.getValue());
            } else if (e.getIndex() == 3) {
                this.addressConfigMode = AddressConfigMode.values()[((Number)e.getValue()).intValue()];
            } else if (e.getIndex() == 4) {
                ArrayList<InetAddress> data = new ArrayList<InetAddress>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        data.add(InetAddress.getByAddress((byte[])it));
                    }
                }
                this.unicastIPAddress = data.toArray(new InetAddress[0]);
            } else if (e.getIndex() == 5) {
                ArrayList<InetAddress> data = new ArrayList<InetAddress>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        data.add(InetAddress.getByAddress((byte[])it));
                    }
                }
                this.multicastIPAddress = data.toArray(new InetAddress[0]);
            } else if (e.getIndex() == 6) {
                ArrayList<InetAddress> data = new ArrayList<InetAddress>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        data.add(InetAddress.getByAddress((byte[])it));
                    }
                }
                this.gatewayIPAddress = data.toArray(new InetAddress[0]);
            } else if (e.getIndex() == 7) {
                this.primaryDNSAddress = e.getValue() == null || ((byte[])e.getValue()).length == 0 ? null : InetAddress.getByAddress((byte[])e.getValue());
            } else if (e.getIndex() == 8) {
                this.secondaryDNSAddress = e.getValue() == null || ((byte[])e.getValue()).length == 0 ? null : InetAddress.getByAddress((byte[])e.getValue());
            } else if (e.getIndex() == 9) {
                this.trafficClass = ((Number)e.getValue()).byteValue();
            } else if (e.getIndex() == 10) {
                ArrayList<GXNeighborDiscoverySetup> data = new ArrayList<GXNeighborDiscoverySetup>();
                if (e.getValue() != null) {
                    for (Object it : (List)e.getValue()) {
                        List tmp = (List)it;
                        GXNeighborDiscoverySetup v = new GXNeighborDiscoverySetup();
                        v.setMaxRetry(((Number)tmp.get(0)).byteValue());
                        v.setRetryWaitTime(((Number)tmp.get(1)).shortValue());
                        v.setSendPeriod(((Number)tmp.get(2)).longValue());
                        data.add(v);
                    }
                }
                this.neighborDiscoverySetup = data.toArray(new GXNeighborDiscoverySetup[0]);
            } else {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private InetAddress[] loadIPAddress(GXXmlReader reader, String name) throws UnknownHostException, XMLStreamException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        if (reader.isStartElement(name, true)) {
            while (reader.isStartElement("Value", false)) {
                list.add(InetAddress.getByName(reader.readElementContentAsString("Value")));
            }
            reader.readEndElement(name);
        }
        return list.toArray(new InetAddress[0]);
    }

    private GXNeighborDiscoverySetup[] loadNeighborDiscoverySetup(GXXmlReader reader, String name) throws XMLStreamException {
        ArrayList<GXNeighborDiscoverySetup> list = new ArrayList<GXNeighborDiscoverySetup>();
        if (reader.isStartElement(name, true)) {
            while (reader.isStartElement("Item", true)) {
                GXNeighborDiscoverySetup it = new GXNeighborDiscoverySetup();
                list.add(it);
                it.setMaxRetry(reader.readElementContentAsInt("MaxRetry"));
                it.setRetryWaitTime(reader.readElementContentAsInt("RetryWaitTime"));
                it.setSendPeriod(reader.readElementContentAsInt("SendPeriod"));
            }
            reader.readEndElement(name);
        }
        return list.toArray(new GXNeighborDiscoverySetup[0]);
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        try {
            this.dataLinkLayerReference = reader.readElementContentAsString("DataLinkLayerReference");
            this.addressConfigMode = AddressConfigMode.values()[reader.readElementContentAsInt("AddressConfigMode")];
            this.unicastIPAddress = this.loadIPAddress(reader, "UnicastIPAddress");
            this.multicastIPAddress = this.loadIPAddress(reader, "MulticastIPAddress");
            this.gatewayIPAddress = this.loadIPAddress(reader, "GatewayIPAddress");
            String str = reader.readElementContentAsString("PrimaryDNSAddress");
            this.primaryDNSAddress = str != null ? InetAddress.getByName(str) : null;
            str = reader.readElementContentAsString("SecondaryDNSAddress");
            this.secondaryDNSAddress = str != null ? InetAddress.getByName(str) : null;
            this.trafficClass = (byte)reader.readElementContentAsInt("TrafficClass");
            this.neighborDiscoverySetup = this.loadNeighborDiscoverySetup(reader, "NeighborDiscoverySetup");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private void saveIPAddress(GXXmlWriter writer, InetAddress[] list, String name) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement(name);
            for (InetAddress it : list) {
                writer.writeElementString("Value", it.getHostAddress());
            }
            writer.writeEndElement();
        }
    }

    private void saveNeighborDiscoverySetup(GXXmlWriter writer, GXNeighborDiscoverySetup[] list, String name) throws XMLStreamException {
        if (list != null) {
            writer.writeStartElement(name);
            for (GXNeighborDiscoverySetup it : list) {
                writer.writeStartElement("Item");
                writer.writeElementString("MaxRetry", it.getMaxRetry());
                writer.writeElementString("RetryWaitTime", it.getRetryWaitTime());
                writer.writeElementString("SendPeriod", it.getSendPeriod());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("DataLinkLayerReference", this.dataLinkLayerReference);
        writer.writeElementString("AddressConfigMode", this.addressConfigMode.ordinal());
        this.saveIPAddress(writer, this.unicastIPAddress, "UnicastIPAddress");
        this.saveIPAddress(writer, this.multicastIPAddress, "MulticastIPAddress");
        this.saveIPAddress(writer, this.gatewayIPAddress, "GatewayIPAddress");
        if (this.primaryDNSAddress != null) {
            writer.writeElementString("PrimaryDNSAddress", this.primaryDNSAddress.getHostAddress());
        }
        if (this.secondaryDNSAddress != null) {
            writer.writeElementString("SecondaryDNSAddress", this.secondaryDNSAddress.getHostAddress());
        }
        writer.writeElementString("TrafficClass", this.trafficClass);
        this.saveNeighborDiscoverySetup(writer, this.neighborDiscoverySetup, "NeighborDiscoverySetup");
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Data LinkLayer Reference", "Address Config Mode", "Unicast IP Address", "Multicast IP Address", "Gateway IP Address", "Primary DNS Address", "Secondary DNS Address", "Traffic Class", "Neighbor Discovery Setup"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Add IP v6 address", "Remove IP v6 address"};
    }
}

