/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Unit;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSExtendedRegister;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;

public class GXDLMSRegister
extends GXDLMSObject
implements IGXDLMSBase {
    private int scaler;
    private int unit;
    private Object objectValue;

    public GXDLMSRegister() {
        super(ObjectType.REGISTER);
        this.setScaler(1.0);
        this.setUnit(Unit.NONE);
    }

    public GXDLMSRegister(ObjectType type, String ln, int sn) {
        super(type, ln, sn);
        this.setScaler(1.0);
        this.setUnit(Unit.NONE);
    }

    public GXDLMSRegister(String ln) {
        this(ObjectType.REGISTER, ln, 0);
    }

    public GXDLMSRegister(String ln, int sn) {
        this(ObjectType.REGISTER, ln, sn);
    }

    public final double getScaler() {
        return Math.pow(10.0, this.scaler);
    }

    public final void setScaler(double value) {
        this.scaler = (int)Math.log10(value);
    }

    public final Unit getUnit() {
        return Unit.forValue(this.unit);
    }

    public final void setUnit(Unit value) {
        this.unit = value.getValue();
    }

    public final Object getValue() {
        return this.objectValue;
    }

    public final void setValue(Object value) {
        this.objectValue = value;
    }

    public final byte[][] reset(GXDLMSClient client) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, SignatureException {
        return client.method(this.getName(), this.getObjectType(), 1, 0, DataType.INT8);
    }

    @Override
    public Object[] getValues() {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String str = "Scaler: " + formatter.format(this.getScaler());
        str = str + " Unit: ";
        str = str + this.getUnit().toString();
        return new Object[]{this.getLogicalName(), this.getValue(), str};
    }

    @Override
    public byte[] invoke(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setValue(null);
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
        return null;
    }

    @Override
    public final boolean isRead(int index) {
        if (index == 3) {
            return this.unit != 0;
        }
        return super.isRead(index);
    }

    @Override
    public int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || !this.isRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public int getAttributeCount() {
        return 3;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public DataType getDataType(int index) {
        if (index == 1) {
            return DataType.OCTET_STRING;
        }
        if (index == 2) {
            return super.getDataType(index);
        }
        if (index == 3) {
            return DataType.STRUCTURE;
        }
        if (index == 4 && this instanceof GXDLMSExtendedRegister) {
            return super.getDataType(index);
        }
        throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
    }

    @Override
    public Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            return GXCommon.logicalNameToBytes(this.getLogicalName());
        }
        if (e.getIndex() == 2) {
            if (settings != null && !settings.isServer() && this.getScaler() != 1.0 && this.objectValue != null) {
                DataType type = GXDLMSConverter.getDLMSDataType(this.objectValue);
                Object tmp = ((Number)this.objectValue).doubleValue() / this.getScaler();
                if (type != DataType.NONE) {
                    tmp = GXDLMSConverter.changeType(tmp, type);
                }
                return tmp;
            }
            return this.objectValue;
        }
        if (e.getIndex() == 3) {
            GXByteBuffer data = new GXByteBuffer();
            data.setUInt8(DataType.STRUCTURE.getValue());
            data.setUInt8(2);
            GXCommon.setData(settings, data, DataType.INT8, this.scaler);
            GXCommon.setData(settings, data, DataType.ENUM, this.unit);
            return data.array();
        }
        e.setError(ErrorCode.READ_WRITE_DENIED);
        return null;
    }

    @Override
    public void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        if (e.getIndex() == 1) {
            this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
        } else if (e.getIndex() == 2) {
            if (settings != null && !settings.isServer() && this.getScaler() != 1.0 && e.getValue() != null) {
                try {
                    this.objectValue = ((Number)e.getValue()).doubleValue() * this.getScaler();
                }
                catch (Exception e1) {
                    this.setValue(e.getValue());
                }
            } else {
                this.setValue(e.getValue());
            }
        } else if (e.getIndex() == 3) {
            if (e.getValue() == null) {
                this.scaler = 0;
                this.unit = 0;
            } else {
                List arr = (List)e.getValue();
                if (arr == null || arr.size() != 2) {
                    this.scaler = 0;
                    this.unit = 0;
                } else {
                    this.scaler = ((Number)arr.get(0)).intValue();
                    this.unit = ((Number)arr.get(1)).intValue() & 0xFF;
                }
            }
        } else {
            e.setError(ErrorCode.READ_WRITE_DENIED);
        }
    }

    @Override
    public void load(GXXmlReader reader) throws XMLStreamException {
        this.unit = reader.readElementContentAsInt("Unit", 0);
        this.setScaler(reader.readElementContentAsDouble("Scaler", 1.0));
        this.setValue(reader.readElementContentAsObject("Value", null, this, 2));
    }

    @Override
    public void save(GXXmlWriter writer) throws XMLStreamException {
        writer.writeElementString("Unit", this.unit);
        writer.writeElementString("Scaler", this.getScaler(), 1.0);
        writer.writeElementObject("Value", this.getValue(), this.getDataType(2), this.getUIDataType(2));
    }

    @Override
    public void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "Value", "Scaler and Unit"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

