/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.ValueEventArgs;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ErrorCode;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXDLMSObject;
import gurux.dlms.objects.GXDLMSObjectHelpers;
import gurux.dlms.objects.GXXmlReader;
import gurux.dlms.objects.GXXmlWriter;
import gurux.dlms.objects.IGXDLMSBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class GXDLMSSFSKMacCounters
extends GXDLMSObject
implements IGXDLMSBase {
    private ArrayList<Map.Entry<Integer, Long>> synchronizationRegister = new ArrayList();
    private long physicalLayerDesynchronization;
    private long timeOutNotAddressedDesynchronization;
    private long timeOutFrameNotOkDesynchronization;
    private long writeRequestDesynchronization;
    private long wrongInitiatorDesynchronization;
    private ArrayList<Map.Entry<Integer, Long>> broadcastFramesCounter = new ArrayList();
    private long repetitionsCounter;
    private long transmissionsCounter;
    private long crcOkFramesCounter;
    private long crcNOkFramesCounter;

    public GXDLMSSFSKMacCounters() {
        this("0.0.26.3.0.255", 0);
    }

    public GXDLMSSFSKMacCounters(String ln) {
        this(ln, 0);
    }

    public GXDLMSSFSKMacCounters(String ln, int sn) {
        super(ObjectType.SFSK_MAC_COUNTERS, ln, sn);
    }

    public final ArrayList<Map.Entry<Integer, Long>> getSynchronizationRegister() {
        return this.synchronizationRegister;
    }

    public final void setSynchronizationRegister(ArrayList<Map.Entry<Integer, Long>> value) {
        this.synchronizationRegister = value;
    }

    public final long getPhysicalLayerDesynchronization() {
        return this.physicalLayerDesynchronization;
    }

    public final void setPhysicalLayerDesynchronization(long value) {
        this.physicalLayerDesynchronization = value;
    }

    public final long getTimeOutNotAddressedDesynchronization() {
        return this.timeOutNotAddressedDesynchronization;
    }

    public final void setTimeOutNotAddressedDesynchronization(long value) {
        this.timeOutNotAddressedDesynchronization = value;
    }

    public final long getTimeOutFrameNotOkDesynchronization() {
        return this.timeOutFrameNotOkDesynchronization;
    }

    public final void setTimeOutFrameNotOkDesynchronization(long value) {
        this.timeOutFrameNotOkDesynchronization = value;
    }

    public final long getWriteRequestDesynchronization() {
        return this.writeRequestDesynchronization;
    }

    public final void setWriteRequestDesynchronization(long value) {
        this.writeRequestDesynchronization = value;
    }

    public final long getWrongInitiatorDesynchronization() {
        return this.wrongInitiatorDesynchronization;
    }

    public final void setWrongInitiatorDesynchronization(long value) {
        this.wrongInitiatorDesynchronization = value;
    }

    public final ArrayList<Map.Entry<Integer, Long>> getBroadcastFramesCounter() {
        return this.broadcastFramesCounter;
    }

    public final void setBroadcastFramesCounter(ArrayList<Map.Entry<Integer, Long>> value) {
        this.broadcastFramesCounter = value;
    }

    public final long getRepetitionsCounter() {
        return this.repetitionsCounter;
    }

    public final void setRepetitionsCounter(long value) {
        this.repetitionsCounter = value;
    }

    public final long getTransmissionsCounter() {
        return this.transmissionsCounter;
    }

    public final void setTransmissionsCounter(long value) {
        this.transmissionsCounter = value;
    }

    public final long getCrcOkFramesCounter() {
        return this.crcOkFramesCounter;
    }

    public final void setCrcOkFramesCounter(long value) {
        this.crcOkFramesCounter = value;
    }

    public final long getCrcNOkFramesCounter() {
        return this.crcNOkFramesCounter;
    }

    public final void setCrcNOkFramesCounter(long value) {
        this.crcNOkFramesCounter = value;
    }

    @Override
    public final Object[] getValues() {
        return new Object[]{this.getLogicalName(), this.synchronizationRegister, new Object[]{this.physicalLayerDesynchronization, this.timeOutNotAddressedDesynchronization, this.timeOutFrameNotOkDesynchronization, this.writeRequestDesynchronization, this.wrongInitiatorDesynchronization}, this.broadcastFramesCounter, this.repetitionsCounter, this.transmissionsCounter, this.crcOkFramesCounter, this.crcNOkFramesCounter};
    }

    @Override
    public final int[] getAttributeIndexToRead(boolean all) {
        ArrayList<Integer> attributes = new ArrayList<Integer>();
        if (all || this.getLogicalName() == null || this.getLogicalName().compareTo("") == 0) {
            attributes.add(1);
        }
        if (all || this.canRead(2)) {
            attributes.add(2);
        }
        if (all || this.canRead(3)) {
            attributes.add(3);
        }
        if (all || this.canRead(4)) {
            attributes.add(4);
        }
        if (all || this.canRead(5)) {
            attributes.add(5);
        }
        if (all || this.canRead(6)) {
            attributes.add(6);
        }
        if (all || this.canRead(7)) {
            attributes.add(7);
        }
        if (all || this.canRead(8)) {
            attributes.add(8);
        }
        return GXDLMSObjectHelpers.toIntArray(attributes);
    }

    @Override
    public final int getAttributeCount() {
        return 8;
    }

    @Override
    public final int getMethodCount() {
        return 1;
    }

    @Override
    public final DataType getDataType(int index) {
        DataType ret;
        switch (index) {
            case 1: {
                ret = DataType.OCTET_STRING;
                break;
            }
            case 2: 
            case 4: {
                ret = DataType.ARRAY;
                break;
            }
            case 3: {
                ret = DataType.STRUCTURE;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ret = DataType.UINT32;
                break;
            }
            default: {
                throw new IllegalArgumentException("getDataType failed. Invalid attribute index.");
            }
        }
        return ret;
    }

    @Override
    public final Object getValue(GXDLMSSettings settings, ValueEventArgs e) {
        Object ret;
        switch (e.getIndex()) {
            case 1: {
                ret = GXCommon.logicalNameToBytes(this.getLogicalName());
                break;
            }
            case 2: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY);
                if (this.synchronizationRegister == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.synchronizationRegister.size(), bb);
                    for (Map.Entry<Integer, Long> it : this.synchronizationRegister) {
                        bb.setUInt8(DataType.STRUCTURE);
                        bb.setUInt8(2);
                        GXCommon.setData(settings, bb, DataType.UINT16, it.getKey());
                        GXCommon.setData(settings, bb, DataType.UINT32, it.getValue());
                    }
                }
                ret = bb.array();
                break;
            }
            case 3: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.STRUCTURE);
                bb.setUInt8(5);
                GXCommon.setData(settings, bb, DataType.UINT32, this.physicalLayerDesynchronization);
                GXCommon.setData(settings, bb, DataType.UINT32, this.timeOutNotAddressedDesynchronization);
                GXCommon.setData(settings, bb, DataType.UINT32, this.timeOutFrameNotOkDesynchronization);
                GXCommon.setData(settings, bb, DataType.UINT32, this.writeRequestDesynchronization);
                GXCommon.setData(settings, bb, DataType.UINT32, this.wrongInitiatorDesynchronization);
                ret = bb.array();
                break;
            }
            case 4: {
                GXByteBuffer bb = new GXByteBuffer();
                bb.setUInt8(DataType.ARRAY);
                if (this.broadcastFramesCounter == null) {
                    bb.setUInt8(0);
                } else {
                    GXCommon.setObjectCount(this.broadcastFramesCounter.size(), bb);
                    for (Map.Entry<Integer, Long> it : this.broadcastFramesCounter) {
                        bb.setUInt8(DataType.STRUCTURE);
                        bb.setUInt8(2);
                        GXCommon.setData(settings, bb, DataType.UINT16, it.getKey());
                        GXCommon.setData(settings, bb, DataType.UINT32, it.getValue());
                    }
                }
                ret = bb.array();
                break;
            }
            case 5: {
                ret = this.repetitionsCounter;
                break;
            }
            case 6: {
                ret = this.transmissionsCounter;
                break;
            }
            case 7: {
                ret = this.crcOkFramesCounter;
                break;
            }
            case 8: {
                ret = this.crcNOkFramesCounter;
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public final void setValue(GXDLMSSettings settings, ValueEventArgs e) {
        switch (e.getIndex()) {
            case 1: {
                this.setLogicalName(GXCommon.toLogicalName(e.getValue()));
                break;
            }
            case 2: {
                this.synchronizationRegister.clear();
                if (e.getValue() == null) break;
                for (Object tmp : (List)e.getValue()) {
                    List it = (List)tmp;
                    this.synchronizationRegister.add(new GXSimpleEntry<Integer, Long>(((Number)it.get(0)).intValue(), ((Number)it.get(1)).longValue()));
                }
                break;
            }
            case 3: {
                if (e.getValue() != null) {
                    List arr = (List)e.getValue();
                    this.physicalLayerDesynchronization = ((Number)arr.get(0)).intValue();
                    this.timeOutNotAddressedDesynchronization = ((Number)arr.get(1)).intValue();
                    this.timeOutFrameNotOkDesynchronization = ((Number)arr.get(2)).intValue();
                    this.writeRequestDesynchronization = ((Number)arr.get(3)).intValue();
                    this.wrongInitiatorDesynchronization = ((Number)arr.get(4)).intValue();
                    break;
                }
                this.physicalLayerDesynchronization = 0L;
                this.timeOutNotAddressedDesynchronization = 0L;
                this.timeOutFrameNotOkDesynchronization = 0L;
                this.writeRequestDesynchronization = 0L;
                this.wrongInitiatorDesynchronization = 0L;
                break;
            }
            case 4: {
                this.broadcastFramesCounter.clear();
                if (e.getValue() == null) break;
                for (Object tmp : (List)e.getValue()) {
                    List it = (List)tmp;
                    this.broadcastFramesCounter.add(new GXSimpleEntry<Integer, Long>(((Number)it.get(0)).intValue(), ((Number)it.get(1)).longValue()));
                }
                break;
            }
            case 5: {
                this.repetitionsCounter = ((Number)e.getValue()).intValue();
                break;
            }
            case 6: {
                this.transmissionsCounter = ((Number)e.getValue()).intValue();
                break;
            }
            case 7: {
                this.crcOkFramesCounter = ((Number)e.getValue()).intValue();
                break;
            }
            case 8: {
                this.crcNOkFramesCounter = ((Number)e.getValue()).intValue();
                break;
            }
            default: {
                e.setError(ErrorCode.READ_WRITE_DENIED);
            }
        }
    }

    @Override
    public final void load(GXXmlReader reader) throws XMLStreamException {
        Long v;
        Integer k;
        this.synchronizationRegister.clear();
        if (reader.isStartElement("SynchronizationRegisters", true)) {
            while (reader.isStartElement("Item", true)) {
                k = reader.readElementContentAsInt("Key");
                v = reader.readElementContentAsLong("Value");
                this.synchronizationRegister.add(new GXSimpleEntry<Integer, Long>(k, v));
            }
            reader.readEndElement("SynchronizationRegisters");
        }
        this.physicalLayerDesynchronization = reader.readElementContentAsInt("PhysicalLayerDesynchronization");
        this.timeOutNotAddressedDesynchronization = reader.readElementContentAsInt("TimeOutNotAddressedDesynchronization");
        this.timeOutFrameNotOkDesynchronization = reader.readElementContentAsInt("TimeOutFrameNotOkDesynchronization");
        this.writeRequestDesynchronization = reader.readElementContentAsInt("WriteRequestDesynchronization");
        this.wrongInitiatorDesynchronization = reader.readElementContentAsInt("WrongInitiatorDesynchronization");
        this.broadcastFramesCounter.clear();
        if (reader.isStartElement("BroadcastFramesCounters", true)) {
            while (reader.isStartElement("Item", true)) {
                k = reader.readElementContentAsInt("Key");
                v = reader.readElementContentAsLong("Value");
                this.broadcastFramesCounter.add(new GXSimpleEntry<Integer, Long>(k, v));
            }
            reader.readEndElement("BroadcastFramesCounters");
        }
        this.repetitionsCounter = reader.readElementContentAsInt("RepetitionsCounter");
        this.transmissionsCounter = reader.readElementContentAsInt("TransmissionsCounter");
        this.crcOkFramesCounter = reader.readElementContentAsInt("CrcOkFramesCounter");
        this.crcNOkFramesCounter = reader.readElementContentAsInt("CrcNOkFramesCounter");
    }

    @Override
    public final void save(GXXmlWriter writer) throws XMLStreamException {
        if (this.synchronizationRegister != null) {
            writer.writeStartElement("SynchronizationRegisters");
            for (Map.Entry<Integer, Long> it : this.synchronizationRegister) {
                writer.writeStartElement("Item");
                writer.writeElementString("Key", it.getKey());
                writer.writeElementString("Value", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("PhysicalLayerDesynchronization", this.physicalLayerDesynchronization);
        writer.writeElementString("TimeOutNotAddressedDesynchronization", this.timeOutNotAddressedDesynchronization);
        writer.writeElementString("TimeOutFrameNotOkDesynchronization", this.timeOutFrameNotOkDesynchronization);
        writer.writeElementString("WriteRequestDesynchronization", this.writeRequestDesynchronization);
        writer.writeElementString("WrongInitiatorDesynchronization", this.wrongInitiatorDesynchronization);
        if (this.broadcastFramesCounter != null) {
            writer.writeStartElement("BroadcastFramesCounters");
            for (Map.Entry<Integer, Long> it : this.broadcastFramesCounter) {
                writer.writeStartElement("Item");
                writer.writeElementString("Key", it.getKey());
                writer.writeElementString("Value", it.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeElementString("RepetitionsCounter", this.repetitionsCounter);
        writer.writeElementString("TransmissionsCounter", this.transmissionsCounter);
        writer.writeElementString("CrcOkFramesCounter", this.crcOkFramesCounter);
        writer.writeElementString("CrcNOkFramesCounter", this.crcNOkFramesCounter);
    }

    @Override
    public final void postLoad(GXXmlReader reader) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"Logical Name", "SynchronizationRegister", "Desynchronization listing", "BroadcastFramesCounter", "RepetitionsCounter", "TransmissionsCounter", "CrcOkFramesCounter", "CrcNOkFramesCounter"};
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"Reset"};
    }
}

