/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects;

import gurux.dlms.GXArray;
import gurux.dlms.GXDLMSConverter;
import gurux.dlms.GXDateOS;
import gurux.dlms.GXDateTime;
import gurux.dlms.GXDateTimeOS;
import gurux.dlms.GXSimpleEntry;
import gurux.dlms.GXStructure;
import gurux.dlms.GXTimeOS;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.objects.GXIgnoreSerialize;
import gurux.dlms.objects.GXXmlWriterSettings;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GXXmlWriter
implements AutoCloseable {
    private XMLStreamWriter writer = null;
    private String newline = System.getProperty("line.separator");
    private int indenting = 0;
    char[] spaces = null;
    private GXXmlWriterSettings settings;

    public boolean isSkipDefaults() {
        if (this.settings == null) {
            return false;
        }
        return this.settings.isIgnoreDefaultValues();
    }

    public boolean isUseMeterTime() {
        if (this.settings == null) {
            return false;
        }
        return this.settings.isUseMeterTime();
    }

    @Override
    public final void close() throws XMLStreamException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public GXXmlWriter(String filename, GXXmlWriterSettings wSettings) throws FileNotFoundException, XMLStreamException {
        this.settings = wSettings;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(new FileOutputStream(filename));
    }

    public GXXmlWriter(OutputStream s, GXXmlWriterSettings wSettings) throws XMLStreamException {
        this.settings = wSettings;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        this.writer = outputFactory.createXMLStreamWriter(s);
    }

    private void appendSpaces() throws XMLStreamException {
        if (this.indenting > this.spaces.length / 2) {
            this.writer.writeCharacters(this.spaces, 0, this.spaces.length);
        } else {
            this.writer.writeCharacters(this.spaces, 0, 2 * this.indenting);
        }
    }

    public final void writeStartDocument() throws XMLStreamException {
        if (this.spaces == null) {
            this.spaces = new char[100];
            for (int pos = 0; pos != this.spaces.length; ++pos) {
                this.spaces[pos] = 32;
            }
        }
        this.writer.writeStartDocument();
        this.writer.writeCharacters(this.newline);
        this.indenting = 0;
    }

    public final void writeStartElement(String name) throws XMLStreamException {
        this.appendSpaces();
        this.writer.writeStartElement(name);
        this.writer.writeCharacters(this.newline);
        ++this.indenting;
    }

    public final void writeStartElement(String elementName, String attributeName, String value, boolean newLine) throws XMLStreamException {
        this.appendSpaces();
        this.writer.writeStartElement(elementName);
        this.writer.writeAttribute(attributeName, value);
        if (newLine) {
            this.writer.writeCharacters(this.newline);
        }
        ++this.indenting;
    }

    public final void writeStartElement(String elementName, List<Map.Entry<String, String>> attributes, boolean newLine) throws XMLStreamException {
        this.appendSpaces();
        this.writer.writeStartElement(elementName);
        for (Map.Entry<String, String> it : attributes) {
            this.writer.writeAttribute(it.getKey(), it.getValue());
        }
        if (newLine) {
            this.writer.writeCharacters(this.newline);
        }
        ++this.indenting;
    }

    public final void writeElementString(String name, Date value) throws XMLStreamException {
        if (value != null && value.compareTo(new Date(0L)) != 0) {
            SimpleDateFormat sd = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
            this.writeElementString(name, sd.format(value));
        }
    }

    public final void writeElementString(String name, long value) throws XMLStreamException {
        if (!this.isSkipDefaults() || value != 0L) {
            this.writeElementString(name, String.valueOf(value));
        }
    }

    public final void writeElementString(String name, double value) throws XMLStreamException {
        this.writeElementString(name, value, 0.0);
    }

    public final void writeElementString(String name, double value, double defaultValue) throws XMLStreamException {
        if (!this.isSkipDefaults() || value != defaultValue) {
            this.writeElementString(name, String.format(Locale.US, "%f", value));
        }
    }

    public final void writeElementString(String name, int value) throws XMLStreamException {
        if (!this.isSkipDefaults() || value != 0) {
            this.writeElementString(name, String.valueOf(value));
        }
    }

    public final void writeElementString(String name, String value) throws XMLStreamException {
        if (!this.isSkipDefaults() || value != null && value.length() != 0) {
            this.appendSpaces();
            this.writer.writeStartElement(name);
            if (value != null) {
                this.writer.writeCharacters(value.replaceAll("[\\x00]", ""));
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters(this.newline);
        }
    }

    public final void writeElementString(String name, boolean value) throws XMLStreamException {
        if (!this.isSkipDefaults() || value) {
            this.writeElementString(name, value ? "1" : "0");
        }
    }

    public final void writeElementString(String name, GXDateTime value) throws XMLStreamException {
        if (value != null && value.getMeterCalendar().getTime() != new Date(0L)) {
            if (this.isUseMeterTime()) {
                this.writeElementString(name, value.toFormatMeterString(Locale.ROOT));
            } else {
                this.writeElementString(name, value.toFormatString(Locale.ROOT));
            }
        }
    }

    private void writeArray(Object data) throws XMLStreamException {
        if (data instanceof List) {
            this.writer.writeCharacters(System.getProperty("line.separator"));
            List arr = (List)data;
            for (Object tmp : arr) {
                if (tmp instanceof byte[]) {
                    this.writeElementObject("Item", tmp, false);
                    continue;
                }
                if (tmp instanceof GXArray) {
                    this.writeStartElement("Item", "Type", String.valueOf(DataType.ARRAY.getValue()), true);
                    this.writeArray(tmp);
                    this.writeEndElement();
                    continue;
                }
                if (tmp instanceof GXStructure) {
                    this.writeStartElement("Item", "Type", String.valueOf(DataType.STRUCTURE.getValue()), true);
                    this.writeArray(tmp);
                    this.writeEndElement();
                    continue;
                }
                this.writeElementObject("Item", tmp);
            }
        }
    }

    public final void writeElementObject(String name, Object value) throws XMLStreamException {
        this.writeElementObject(name, value, this.isSkipDefaults());
    }

    public final void writeElementObject(String name, Object value, DataType dt, DataType uiType) throws XMLStreamException {
        if (value != null) {
            String str;
            ArrayList<Map.Entry<String, String>> list;
            if (this.isSkipDefaults() && value instanceof Date && ((Date)value).compareTo(new Date(0L)) == 0) {
                return;
            }
            boolean addSpaces = false;
            if (value instanceof GXDateTimeOS) {
                list = new ArrayList<Map.Entry<String, String>>();
                list.add(new GXSimpleEntry<String, String>("Type", String.valueOf(DataType.OCTET_STRING.getValue())));
                if (value instanceof GXTimeOS) {
                    list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(DataType.TIME.getValue())));
                } else if (value instanceof GXDateOS) {
                    list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(DataType.DATE.getValue())));
                } else {
                    list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(DataType.DATETIME.getValue())));
                }
                this.writeStartElement(name, list, false);
            } else if (uiType != DataType.NONE && uiType != dt && (uiType != DataType.STRING || dt == DataType.OCTET_STRING)) {
                list = new ArrayList();
                list.add(new GXSimpleEntry<String, String>("Type", String.valueOf(dt.getValue())));
                list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(uiType.getValue())));
                this.writeStartElement(name, list, false);
            } else if (value instanceof Double || value instanceof Float) {
                list = new ArrayList();
                list.add(new GXSimpleEntry<String, String>("Type", String.valueOf(dt.getValue())));
                if (value instanceof Double) {
                    list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(DataType.FLOAT64.getValue())));
                } else {
                    list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(DataType.FLOAT32.getValue())));
                }
                this.writeStartElement(name, list, false);
            } else if (dt == DataType.NONE) {
                addSpaces = true;
                this.writeStartElement(name);
            } else {
                this.writeStartElement(name, "Type", String.valueOf(dt.getValue()), false);
            }
            if (dt == DataType.ARRAY || dt == DataType.STRUCTURE) {
                this.writeArray(value);
            } else if (value instanceof GXDateTime) {
                str = this.isUseMeterTime() ? ((GXDateTime)value).toFormatMeterString(Locale.ROOT) : ((GXDateTime)value).toFormatString(Locale.ROOT);
                this.writer.writeCharacters(str);
            } else if (value instanceof Date) {
                SimpleDateFormat sd = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss XXX");
                str = sd.format(value);
                this.writer.writeCharacters(str);
            } else if (value instanceof byte[]) {
                this.writer.writeCharacters(GXCommon.toHex((byte[])value));
            } else if (value != null) {
                this.writer.writeCharacters(String.valueOf(value));
            }
            this.writeEndElement(addSpaces);
        } else if (!this.isSkipDefaults()) {
            if (dt != DataType.NONE || uiType != DataType.NONE) {
                ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
                list.add(new GXSimpleEntry<String, String>("Type", String.valueOf(dt.getValue())));
                list.add(new GXSimpleEntry<String, String>("UIType", String.valueOf(uiType.getValue())));
                this.writeStartElement(name, list, false);
                this.writeEndElement(false);
            } else {
                this.writeStartElement(name);
                this.writeEndElement(false);
            }
        }
    }

    public final void writeElementObject(String name, Object value, boolean skipDefaultValue) throws XMLStreamException {
        if (value != null || !skipDefaultValue) {
            if (skipDefaultValue && value instanceof Date && ((Date)value).compareTo(new Date(0L)) == 0) {
                return;
            }
            if (value instanceof GXDateTimeOS) {
                this.writeElementObject(name, value, DataType.OCTET_STRING, DataType.DATETIME);
            } else if (value instanceof GXDateOS) {
                this.writeElementObject(name, value, DataType.OCTET_STRING, DataType.DATE);
            } else if (value instanceof GXTimeOS) {
                this.writeElementObject(name, value, DataType.OCTET_STRING, DataType.TIME);
            } else {
                DataType dt = GXDLMSConverter.getDLMSDataType(value);
                this.writeElementObject(name, value, dt, DataType.NONE);
            }
        }
    }

    private void writeEndElement(boolean addSpaces) throws XMLStreamException {
        --this.indenting;
        if (addSpaces) {
            this.appendSpaces();
        }
        this.writer.writeEndElement();
        this.writer.writeCharacters(this.newline);
    }

    public final void writeEndElement() throws XMLStreamException {
        this.writeEndElement(true);
    }

    public final void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
        this.writer.flush();
    }

    public final void flush() throws XMLStreamException {
        this.writer.flush();
    }

    boolean isSerialized(ObjectType objectType, int index) {
        if (this.settings == null) {
            return false;
        }
        for (GXIgnoreSerialize it : this.settings.getIgnored()) {
            if (it.getObjectType() != objectType) continue;
            for (int i : it.getAttributes()) {
                if (i != index) continue;
                return false;
            }
        }
        return true;
    }
}

