/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum AccountCreditStatus {
    NONE(0),
    IN_CREDIT(1),
    LOW_CREDIT(2),
    NEXT_CREDIT_ENABLED(4),
    NEXT_CREDIT_SELECTABLE(8),
    CREDIT_REFERENCE_LIST(16),
    SELECTABLE_CREDIT_IN_USE(32),
    OUT_OF_CREDIT(64),
    RESERVED(128);

    private int intValue;
    private static HashMap<Integer, AccountCreditStatus> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, AccountCreditStatus> getMappings() {
        Class<AccountCreditStatus> clazz = AccountCreditStatus.class;
        synchronized (AccountCreditStatus.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private AccountCreditStatus(int value) {
        this.intValue = value;
        AccountCreditStatus.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static AccountCreditStatus forValue(int value) {
        AccountCreditStatus ret = AccountCreditStatus.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid account credit status enum value.");
        }
        return ret;
    }
}

