/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum MessageType {
    COSEM_APDU(0),
    COSEM_APDU_XML(1),
    MANUFACTURER_SPESIFIC(128);

    private int intValue;
    private static HashMap<Integer, MessageType> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, MessageType> getMappings() {
        if (mappings != null) return mappings;
        Class<MessageType> clazz = MessageType.class;
        synchronized (MessageType.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private MessageType(int value) {
        this.intValue = value;
        MessageType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static MessageType forValue(int value) {
        MessageType ret = MessageType.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid message type enum value.");
        }
        return ret;
    }
}

