/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms.objects.enums;

import java.util.HashMap;

public enum SortMethod {
    FIFO(1),
    LIFO(2),
    LARGEST(3),
    SMALLEST(4),
    NEAREST_TO_ZERO(5),
    FAREST_FROM_ZERO(6);

    private int intValue;
    private static HashMap<Integer, SortMethod> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, SortMethod> getMappings() {
        Class<SortMethod> clazz = SortMethod.class;
        synchronized (SortMethod.class) {
            if (mappings == null) {
                mappings = new HashMap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private SortMethod(int value) {
        this.intValue = value;
        SortMethod.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static SortMethod forValue(int value) {
        SortMethod ret = SortMethod.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid sort method enum value.");
        }
        return ret;
    }
}

