/*
 * Decompiled with CFR 0.152.
 */
package gurux.mqtt;

import com.google.gson.Gson;
import gurux.common.AutoResetEvent;
import gurux.common.GXCommon;
import gurux.common.GXSynchronousMediaBase;
import gurux.common.ReceiveEventArgs;
import gurux.common.TraceEventArgs;
import gurux.common.enums.MediaState;
import gurux.common.enums.TraceLevel;
import gurux.common.enums.TraceTypes;
import gurux.mqtt.GXMessage;
import gurux.mqtt.GXMqtt;
import java.lang.reflect.Array;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

class GXListener
implements MqttCallback,
IMqttActionListener {
    final GXMqtt parentMedia;
    long bytesReceived = 0L;
    private int messageId = 0;
    final AutoResetEvent replyReceivedEvent = new AutoResetEvent(false);
    String lastException;

    int getMessageId() {
        return ++this.messageId;
    }

    public GXListener(GXMqtt parent) {
        this.parentMedia = parent;
    }

    public void connectionLost(Throwable cause) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReceivedData(int length, byte[] buffer, String sender) {
        if (length == 0) {
            return;
        }
        Object eop = this.parentMedia.getEop();
        this.bytesReceived += (long)length;
        int totalCount = 0;
        if (this.parentMedia.getIsSynchronous()) {
            TraceEventArgs arg = null;
            Object object = this.parentMedia.getSyncBase().getSync();
            synchronized (object) {
                this.parentMedia.getSyncBase().appendData(buffer, 0, length);
                if (eop != null) {
                    if (eop instanceof Array) {
                        Object it;
                        Object[] objectArray = (Object[])eop;
                        int n = objectArray.length;
                        for (int i = 0; i < n && (totalCount = GXSynchronousMediaBase.indexOf((byte[])buffer, (byte[])GXSynchronousMediaBase.getAsByteArray((Object)(it = objectArray[i])), (int)0, (int)length)) == -1; ++i) {
                        }
                    } else {
                        totalCount = GXSynchronousMediaBase.indexOf((byte[])buffer, (byte[])GXSynchronousMediaBase.getAsByteArray((Object)eop), (int)0, (int)length);
                    }
                }
                if (totalCount != -1) {
                    if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
                        arg = new TraceEventArgs(TraceTypes.RECEIVED, buffer, 0, totalCount + 1);
                    }
                    this.parentMedia.getSyncBase().setReceived();
                }
            }
            if (arg != null) {
                this.parentMedia.notifyTrace(arg);
            }
        } else {
            this.parentMedia.getSyncBase().resetReceivedSize();
            byte[] data = new byte[length];
            System.arraycopy(buffer, 0, data, 0, length);
            if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
                this.parentMedia.notifyTrace(new TraceEventArgs(TraceTypes.RECEIVED, (Object)data));
            }
            ReceiveEventArgs e = new ReceiveEventArgs((Object)data, sender);
            this.parentMedia.notifyReceived(e);
        }
    }

    private GXMessage getMessage(String data) {
        Gson g = new Gson();
        GXMessage msg = (GXMessage)g.fromJson(data, GXMessage.class);
        return msg;
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String payload = new String(message.getPayload());
        GXMessage msg = this.getMessage(payload);
        if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
            System.out.println("---Received message");
            System.out.println("Topic = " + topic);
            System.out.println("Payload = " + payload);
            System.out.println("QoS = " + message.getQos());
            System.out.println("Retain = " + message.getQos());
        }
        if (msg.getId() == this.messageId || msg.getType() == 3 || msg.getType() == 4) {
            switch (msg.getType()) {
                case 0: {
                    this.parentMedia.notifyMediaStateChange(MediaState.OPEN);
                    this.replyReceivedEvent.set();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    byte[] bytes = GXCommon.hexToBytes((String)msg.getFrame());
                    this.replyReceivedEvent.set();
                    if (bytes.length == 0) break;
                    this.handleReceivedData(bytes.length, bytes, msg.getSender());
                    break;
                }
                case 3: {
                    this.parentMedia.notifyMediaStateChange(MediaState.CLOSED);
                    this.replyReceivedEvent.set();
                    break;
                }
                case 4: {
                    this.lastException = msg.getException();
                    this.replyReceivedEvent.set();
                }
            }
        } else if (this.parentMedia.getTrace().ordinal() >= TraceLevel.INFO.ordinal()) {
            this.parentMedia.notifyTrace(new TraceEventArgs(TraceTypes.INFO, (Object)("Unknown reply: " + msg)));
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.replyReceivedEvent.set();
    }

    public void onSuccess(IMqttToken asyncActionToken) {
        this.replyReceivedEvent.set();
    }

    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
        this.lastException = exception.getMessage();
        this.replyReceivedEvent.set();
    }
}

