/*
 * Decompiled with CFR 0.152.
 */
package gurux.mqtt;

import com.google.gson.Gson;
import gurux.common.GXCommon;
import gurux.common.GXSync;
import gurux.common.GXSynchronousMediaBase;
import gurux.common.IGXMedia2;
import gurux.common.IGXMediaListener;
import gurux.common.MediaStateEventArgs;
import gurux.common.PropertyChangedEventArgs;
import gurux.common.ReceiveEventArgs;
import gurux.common.ReceiveParameters;
import gurux.common.TraceEventArgs;
import gurux.common.enums.MediaState;
import gurux.common.enums.TraceLevel;
import gurux.common.enums.TraceTypes;
import gurux.mqtt.GXListener;
import gurux.mqtt.GXMessage;
import gurux.mqtt.GXSettings;
import gurux.mqtt.enums.AvailableMediaSettings;
import java.awt.Frame;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GXMqtt
implements IGXMedia2,
AutoCloseable {
    private MqttAsyncClient publisher;
    private int receiveDelay;
    private int asyncWaitTime;
    private String serverAddress;
    private int port = 1883;
    private String topic;
    private String clientId;
    private String userClientId;
    private GXSynchronousMediaBase syncBase;
    private final GXListener listener;
    private long bytesSent = 0L;
    private int synchronous = 0;
    private TraceLevel trace = TraceLevel.OFF;
    private Object eop;
    private int configurableSettings;
    private List<IGXMediaListener> listeners = new ArrayList<IGXMediaListener>();
    private Locale locale;

    public GXMqtt() {
        this.listener = new GXListener(this);
        this.syncBase = new GXSynchronousMediaBase(1024);
        this.setConfigurableSettings(AvailableMediaSettings.ALL.getValue());
        this.locale = Locale.getDefault();
    }

    public GXMqtt(String name, int portNo) {
        this();
        this.serverAddress = name;
        this.setPort(portNo);
    }

    protected final void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    final GXSynchronousMediaBase getSyncBase() {
        return this.syncBase;
    }

    public final TraceLevel getTrace() {
        return this.trace;
    }

    public final void setTrace(TraceLevel value) {
        this.trace = value;
        this.syncBase.setTrace(value);
    }

    private void notifyPropertyChanged(String info) {
        for (IGXMediaListener it : this.listeners) {
            it.onPropertyChanged((Object)this, new PropertyChangedEventArgs(info));
        }
    }

    final void notifyError(RuntimeException ex) {
        for (IGXMediaListener it : this.listeners) {
            it.onError((Object)this, (Exception)ex);
            if (this.trace.ordinal() < TraceLevel.ERROR.ordinal()) continue;
            it.onTrace((Object)this, new TraceEventArgs(TraceTypes.ERROR, (Object)ex));
        }
    }

    final void notifyReceived(ReceiveEventArgs e) {
        for (IGXMediaListener it : this.listeners) {
            it.onReceived((Object)this, e);
        }
    }

    final void notifyTrace(TraceEventArgs e) {
        for (IGXMediaListener it : this.listeners) {
            it.onTrace((Object)this, e);
        }
    }

    public final int getConfigurableSettings() {
        return this.configurableSettings;
    }

    public final void setConfigurableSettings(int value) {
        this.configurableSettings = value;
    }

    public final boolean properties(JFrame parent) {
        GXSettings dlg = new GXSettings((Frame)parent, true, this, this.locale);
        dlg.pack();
        dlg.setVisible(true);
        return dlg.isAccepted();
    }

    public final void aboutBox() {
        throw new UnsupportedOperationException();
    }

    private void publishMessageAsync(GXMessage payload) throws MqttPersistenceException, MqttException {
        MqttMessage msg = new MqttMessage();
        msg.setQos(1);
        Gson g = new Gson();
        String tmp = g.toJson((Object)payload);
        msg.setPayload(tmp.getBytes());
        if (this.trace.ordinal() > TraceLevel.WARNING.ordinal()) {
            System.out.println("---Sending message: " + tmp);
        }
        this.publisher.publish(this.topic, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(Object data, String target) throws Exception {
        if (this.trace == TraceLevel.VERBOSE) {
            this.notifyTrace(new TraceEventArgs(TraceTypes.SENT, data));
        }
        Object object = this.syncBase.getSync();
        synchronized (object) {
            this.syncBase.resetLastPosition();
        }
        byte[] buff = GXSynchronousMediaBase.getAsByteArray((Object)data);
        if (buff == null) {
            throw new IllegalArgumentException("Data send failed. Invalid data.");
        }
        this.bytesSent += (long)buff.length;
        GXMessage msg = new GXMessage();
        msg.setId(this.listener.getMessageId());
        msg.setType((byte)1);
        msg.setSender(this.clientId);
        msg.setFrame(GXCommon.bytesToHex((byte[])buff));
        this.publishMessageAsync(msg);
    }

    void notifyMediaStateChange(MediaState state) {
        for (IGXMediaListener it : this.listeners) {
            if (this.trace.ordinal() >= TraceLevel.ERROR.ordinal()) {
                it.onTrace((Object)this, new TraceEventArgs(TraceTypes.INFO, (Object)state));
            }
            it.onMediaStateChange((Object)this, new MediaStateEventArgs(state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() throws Exception {
        this.close();
        this.listener.lastException = null;
        try {
            Object object = this.syncBase.getSync();
            synchronized (object) {
                this.syncBase.resetLastPosition();
            }
            this.notifyMediaStateChange(MediaState.OPENING);
            this.clientId = this.userClientId == null || this.userClientId == "" ? UUID.randomUUID().toString() : this.userClientId;
            this.publisher = new MqttAsyncClient("tcp://" + this.serverAddress + ":" + this.port, this.clientId);
            this.publisher.setCallback((MqttCallback)this.listener);
            if (this.trace.ordinal() >= TraceLevel.INFO.ordinal()) {
                this.notifyTrace(new TraceEventArgs(TraceTypes.INFO, (Object)("MQTT settings: Host: " + this.serverAddress + " Port: " + String.valueOf(this.getPort()))));
            }
            MqttConnectOptions options = new MqttConnectOptions();
            options.setAutomaticReconnect(true);
            options.setCleanSession(true);
            options.setConnectionTimeout(10);
            this.publisher.connect((Object)options, (IMqttActionListener)this.listener);
            if (this.getAsyncWaitTime() < 1) {
                this.listener.replyReceivedEvent.waitOne();
            } else {
                this.listener.replyReceivedEvent.waitOne((long)(this.getAsyncWaitTime() * 1000));
            }
            if (this.listener.lastException != null) {
                throw new RuntimeException(this.listener.lastException);
            }
            this.publisher.subscribe(this.clientId, 2);
            this.listener.replyReceivedEvent.reset();
            GXMessage msg = new GXMessage();
            msg.setId(this.listener.getMessageId());
            msg.setType((byte)0);
            msg.setSender(this.clientId);
            this.publishMessageAsync(msg);
            if (this.getAsyncWaitTime() < 1) {
                this.listener.replyReceivedEvent.waitOne();
            } else {
                this.listener.replyReceivedEvent.waitOne((long)(this.getAsyncWaitTime() * 1000));
            }
            if (this.listener.lastException != null) {
                throw new RuntimeException(this.listener.lastException);
            }
            this.notifyMediaStateChange(MediaState.OPEN);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Override
    public final void close() {
        this.listener.lastException = null;
        if (this.isOpen()) {
            GXMessage msg = new GXMessage();
            msg.setId(this.listener.getMessageId());
            msg.setType((byte)3);
            msg.setSender(this.clientId);
            try {
                this.publishMessageAsync(msg);
            }
            catch (Exception ex) {
                this.listener.replyReceivedEvent.set();
            }
            if (this.getAsyncWaitTime() < 1) {
                this.listener.replyReceivedEvent.waitOne();
            } else {
                this.listener.replyReceivedEvent.waitOne((long)(this.getAsyncWaitTime() * 1000));
            }
            if (this.publisher != null) {
                try {
                    IMqttToken disconnectToken = this.publisher.disconnect();
                    disconnectToken.waitForCompletion();
                    this.publisher.close(true);
                    this.publisher = null;
                }
                catch (MqttException e) {
                    this.publisher = null;
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            if (this.listener.lastException != null) {
                throw new RuntimeException(this.listener.lastException);
            }
        }
    }

    public final boolean isOpen() {
        return this.publisher != null && this.publisher.isConnected();
    }

    public final String getTopic() {
        return this.topic;
    }

    public final void setTopic(String value) {
        if (this.topic == null || !this.topic.equals(value)) {
            this.topic = value;
            this.notifyPropertyChanged("Topic");
        }
    }

    public final String getServerAddress() {
        return this.serverAddress;
    }

    public final void setServerAddress(String value) {
        if (this.serverAddress == null || !this.serverAddress.equals(value)) {
            this.serverAddress = value;
            this.notifyPropertyChanged("ServerAddress");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int value) {
        if (this.port != value) {
            this.port = value;
            this.notifyPropertyChanged("Port");
        }
    }

    public final <T> boolean receive(ReceiveParameters<T> args) {
        return this.syncBase.receive(args);
    }

    public final long getBytesSent() {
        return this.bytesSent;
    }

    public final long getBytesReceived() {
        return this.listener.bytesReceived;
    }

    public final void resetByteCounters() {
        this.bytesSent = 0L;
        this.listener.bytesReceived = 0L;
    }

    public final String getSettings() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        if (this.serverAddress != null && !this.serverAddress.isEmpty()) {
            sb.append("<IP>");
            sb.append(this.serverAddress);
            sb.append("</IP>");
            sb.append(nl);
        }
        if (this.port != 0) {
            sb.append("<Port>");
            sb.append(String.valueOf(this.port));
            sb.append("</Port>");
            sb.append(nl);
        }
        sb.append("<Topic>");
        sb.append(this.topic);
        sb.append("</Topic>");
        sb.append(nl);
        if (this.userClientId != null && !this.userClientId.isEmpty()) {
            sb.append("<ClientId>");
            sb.append(this.clientId);
            sb.append("</ClientId>");
            sb.append(nl);
        }
        return sb.toString();
    }

    public final void setSettings(String value) {
        this.topic = "";
        this.clientId = "";
        this.serverAddress = "";
        this.port = 0;
        this.userClientId = "";
        if (value != null && !value.isEmpty()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringBuilder sb = new StringBuilder();
                if (value.startsWith("<?xml version=\"1.0\"?>")) {
                    sb.append(value);
                } else {
                    String nl = System.getProperty("line.separator");
                    sb.append("<?xml version=\"1.0\"?>\r\n");
                    sb.append(nl);
                    sb.append("<Mqtt>");
                    sb.append(value);
                    sb.append(nl);
                    sb.append("</Mqtt>");
                }
                InputSource is = new InputSource(new StringReader(sb.toString()));
                Document doc = builder.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getChildNodes();
                if (nList.getLength() != 1) {
                    throw new IllegalArgumentException("Invalid XML root node.");
                }
                nList = nList.item(0).getChildNodes();
                for (int pos = 0; pos < nList.getLength(); ++pos) {
                    Node it = nList.item(pos);
                    if (it.getNodeType() != 1) continue;
                    if ("topic".equalsIgnoreCase(it.getNodeName())) {
                        this.setTopic(it.getFirstChild().getNodeValue());
                        continue;
                    }
                    if ("IP".equalsIgnoreCase(it.getNodeName())) {
                        this.setServerAddress(it.getFirstChild().getNodeValue());
                        continue;
                    }
                    if ("Port".equalsIgnoreCase(it.getNodeName())) {
                        this.setPort(Integer.parseInt(it.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (!"ClientId".equalsIgnoreCase(it.getNodeName())) continue;
                    this.userClientId = it.getFirstChild().getNodeValue();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public final void copy(Object target) {
        GXMqtt tmp = (GXMqtt)target;
        this.setPort(tmp.getPort());
        this.setServerAddress(tmp.getServerAddress());
        this.setTopic(tmp.getTopic());
    }

    public final String getName() {
        return this.getServerAddress() + " " + this.getPort() + " MQTT";
    }

    public final String getMediaType() {
        return "MQTT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getSynchronous() {
        GXMqtt gXMqtt = this;
        synchronized (gXMqtt) {
            int[] tmp = new int[]{this.synchronous};
            GXSync obj = new GXSync(tmp);
            this.synchronous = tmp[0];
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsSynchronous() {
        GXMqtt gXMqtt = this;
        synchronized (gXMqtt) {
            return this.synchronous != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetSynchronousBuffer() {
        Object object = this.syncBase.getSync();
        synchronized (object) {
            this.syncBase.resetReceivedSize();
        }
    }

    public final void validate() {
        if (this.getPort() == 0) {
            ResourceBundle bundle = ResourceBundle.getBundle("resources", this.locale);
            throw new RuntimeException(bundle.getString("InvalidPortName"));
        }
        if (this.serverAddress == null || "".equals(this.serverAddress)) {
            ResourceBundle bundle = ResourceBundle.getBundle("resources", this.locale);
            throw new RuntimeException(bundle.getString("InvalidHostName"));
        }
        if (this.topic == null || "".equals(this.topic)) {
            ResourceBundle bundle = ResourceBundle.getBundle("resources", this.locale);
            throw new RuntimeException(bundle.getString("InvalidTopic"));
        }
    }

    public final Object getEop() {
        return this.eop;
    }

    public final void setEop(Object value) {
        this.eop = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(IGXMediaListener listener) {
        List<IGXMediaListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(IGXMediaListener listener) {
        List<IGXMediaListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int getReceiveDelay() {
        return this.receiveDelay;
    }

    public void setReceiveDelay(int value) {
        this.receiveDelay = value;
    }

    public int getAsyncWaitTime() {
        return this.asyncWaitTime;
    }

    public void setAsyncWaitTime(int value) {
        this.asyncWaitTime = value;
    }

    public Object getAsyncWaitHandle() {
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale value) {
        this.locale = value;
    }

    public String getUserClientId() {
        return this.userClientId;
    }

    public void setUserClientId(String value) {
        this.userClientId = value;
    }
}

