/*
 * Decompiled with CFR 0.152.
 */
package gurux.mqtt;

import gurux.mqtt.GXMqtt;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

class GXSettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean accepted;
    private GXMqtt target;
    private JButton cancelBtn;
    private JLabel ipAddressLbl;
    private JPanel ipAddressPanel;
    private JTextField ipAddressTB;
    private JButton okBtn;
    private JLabel portLbl;
    private JPanel portPanel;
    private JTextField portTB;
    private JPanel jPanel1;

    GXSettings(Frame parent, boolean modal, GXMqtt comp, Locale locale) {
        super(parent, modal);
        super.setLocationRelativeTo(parent);
        this.initComponents();
        this.target = comp;
        this.ipAddressTB.setText(this.target.getServerAddress());
        this.portTB.setText(String.valueOf(this.target.getPort()));
        ResourceBundle bundle = ResourceBundle.getBundle("resources", locale);
        this.setTitle(bundle.getString("SettingsTxt"));
        this.ipAddressLbl.setText(bundle.getString("ServerAddressTxt"));
        this.portLbl.setText(bundle.getString("PortTxt"));
        this.okBtn.setText(bundle.getString("OK"));
        this.cancelBtn.setText(bundle.getString("Cancel"));
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ipAddressPanel = new JPanel();
        this.ipAddressLbl = new JLabel();
        this.ipAddressTB = new JTextField();
        this.portPanel = new JPanel();
        this.portLbl = new JLabel();
        this.portTB = new JTextField();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.ipAddressPanel.setPreferredSize(new Dimension(298, 33));
        this.ipAddressLbl.setText("IP Address:");
        GroupLayout ipAddressPanelLayout = new GroupLayout(this.ipAddressPanel);
        this.ipAddressPanel.setLayout(ipAddressPanelLayout);
        ipAddressPanelLayout.setHorizontalGroup(ipAddressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ipAddressPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ipAddressLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.ipAddressTB, -2, 211, -2).addContainerGap()));
        ipAddressPanelLayout.setVerticalGroup(ipAddressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ipAddressPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(ipAddressPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipAddressLbl).addComponent(this.ipAddressTB, -2, -1, -2)).addGap(367, 367, 367)));
        this.portPanel.setPreferredSize(new Dimension(298, 35));
        this.portLbl.setText("Port:");
        GroupLayout portPanelLayout = new GroupLayout(this.portPanel);
        this.portPanel.setLayout(portPanelLayout);
        portPanelLayout.setHorizontalGroup(portPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(portPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.portLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.portTB, -2, 213, -2).addContainerGap()));
        portPanelLayout.setVerticalGroup(portPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, portPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(portPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLbl).addComponent(this.portTB, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ipAddressPanel, -1, 341, Short.MAX_VALUE).addComponent(this.portPanel, -1, 341, Short.MAX_VALUE));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                GXSettings.this.okBtnActionPerformed(evt);
            }
        });
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                GXSettings.this.cancelBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap(220, Short.MAX_VALUE).addComponent(this.okBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelBtn).addContainerGap()).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(11, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 234, -2).addGap(26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBtn).addComponent(this.okBtn)).addContainerGap()));
        this.getContentPane().setLayout(layout);
        this.pack();
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(this, stroke, 2);
        return rootPane;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.target.setServerAddress(this.ipAddressTB.getText());
            this.target.setPort(Integer.parseInt(this.portTB.getText()));
            this.target.validate();
            this.accepted = true;
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

