/*
 * Decompiled with CFR 0.152.
 */
package gurux.net;

import gurux.common.GXSync;
import gurux.common.GXSynchronousMediaBase;
import gurux.common.IGXMedia2;
import gurux.common.IGXMediaListener;
import gurux.common.MediaStateEventArgs;
import gurux.common.PropertyChangedEventArgs;
import gurux.common.ReceiveEventArgs;
import gurux.common.ReceiveParameters;
import gurux.common.TraceEventArgs;
import gurux.common.enums.MediaState;
import gurux.common.enums.TraceLevel;
import gurux.common.enums.TraceTypes;
import gurux.net.ConnectionEventArgs;
import gurux.net.GXSettings;
import gurux.net.IGXNetListener;
import gurux.net.ListenerThread;
import gurux.net.ReceiveThread;
import gurux.net.enums.AvailableMediaSettings;
import gurux.net.enums.NetworkType;
import java.awt.Frame;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GXNet
implements IGXMedia2,
AutoCloseable {
    private int receiveDelay;
    private int asyncWaitTime;
    private NetworkType protocol = NetworkType.TCP;
    private String hostName;
    private int port;
    private boolean server;
    private GXSynchronousMediaBase syncBase;
    private Closeable socket = null;
    private List<Socket> tcpIpClients = new ArrayList<Socket>();
    private long bytesSent = 0L;
    private int synchronous = 0;
    private TraceLevel trace = TraceLevel.OFF;
    private int maxClientCount;
    private Object eop;
    private int configurableSettings;
    private List<IGXMediaListener> listeners = new ArrayList<IGXMediaListener>();
    private List<IGXNetListener> netListeners = new ArrayList<IGXNetListener>();
    private ReceiveThread receiverThread = null;
    private ListenerThread listenerThread = null;
    private int connectionWaitTime = 0;
    private Locale locale;

    public GXNet() {
        this.syncBase = new GXSynchronousMediaBase(1100);
        this.setConfigurableSettings(AvailableMediaSettings.ALL.getValue());
        this.setProtocol(NetworkType.TCP);
        this.locale = Locale.getDefault();
    }

    public GXNet(NetworkType networkType, String name, int portNo) {
        this();
        this.setProtocol(networkType);
        this.setHostName(name);
        this.setPort(portNo);
    }

    public GXNet(NetworkType networkType, int portNo) {
        this(networkType, null, portNo);
        this.setServer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GXNet attach(String address) {
        if (this.protocol != NetworkType.TCP) {
            throw new IllegalArgumentException("Attach can be used only with TCP/IP connection.");
        }
        GXNet net = new GXNet();
        net.setConfigurableSettings(this.configurableSettings);
        net.setProtocol(this.protocol);
        net.setTrace(this.trace);
        List<Socket> list = this.tcpIpClients;
        synchronized (list) {
            for (Closeable closeable : this.tcpIpClients) {
                Socket s;
                if (!(closeable instanceof Socket) || !(s = (Socket)closeable).getRemoteSocketAddress().toString().equals(address)) continue;
                net.socket = s;
                net.hostName = this.hostName;
                net.port = this.port;
                this.tcpIpClients.remove(s);
                net.receiverThread = new ReceiveThread(net, s);
                net.receiverThread.start();
                break;
            }
        }
        if (net.socket == null) {
            throw new IllegalArgumentException("Unknown address.");
        }
        return net;
    }

    protected final void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    final List<Socket> getTcpIpClients() {
        return this.tcpIpClients;
    }

    final GXSynchronousMediaBase getSyncBase() {
        return this.syncBase;
    }

    public final TraceLevel getTrace() {
        return this.trace;
    }

    public final void setTrace(TraceLevel value) {
        this.trace = value;
        this.syncBase.setTrace(value);
    }

    private void notifyPropertyChanged(String info) {
        for (IGXMediaListener it : this.listeners) {
            it.onPropertyChanged((Object)this, new PropertyChangedEventArgs(info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyClientConnected(ConnectionEventArgs e) {
        List<IGXNetListener> list = this.netListeners;
        synchronized (list) {
            for (IGXNetListener iGXNetListener : this.netListeners) {
                iGXNetListener.onClientConnected(this, e);
            }
            if (this.trace.ordinal() >= TraceLevel.INFO.ordinal()) {
                for (IGXMediaListener iGXMediaListener : this.listeners) {
                    iGXMediaListener.onTrace((Object)this, new TraceEventArgs(TraceTypes.INFO, (Object)"Client connected."));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyClientDisconnected(ConnectionEventArgs e) {
        List<IGXNetListener> list = this.netListeners;
        synchronized (list) {
            for (IGXNetListener iGXNetListener : this.netListeners) {
                iGXNetListener.onClientDisconnected(this, e);
            }
            if (this.trace.ordinal() >= TraceLevel.INFO.ordinal()) {
                for (IGXMediaListener iGXMediaListener : this.listeners) {
                    iGXMediaListener.onTrace((Object)this, new TraceEventArgs(TraceTypes.INFO, (Object)"Client disconnected."));
                }
            }
        }
    }

    final void notifyError(RuntimeException ex) {
        for (IGXMediaListener it : this.listeners) {
            it.onError((Object)this, (Exception)ex);
            if (this.trace.ordinal() < TraceLevel.ERROR.ordinal()) continue;
            it.onTrace((Object)this, new TraceEventArgs(TraceTypes.ERROR, (Object)ex));
        }
    }

    final void notifyReceived(ReceiveEventArgs e) {
        for (IGXMediaListener it : this.listeners) {
            it.onReceived((Object)this, e);
        }
    }

    final void notifyTrace(TraceEventArgs e) {
        for (IGXMediaListener it : this.listeners) {
            it.onTrace((Object)this, e);
        }
    }

    public final int getConfigurableSettings() {
        return this.configurableSettings;
    }

    public final void setConfigurableSettings(int value) {
        this.configurableSettings = value;
    }

    public final boolean properties(JFrame parent) {
        GXSettings dlg = new GXSettings((Frame)parent, true, this, this.locale);
        dlg.pack();
        dlg.setVisible(true);
        return dlg.isAccepted();
    }

    public final void aboutBox() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(Object data, String target) throws Exception {
        if (this.socket == null) {
            throw new RuntimeException("Invalid connection.");
        }
        if (this.trace == TraceLevel.VERBOSE) {
            this.notifyTrace(new TraceEventArgs(TraceTypes.SENT, data));
        }
        Object object = this.syncBase.getSync();
        synchronized (object) {
            this.syncBase.resetLastPosition();
        }
        byte[] buff = GXSynchronousMediaBase.getAsByteArray((Object)data);
        if (buff == null) {
            throw new IllegalArgumentException("Data send failed. Invalid data.");
        }
        if (this.getServer()) {
            if (this.getProtocol() == NetworkType.TCP) {
                List<Socket> list = this.tcpIpClients;
                synchronized (list) {
                    for (Closeable closeable : this.tcpIpClients) {
                        if (!(closeable instanceof Socket) || !((Socket)closeable).getRemoteSocketAddress().toString().equals(target)) continue;
                        ((Socket)closeable).getOutputStream().write(buff);
                        break;
                    }
                }
            } else {
                String info = target.startsWith("/") ? target.substring(1) : target;
                int index = info.lastIndexOf(":");
                if (index == -1) {
                    throw new RuntimeException("Port is missing.");
                }
                InetAddress inetAddress = InetAddress.getByName(info.substring(0, index));
                DatagramPacket p = new DatagramPacket(buff, buff.length, inetAddress, Integer.parseInt(info.substring(1 + index)));
                ((DatagramSocket)this.socket).send(p);
            }
        } else if (this.getProtocol() == NetworkType.TCP) {
            ((Socket)this.socket).getOutputStream().write(buff);
        } else if (this.getProtocol() == NetworkType.UDP) {
            InetAddress addr = InetAddress.getByName(this.getHostName());
            DatagramPacket p = new DatagramPacket(buff, buff.length, addr, this.getPort());
            ((DatagramSocket)this.socket).send(p);
        }
        this.bytesSent += (long)buff.length;
    }

    void notifyMediaStateChange(MediaState state) {
        for (IGXMediaListener it : this.listeners) {
            if (this.trace.ordinal() >= TraceLevel.ERROR.ordinal()) {
                it.onTrace((Object)this, new TraceEventArgs(TraceTypes.INFO, (Object)state));
            }
            it.onMediaStateChange((Object)this, new MediaStateEventArgs(state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() throws Exception {
        this.close();
        try {
            Object object = this.syncBase.getSync();
            synchronized (object) {
                this.syncBase.resetLastPosition();
            }
            this.notifyMediaStateChange(MediaState.OPENING);
            if (this.getServer()) {
                if (this.trace.ordinal() >= TraceLevel.INFO.ordinal()) {
                    this.notifyTrace(new TraceEventArgs(TraceTypes.INFO, (Object)("Server settings: Protocol: " + this.getProtocol().toString() + " Port: " + String.valueOf(this.getPort()))));
                }
                if (this.getProtocol() == NetworkType.TCP) {
                    this.socket = new ServerSocket(this.getPort());
                    this.listenerThread = new ListenerThread(this, this.socket);
                    this.listenerThread.start();
                    this.listenerThread.waitUntilRun();
                } else if (this.getProtocol() == NetworkType.UDP) {
                    this.socket = new DatagramSocket(this.getPort());
                    this.receiverThread = new ReceiveThread(this, this.socket);
                    this.receiverThread.start();
                    this.receiverThread.waitUntilRun();
                }
            } else {
                if (this.getProtocol() == NetworkType.TCP) {
                    if (this.connectionWaitTime == 0) {
                        this.socket = new Socket(this.getHostName(), this.getPort());
                    } else {
                        this.socket = new Socket();
                        ((Socket)this.socket).connect(new InetSocketAddress(this.getHostName(), this.getPort()), this.connectionWaitTime);
                    }
                } else if (this.getProtocol() == NetworkType.UDP) {
                    this.socket = new DatagramSocket();
                } else {
                    throw new IllegalArgumentException("Protocol");
                }
                if (this.trace.ordinal() >= TraceLevel.INFO.ordinal()) {
                    this.notifyTrace(new TraceEventArgs(TraceTypes.INFO, (Object)("Client settings: Protocol: " + this.getProtocol().toString() + " Host: " + this.getHostName() + " Port: " + String.valueOf(this.getPort()))));
                }
                this.receiverThread = new ReceiveThread(this, this.socket);
                this.receiverThread.start();
                this.receiverThread.waitUntilRun();
            }
            this.notifyMediaStateChange(MediaState.OPEN);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (this.socket != null) {
            if (this.getServer() && this.listenerThread != null) {
                List<Socket> list = this.tcpIpClients;
                synchronized (list) {
                    for (Closeable closeable : this.tcpIpClients) {
                        if (!(closeable instanceof Socket)) continue;
                        try {
                            closeable.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.listenerThread.interrupt();
                this.listenerThread = null;
            } else if (this.receiverThread != null) {
                this.receiverThread.interrupt();
                this.receiverThread = null;
            }
            try {
                this.notifyMediaStateChange(MediaState.CLOSING);
            }
            catch (RuntimeException ex) {
                this.notifyError(ex);
                throw ex;
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
                this.socket = null;
                this.notifyMediaStateChange(MediaState.CLOSED);
                this.bytesSent = 0L;
                if (this.receiverThread != null) {
                    this.receiverThread.resetBytesReceived();
                }
                this.syncBase.resetReceivedSize();
            }
        }
    }

    public final boolean isOpen() {
        return this.socket != null;
    }

    public final NetworkType getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(NetworkType value) {
        if (this.protocol != value) {
            this.protocol = value;
            this.notifyPropertyChanged("Protocol");
        }
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(String value) {
        if (this.hostName == null || !this.hostName.equals(value)) {
            this.hostName = value;
            this.notifyPropertyChanged("HostName");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int value) {
        if (this.port != value) {
            this.port = value;
            this.notifyPropertyChanged("Port");
        }
    }

    public final boolean getServer() {
        return this.server;
    }

    public final void setServer(boolean value) {
        if (this.server != value) {
            this.server = value;
            this.notifyPropertyChanged("Server");
        }
    }

    public final int getConnectionWaitTime() {
        return this.connectionWaitTime;
    }

    public final void setConnectionWaitTime(int value) {
        boolean change = this.connectionWaitTime != value;
        this.connectionWaitTime = value;
        if (change) {
            this.notifyPropertyChanged("ConnectionWaitTime");
        }
    }

    public final <T> boolean receive(ReceiveParameters<T> args) {
        return this.syncBase.receive(args);
    }

    public final long getBytesSent() {
        return this.bytesSent;
    }

    public final long getBytesReceived() {
        if (this.receiverThread == null) {
            return 0L;
        }
        return this.receiverThread.getBytesReceived();
    }

    public final void resetByteCounters() {
        this.bytesSent = 0L;
        if (this.receiverThread != null) {
            this.receiverThread.resetBytesReceived();
        }
    }

    public final int getMaxClientCount() {
        return this.maxClientCount;
    }

    public final void setMaxClientCount(int value) {
        this.maxClientCount = value;
    }

    public final String getSettings() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        if (this.server) {
            sb.append("<Server>");
            if (this.server) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            sb.append("</Server>");
            sb.append(nl);
        }
        if (this.hostName != null && !this.hostName.isEmpty()) {
            sb.append("<IP>");
            sb.append(this.hostName);
            sb.append("</IP>");
            sb.append(nl);
        }
        if (this.port != 0) {
            sb.append("<Port>");
            sb.append(String.valueOf(this.port));
            sb.append("</Port>");
            sb.append(nl);
        }
        if (this.protocol != NetworkType.TCP) {
            sb.append("<Protocol>");
            sb.append(this.protocol.ordinal());
            sb.append("</Protocol>");
            sb.append(nl);
        }
        return sb.toString();
    }

    public final void setSettings(String value) {
        this.server = false;
        this.hostName = "";
        this.port = 0;
        this.protocol = NetworkType.TCP;
        if (value != null && !value.isEmpty()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringBuilder sb = new StringBuilder();
                if (value.startsWith("<?xml version=\"1.0\"?>")) {
                    sb.append(value);
                } else {
                    String nl = System.getProperty("line.separator");
                    sb.append("<?xml version=\"1.0\"?>\r\n");
                    sb.append(nl);
                    sb.append("<Net>");
                    sb.append(value);
                    sb.append(nl);
                    sb.append("</Net>");
                }
                InputSource is = new InputSource(new StringReader(sb.toString()));
                Document doc = builder.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getChildNodes();
                if (nList.getLength() != 1) {
                    throw new IllegalArgumentException("Invalid XML root node.");
                }
                nList = nList.item(0).getChildNodes();
                for (int pos = 0; pos < nList.getLength(); ++pos) {
                    Node it = nList.item(pos);
                    if (it.getNodeType() != 1) continue;
                    if ("Server".equalsIgnoreCase(it.getNodeName())) {
                        this.setServer(true);
                        continue;
                    }
                    if ("IP".equalsIgnoreCase(it.getNodeName())) {
                        this.setHostName(it.getFirstChild().getNodeValue());
                        continue;
                    }
                    if ("Port".equalsIgnoreCase(it.getNodeName())) {
                        this.setPort(Integer.parseInt(it.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (!"Protocol".equalsIgnoreCase(it.getNodeName())) continue;
                    this.setProtocol(NetworkType.values()[Integer.parseInt(it.getFirstChild().getNodeValue())]);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public final void copy(Object target) {
        GXNet tmp = (GXNet)target;
        this.setPort(tmp.getPort());
        this.setHostName(tmp.getHostName());
        this.setProtocol(tmp.getProtocol());
    }

    public final String getName() {
        String tmp = this.getHostName() + " " + this.getPort();
        tmp = this.getProtocol() == NetworkType.UDP ? tmp + "UDP" : tmp + "TCP/IP";
        return tmp;
    }

    public final String getMediaType() {
        return "Net";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getSynchronous() {
        GXNet gXNet = this;
        synchronized (gXNet) {
            int[] tmp = new int[]{this.synchronous};
            GXSync obj = new GXSync(tmp);
            this.synchronous = tmp[0];
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsSynchronous() {
        GXNet gXNet = this;
        synchronized (gXNet) {
            return this.synchronous != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetSynchronousBuffer() {
        Object object = this.syncBase.getSync();
        synchronized (object) {
            this.syncBase.resetReceivedSize();
        }
    }

    public final void validate() {
        if (this.getPort() == 0) {
            ResourceBundle bundle = ResourceBundle.getBundle("resources", this.locale);
            throw new RuntimeException(bundle.getString("InvalidPortName"));
        }
        if (this.getHostName() == null || "".equals(this.getHostName())) {
            ResourceBundle bundle = ResourceBundle.getBundle("resources", this.locale);
            throw new RuntimeException(bundle.getString("InvalidHostName"));
        }
    }

    public final Object getEop() {
        return this.eop;
    }

    public final void setEop(Object value) {
        this.eop = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(IGXMediaListener listener) {
        List<IGXNetListener> list = this.netListeners;
        synchronized (list) {
            this.listeners.add(listener);
            if (listener instanceof IGXNetListener) {
                this.netListeners.add((IGXNetListener)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(IGXMediaListener listener) {
        List<IGXNetListener> list = this.netListeners;
        synchronized (list) {
            this.listeners.remove(listener);
            if (listener instanceof IGXNetListener) {
                this.netListeners.remove((IGXNetListener)listener);
            }
        }
    }

    public int getReceiveDelay() {
        return this.receiveDelay;
    }

    public void setReceiveDelay(int value) {
        this.receiveDelay = value;
    }

    public int getAsyncWaitTime() {
        return this.asyncWaitTime;
    }

    public void setAsyncWaitTime(int value) {
        this.asyncWaitTime = value;
    }

    public Object getAsyncWaitHandle() {
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale value) {
        this.locale = value;
    }
}

