/*
 * Decompiled with CFR 0.152.
 */
package gurux.net;

import gurux.net.GXNet;
import gurux.net.enums.NetworkType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

class GXSettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean accepted;
    private GXNet target;
    private JButton cancelBtn;
    private JLabel ipAddressLbl;
    private JPanel ipAddressPanel;
    private JTextField ipAddressTB;
    private JButton okBtn;
    private JLabel portLbl;
    private JPanel portPanel;
    private JTextField portTB;
    private JComboBox<String> protocol;
    private JLabel protocolLbl;
    private JPanel protocolPanel;
    JLabel waittimeLbl = new JLabel();
    private JCheckBox serverCB;
    private JPanel serverPanel;
    private JPanel jPanel1;
    private JTextField WaittimeTB;

    GXSettings(Frame parent, boolean modal, GXNet comp, Locale locale) {
        super(parent, modal);
        super.setLocationRelativeTo(parent);
        this.initComponents();
        this.target = comp;
        String[] protocols = new String[]{"TCP/IP", "UDP"};
        this.protocol.setModel(new DefaultComboBoxModel<String>(protocols));
        this.ipAddressTB.setText(this.target.getHostName());
        this.portTB.setText(String.valueOf(this.target.getPort()));
        this.serverCB.setSelected(this.target.getServer());
        this.protocol.setSelectedItem(this.getProtocol(this.target.getProtocol()));
        this.WaittimeTB.setText(String.valueOf(this.target.getConnectionWaitTime()));
        ResourceBundle bundle = ResourceBundle.getBundle("resources", locale);
        this.setTitle(bundle.getString("SettingsTxt"));
        this.ipAddressLbl.setText(bundle.getString("HostNameTxt"));
        this.portLbl.setText(bundle.getString("PortTxt"));
        this.serverCB.setText(bundle.getString("ServerTxt"));
        this.protocolLbl.setText(bundle.getString("ProtocolTxt"));
        this.okBtn.setText(bundle.getString("OK"));
        this.cancelBtn.setText(bundle.getString("Cancel"));
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    final String getProtocol(NetworkType value) {
        if (value == NetworkType.UDP) {
            return "UDP";
        }
        return "TCP/IP";
    }

    final NetworkType getProtocol(String value) {
        if (value.equalsIgnoreCase("UDP")) {
            return NetworkType.UDP;
        }
        return NetworkType.TCP;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ipAddressPanel = new JPanel();
        this.ipAddressLbl = new JLabel();
        this.ipAddressTB = new JTextField();
        this.portPanel = new JPanel();
        this.portLbl = new JLabel();
        this.portTB = new JTextField();
        this.serverPanel = new JPanel();
        this.serverCB = new JCheckBox();
        this.protocolPanel = new JPanel();
        this.protocolLbl = new JLabel();
        this.protocol = new JComboBox();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.ipAddressPanel.setPreferredSize(new Dimension(298, 33));
        this.ipAddressLbl.setText("IP Address:");
        GroupLayout ipAddressPanelLayout = new GroupLayout(this.ipAddressPanel);
        this.ipAddressPanel.setLayout(ipAddressPanelLayout);
        ipAddressPanelLayout.setHorizontalGroup(ipAddressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ipAddressPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ipAddressLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.ipAddressTB, -2, 211, -2).addContainerGap()));
        ipAddressPanelLayout.setVerticalGroup(ipAddressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ipAddressPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(ipAddressPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipAddressLbl).addComponent(this.ipAddressTB, -2, -1, -2)).addGap(367, 367, 367)));
        this.portPanel.setPreferredSize(new Dimension(298, 35));
        this.portLbl.setText("Port:");
        GroupLayout portPanelLayout = new GroupLayout(this.portPanel);
        this.portPanel.setLayout(portPanelLayout);
        portPanelLayout.setHorizontalGroup(portPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(portPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.portLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.portTB, -2, 213, -2).addContainerGap()));
        portPanelLayout.setVerticalGroup(portPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, portPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(portPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLbl).addComponent(this.portTB, -2, -1, -2)).addContainerGap()));
        this.serverPanel.setPreferredSize(new Dimension(298, 35));
        this.serverCB.setText("Server");
        GroupLayout serverPanelLayout = new GroupLayout(this.serverPanel);
        this.serverPanel.setLayout(serverPanelLayout);
        serverPanelLayout.setHorizontalGroup(serverPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serverPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.serverCB).addContainerGap(-1, Short.MAX_VALUE)));
        serverPanelLayout.setVerticalGroup(serverPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, serverPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.serverCB).addContainerGap()));
        this.protocolPanel.setPreferredSize(new Dimension(218, 35));
        this.protocolLbl.setText("Protocol");
        this.protocol.setModel(new DefaultComboBoxModel<String>(new String[0]));
        GroupLayout protocolPanelLayout = new GroupLayout(this.protocolPanel);
        this.protocolPanel.setLayout(protocolPanelLayout);
        protocolPanelLayout.setHorizontalGroup(protocolPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(protocolPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.protocolLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.protocol, -2, 208, -2).addContainerGap()));
        protocolPanelLayout.setVerticalGroup(protocolPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, protocolPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(protocolPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.protocolLbl).addComponent(this.protocol, -2, -1, -2)).addContainerGap()));
        JPanel WaittimePanel = new JPanel();
        WaittimePanel.setPreferredSize(new Dimension(298, 35));
        this.waittimeLbl.setText("Wait time:");
        this.WaittimeTB = new JTextField();
        this.WaittimeTB.setText("0");
        GroupLayout gl_WaittimePanel = new GroupLayout(WaittimePanel);
        gl_WaittimePanel.setHorizontalGroup(gl_WaittimePanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 341, Short.MAX_VALUE).addGroup(gl_WaittimePanel.createSequentialGroup().addContainerGap().addComponent(this.waittimeLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addComponent(this.WaittimeTB, -2, 213, -2).addContainerGap()));
        gl_WaittimePanel.setVerticalGroup(gl_WaittimePanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGap(0, 42, Short.MAX_VALUE).addGroup(gl_WaittimePanel.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(gl_WaittimePanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.waittimeLbl).addComponent(this.WaittimeTB, -2, -1, -2)).addContainerGap()));
        WaittimePanel.setLayout(gl_WaittimePanel);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ipAddressPanel, -1, 341, Short.MAX_VALUE).addComponent(this.portPanel, -1, 341, Short.MAX_VALUE).addComponent(this.serverPanel, -1, 341, Short.MAX_VALUE).addComponent(this.protocolPanel, -1, 341, Short.MAX_VALUE).addComponent(WaittimePanel, -1, 351, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.serverPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ipAddressPanel, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portPanel, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocolPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(WaittimePanel, -2, 42, -2).addContainerGap(35, Short.MAX_VALUE)));
        this.jPanel1.setLayout(jPanel1Layout);
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                GXSettings.this.okBtnActionPerformed(evt);
            }
        });
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                GXSettings.this.cancelBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap(220, Short.MAX_VALUE).addComponent(this.okBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelBtn).addContainerGap()).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(11, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 234, -2).addGap(26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBtn).addComponent(this.okBtn)).addContainerGap()));
        this.getContentPane().setLayout(layout);
        this.pack();
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(this, stroke, 2);
        return rootPane;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.target.setHostName(this.ipAddressTB.getText());
            this.target.setPort(Integer.parseInt(this.portTB.getText()));
            this.target.setServer(this.serverCB.isSelected());
            this.target.setProtocol(this.getProtocol(this.protocol.getSelectedItem().toString()));
            this.target.setConnectionWaitTime(Integer.parseInt(this.WaittimeTB.getText()));
            this.target.validate();
            this.accepted = true;
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

