/*
 * Decompiled with CFR 0.152.
 */
package gurux.net;

import gurux.common.AutoResetEvent;
import gurux.net.ConnectionEventArgs;
import gurux.net.GXNet;
import gurux.net.ReceiveThread;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

class ListenerThread
extends Thread {
    private AutoResetEvent started = new AutoResetEvent(false);
    private final ServerSocket serverSocket;
    private GXNet parentMedia;

    ListenerThread(GXNet parent, Closeable socket) {
        super("GXNet " + socket.toString());
        this.parentMedia = parent;
        this.serverSocket = (ServerSocket)socket;
    }

    public boolean waitUntilRun() {
        return this.started.waitOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.started.set();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                boolean exist;
                Socket socket = null;
                socket = this.serverSocket.accept();
                List<Socket> list = this.parentMedia.getTcpIpClients();
                synchronized (list) {
                    this.parentMedia.getTcpIpClients().add(socket);
                }
                ConnectionEventArgs c = new ConnectionEventArgs(String.valueOf(socket.getRemoteSocketAddress()));
                this.parentMedia.notifyClientConnected(c);
                if (!c.getAccept()) {
                    List<Socket> list2 = this.parentMedia.getTcpIpClients();
                    synchronized (list2) {
                        this.parentMedia.getTcpIpClients().remove(socket);
                    }
                    socket.sendUrgentData(0);
                    socket.shutdownInput();
                    socket.close();
                    continue;
                }
                List<Socket> list3 = this.parentMedia.getTcpIpClients();
                synchronized (list3) {
                    exist = this.parentMedia.getTcpIpClients().contains(socket);
                }
                if (!exist) continue;
                ReceiveThread receiver = new ReceiveThread(this.parentMedia, socket);
                receiver.start();
            }
            catch (IOException ex) {
                if (Thread.currentThread().isInterrupted()) continue;
                this.parentMedia.notifyError(new RuntimeException(ex.getMessage()));
            }
        }
    }
}

