/*
 * Decompiled with CFR 0.152.
 */
package gurux.net;

import gurux.common.AutoResetEvent;
import gurux.common.GXSynchronousMediaBase;
import gurux.common.ReceiveEventArgs;
import gurux.common.TraceEventArgs;
import gurux.common.enums.TraceLevel;
import gurux.common.enums.TraceTypes;
import gurux.net.ConnectionEventArgs;
import gurux.net.GXNet;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;

class ReceiveThread
extends Thread {
    private AutoResetEvent started = new AutoResetEvent(false);
    private final Closeable socket;
    private GXNet parentMedia;
    private byte[] buffer = null;
    private long bytesReceived = 0L;
    byte[] receiveBuffer = new byte[1518];
    public static final int RECEIVE_BUFFER_SIZE = 1518;

    ReceiveThread(GXNet parent, Closeable s) {
        super("GXNet " + s.toString());
        this.parentMedia = parent;
        this.socket = s;
        this.buffer = new byte[1518];
    }

    public final long getBytesReceived() {
        return this.bytesReceived;
    }

    public final void resetBytesReceived() {
        this.bytesReceived = 0L;
    }

    public boolean waitUntilRun() {
        return this.started.waitOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReceivedData(int length, String info) {
        if (length == 0) {
            return;
        }
        Object eop = this.parentMedia.getEop();
        this.bytesReceived += (long)length;
        int totalCount = 0;
        if (this.parentMedia.getIsSynchronous()) {
            TraceEventArgs arg = null;
            Object object = this.parentMedia.getSyncBase().getSync();
            synchronized (object) {
                this.parentMedia.getSyncBase().appendData(this.buffer, 0, length);
                if (eop != null) {
                    if (eop instanceof Array) {
                        Object it;
                        Object[] objectArray = (Object[])eop;
                        int n = objectArray.length;
                        for (int i = 0; i < n && (totalCount = GXSynchronousMediaBase.indexOf((byte[])this.buffer, (byte[])GXSynchronousMediaBase.getAsByteArray((Object)(it = objectArray[i])), (int)0, (int)length)) == -1; ++i) {
                        }
                    } else {
                        totalCount = GXSynchronousMediaBase.indexOf((byte[])this.buffer, (byte[])GXSynchronousMediaBase.getAsByteArray((Object)eop), (int)0, (int)length);
                    }
                }
                if (totalCount != -1) {
                    if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
                        arg = new TraceEventArgs(TraceTypes.RECEIVED, this.buffer, 0, totalCount + 1);
                    }
                    this.parentMedia.getSyncBase().setReceived();
                }
            }
            if (arg != null) {
                this.parentMedia.notifyTrace(arg);
            }
        } else {
            this.parentMedia.getSyncBase().resetReceivedSize();
            byte[] data = new byte[length];
            System.arraycopy(this.buffer, 0, data, 0, length);
            if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
                this.parentMedia.notifyTrace(new TraceEventArgs(TraceTypes.RECEIVED, (Object)data));
            }
            ReceiveEventArgs e = new ReceiveEventArgs((Object)data, info);
            this.parentMedia.notifyReceived(e);
        }
    }

    private boolean handleTCP(Socket s) throws IOException, InterruptedException {
        DataInputStream in = new DataInputStream(s.getInputStream());
        int count = in.read(this.buffer, 0, 1);
        if (count == -1) {
            in.close();
            return false;
        }
        Thread.sleep(this.parentMedia.getReceiveDelay());
        while (in.available() != 0) {
            int cnt = in.available();
            if (count + cnt > this.buffer.length) {
                cnt = this.buffer.length - count;
            }
            if ((count += in.read(this.buffer, count, cnt)) != this.buffer.length) continue;
            this.handleReceivedData(count, s.getRemoteSocketAddress().toString());
            count = 0;
        }
        this.handleReceivedData(count, s.getRemoteSocketAddress().toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.started.set();
        if (this.socket instanceof Socket) {
            Socket s = (Socket)this.socket;
            String info = String.valueOf(s.getRemoteSocketAddress());
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.handleTCP(s)) continue;
                }
                catch (SocketException e) {
                    if (this.parentMedia.getServer()) {
                        List<Socket> list = this.parentMedia.getTcpIpClients();
                        synchronized (list) {
                            this.parentMedia.getTcpIpClients().remove(s);
                        }
                        this.parentMedia.notifyClientDisconnected(new ConnectionEventArgs(info));
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        this.parentMedia.notifyError(new RuntimeException(e.getMessage()));
                        this.parentMedia.close();
                    }
                }
                catch (IOException e) {
                    if (!Thread.currentThread().isInterrupted()) {
                        this.parentMedia.notifyError(new RuntimeException(e.getMessage()));
                    }
                }
                catch (InterruptedException e) {}
                break;
            }
        } else {
            DatagramPacket receivePacket = new DatagramPacket(this.buffer, this.buffer.length);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ((DatagramSocket)this.socket).receive(receivePacket);
                    InetSocketAddress socketAddress = (InetSocketAddress)receivePacket.getSocketAddress();
                    String address = socketAddress.getHostName() + ":" + String.valueOf(socketAddress.getPort());
                    this.handleReceivedData(receivePacket.getLength(), address);
                }
                catch (SocketException e) {
                    break;
                }
                catch (IOException ex) {
                    if (Thread.currentThread().isInterrupted()) continue;
                    this.parentMedia.notifyError(new RuntimeException(ex.getMessage()));
                }
            }
        }
    }
}

