/*
 * Decompiled with CFR 0.152.
 */
package gurux.serial;

import gurux.common.GXSynchronousMediaBase;
import gurux.common.ReceiveEventArgs;
import gurux.common.TraceEventArgs;
import gurux.common.enums.TraceLevel;
import gurux.common.enums.TraceTypes;
import gurux.io.NativeCode;
import gurux.serial.GXSerial;
import java.lang.reflect.Array;

class GXReceiveThread
extends Thread {
    static final int WAIT_TIME = 200;
    private long comPort;
    private final GXSerial parentMedia;
    private long bytesReceived = 0L;

    GXReceiveThread(GXSerial parent, long hComPort) {
        super("GXSerial " + String.valueOf(hComPort));
        this.comPort = hComPort;
        this.parentMedia = parent;
    }

    public final long getBytesReceived() {
        return this.bytesReceived;
    }

    public final void resetBytesReceived() {
        this.bytesReceived = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReceivedData(byte[] buffer) {
        Object object;
        int len = buffer.length;
        if (len == 0) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception ex) {
                return;
            }
            return;
        }
        this.bytesReceived += (long)len;
        int totalCount = 0;
        Object object2 = this.parentMedia.getSyncBase().getSync();
        synchronized (object2) {
            this.parentMedia.getSyncBase().appendData(buffer, 0, len);
            if (this.parentMedia.getEop() != null) {
                if (this.parentMedia.getEop() instanceof Array) {
                    Object eop;
                    object = (Object[])this.parentMedia.getEop();
                    int n = ((Object[])object).length;
                    for (int i = 0; i < n && (totalCount = GXSynchronousMediaBase.indexOf((byte[])buffer, (byte[])GXSynchronousMediaBase.getAsByteArray((Object)(eop = object[i])), (int)0, (int)len)) == -1; ++i) {
                    }
                } else {
                    totalCount = GXSynchronousMediaBase.indexOf((byte[])buffer, (byte[])GXSynchronousMediaBase.getAsByteArray((Object)this.parentMedia.getEop()), (int)0, (int)len);
                }
            }
        }
        if (this.parentMedia.getIsSynchronous()) {
            TraceEventArgs arg = null;
            object = this.parentMedia.getSyncBase().getSync();
            synchronized (object) {
                if (totalCount != -1) {
                    if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
                        arg = new TraceEventArgs(TraceTypes.RECEIVED, buffer, 0, totalCount + 1);
                    }
                    this.parentMedia.getSyncBase().setReceived();
                }
            }
            if (arg != null) {
                this.parentMedia.notifyTrace(arg);
            }
        } else if (totalCount != -1) {
            byte[] data = this.parentMedia.getSyncBase().getReceivedData();
            this.parentMedia.getSyncBase().resetReceivedSize();
            if (this.parentMedia.getTrace() == TraceLevel.VERBOSE) {
                this.parentMedia.notifyTrace(new TraceEventArgs(TraceTypes.RECEIVED, (Object)data));
            }
            ReceiveEventArgs e = new ReceiveEventArgs((Object)data, this.parentMedia.getPortName());
            this.parentMedia.notifyReceived(e);
        }
    }

    @Override
    public final void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                byte[] buff = NativeCode.read((long)this.comPort, (int)this.parentMedia.getReadTimeout(), (long)this.parentMedia.getClosing());
                if (buff.length == 0 && Thread.currentThread().isInterrupted()) {
                    this.parentMedia.setClosing(0L);
                    break;
                }
                Thread.sleep(this.parentMedia.getReceiveDelay());
                byte[] buff2 = null;
                try {
                    if (NativeCode.getBytesToRead((long)this.comPort) != 0) {
                        buff2 = NativeCode.read((long)this.comPort, (int)1, (long)this.parentMedia.getClosing());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (buff2 != null && buff2.length != 0) {
                    byte[] tmp = new byte[buff.length + buff2.length];
                    System.arraycopy(buff, 0, tmp, 0, buff.length);
                    System.arraycopy(buff2, 0, tmp, buff.length, buff2.length);
                    this.handleReceivedData(tmp);
                    continue;
                }
                this.handleReceivedData(buff);
            }
            catch (Exception ex) {
                if (Thread.currentThread().isInterrupted()) break;
                this.parentMedia.notifyError(new RuntimeException(ex.getMessage()));
            }
        }
    }
}

