/*
 * Decompiled with CFR 0.152.
 */
package gurux.serial;

import gurux.common.GXCommon;
import gurux.common.GXSync;
import gurux.common.GXSynchronousMediaBase;
import gurux.common.IGXMedia;
import gurux.common.IGXMedia2;
import gurux.common.IGXMediaListener;
import gurux.common.MediaStateEventArgs;
import gurux.common.PropertyChangedEventArgs;
import gurux.common.ReceiveEventArgs;
import gurux.common.ReceiveParameters;
import gurux.common.TraceEventArgs;
import gurux.common.enums.MediaState;
import gurux.common.enums.TraceLevel;
import gurux.common.enums.TraceTypes;
import gurux.io.BaudRate;
import gurux.io.Handshake;
import gurux.io.NativeCode;
import gurux.io.Parity;
import gurux.io.StopBits;
import gurux.serial.GXReceiveThread;
import gurux.serial.GXSettings;
import gurux.serial.enums.AvailableMediaSettings;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GXSerial
implements IGXMedia,
IGXMedia2,
AutoCloseable {
    private int receiveDelay;
    private int asyncWaitTime;
    static final int DEFUALT_READ_BUFFER_SIZE = 256;
    static final int DEFAULT_DATA_BITS = 8;
    private BaudRate baudRate = BaudRate.BAUD_RATE_9600;
    private int dataBits = 8;
    private StopBits stopBits = StopBits.ONE;
    private Parity parity = Parity.NONE;
    private long closing = 0L;
    private int writeTimeout;
    private int readTimeout;
    private static boolean initialized;
    private int readBufferSize;
    private GXReceiveThread receiver;
    private int hWnd;
    private String portName;
    private GXSynchronousMediaBase syncBase;
    private long bytesSend = 0L;
    private int synchronous = 0;
    private TraceLevel trace = TraceLevel.OFF;
    private Object eop;
    private int configurableSettings;
    private List<IGXMediaListener> mediaListeners = new ArrayList<IGXMediaListener>();

    public GXSerial() {
        GXSerial.initialize();
        this.readBufferSize = 256;
        this.syncBase = new GXSynchronousMediaBase(this.readBufferSize);
        this.setConfigurableSettings(AvailableMediaSettings.ALL.getValue());
    }

    public GXSerial(String port, BaudRate baudRateValue, int dataBitsValue, Parity parityValue, StopBits stopBitsValue) {
        GXSerial.initialize();
        this.readBufferSize = 256;
        this.syncBase = new GXSynchronousMediaBase(this.readBufferSize);
        this.setConfigurableSettings(AvailableMediaSettings.ALL.getValue());
        this.setPortName(port);
        this.setBaudRate(baudRateValue);
        this.setDataBits(dataBitsValue);
        this.setParity(parityValue);
        this.setStopBits(stopBitsValue);
    }

    final GXSynchronousMediaBase getSyncBase() {
        return this.syncBase;
    }

    final long getClosing() {
        return this.closing;
    }

    final void setClosing(long value) {
        this.closing = value;
    }

    static boolean isWindows(String os) {
        return os.indexOf("win") >= 0;
    }

    static boolean isMac(String os) {
        return os.indexOf("mac") >= 0;
    }

    static boolean isUnix(String os) {
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0;
    }

    static boolean isSolaris(String os) {
        return os.indexOf("sunos") >= 0;
    }

    private static void initialize() {
        if (!initialized) {
            File file;
            String path;
            String os = System.getProperty("os.name").toLowerCase();
            boolean is32Bit = System.getProperty("sun.arch.data.model").equals("32");
            if (GXSerial.isWindows(os)) {
                path = is32Bit ? "win32" : "win64";
            } else if (GXSerial.isUnix(os)) {
                String str = System.getProperty("os.arch");
                path = str.indexOf("aarch64") != -1 ? "aarch64" : (str.indexOf("arm") != -1 ? (is32Bit ? "linux32Arm" : "linux64Arm") : (is32Bit ? "linux86Amd" : "linux64Amd"));
            } else {
                throw new RuntimeException("Invald operating system. " + os);
            }
            try {
                file = File.createTempFile("gurux.serial.java", ".dll");
            }
            catch (IOException e1) {
                throw new RuntimeException("Failed to load file. " + path + "/gurux.serial.java");
            }
            try (InputStream in = GXSerial.class.getResourceAsStream("/" + path + "/" + System.mapLibraryName("gurux.serial.java"));){
                Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.load(file.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load file. " + path + "/gurux.serial.java" + e.toString());
            }
        }
    }

    public static String[] getPortNames() {
        GXSerial.initialize();
        return NativeCode.getPortNames();
    }

    public static final BaudRate[] getAvailableBaudRates(String portName) {
        return new BaudRate[]{BaudRate.BAUD_RATE_300, BaudRate.BAUD_RATE_600, BaudRate.BAUD_RATE_1800, BaudRate.BAUD_RATE_2400, BaudRate.BAUD_RATE_4800, BaudRate.BAUD_RATE_9600, BaudRate.BAUD_RATE_19200, BaudRate.BAUD_RATE_38400};
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        if (this.isOpen()) {
            this.close();
        }
    }

    public final TraceLevel getTrace() {
        return this.trace;
    }

    public final void setTrace(TraceLevel value) {
        this.trace = value;
        this.syncBase.setTrace(value);
    }

    private void notifyPropertyChanged(String info) {
        for (IGXMediaListener listener : this.mediaListeners) {
            listener.onPropertyChanged((Object)this, new PropertyChangedEventArgs(info));
        }
    }

    final void notifyError(RuntimeException ex) {
        for (IGXMediaListener listener : this.mediaListeners) {
            listener.onError((Object)this, (Exception)ex);
            if (this.trace.ordinal() < TraceLevel.ERROR.ordinal()) continue;
            listener.onTrace((Object)this, new TraceEventArgs(TraceTypes.ERROR, (Object)ex));
        }
    }

    final void notifyReceived(ReceiveEventArgs e) {
        for (IGXMediaListener listener : this.mediaListeners) {
            listener.onReceived((Object)this, e);
        }
    }

    final void notifyTrace(TraceEventArgs e) {
        for (IGXMediaListener listener : this.mediaListeners) {
            listener.onTrace((Object)this, e);
        }
    }

    public final int getConfigurableSettings() {
        return this.configurableSettings;
    }

    public final void setConfigurableSettings(int value) {
        this.configurableSettings = value;
    }

    public final boolean properties(JFrame parent) {
        GXSettings dlg = new GXSettings((Frame)parent, true, this);
        dlg.pack();
        dlg.setVisible(true);
        return dlg.isAccepted();
    }

    public final void aboutBox() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(Object data, String target) throws Exception {
        if (this.hWnd == 0) {
            throw new RuntimeException("Serial port is not open.");
        }
        if (this.trace == TraceLevel.VERBOSE) {
            this.notifyTrace(new TraceEventArgs(TraceTypes.SENT, data));
        }
        Object object = this.syncBase.getSync();
        synchronized (object) {
            this.syncBase.resetLastPosition();
        }
        byte[] buff = GXSynchronousMediaBase.getAsByteArray((Object)data);
        if (buff == null) {
            throw new IllegalArgumentException("Data send failed. Invalid data.");
        }
        NativeCode.write((long)this.hWnd, (byte[])buff, (int)this.writeTimeout);
        this.bytesSend += (long)buff.length;
    }

    private void notifyMediaStateChange(MediaState state) {
        for (IGXMediaListener listener : this.mediaListeners) {
            if (this.trace.ordinal() >= TraceLevel.ERROR.ordinal()) {
                listener.onTrace((Object)this, new TraceEventArgs(TraceTypes.INFO, (Object)state));
            }
            listener.onMediaStateChange((Object)this, new MediaStateEventArgs(state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() throws Exception {
        this.close();
        try {
            if (this.portName == null || this.portName == "") {
                throw new IllegalArgumentException("Serial port is not selected.");
            }
            Object object = this.syncBase.getSync();
            synchronized (object) {
                this.syncBase.resetLastPosition();
            }
            this.notifyMediaStateChange(MediaState.OPENING);
            if (this.trace.ordinal() >= TraceLevel.INFO.ordinal()) {
                String eopString = "None";
                if (this.getEop() instanceof byte[]) {
                    eopString = GXCommon.bytesToHex((byte[])((byte[])this.getEop()));
                } else if (this.getEop() != null) {
                    eopString = this.getEop().toString();
                }
                this.notifyTrace(new TraceEventArgs(TraceTypes.INFO, (Object)("Settings: Port: " + this.getPortName() + " Baud Rate: " + this.getBaudRate() + " Data Bits: " + String.valueOf(this.getDataBits()) + " Parity: " + String.valueOf(this.getParity()) + " Stop Bits: " + String.valueOf(this.getStopBits()) + " Eop:" + eopString)));
            }
            long[] tmp = new long[1];
            this.hWnd = NativeCode.openSerialPort((String)this.portName, (long[])tmp);
            if (this.baudRate != BaudRate.BAUD_RATE_9600) {
                this.setBaudRate(this.baudRate);
            }
            if (this.dataBits != 8) {
                this.setDataBits(this.dataBits);
            }
            if (this.parity != Parity.NONE) {
                this.setParity(this.parity);
            }
            if (this.stopBits != StopBits.ONE) {
                this.setStopBits(this.stopBits);
            }
            this.closing = tmp[0];
            this.setRtsEnable(true);
            this.setDtrEnable(true);
            this.receiver = new GXReceiveThread(this, this.hWnd);
            this.receiver.start();
            this.notifyMediaStateChange(MediaState.OPEN);
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public final void close() {
        if (this.hWnd != 0) {
            if (this.receiver != null) {
                this.receiver.interrupt();
                this.receiver = null;
            }
            try {
                this.notifyMediaStateChange(MediaState.CLOSING);
            }
            catch (RuntimeException ex) {
                this.notifyError(ex);
                throw ex;
            }
            finally {
                try {
                    NativeCode.closeSerialPort((long)this.hWnd, (long)this.closing);
                }
                catch (Exception exception) {}
                this.hWnd = 0;
                this.notifyMediaStateChange(MediaState.CLOSED);
                this.bytesSend = 0L;
                this.syncBase.resetReceivedSize();
            }
        }
    }

    public final BaudRate getBaudRate() {
        if (this.hWnd == 0) {
            return this.baudRate;
        }
        return BaudRate.forValue((int)NativeCode.getBaudRate((long)this.hWnd));
    }

    public final void setBaudRate(BaudRate value) {
        boolean change;
        boolean bl = change = this.getBaudRate() != value;
        if (change) {
            if (this.hWnd == 0) {
                this.baudRate = value;
            } else {
                NativeCode.setBaudRate((long)this.hWnd, (int)value.getValue());
            }
            this.notifyPropertyChanged("BaudRate");
        }
    }

    public final boolean getBreakState() {
        return NativeCode.getBreakState((long)this.hWnd);
    }

    public final void setBreakState(boolean value) {
        boolean change;
        boolean bl = change = this.getBreakState() != value;
        if (change) {
            NativeCode.setBreakState((long)this.hWnd, (boolean)value);
            this.notifyPropertyChanged("BreakState");
        }
    }

    public final int getBytesToRead() {
        return NativeCode.getBytesToRead((long)this.hWnd);
    }

    public final int getBytesToWrite() {
        return NativeCode.getBytesToWrite((long)this.hWnd);
    }

    public final boolean getCDHolding() {
        return NativeCode.getCDHolding((long)this.hWnd);
    }

    public final boolean getCtsHolding() {
        return NativeCode.getCtsHolding((long)this.hWnd);
    }

    public final int getDataBits() {
        if (this.hWnd == 0) {
            return this.dataBits;
        }
        return NativeCode.getDataBits((long)this.hWnd);
    }

    public final void setDataBits(int value) {
        boolean change;
        boolean bl = change = this.getDataBits() != value;
        if (change) {
            if (this.hWnd == 0) {
                this.dataBits = value;
            } else {
                NativeCode.setDataBits((long)this.hWnd, (int)value);
            }
            this.notifyPropertyChanged("DataBits");
        }
    }

    public final boolean getDsrHolding() {
        return NativeCode.getDsrHolding((long)this.hWnd);
    }

    public final boolean getDtrEnable() {
        return NativeCode.getDtrEnable((long)this.hWnd);
    }

    public final void setDtrEnable(boolean value) {
        boolean change = this.getDtrEnable() != value;
        NativeCode.setDtrEnable((long)this.hWnd, (boolean)value);
        if (change) {
            this.notifyPropertyChanged("DtrEnable");
        }
    }

    public final Handshake getHandshake() {
        return Handshake.values()[NativeCode.getHandshake((long)this.hWnd)];
    }

    public final void setHandshake(Handshake value) {
        boolean change;
        boolean bl = change = this.getHandshake() != value;
        if (change) {
            NativeCode.setHandshake((long)this.hWnd, (int)value.ordinal());
            this.notifyPropertyChanged("Handshake");
        }
    }

    public final boolean isOpen() {
        return this.hWnd != 0;
    }

    public final Parity getParity() {
        if (this.hWnd == 0) {
            return this.parity;
        }
        return Parity.values()[NativeCode.getParity((long)this.hWnd)];
    }

    public final void setParity(Parity value) {
        boolean change;
        boolean bl = change = this.getParity() != value;
        if (change) {
            if (this.hWnd == 0) {
                this.parity = value;
            } else {
                NativeCode.setParity((long)this.hWnd, (int)value.ordinal());
            }
            this.notifyPropertyChanged("Parity");
        }
    }

    public final String getPortName() {
        return this.portName;
    }

    public final void setPortName(String value) {
        boolean change = !value.equals(this.portName);
        this.portName = value;
        if (change) {
            this.notifyPropertyChanged("PortName");
        }
    }

    public final int getReadBufferSize() {
        return this.readBufferSize;
    }

    public final void setReadBufferSize(int value) {
        boolean change;
        boolean bl = change = this.getReadBufferSize() != value;
        if (change) {
            this.readBufferSize = value;
            this.notifyPropertyChanged("ReadBufferSize");
        }
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(int value) {
        boolean change = this.readTimeout != value;
        this.readTimeout = value;
        if (change) {
            this.notifyPropertyChanged("ReadTimeout");
        }
    }

    public final boolean getRtsEnable() {
        return NativeCode.getRtsEnable((long)this.hWnd);
    }

    public final void setRtsEnable(boolean value) {
        boolean change = this.getRtsEnable() != value;
        NativeCode.setRtsEnable((long)this.hWnd, (boolean)value);
        if (change) {
            this.notifyPropertyChanged("RtsEnable");
        }
    }

    public final StopBits getStopBits() {
        if (this.hWnd == 0) {
            return this.stopBits;
        }
        return StopBits.values()[NativeCode.getStopBits((long)this.hWnd)];
    }

    public final void setStopBits(StopBits value) {
        boolean change;
        boolean bl = change = this.getStopBits() != value;
        if (change) {
            if (this.hWnd == 0) {
                this.stopBits = value;
            } else {
                NativeCode.setStopBits((long)this.hWnd, (int)value.ordinal());
            }
            this.notifyPropertyChanged("StopBits");
        }
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final void setWriteTimeout(int value) {
        boolean change;
        boolean bl = change = this.writeTimeout != value;
        if (change) {
            this.writeTimeout = value;
            this.notifyPropertyChanged("WriteTimeout");
        }
    }

    public final <T> boolean receive(ReceiveParameters<T> args) {
        return this.syncBase.receive(args);
    }

    public final long getBytesSent() {
        return this.bytesSend;
    }

    public final long getBytesReceived() {
        return this.receiver.getBytesReceived();
    }

    public final void resetByteCounters() {
        this.bytesSend = 0L;
        this.receiver.resetBytesReceived();
    }

    public final String getSettings() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        if (this.portName != null && !this.portName.isEmpty()) {
            sb.append("<Port>");
            sb.append(this.portName);
            sb.append("</Port>");
            sb.append(nl);
        }
        if (this.baudRate != BaudRate.BAUD_RATE_9600) {
            sb.append("<BaudRate>");
            sb.append(String.valueOf(this.baudRate.getValue()));
            sb.append("</BaudRate>");
            sb.append(nl);
        }
        if (this.stopBits != StopBits.ONE) {
            sb.append("<StopBits>");
            sb.append(String.valueOf(this.stopBits.ordinal()));
            sb.append("</StopBits>");
            sb.append(nl);
        }
        if (this.parity != Parity.NONE) {
            sb.append("<Parity>");
            sb.append(String.valueOf(this.parity.ordinal()));
            sb.append("</Parity>");
            sb.append(nl);
        }
        if (this.dataBits != 8) {
            sb.append("<DataBits>");
            sb.append(String.valueOf(this.dataBits));
            sb.append("</DataBits>");
            sb.append(nl);
        }
        return sb.toString();
    }

    public final void setSettings(String value) {
        this.portName = "";
        this.baudRate = BaudRate.BAUD_RATE_9600;
        this.stopBits = StopBits.ONE;
        this.parity = Parity.NONE;
        this.dataBits = 8;
        if (value != null && !value.isEmpty()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringBuilder sb = new StringBuilder();
                if (value.startsWith("<?xml version=\"1.0\"?>")) {
                    sb.append(value);
                } else {
                    String nl = System.getProperty("line.separator");
                    sb.append("<?xml version=\"1.0\"?>\r\n");
                    sb.append(nl);
                    sb.append("<Net>");
                    sb.append(value);
                    sb.append(nl);
                    sb.append("</Net>");
                }
                InputSource is = new InputSource(new StringReader(sb.toString()));
                Document doc = builder.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getChildNodes();
                if (nList.getLength() != 1) {
                    throw new IllegalArgumentException("Invalid XML root node.");
                }
                nList = nList.item(0).getChildNodes();
                for (int pos = 0; pos < nList.getLength(); ++pos) {
                    Node it = nList.item(pos);
                    if (it.getNodeType() != 1) continue;
                    if ("Port".equalsIgnoreCase(it.getNodeName())) {
                        this.setPortName(it.getFirstChild().getNodeValue());
                        continue;
                    }
                    if ("BaudRate".equalsIgnoreCase(it.getNodeName())) {
                        this.setBaudRate(BaudRate.forValue((int)Integer.parseInt(it.getFirstChild().getNodeValue())));
                        continue;
                    }
                    if ("StopBits".equalsIgnoreCase(it.getNodeName())) {
                        this.setStopBits(StopBits.values()[Integer.parseInt(it.getFirstChild().getNodeValue())]);
                        continue;
                    }
                    if ("Parity".equalsIgnoreCase(it.getNodeName())) {
                        this.setParity(Parity.values()[Integer.parseInt(it.getFirstChild().getNodeValue())]);
                        continue;
                    }
                    if (!"DataBits".equalsIgnoreCase(it.getNodeName())) continue;
                    this.setDataBits(Integer.parseInt(it.getFirstChild().getNodeValue()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public final void copy(Object target) {
        GXSerial tmp = (GXSerial)target;
        this.setPortName(tmp.getPortName());
        this.setBaudRate(tmp.getBaudRate());
        this.setStopBits(tmp.getStopBits());
        this.setParity(tmp.getParity());
        this.setDataBits(tmp.getDataBits());
    }

    public final String getName() {
        return this.getPortName();
    }

    public final String getMediaType() {
        return "Serial";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getSynchronous() {
        GXSerial gXSerial = this;
        synchronized (gXSerial) {
            int[] tmp = new int[]{this.synchronous};
            GXSync obj = new GXSync(tmp);
            this.synchronous = tmp[0];
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getIsSynchronous() {
        GXSerial gXSerial = this;
        synchronized (gXSerial) {
            return this.synchronous != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetSynchronousBuffer() {
        Object object = this.syncBase.getSync();
        synchronized (object) {
            this.syncBase.resetReceivedSize();
        }
    }

    public final void validate() {
        if (this.getPortName() == null || this.getPortName().length() == 0) {
            throw new RuntimeException("Invalid port name.");
        }
    }

    public final Object getEop() {
        return this.eop;
    }

    public final void setEop(Object value) {
        this.eop = value;
    }

    public final void addListener(IGXMediaListener listener) {
        this.mediaListeners.add(listener);
    }

    public final void removeListener(IGXMediaListener listener) {
        this.mediaListeners.remove(listener);
    }

    public int getReceiveDelay() {
        return this.receiveDelay;
    }

    public void setReceiveDelay(int value) {
        this.receiveDelay = value;
    }

    public int getAsyncWaitTime() {
        return this.asyncWaitTime;
    }

    public void setAsyncWaitTime(int value) {
        this.asyncWaitTime = value;
    }

    public Object getAsyncWaitHandle() {
        return null;
    }
}

