/*
 * Decompiled with CFR 0.152.
 */
package gurux.terminal;

import gurux.io.BaudRate;
import gurux.io.Parity;
import gurux.io.StopBits;
import gurux.terminal.GXTerminal;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

class GXSettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean accepted;
    private final GXTerminal target;
    private JComboBox<String> baudRateCB;
    private JLabel baudRateLbl;
    private JPanel baudRatePanel;
    private JButton cancelBtn;
    private JComboBox<String> dataBitsCB;
    private JLabel dataBitsLbl;
    private JPanel dataBitsPanel;
    private JButton okBtn;
    private JPanel pinCodePanel;
    private JTextField pinCodeTB;
    private JComboBox<String> parityCB;
    private JLabel parityLbl;
    private JPanel parityPanel;
    private JLabel phoneNumberLbl;
    private JLabel pinCodeLbl;
    private JPanel phoneNumberPanel;
    private JTextField phoneNumberTB;
    private JComboBox<String> portCB;
    private JLabel portLbl;
    private JPanel portPanel;
    private JComboBox<String> stopBitsCB;
    private JLabel stopBitsLbl;
    private JPanel stopBitsPanel;
    private JPanel jPanel1;

    GXSettings(Frame parent, boolean modal, GXTerminal comp) {
        super(parent, modal);
        super.setLocationRelativeTo(parent);
        this.initComponents();
        this.target = comp;
        String[] ports = GXTerminal.getPortNames();
        this.portCB.setModel(new DefaultComboBoxModel<String>(ports));
        BaudRate[] rates = GXTerminal.getAvailableBaudRates(null);
        this.baudRateCB.setModel(new DefaultComboBoxModel<String>(this.getStrings(rates)));
        int[] dataBits = new int[]{7, 8};
        this.dataBitsCB.setModel(new DefaultComboBoxModel<String>(this.getStrings(dataBits)));
        String[] parity = new String[]{"None", "Odd", "Even", "Mark", "Space"};
        this.parityCB.setModel(new DefaultComboBoxModel<String>(parity));
        String[] stopBits = new String[]{"One", "One_Point_Five", "Two"};
        this.stopBitsCB.setModel(new DefaultComboBoxModel<String>(stopBits));
        this.phoneNumberTB.setText(this.target.getPhoneNumber());
        this.pinCodeTB.setText(this.target.getPINCode());
        this.portCB.setSelectedItem(this.target.getPortName());
        this.baudRateCB.setSelectedItem(String.valueOf(this.target.getBaudRate()));
        this.dataBitsCB.setSelectedItem(String.valueOf(this.target.getDataBits()));
        this.parityCB.setSelectedItem(this.findParity(this.target.getParity()));
        this.stopBitsCB.setSelectedItem(this.findStopBit(this.target.getStopBits()));
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    final String findStopBit(StopBits stopBits) {
        switch (stopBits) {
            case ONE: {
                return "One";
            }
            case TWO: {
                return "Two";
            }
            case ONE_POINT_FIVE: {
                return "One_Point_Five";
            }
        }
        return "";
    }

    final String findParity(Parity parity) {
        switch (parity) {
            case NONE: {
                return "None";
            }
            case ODD: {
                return "Odd";
            }
            case EVEN: {
                return "Even";
            }
            case MARK: {
                return "Mark";
            }
            case SPACE: {
                return "Space";
            }
        }
        return "";
    }

    final String[] getStrings(BaudRate[] list) {
        String[] tmp = new String[list.length];
        int pos = 0;
        for (BaudRate it : list) {
            tmp[pos] = String.valueOf(it.getValue());
            ++pos;
        }
        return tmp;
    }

    final String[] getStrings(int[] list) {
        String[] tmp = new String[list.length];
        int pos = 0;
        for (int it : list) {
            tmp[pos] = String.valueOf(it);
            ++pos;
        }
        return tmp;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.phoneNumberPanel = new JPanel();
        this.phoneNumberLbl = new JLabel();
        this.phoneNumberTB = new JTextField();
        this.pinCodePanel = new JPanel();
        this.pinCodeLbl = new JLabel();
        this.pinCodeTB = new JTextField();
        this.portPanel = new JPanel();
        this.portLbl = new JLabel();
        this.portCB = new JComboBox();
        this.baudRatePanel = new JPanel();
        this.baudRateLbl = new JLabel();
        this.baudRateCB = new JComboBox();
        this.dataBitsPanel = new JPanel();
        this.dataBitsLbl = new JLabel();
        this.dataBitsCB = new JComboBox();
        this.parityPanel = new JPanel();
        this.parityLbl = new JLabel();
        this.parityCB = new JComboBox();
        this.stopBitsPanel = new JPanel();
        this.stopBitsLbl = new JLabel();
        this.stopBitsCB = new JComboBox();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.phoneNumberPanel.setPreferredSize(new Dimension(298, 33));
        this.phoneNumberLbl.setText("Phone Number:");
        GroupLayout PhoneNumberPanelLayout = new GroupLayout(this.phoneNumberPanel);
        this.phoneNumberPanel.setLayout(PhoneNumberPanelLayout);
        PhoneNumberPanelLayout.setHorizontalGroup(PhoneNumberPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PhoneNumberPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.phoneNumberLbl).addGap(18, 18, 18).addComponent(this.phoneNumberTB, -2, 211, -2).addContainerGap(-1, Short.MAX_VALUE)));
        PhoneNumberPanelLayout.setVerticalGroup(PhoneNumberPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PhoneNumberPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(PhoneNumberPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phoneNumberLbl).addComponent(this.phoneNumberTB, -2, -1, -2)).addGap(367, 367, 367)));
        this.pinCodePanel.setPreferredSize(new Dimension(298, 35));
        this.pinCodeLbl.setText("PIN Code:");
        GroupLayout PINCodePanelLayout = new GroupLayout(this.pinCodePanel);
        this.pinCodePanel.setLayout(PINCodePanelLayout);
        PINCodePanelLayout.setHorizontalGroup(PINCodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PINCodePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pinCodeLbl).addGap(41, 41, 41).addComponent(this.pinCodeTB, -2, 213, -2).addContainerGap(-1, Short.MAX_VALUE)));
        PINCodePanelLayout.setVerticalGroup(PINCodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PINCodePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(PINCodePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pinCodeLbl).addComponent(this.pinCodeTB, -2, -1, -2)).addContainerGap()));
        this.portPanel.setPreferredSize(new Dimension(298, 35));
        this.portLbl.setText("Port:");
        this.portCB.setModel(new DefaultComboBoxModel<String>(new String[0]));
        GroupLayout PortPanelLayout = new GroupLayout(this.portPanel);
        this.portPanel.setLayout(PortPanelLayout);
        PortPanelLayout.setHorizontalGroup(PortPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PortPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.portLbl).addGap(70, 70, 70).addComponent(this.portCB, -2, 208, -2).addContainerGap(-1, Short.MAX_VALUE)));
        PortPanelLayout.setVerticalGroup(PortPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, PortPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(PortPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLbl).addComponent(this.portCB, -2, -1, -2)).addContainerGap()));
        this.baudRatePanel.setPreferredSize(new Dimension(218, 35));
        this.baudRateLbl.setText("Baud Rate:");
        this.baudRateCB.setModel(new DefaultComboBoxModel<String>(new String[0]));
        GroupLayout BaudRatePanelLayout = new GroupLayout(this.baudRatePanel);
        this.baudRatePanel.setLayout(BaudRatePanelLayout);
        BaudRatePanelLayout.setHorizontalGroup(BaudRatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(BaudRatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.baudRateLbl).addGap(41, 41, 41).addComponent(this.baudRateCB, -2, 208, -2).addContainerGap(-1, Short.MAX_VALUE)));
        BaudRatePanelLayout.setVerticalGroup(BaudRatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, BaudRatePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(BaudRatePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.baudRateLbl).addComponent(this.baudRateCB, -2, -1, -2)).addContainerGap()));
        this.dataBitsPanel.setPreferredSize(new Dimension(220, 35));
        this.dataBitsLbl.setText("Data Bits:");
        this.dataBitsCB.setModel(new DefaultComboBoxModel<String>(new String[0]));
        GroupLayout DataBitsPanelLayout = new GroupLayout(this.dataBitsPanel);
        this.dataBitsPanel.setLayout(DataBitsPanelLayout);
        DataBitsPanelLayout.setHorizontalGroup(DataBitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DataBitsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dataBitsLbl).addGap(50, 50, 50).addComponent(this.dataBitsCB, -2, 205, -2).addContainerGap(-1, Short.MAX_VALUE)));
        DataBitsPanelLayout.setVerticalGroup(DataBitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, DataBitsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(DataBitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataBitsCB, -2, -1, -2).addComponent(this.dataBitsLbl)).addGap(14, 14, 14)));
        this.parityPanel.setPreferredSize(new Dimension(219, 35));
        this.parityLbl.setText("Parity:");
        this.parityCB.setModel(new DefaultComboBoxModel<String>(new String[0]));
        GroupLayout ParityPanelLayout = new GroupLayout(this.parityPanel);
        this.parityPanel.setLayout(ParityPanelLayout);
        ParityPanelLayout.setHorizontalGroup(ParityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ParityPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.parityLbl).addGap(64, 64, 64).addComponent(this.parityCB, -2, 207, -2).addContainerGap(-1, Short.MAX_VALUE)));
        ParityPanelLayout.setVerticalGroup(ParityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ParityPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(ParityPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parityLbl).addComponent(this.parityCB, -2, -1, -2)).addGap(17, 17, 17)));
        this.stopBitsLbl.setText("Stop Bits:");
        this.stopBitsCB.setModel(new DefaultComboBoxModel<String>(new String[0]));
        GroupLayout StopBitsPanelLayout = new GroupLayout(this.stopBitsPanel);
        this.stopBitsPanel.setLayout(StopBitsPanelLayout);
        StopBitsPanelLayout.setHorizontalGroup(StopBitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(StopBitsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.stopBitsLbl).addGap(49, 49, 49).addComponent(this.stopBitsCB, -2, 207, -2).addContainerGap(58, Short.MAX_VALUE)));
        StopBitsPanelLayout.setVerticalGroup(StopBitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, StopBitsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(StopBitsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopBitsLbl).addComponent(this.stopBitsCB, -2, -1, -2)).addGap(45, 45, 45)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phoneNumberPanel, -1, 370, Short.MAX_VALUE).addComponent(this.pinCodePanel, -1, 370, Short.MAX_VALUE).addComponent(this.portPanel, -1, 370, Short.MAX_VALUE).addComponent(this.baudRatePanel, -1, 370, Short.MAX_VALUE).addComponent(this.dataBitsPanel, -1, 370, Short.MAX_VALUE).addComponent(this.parityPanel, -1, 370, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.stopBitsPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.phoneNumberPanel, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pinCodePanel, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.baudRatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataBitsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parityPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopBitsPanel, -2, 44, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GXSettings.this.okBtnActionPerformed(evt);
            }
        });
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GXSettings.this.cancelBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.okBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelBtn)).addComponent(this.jPanel1, -2, 321, -2)).addGap(0, 11, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 310, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBtn).addComponent(this.okBtn)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(this, stroke, 2);
        return rootPane;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.target.setPhoneNumber(this.phoneNumberTB.getText());
            this.target.setPINCode(this.pinCodeTB.getText());
            this.target.setPortName(this.portCB.getSelectedItem().toString());
            this.target.setBaudRate(BaudRate.forValue((int)Integer.parseInt(this.baudRateCB.getSelectedItem().toString())));
            this.target.setDataBits(Integer.parseInt(this.dataBitsCB.getSelectedItem().toString()));
            this.target.setParity(Parity.valueOf((String)this.parityCB.getSelectedItem().toString().toUpperCase()));
            this.target.setStopBits(StopBits.valueOf((String)this.stopBitsCB.getSelectedItem().toString().toUpperCase()));
            this.accepted = true;
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

