/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.access;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.KubernetesListNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RecreateFromServerGettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.DoneablePolicyBinding;
import io.fabric8.openshift.api.model.DoneableProject;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.NamedRoleBindingFluent;
import io.fabric8.openshift.api.model.PolicyBindingFluent;
import io.fabric8.openshift.api.model.ProjectFluent;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.guvnor.ala.openshift.access.OpenShiftRuntimeId;
import org.guvnor.ala.openshift.access.exceptions.OpenShiftClientException;
import org.guvnor.ala.openshift.config.OpenShiftParameters;
import org.guvnor.ala.openshift.config.OpenShiftRuntimeConfig;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeEndpoint;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeState;

@JsonIgnoreType
public class OpenShiftClient {
    private static final String GUVNOR_ALA_GENERATED = "guvnor.ala/generated";
    private final io.fabric8.openshift.client.OpenShiftClient delegate;
    private final long buildTimeout;
    private static final String APP_LABEL = "application";

    public OpenShiftClient(io.fabric8.openshift.client.OpenShiftClient delegate) {
        this.delegate = delegate;
        long buildTimeout = ((OpenShiftConfig)delegate.getConfiguration()).getBuildTimeout();
        if (buildTimeout < 0L) {
            buildTimeout = OpenShiftConfig.DEFAULT_BUILD_TIMEOUT;
        }
        this.buildTimeout = buildTimeout;
    }

    public void dispose() {
        this.delegate.close();
    }

    public OpenShiftRuntimeState create(OpenShiftRuntimeConfig runtimeConfig) throws OpenShiftClientException {
        try {
            String prjName = runtimeConfig.getProjectName();
            String svcName = runtimeConfig.getServiceName();
            String appName = runtimeConfig.getApplicationName();
            OpenShiftRuntimeId runtimeId = new OpenShiftRuntimeId(prjName, svcName, appName);
            OpenShiftRuntimeState runtimeState = this.getRuntimeState(runtimeId);
            if ("NA".equals(runtimeState.getState())) {
                this.createProject(prjName);
                this.createFromUri(prjName, runtimeConfig.getResourceSecretsUri());
                this.createFromUri(prjName, runtimeConfig.getResourceStreamsUri());
                this.createFromTemplate(prjName, runtimeConfig);
                runtimeState = this.getRuntimeState(runtimeId);
            }
            return runtimeState;
        }
        catch (Throwable t) {
            throw new OpenShiftClientException(t.getMessage(), t);
        }
    }

    private void createProject(String prjName) {
        if (((Resource)this.delegate.projects().withName(prjName)).get() == null) {
            ((DoneableProject)((ProjectFluent.MetadataNested)((ProjectFluent.MetadataNested)((DoneableProject)this.delegate.projects().createNew()).editOrNewMetadata().withName(prjName)).addToAnnotations(GUVNOR_ALA_GENERATED, Boolean.TRUE.toString())).endMetadata()).done();
        }
        this.addServiceAccountRole(prjName, "builder", "system:image-builder");
        this.addServiceAccountRole(prjName, "default", "admin");
        this.addServiceAccountRole(prjName, "default", "view");
        this.addServiceAccountRole(prjName, "deployer", "system:deployer");
        this.addSystemGroupRole(prjName, "deployer", "system:image-puller");
    }

    private void addServiceAccountRole(String prjName, String name, String role) {
        Resource bindingResource = (Resource)((NonNamespaceOperation)this.delegate.policyBindings().inNamespace(prjName)).withName(":default");
        DoneablePolicyBinding binding = bindingResource.get() == null ? (DoneablePolicyBinding)bindingResource.createNew() : (DoneablePolicyBinding)bindingResource.edit();
        ((DoneablePolicyBinding)((PolicyBindingFluent.RoleBindingsNested)((NamedRoleBindingFluent.RoleBindingNested)((RoleBindingFluent.RoleRefNested)((NamedRoleBindingFluent.RoleBindingNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((NamedRoleBindingFluent.RoleBindingNested)((NamedRoleBindingFluent.RoleBindingNested)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)((PolicyBindingFluent.RoleBindingsNested)((DoneablePolicyBinding)((PolicyBindingFluent.PolicyRefNested)((DoneablePolicyBinding)((PolicyBindingFluent.MetadataNested)binding.editOrNewMetadata().withName(":default")).endMetadata()).editOrNewPolicyRef().withName("default")).endPolicyRef()).addNewRoleBinding().withName(role)).editOrNewRoleBinding().editOrNewMetadata().withName(role)).withNamespace(prjName)).endMetadata()).addToUserNames(new String[]{"system:serviceaccount:" + prjName + ":" + name})).addNewSubject().withName("default")).withNamespace(prjName)).withKind("ServiceAccount")).endSubject()).withNewRoleRef().withName(role)).endRoleRef()).endRoleBinding()).endRoleBinding()).done();
    }

    private void addSystemGroupRole(String prjName, String name, String role) {
        Resource bindingResource = (Resource)((NonNamespaceOperation)this.delegate.policyBindings().inNamespace(prjName)).withName(":default");
        DoneablePolicyBinding binding = bindingResource.get() == null ? (DoneablePolicyBinding)bindingResource.createNew() : (DoneablePolicyBinding)bindingResource.edit();
        ((DoneablePolicyBinding)((PolicyBindingFluent.RoleBindingsNested)((NamedRoleBindingFluent.RoleBindingNested)((RoleBindingFluent.RoleRefNested)((NamedRoleBindingFluent.RoleBindingNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((NamedRoleBindingFluent.RoleBindingNested)((NamedRoleBindingFluent.RoleBindingNested)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)((PolicyBindingFluent.RoleBindingsNested)((DoneablePolicyBinding)((PolicyBindingFluent.PolicyRefNested)((DoneablePolicyBinding)((PolicyBindingFluent.MetadataNested)binding.editOrNewMetadata().withName(":default")).endMetadata()).editOrNewPolicyRef().withName("default")).endPolicyRef()).addNewRoleBinding().withName(role)).editOrNewRoleBinding().editOrNewMetadata().withName(role)).withNamespace(prjName)).endMetadata()).addToGroupNames(new String[]{"system:serviceaccounts:" + prjName})).addNewSubject().withName("default")).withNamespace(prjName)).withKind("SystemGroup")).endSubject()).withNewRoleRef().withName(role)).endRoleRef()).endRoleBinding()).endRoleBinding()).done();
    }

    private void createFromUri(String prjName, String uri) throws MalformedURLException {
        KubernetesList kubeList;
        List items;
        URL url = this.toUrl(uri);
        if (url != null && (items = (kubeList = (KubernetesList)((RecreateFromServerGettable)this.delegate.lists().load(url)).get()).getItems()).size() > 0) {
            for (HasMetadata item : items) {
                String name = item.getMetadata().getName();
                if (item instanceof ServiceAccount) {
                    if (((Resource)((NonNamespaceOperation)this.delegate.serviceAccounts().inNamespace(prjName)).withName(name)).get() != null) continue;
                    this.setGuvnorAlaGenerated(item);
                    continue;
                }
                if (item instanceof Secret) {
                    if (((Resource)((NonNamespaceOperation)this.delegate.secrets().inNamespace(prjName)).withName(name)).get() != null) continue;
                    this.setGuvnorAlaGenerated(item);
                    continue;
                }
                if (!(item instanceof ImageStream) || ((Resource)((NonNamespaceOperation)this.delegate.imageStreams().inNamespace(prjName)).withName(name)).get() != null) continue;
                this.setGuvnorAlaGenerated(item);
            }
            ((KubernetesListNonNamespaceOperation)this.delegate.lists().inNamespace(prjName)).create((Object[])new KubernetesList[]{kubeList});
        }
    }

    private void createFromTemplate(String prjName, OpenShiftRuntimeConfig runtimeConfig) throws MalformedURLException {
        KubernetesList kubeList = this.processTemplate(runtimeConfig);
        if (kubeList != null && kubeList.getItems().size() > 0) {
            try {
                DeploymentConfig dc = this.getDeploymentConfig(kubeList, runtimeConfig.getServiceName());
                if (dc != null) {
                    dc.getSpec().setReplicas(Integer.valueOf(0));
                }
                ((KubernetesListNonNamespaceOperation)this.delegate.lists().inNamespace(prjName)).create((Object[])new KubernetesList[]{kubeList});
            }
            catch (Throwable t) {
                throw new OpenShiftClientException(t.getMessage(), t);
            }
        }
    }

    private KubernetesList processTemplate(OpenShiftRuntimeConfig runtimeConfig) throws MalformedURLException {
        String prjName = runtimeConfig.getProjectName();
        URL url = this.toUrl(runtimeConfig.getResourceTemplateUri());
        if (url != null) {
            OpenShiftParameters params = OpenShiftParameters.fromRuntimeConfig(runtimeConfig);
            return (KubernetesList)((TemplateResource)((NonNamespaceOperation)this.delegate.templates().inNamespace(prjName)).load(url)).process((Map)params);
        }
        String templateName = runtimeConfig.getResourceTemplateName();
        if (templateName != null && !templateName.isEmpty()) {
            OpenShiftParameters params = OpenShiftParameters.fromRuntimeConfig(runtimeConfig);
            return (KubernetesList)((TemplateResource)((NonNamespaceOperation)this.delegate.templates().inNamespace(prjName)).withName(templateName)).process((Map)params);
        }
        return null;
    }

    private DeploymentConfig getDeploymentConfig(KubernetesList list, String svcName) {
        if (list != null) {
            List items = list.getItems();
            String dcName = null;
            for (HasMetadata item : items) {
                if (!(item instanceof Service) || !item.getMetadata().getName().equals(svcName)) continue;
                dcName = (String)((Service)item).getSpec().getSelector().get("deploymentConfig");
                break;
            }
            if (dcName != null) {
                for (HasMetadata item : items) {
                    if (!(item instanceof DeploymentConfig) || !item.getMetadata().getName().equals(dcName)) continue;
                    return (DeploymentConfig)item;
                }
            }
        }
        return null;
    }

    private URL toUrl(String uri) throws MalformedURLException {
        if (uri != null && !uri.isEmpty()) {
            return URI.create(uri).toURL();
        }
        return null;
    }

    public void destroy(String id) throws OpenShiftClientException {
        try {
            Service service;
            OpenShiftRuntimeId runtimeId = OpenShiftRuntimeId.fromString(id);
            String prjName = runtimeId.project();
            String svcName = runtimeId.service();
            String appName = runtimeId.application();
            if ((appName == null || appName.isEmpty()) && (service = (Service)((Resource)((NonNamespaceOperation)this.delegate.services().inNamespace(prjName)).withName(svcName)).get()) != null) {
                appName = (String)service.getMetadata().getLabels().get(APP_LABEL);
            }
            ((EditReplacePatchDeletable)((DeployableScalableResource)((NonNamespaceOperation)this.delegate.deploymentConfigs().inNamespace(prjName)).withName(svcName)).cascading(true)).delete();
            ((FilterWatchListDeletable)((NonNamespaceOperation)this.delegate.services().inNamespace(prjName)).withLabel(APP_LABEL, appName)).delete();
            ((FilterWatchListDeletable)((NonNamespaceOperation)this.delegate.routes().inNamespace(prjName)).withLabel(APP_LABEL, appName)).delete();
            for (ImageStream item : ((ImageStreamList)((NonNamespaceOperation)this.delegate.imageStreams().inNamespace(prjName)).list()).getItems()) {
                if (!this.isGuvnorAlaGenerated((HasMetadata)item)) continue;
                ((NonNamespaceOperation)this.delegate.imageStreams().inNamespace(prjName)).delete((Object[])new ImageStream[]{item});
            }
            for (ImageStream item : ((SecretList)((NonNamespaceOperation)this.delegate.secrets().inNamespace(prjName)).list()).getItems()) {
                if (!this.isGuvnorAlaGenerated((HasMetadata)item)) continue;
                ((NonNamespaceOperation)this.delegate.secrets().inNamespace(prjName)).delete((Object[])new Secret[]{item});
            }
            for (ImageStream item : ((ServiceAccountList)((NonNamespaceOperation)this.delegate.serviceAccounts().inNamespace(prjName)).list()).getItems()) {
                if (!this.isGuvnorAlaGenerated((HasMetadata)item)) continue;
                ((NonNamespaceOperation)this.delegate.serviceAccounts().inNamespace(prjName)).delete((Object[])new ServiceAccount[]{item});
            }
            if (this.isGuvnorAlaGenerated((HasMetadata)((Resource)this.delegate.projects().withName(prjName)).get())) {
                ((Resource)this.delegate.projects().withName(prjName)).delete();
            }
        }
        catch (Throwable t) {
            throw new OpenShiftClientException(t.getMessage(), t);
        }
    }

    private void setGuvnorAlaGenerated(HasMetadata item) {
        if (item != null) {
            ObjectMeta metadata = item.getMetadata();
            HashMap<String, String> annotations = metadata.getAnnotations();
            if (annotations == null) {
                annotations = new HashMap<String, String>();
                metadata.setAnnotations(annotations);
            }
            annotations.put(GUVNOR_ALA_GENERATED, Boolean.TRUE.toString());
        }
    }

    private boolean isGuvnorAlaGenerated(HasMetadata item) {
        Map annotations;
        if (item != null && (annotations = item.getMetadata().getAnnotations()) != null) {
            String generated = (String)annotations.get(GUVNOR_ALA_GENERATED);
            return generated != null && Boolean.parseBoolean(generated);
        }
        return false;
    }

    public OpenShiftRuntimeEndpoint getRuntimeEndpoint(String id) throws OpenShiftClientException {
        try {
            OpenShiftRuntimeId runtimeId = OpenShiftRuntimeId.fromString(id);
            String prjName = runtimeId.project();
            String svcName = runtimeId.service();
            OpenShiftRuntimeEndpoint endpoint = new OpenShiftRuntimeEndpoint();
            Route route = (Route)((Resource)((NonNamespaceOperation)this.delegate.routes().inNamespace(prjName)).withName(svcName)).get();
            if (route != null) {
                IntOrString targetPort;
                RouteSpec routeSpec = route.getSpec();
                endpoint.setHost(routeSpec.getHost());
                Integer port = null;
                RoutePort routePort = routeSpec.getPort();
                if (routePort != null && (targetPort = routePort.getTargetPort()) != null) {
                    port = targetPort.getIntVal();
                }
                endpoint.setPort(port != null && port > 0 ? port : 80);
            }
            endpoint.setContext("");
            return endpoint;
        }
        catch (Throwable t) {
            throw new OpenShiftClientException(t.getMessage(), t);
        }
    }

    public OpenShiftRuntimeState getRuntimeState(String id) throws OpenShiftClientException {
        try {
            return this.getRuntimeState(OpenShiftRuntimeId.fromString(id));
        }
        catch (Throwable t) {
            throw new OpenShiftClientException(t.getMessage(), t);
        }
    }

    private OpenShiftRuntimeState getRuntimeState(OpenShiftRuntimeId runtimeId) {
        String startedAt;
        String state;
        String prjName = runtimeId.project();
        String svcName = runtimeId.service();
        Service service = (Service)((Resource)((NonNamespaceOperation)this.delegate.services().inNamespace(prjName)).withName(svcName)).get();
        if (service != null) {
            Integer replicas = this.getReplicas(service);
            state = replicas != null && replicas > 0 ? "Started" : "Ready";
            startedAt = service.getMetadata().getCreationTimestamp();
        } else {
            state = "NA";
            startedAt = new Date().toString();
        }
        return new OpenShiftRuntimeState(state, startedAt);
    }

    public void start(String id) throws OpenShiftClientException {
        try {
            this.setReplicas(id, 1);
        }
        catch (Throwable t) {
            throw new OpenShiftClientException(t.getMessage(), t);
        }
    }

    public void stop(String id) throws OpenShiftClientException {
        try {
            this.setReplicas(id, 0);
        }
        catch (Throwable t) {
            throw new OpenShiftClientException(t.getMessage(), t);
        }
    }

    public void restart(String id) throws OpenShiftClientException {
        this.stop(id);
        this.start(id);
    }

    public void pause(String id) throws OpenShiftClientException {
        this.stop(id);
    }

    private void setReplicas(String id, int replicas) throws InterruptedException {
        OpenShiftRuntimeId runtimeId = OpenShiftRuntimeId.fromString(id);
        String prjName = runtimeId.project();
        String svcName = runtimeId.service();
        Service service = (Service)((Resource)((NonNamespaceOperation)this.delegate.services().inNamespace(prjName)).withName(svcName)).get();
        DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> dcr = this.getDeploymentConfigResource(service);
        if (dcr != null) {
            DeploymentConfig dc = (DeploymentConfig)dcr.get();
            dc.getSpec().setReplicas(Integer.valueOf(replicas));
            dcr.replace((Object)dc);
            dcr.waitUntilReady(this.buildTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private Integer getReplicas(Service service) {
        DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> dcr = this.getDeploymentConfigResource(service);
        return dcr != null ? ((DeploymentConfig)dcr.get()).getSpec().getReplicas() : null;
    }

    private DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> getDeploymentConfigResource(Service service) {
        if (service != null) {
            String prjName = service.getMetadata().getNamespace();
            String dcName = (String)service.getSpec().getSelector().get("deploymentConfig");
            if (dcName != null) {
                return (DeployableScalableResource)((NonNamespaceOperation)this.delegate.deploymentConfigs().inNamespace(prjName)).withName(dcName);
            }
        }
        return null;
    }
}

