/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.config;

import io.fabric8.kubernetes.client.Config;

public enum OpenShiftProperty {
    ALL_PROXY("all.proxy"),
    HTTP_PROXY("http.proxy"),
    HTTPS_PROXY("https.proxy"),
    KUBERNETES_API_VERSION("kubernetes.api.version"),
    KUBERNETES_AUTH_BASIC_PASSWORD("kubernetes.auth.basic.password"),
    KUBERNETES_AUTH_BASIC_USERNAME("kubernetes.auth.basic.username"),
    KUBERNETES_AUTH_TOKEN("kubernetes.auth.token"),
    KUBERNETES_CERTS_CA_DATA("kubernetes.certs.ca.data"),
    KUBERNETES_CERTS_CA_FILE("kubernetes.certs.ca.file"),
    KUBERNETES_CERTS_CLIENT_DATA("kubernetes.certs.client.data"),
    KUBERNETES_CERTS_CLIENT_FILE("kubernetes.certs.client.file"),
    KUBERNETES_CERTS_CLIENT_KEY_ALGO("kubernetes.certs.client.key.algo"),
    KUBERNETES_CERTS_CLIENT_KEY_DATA("kubernetes.certs.client.key.data"),
    KUBERNETES_CERTS_CLIENT_KEY_FILE("kubernetes.certs.client.key.file"),
    KUBERNETES_CERTS_CLIENT_KEY_PASSPHRASE("kubernetes.certs.client.key.passphrase"),
    KUBERNETES_CONNECTION_TIMEOUT("kubernetes.connection.timeout"),
    KUBERNETES_KEYSTORE_FILE("kubernetes.keystore.file"),
    KUBERNETES_KEYSTORE_PASSPHRASE("kubernetes.keystore.passphrase"),
    KUBERNETES_LOGGING_INTERVAL("kubernetes.logging.interval"),
    KUBERNETES_MASTER("kubernetes.master"),
    KUBERNETES_NAMESPACE("kubernetes.namespace"),
    KUBERNETES_REQUEST_TIMEOUT("kubernetes.request.timeout"),
    KUBERNETES_ROLLING_TIMEOUT("kubernetes.rolling.timeout"),
    KUBERNETES_SCALE_TIMEOUT("kubernetes.scale.timeout"),
    KUBERNETES_TLS_VERSIONS("kubernetes.tls.versions"),
    KUBERNETES_TRUST_CERTIFICATES("kubernetes.trust.certificates"),
    KUBERNETES_TRUSTSTORE_FILE("kubernetes.truststore.file"),
    KUBERNETES_TRUSTSTORE_PASSPHRASE("kubernetes.truststore.passphrase"),
    KUBERNETES_USER_AGENT(Config.KUBERNETES_USER_AGENT),
    KUBERNETES_WATCH_RECONNECT_INTERVAL("kubernetes.watch.reconnectInterval"),
    KUBERNETES_WATCH_RECONNECT_LIMIT("kubernetes.watch.reconnectLimit"),
    KUBERNETES_WEBSOCKET_PING_INTERVAL("kubernetes.websocket.ping.interval"),
    KUBERNETES_WEBSOCKET_TIMEOUT("kubernetes.websocket.timeout"),
    NO_PROXY("no.proxy"),
    PROXY_PASSWORD("proxy.password"),
    PROXY_USERNAME("proxy.username"),
    KUBERNETES_OAPI_VERSION("kubernetes.oapi.version"),
    OPENSHIFT_BUILD_TIMEOUT("openshift.build.timeout"),
    OPENSHIFT_URL("openshift.url"),
    PROVIDER_NAME("provider-name".replaceAll("-", ".")),
    APPLICATION_NAME("application.name"),
    PROJECT_NAME("project.name"),
    RUNTIME_NAME("runtime-name".replaceAll("-", ".")),
    RESOURCE_SECRETS_URI("resource.secrets.uri"),
    RESOURCE_STREAMS_URI("resource.streams.uri"),
    RESOURCE_TEMPLATE_NAME("resource.template.name"),
    RESOURCE_TEMPLATE_PARAM_DELIMITER("resource.template.param.delimiter"),
    RESOURCE_TEMPLATE_PARAM_ASSIGNER("resource.template.param.assigner"),
    RESOURCE_TEMPLATE_PARAM_VALUES("resource.template.param.values"),
    RESOURCE_TEMPLATE_URI("resource.template.uri"),
    SERVICE_NAME("service.name");

    private final String propertyKey;
    private final String inputKey;
    private final String inputExpression;

    private OpenShiftProperty(String propertyKey) {
        this.propertyKey = propertyKey;
        this.inputKey = propertyKey.replaceAll("[^A-Za-z0-9]", "-");
        this.inputExpression = "${input." + this.inputKey + "}";
    }

    public final String envKey() {
        return this.name();
    }

    public final String propertyKey() {
        return this.propertyKey;
    }

    public final String inputKey() {
        return this.inputKey;
    }

    public final String inputExpression() {
        return this.inputExpression;
    }

    public static final void main(String ... args) {
        for (OpenShiftProperty p : OpenShiftProperty.values()) {
            System.out.println(String.format("%s | %s | %s | %s", p.envKey(), p.propertyKey(), p.inputKey(), p.inputExpression()));
        }
    }
}

